/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection.incompatible;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jinja.tags.Jinja2Tag;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.python.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.intellij.python.django.lang.template.inspection.DjangoTemplateLocalInspectionTool;
import com.intellij.python.django.lang.template.inspection.incompatible.DjangoBlockTransAsVarCompatibilityInfo;
import com.intellij.python.django.lang.template.inspection.incompatible.DjangoBlockTransTrimmedCompatibilityInfo;
import com.intellij.python.django.lang.template.inspection.incompatible.DjangoCompatibilityInfo;
import com.intellij.python.django.lang.template.inspection.incompatible.DjangoIfIsCompatibilityInfo;
import com.intellij.python.django.lang.template.inspection.incompatible.DjangoNowAsCompatibilityInfo;
import com.intellij.python.django.lang.template.inspection.incompatible.DjangoUrlParamCompatibilityInfo;
import com.intellij.python.django.lang.template.inspection.incompatible.DjangoVersionObtainer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoIncompatibleInspection
extends DjangoTemplateLocalInspectionTool {
    private static final List<DjangoCompatibilityInfo<?>> COMPATIBILITY_INFOS = Arrays.asList(new DjangoUrlParamCompatibilityInfo(), new DjangoBlockTransTrimmedCompatibilityInfo(), new DjangoBlockTransAsVarCompatibilityInfo(), new DjangoNowAsCompatibilityInfo(), new DjangoIfIsCompatibilityInfo());
    @NotNull
    private final DjangoVersionObtainer myVersionObtainer;

    public DjangoIncompatibleInspection() {
        this(new DjangoVersionObtainer());
    }

    public DjangoIncompatibleInspection(@NotNull DjangoVersionObtainer versionObtainer) {
        if (versionObtainer == null) {
            DjangoIncompatibleInspection.$$$reportNull$$$0(0);
        }
        this.myVersionObtainer = versionObtainer;
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoIncompatibleVisitor(manager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionObtainer", "com/intellij/python/django/lang/template/inspection/incompatible/DjangoIncompatibleInspection", "<init>"));
    }

    private final class DjangoIncompatibleVisitor
    extends DjangoInspectionVisitorAdapter {
        private DjangoIncompatibleVisitor(InspectionManager manager) {
            if (manager == null) {
                DjangoIncompatibleVisitor.$$$reportNull$$$0(0);
            }
            super(manager);
        }

        public void visitTag(@NotNull Jinja2Tag djangoTag) {
            if (djangoTag == null) {
                DjangoIncompatibleVisitor.$$$reportNull$$$0(1);
            }
            for (DjangoCompatibilityInfo<?> info : COMPATIBILITY_INFOS) {
                ProblemDescriptor descriptor;
                Boolean isVersionGreater;
                if (!info.getTagClass().isAssignableFrom(djangoTag.getClass()) || (isVersionGreater = DjangoIncompatibleInspection.this.myVersionObtainer.getIsDjangoVersionOrMore(info.getRequirement(), (PsiElement)djangoTag)) == null || (descriptor = this.processVersionSafely(djangoTag, info, isVersionGreater)) == null) continue;
                this.myProblems.add(descriptor);
            }
        }

        @Nullable
        private ProblemDescriptor processVersionSafely(@NotNull Jinja2Tag djangoTag, @NotNull DjangoCompatibilityInfo<? extends Jinja2Tag> info, boolean isVersionGreater) {
            if (djangoTag == null) {
                DjangoIncompatibleVisitor.$$$reportNull$$$0(2);
            }
            if (info == null) {
                DjangoIncompatibleVisitor.$$$reportNull$$$0(3);
            }
            assert (info.getTagClass().isAssignableFrom(djangoTag.getClass())) : "bad django tag type";
            DjangoCompatibilityInfo<? extends Jinja2Tag> saveInfo = info;
            return saveInfo.processVersion(isVersionGreater, (Jinja2Tag)djangoTag, this.myManager);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "djangoTag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/python/django/lang/template/inspection/incompatible/DjangoIncompatibleInspection$DjangoIncompatibleVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTag";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processVersionSafely";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

