/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.ref;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralFileReferenceSet;
import com.jetbrains.python.psi.WeakFileReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoDirectoryReferenceSet
extends PyStringLiteralFileReferenceSet {
    public DjangoDirectoryReferenceSet(String str, PyStringLiteralExpression element, int startInElement, @Nullable PsiReferenceProvider provider, boolean isCaseSensitive) {
        super(str, element, startInElement, provider, isCaseSensitive, false, null);
    }

    protected String getNewAbsolutePath(PsiFileSystemItem root, String relativePath) {
        if (root != null && root.getVirtualFile() != null) {
            return VirtualFileUtil.getAbsolutePath((VirtualFile)root.getVirtualFile(), (String)relativePath).replace(File.separatorChar, DjangoDirectoryReferenceSet.getUsedSeparatorChar(this.getPathString()));
        }
        return super.getNewAbsolutePath(root, relativePath);
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        ArrayList<PsiFileSystemItem> contexts = new ArrayList<PsiFileSystemItem>();
        contexts.addAll(super.computeDefaultContexts());
        if (!this.isAbsolutePathReference()) {
            contexts.addAll(DjangoDirectoryReferenceSet.getModuleRoots(this.getElement()));
        }
        ArrayList<PsiFileSystemItem> arrayList = contexts;
        if (arrayList == null) {
            DjangoDirectoryReferenceSet.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public static List<PsiFileSystemItem> getModuleRoots(@NotNull PsiElement element) {
        PsiDirectory djangoRootDirectory;
        DjangoModelApi modelApi;
        Module module;
        PsiDirectory psiDirectory;
        if (element == null) {
            DjangoDirectoryReferenceSet.$$$reportNull$$$0(1);
        }
        ArrayList<PsiFileSystemItem> contexts = new ArrayList<PsiFileSystemItem>();
        Project project = element.getProject();
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)element.getProject());
        if (projectDir != null && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(projectDir)) != null) {
            contexts.add((PsiFileSystemItem)psiDirectory);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null && (modelApi = (DjangoModelApi)DjangoModelApi.create((Module)module).getSuccessOrNull()) != null && (djangoRootDirectory = element.getManager().findDirectory(modelApi.getDjangoProjectRoot())) != null) {
            contexts.add((PsiFileSystemItem)djangoRootDirectory);
        }
        return contexts;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return DIRECTORY_FILTER;
    }

    public static char getUsedSeparatorChar(String pathString) {
        if (pathString.contains("\\")) {
            return '\\';
        }
        if (pathString.contains("/")) {
            return '/';
        }
        return File.separatorChar;
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new WeakFileReference((FileReferenceSet)this, range, index, text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/ref/DjangoDirectoryReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/ref/DjangoDirectoryReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModuleRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

