/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.structure.ui;

import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.python.django.structure.ui.DjangoStructurePromotionService;
import com.intellij.python.django.structure.ui.DjangoStructureView;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.django.ui.DjangoBundle;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/python/django/structure/ui/DjangoStructureToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "<init>", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "init", "observeVisibilityOfProjectView", "djangoStructureToolWindow", "promoteDjangoStructureOnceForProject", "Companion", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nDjangoStructureToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoStructureToolWindowFactory.kt\ncom/intellij/python/django/structure/ui/DjangoStructureToolWindowFactory\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,64:1\n31#2,2:65\n31#2,2:67\n*S KotlinDebug\n*F\n+ 1 DjangoStructureToolWindowFactory.kt\ncom/intellij/python/django/structure/ui/DjangoStructureToolWindowFactory\n*L\n17#1:65,2\n36#1:67,2\n*E\n"})
public final class DjangoStructureToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String OPEN_DJANGO_STRUCTURE_TASK_ID = "OpenDjangoStructureViewOnStart";

    /*
     * WARNING - void declaration
     */
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        void $this$createToolWindowContent_u24lambda_u240;
        Content content;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager manager = contentManager;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service22 = false;
        Class<DjangoStructureView> serviceClass$iv = DjangoStructureView.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DjangoStructureView panel = (DjangoStructureView)((Object)object);
        panel.attachToToolWindow(toolWindow);
        Content $i$f$service22 = content = manager.getFactory().createContent((JComponent)((Object)panel), null, false);
        ContentManager contentManager2 = manager;
        boolean bl = false;
        $this$createToolWindowContent_u24lambda_u240.setCloseable(false);
        contentManager2.addContent(content);
        toolWindow.setHelpId("django.structure.toolwindow");
    }

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setStripeTitle(DjangoBundle.message((String)"django.structure.tool.window.title", (Object[])new Object[0]));
        Project project = toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow projectToolWindow = toolWindowManager.getToolWindow("Project");
        if (projectToolWindow != null && projectToolWindow.isVisible()) {
            this.promoteDjangoStructureOnceForProject(toolWindow);
        } else {
            this.observeVisibilityOfProjectView(toolWindow);
        }
        Project project2 = toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<DjangoStructurePromotionService> serviceClass$iv = DjangoStructurePromotionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DjangoStructurePromotionService service = (DjangoStructurePromotionService)object;
        service.initialize(toolWindow);
    }

    private final void observeVisibilityOfProjectView(ToolWindow djangoStructureToolWindow) {
        MessageBusConnection connection = djangoStructureToolWindow.getProject().getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new ToolWindowManagerListener(this, djangoStructureToolWindow, connection){
            final /* synthetic */ DjangoStructureToolWindowFactory this$0;
            final /* synthetic */ ToolWindow $djangoStructureToolWindow;
            final /* synthetic */ MessageBusConnection $connection;
            {
                this.this$0 = $receiver;
                this.$djangoStructureToolWindow = $djangoStructureToolWindow;
                this.$connection = $connection;
            }

            public void toolWindowShown(ToolWindow toolWindow) {
                Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
                if (Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"Project")) {
                    DjangoStructureToolWindowFactory.access$promoteDjangoStructureOnceForProject(this.this$0, this.$djangoStructureToolWindow);
                    this.$connection.disconnect();
                }
            }
        });
    }

    private final void promoteDjangoStructureOnceForProject(ToolWindow djangoStructureToolWindow) {
        Project project = djangoStructureToolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RunOnceUtil.runOnceForProject((Project)project, (String)OPEN_DJANGO_STRUCTURE_TASK_ID, () -> DjangoStructureToolWindowFactory.promoteDjangoStructureOnceForProject$lambda$2(djangoStructureToolWindow));
    }

    private static final void promoteDjangoStructureOnceForProject$lambda$2$lambda$1(ToolWindow $djangoStructureToolWindow) {
        $djangoStructureToolWindow.show();
    }

    private static final void promoteDjangoStructureOnceForProject$lambda$2(ToolWindow $djangoStructureToolWindow) {
        Project project = $djangoStructureToolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ToolWindowManager.Companion.getInstance(project).invokeLater(() -> DjangoStructureToolWindowFactory.promoteDjangoStructureOnceForProject$lambda$2$lambda$1($djangoStructureToolWindow));
    }

    public static final /* synthetic */ void access$promoteDjangoStructureOnceForProject(DjangoStructureToolWindowFactory $this, ToolWindow djangoStructureToolWindow) {
        $this.promoteDjangoStructureOnceForProject(djangoStructureToolWindow);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/django/structure/ui/DjangoStructureToolWindowFactory$Companion;", "", "<init>", "()V", "OPEN_DJANGO_STRUCTURE_TASK_ID", "", "intellij.python.django"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

