/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.testRunner;

import com.intellij.execution.Location;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.testing.PythonUnitTestTestIdUrlProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DjangoDotToElementConverter {
    private int myPosition;
    @NotNull
    private final List<String> myPath;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final Project myProject;

    @NotNull
    static List<Location> getLocations(@NotNull List<String> path, @NotNull VirtualFile root, @NotNull Project project) {
        if (path == null) {
            DjangoDotToElementConverter.$$$reportNull$$$0(0);
        }
        if (root == null) {
            DjangoDotToElementConverter.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DjangoDotToElementConverter.$$$reportNull$$$0(2);
        }
        return new DjangoDotToElementConverter(path, root, project).getLocations();
    }

    private DjangoDotToElementConverter(@NotNull List<String> path, @NotNull VirtualFile root, @NotNull Project project) {
        if (path == null) {
            DjangoDotToElementConverter.$$$reportNull$$$0(3);
        }
        if (root == null) {
            DjangoDotToElementConverter.$$$reportNull$$$0(4);
        }
        if (project == null) {
            DjangoDotToElementConverter.$$$reportNull$$$0(5);
        }
        this.myPath = new ArrayList<String>(path);
        this.myRoot = root;
        this.myProject = project;
    }

    @NotNull
    private List<Location> getLocations() {
        VirtualFile initPy;
        VirtualFile fileOrFolder = this.findFileOrFolder();
        if (fileOrFolder == null) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                DjangoDotToElementConverter.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (fileOrFolder.isDirectory() && (initPy = fileOrFolder.findChild("__init__.py")) != null) {
            fileOrFolder = initPy;
        }
        String functionOrClass = this.getNextPart();
        String method = this.getNextPart();
        String canonicalPath = fileOrFolder.getCanonicalPath();
        if (canonicalPath == null) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                DjangoDotToElementConverter.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = PythonUnitTestTestIdUrlProvider.findLocations((Project)this.myProject, (String)canonicalPath, (String)functionOrClass, (String)method);
        if (list == null) {
            DjangoDotToElementConverter.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private VirtualFile findFileOrFolder() {
        VirtualFile result = null;
        this.myPosition = 0;
        while (this.myPosition < this.myPath.size()) {
            String path = StringUtil.join(this.myPath.subList(0, this.myPosition + 1), (String)"//");
            VirtualFile folder = this.myRoot.findFileByRelativePath(path);
            if (folder != null) {
                result = folder;
            } else {
                VirtualFile file = this.myRoot.findFileByRelativePath(path + ".py");
                if (file != null) {
                    result = file;
                } else {
                    return result;
                }
            }
            ++this.myPosition;
        }
        return null;
    }

    @Nullable
    private String getNextPart() {
        if (this.myPosition < this.myPath.size()) {
            return this.myPath.get(this.myPosition++);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/testRunner/DjangoDotToElementConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/testRunner/DjangoDotToElementConverter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocations";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

