/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.collectors.fus.ClassNameRuleValidator;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.connection.StatisticsResult;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataLoadException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUpdateError;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUpdateStage;
import com.intellij.internal.statistic.eventLog.events.AnonymizedListEventField;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.IntListEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.uploader.EventLogUploadException;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.uploader.EventLogExternalSendConfig;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 62\u00020\u0001:\u00016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0007J\u0010\u0010 \u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0007J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#JB\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00182\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110+J\u000e\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0016J\u0018\u0010/\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010.\u001a\u00020\u0016J\u0006\u00100\u001a\u00020\u001eJ\u0010\u00101\u001a\u00020\u001e2\b\u00102\u001a\u0004\u0018\u000103J\u0016\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogSystemCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "eventLoggerProvider", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "<init>", "(Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;)V", "id", "", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGroup", "metadataLoadedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "metadataUpdatedEvent", "metadataLoadFailedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventLogMetadataUpdateStage;", "", "metadataUpdateFailedEvent", "logsSendEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "externalSendStartedEvent", "", "externalSendFinishedEvent", "", "externalSendCommandCreationStartedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "externalSendCommandCreationFinishedEvent", "loadingConfigFailedEvent", "logMetadataLoaded", "", "version", "logMetadataUpdated", "logMetadataLoadFailed", "error", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventLogMetadataUpdateError;", "logMetadataUpdateFailed", "logFilesSend", "total", "succeed", "failed", "external", "successfullySentFiles", "", "errors", "logStartingExternalSend", "time", "logExternalSendFinished", "logExternalSendCommandCreationStarted", "logExternalSendCommandCreationFinished", "errorType", "Lcom/intellij/internal/statistic/eventLog/uploader/EventLogUploadException$EventLogUploadErrorType;", "logLoadingConfigFailed", "errorClass", "Companion", "intellij.platform.statistics"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEventLogSystemCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLogSystemCollector.kt\ncom/intellij/internal/statistic/eventLog/EventLogSystemCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n257#2,4:210\n257#2,4:218\n257#2,4:230\n1557#3:214\n1628#3,3:215\n1557#3:222\n1628#3,3:223\n1557#3:226\n1628#3,3:227\n*S KotlinDebug\n*F\n+ 1 EventLogSystemCollector.kt\ncom/intellij/internal/statistic/eventLog/EventLogSystemCollector\n*L\n178#1:210,4\n184#1:218,4\n204#1:230,4\n181#1:214\n181#1:215,3\n186#1:222\n186#1:223,3\n200#1:226\n200#1:227,3\n*E\n"})
public final class EventLogSystemCollector
extends CounterUsagesCollector {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String id;
    @NotNull
    private final EventLogGroup GROUP;
    @NotNull
    private final EventId1<String> metadataLoadedEvent;
    @NotNull
    private final EventId1<String> metadataUpdatedEvent;
    @NotNull
    private final EventId3<EventLogMetadataUpdateStage, String, Integer> metadataLoadFailedEvent;
    @NotNull
    private final EventId3<EventLogMetadataUpdateStage, String, Integer> metadataUpdateFailedEvent;
    @NotNull
    private final VarargEventId logsSendEvent;
    @NotNull
    private final EventId1<Long> externalSendStartedEvent;
    @NotNull
    private final EventId3<Long, Boolean, String> externalSendFinishedEvent;
    @NotNull
    private final EventId externalSendCommandCreationStartedEvent;
    @NotNull
    private final VarargEventId externalSendCommandCreationFinishedEvent;
    @NotNull
    private final VarargEventId loadingConfigFailedEvent;
    @NotNull
    private static final String METADATA_LOADED_DESCRIPTION = "The metric is recorded in case the metadata was loaded";
    @NotNull
    private static final String METADATA_UPDATED_DESCRIPTION = "The metric is recorded in case the metadata was updated";
    @NotNull
    private static final String STAGE_METADATA_LOAD_FAILED_DESCRIPTION = "Indicates if metadata load was failed during loading stage (loading) or loaded metadata was invalid (parsing).";
    @NotNull
    private static final String ERROR_METADATA_LOAD_FAILED_DESCRIPTION = "The error name in case the metadata load was failed. The error may occur during parsing metadata from local cache.";
    @NotNull
    private static final String METADATA_LOAD_FAILED_DESCRIPTION = "The event is recorded when IDE can't load metadata from a local cache. Local metadata is loaded on IDE start or on an explicit test action.";
    @NotNull
    private static final String STAGE_METADATA_UPDATE_FAILED_DESCRIPTION = "Indicates if metadata update was failed during loading stage (loading) or loaded metadata was invalid (parsing).";
    @NotNull
    private static final String ERROR_METADATA_UPDATE_FAILED_DESCRIPTION = "The error name in case the metadata update was failed, an error may occur on loading or parsing stages.";
    @NotNull
    private static final String CODE_METADATA_UPDATE_FAILED_DESCRIPTION = "In case loading request failed - the metric is recorded response code if it was different from 200.";
    @NotNull
    private static final String METADATA_UPDATE_FAILED_DESCRIPTION = "The event is recorded when IDE can't update metadata. Update metadata can be triggered by a scheduler or via an explicit test action.";
    @NotNull
    private static final String TOTAL_LOGS_SEND_DESCRIPTION = "Total amount of existing for sending event-log files";
    @NotNull
    private static final String SEND_LOGS_SEND_DESCRIPTION = "Amount of event log files attempted to send";
    @NotNull
    private static final String FAILED_LOGS_SEND_DESCRIPTION = "Amount of event-log files which were failed to send";
    @NotNull
    private static final String EXTERNAL_LOGS_SEND_DESCRIPTION = "Indicates if logs were sending from external process or not.";
    @NotNull
    private static final String SUCCEED_LOGS_SEND_DESCRIPTION = "The amount of successfully sent files.";
    @NotNull
    private static final String ERRORS_LOGS_SEND_DESCRIPTION = "The list of integers which identify error codes. If error is less than 100, the problem is in data structure (e.g. invalid recorder code), if error is between 100 and 600 it's error code from an HTTP request.";
    @NotNull
    private static final String LOGS_SEND_DESCRIPTION = "The metric is recorded the sending or attempt to send the statistics event logs and the corresponding attributes, e.g. number of total amount of files, number of sent files or amount of files which were failed to send.";
    @NotNull
    private static final String SEND_TS_EXTERNAL_SEND_STARTED_DESCRIPTION = "Actual time when sending was started";
    @NotNull
    private static final String EXTERNAL_SEND_STARTED_DESCRIPTION = "Indicates that external process of sending data was started. Note: the time of the event doesn't correspond to a real event time because it's recorded when IDE is opened after external send.";
    @NotNull
    private static final String SEND_TS_EXTERNAL_SEND_FINISHED_DESCRIPTION = "Actual time when sending was finished";
    @NotNull
    private static final String SUCCEED_EXTERNAL_SEND_FINISHED_DESCRIPTION = "Shows if external process sent data successfully or not";
    @NotNull
    private static final String ERROR_EXTERNAL_SEND_FINISHED_DESCRIPTION = "The error name in case the sending was failed, e.g. 'no arguments', 'not permitted server', 'no application config' etc.";
    @NotNull
    private static final String EXTERNAL_SEND_FINISHED_DESCRIPTION = "Indicates that external process sent data or failed with an error. Note: the time of the event doesn't correspond to a real event time because it's recorded when IDE is opened after external send.";
    @NotNull
    private static final String EXTERNAL_SEND_COMMAND_CREATION_STARTED_DESCRIPTION = "The event is recorded on IDE close when we start creating a command to start external upload process.";
    @NotNull
    private static final String SUCCEED_EXTERNAL_SEND_COMMAND_CREATION_FINISHED_DESCRIPTION = "Shows if command to start external upload process was finished successfully or not";
    @NotNull
    private static final String ERROR_EXTERNAL_SEND_COMMAND_CREATION_FINISHED_DESCRIPTION = "The error name in case command to start external upload process was failed, e.g. 'no logs', 'no temp folder' etc.";
    @NotNull
    private static final String EXTERNAL_SEND_COMMAND_CREATION_FINISHED_DESCRIPTION = "The event is recorded when we created a command and ready to start it or when creation failed with an error.";
    @NotNull
    private static final String ERROR_TS_LOADING_CONFIG_FAILED_DESCRIPTION = "Error time stamp is added if error happened in external process";
    @NotNull
    private static final String LOADING_CONFIG_FAILED_DESCRIPTION = "Event is recorded if loading config (i.e. send entrypoint, metadata url, etc) failed.";
    @NotNull
    private static final EnumEventField<EventLogMetadataUpdateStage> stageMetadataLoadFailedField;
    @NotNull
    private static final StringEventField errorMetadataLoadFailedField;
    @NotNull
    private static final IntEventField codeMetadataLoadFailedField;
    @NotNull
    private static final EnumEventField<EventLogMetadataUpdateStage> stageMetadataUpdateFailedField;
    @NotNull
    private static final StringEventField errorMetadataUpdateFailedField;
    @NotNull
    private static final IntEventField codeMetadataUpdateFailedField;
    @NotNull
    private static final IntEventField totalLogsSendField;
    @NotNull
    private static final IntEventField sendLogsSendField;
    @NotNull
    private static final IntEventField failedLogsSendField;
    @NotNull
    private static final BooleanEventField externalLogsSendField;
    @NotNull
    private static final IntEventField succeedLogsSendField;
    @NotNull
    private static final AnonymizedListEventField pathsLogsField;
    @NotNull
    private static final IntListEventField errorsLogsSendField;
    @NotNull
    private static final LongEventField sendTSExternalSendStarted;
    @NotNull
    private static final LongEventField sendTSExternalSendFinishedField;
    @NotNull
    private static final BooleanEventField succeedExternalSendFinishedField;
    @NotNull
    private static final StringEventField errorExternalSendFinishedField;
    @NotNull
    private static final BooleanEventField succeedExternalSendCommandCreationFinishedField;
    @NotNull
    private static final EnumEventField<EventLogUploadException.EventLogUploadErrorType> errorExternalSendCommandCreationFinishedField;
    @NotNull
    private static final StringEventField errorLoadingConfigFailedField;
    @NotNull
    private static final LongEventField errorTSLoadingConfigFailedField;

    public EventLogSystemCollector(@NotNull StatisticsEventLoggerProvider eventLoggerProvider) {
        Intrinsics.checkNotNullParameter((Object)eventLoggerProvider, (String)"eventLoggerProvider");
        EventField[] eventFieldArray = eventLoggerProvider.getRecorderId();
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string = eventFieldArray.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.id = string + ".event.log";
        this.GROUP = new EventLogGroup(this.id, eventLoggerProvider.getVersion(), eventLoggerProvider.getRecorderId());
        this.metadataLoadedEvent = this.GROUP.registerEvent("metadata.loaded", (EventField)EventFields.Version, METADATA_LOADED_DESCRIPTION);
        this.metadataUpdatedEvent = this.GROUP.registerEvent("metadata.updated", (EventField)EventFields.Version, METADATA_UPDATED_DESCRIPTION);
        this.metadataLoadFailedEvent = this.GROUP.registerEvent("metadata.load.failed", (EventField)stageMetadataLoadFailedField, errorMetadataLoadFailedField, codeMetadataLoadFailedField, METADATA_LOAD_FAILED_DESCRIPTION);
        this.metadataUpdateFailedEvent = this.GROUP.registerEvent("metadata.update.failed", (EventField)stageMetadataUpdateFailedField, errorMetadataUpdateFailedField, codeMetadataUpdateFailedField, METADATA_UPDATE_FAILED_DESCRIPTION);
        eventFieldArray = new EventField[]{totalLogsSendField, sendLogsSendField, failedLogsSendField, externalLogsSendField, pathsLogsField, succeedLogsSendField, errorsLogsSendField};
        this.logsSendEvent = this.GROUP.registerVarargEvent("logs.send", LOGS_SEND_DESCRIPTION, eventFieldArray);
        this.externalSendStartedEvent = this.GROUP.registerEvent("external.send.started", (EventField)sendTSExternalSendStarted, EXTERNAL_SEND_STARTED_DESCRIPTION);
        this.externalSendFinishedEvent = this.GROUP.registerEvent("external.send.finished", sendTSExternalSendFinishedField, succeedExternalSendFinishedField, errorExternalSendFinishedField, EXTERNAL_SEND_FINISHED_DESCRIPTION);
        this.externalSendCommandCreationStartedEvent = this.GROUP.registerEvent("external.send.command.creation.started", EXTERNAL_SEND_COMMAND_CREATION_STARTED_DESCRIPTION);
        eventFieldArray = new EventField[]{succeedExternalSendCommandCreationFinishedField, errorExternalSendCommandCreationFinishedField};
        this.externalSendCommandCreationFinishedEvent = this.GROUP.registerVarargEvent("external.send.command.creation.finished", EXTERNAL_SEND_COMMAND_CREATION_FINISHED_DESCRIPTION, eventFieldArray);
        eventFieldArray = new EventField[]{errorLoadingConfigFailedField, errorTSLoadingConfigFailedField};
        this.loadingConfigFailedEvent = this.GROUP.registerVarargEvent("loading.config.failed", LOADING_CONFIG_FAILED_DESCRIPTION, eventFieldArray);
    }

    @Override
    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    public final void logMetadataLoaded(@Nullable String version) {
        this.metadataLoadedEvent.log(version);
    }

    public final void logMetadataUpdated(@Nullable String version) {
        this.metadataUpdatedEvent.log(version);
    }

    public final void logMetadataLoadFailed(@NotNull EventLogMetadataUpdateError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        EventLogMetadataUpdateStage eventLogMetadataUpdateStage = error.getUpdateStage();
        Intrinsics.checkNotNullExpressionValue((Object)eventLogMetadataUpdateStage, (String)"getUpdateStage(...)");
        this.metadataLoadFailedEvent.log(eventLogMetadataUpdateStage, error.getErrorType(), error.getErrorCode());
    }

    public final void logMetadataUpdateFailed(@NotNull EventLogMetadataUpdateError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        EventLogMetadataUpdateStage eventLogMetadataUpdateStage = error.getUpdateStage();
        Intrinsics.checkNotNullExpressionValue((Object)eventLogMetadataUpdateStage, (String)"getUpdateStage(...)");
        this.metadataUpdateFailedEvent.log(eventLogMetadataUpdateStage, error.getErrorType(), error.getErrorCode());
    }

    public final void logFilesSend(int total, int succeed, int failed, boolean external, @NotNull List<String> successfullySentFiles, @NotNull List<Integer> errors) {
        Intrinsics.checkNotNullParameter(successfullySentFiles, (String)"successfullySentFiles");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        EventPair[] eventPairArray = new EventPair[]{totalLogsSendField.with(total), sendLogsSendField.with(succeed + failed), failedLogsSendField.with(failed), externalLogsSendField.with(external), pathsLogsField.with(successfullySentFiles), succeedLogsSendField.with(succeed), errorsLogsSendField.with(errors)};
        this.logsSendEvent.log(eventPairArray);
    }

    public final void logStartingExternalSend(long time) {
        this.externalSendStartedEvent.log(time);
    }

    public final void logExternalSendFinished(@Nullable String error, long time) {
        boolean succeed = StringUtil.isEmpty((String)error);
        this.externalSendFinishedEvent.log(time, succeed, error);
    }

    public final void logExternalSendCommandCreationStarted() {
        this.externalSendCommandCreationStartedEvent.log();
    }

    public final void logExternalSendCommandCreationFinished(@Nullable EventLogUploadException.EventLogUploadErrorType errorType) {
        Object[] objectArray = new EventPair[]{succeedExternalSendCommandCreationFinishedField.with(errorType == null)};
        List eventPairs = CollectionsKt.mutableListOf((Object[])objectArray);
        if (errorType != null) {
            eventPairs.add(errorExternalSendCommandCreationFinishedField.with(errorType));
        }
        this.externalSendCommandCreationFinishedEvent.log(eventPairs);
    }

    public final void logLoadingConfigFailed(@NotNull String errorClass, long time) {
        Intrinsics.checkNotNullParameter((Object)errorClass, (String)"errorClass");
        Object[] objectArray = new EventPair[]{errorLoadingConfigFailedField.with(errorClass)};
        List eventPairs = CollectionsKt.mutableListOf((Object[])objectArray);
        if (time != -1L) {
            eventPairs.add(errorTSLoadingConfigFailedField.with(time));
        }
        this.loadingConfigFailedEvent.log(eventPairs);
    }

    /*
     * WARNING - void declaration
     */
    static {
        Enum x;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv;
        void name$iv;
        Iterable $this$iv;
        Companion = new Companion(null);
        EventFields eventFields = EventFields.INSTANCE;
        String string = "stage";
        Object description$iv = STAGE_METADATA_LOAD_FAILED_DESCRIPTION;
        Function1<Object, String> transform$iv = ((EventFields)((Object)$this$iv)).getDefaultEnumTransform();
        boolean $i$f$Enum = false;
        stageMetadataLoadFailedField = new EnumEventField<Object>((String)name$iv, EventLogMetadataUpdateStage.class, (String)description$iv, transform$iv);
        $this$iv = (Iterable)EntriesMappings.entries$0;
        String string2 = "error";
        boolean $i$f$map22 = false;
        description$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            EventLogMetadataParseException.EventLogMetadataParseErrorType eventLogMetadataParseErrorType = (EventLogMetadataParseException.EventLogMetadataParseErrorType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(x.name());
        }
        errorMetadataLoadFailedField = EventFields.String(string2, CollectionsKt.toList((Iterable)((List)destination$iv$iv)), ERROR_METADATA_LOAD_FAILED_DESCRIPTION);
        codeMetadataLoadFailedField = EventFields.Int("code");
        $this$map$iv = EventFields.INSTANCE;
        String $i$f$map22 = "stage";
        description$iv = STAGE_METADATA_UPDATE_FAILED_DESCRIPTION;
        transform$iv = ((EventFields)((Object)$this$iv)).getDefaultEnumTransform();
        $i$f$Enum = false;
        stageMetadataUpdateFailedField = new EnumEventField<Object>((String)name$iv, EventLogMetadataUpdateStage.class, (String)description$iv, transform$iv);
        $this$iv = CollectionsKt.plus((Collection)((Collection)EntriesMappings.entries$0), (Iterable)((Iterable)EntriesMappings.entries$1));
        string2 = "error";
        boolean $i$f$map = false;
        description$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            x = (Enum)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(x.name());
        }
        errorMetadataUpdateFailedField = EventFields.String(string2, CollectionsKt.toList((Iterable)((List)destination$iv$iv)), ERROR_METADATA_UPDATE_FAILED_DESCRIPTION);
        codeMetadataUpdateFailedField = EventFields.Int("code", CODE_METADATA_UPDATE_FAILED_DESCRIPTION);
        totalLogsSendField = EventFields.Int("total", TOTAL_LOGS_SEND_DESCRIPTION);
        sendLogsSendField = EventFields.Int("send", SEND_LOGS_SEND_DESCRIPTION);
        failedLogsSendField = EventFields.Int("failed", FAILED_LOGS_SEND_DESCRIPTION);
        externalLogsSendField = EventFields.Boolean("external", EXTERNAL_LOGS_SEND_DESCRIPTION);
        succeedLogsSendField = EventFields.Int("succeed", SUCCEED_LOGS_SEND_DESCRIPTION);
        pathsLogsField = EventFields.AnonymizedList$default("paths", null, 2, null);
        errorsLogsSendField = EventFields.IntList("errors", ERRORS_LOGS_SEND_DESCRIPTION);
        sendTSExternalSendStarted = EventFields.Long("send_ts", SEND_TS_EXTERNAL_SEND_STARTED_DESCRIPTION);
        sendTSExternalSendFinishedField = EventFields.Long("send_ts", SEND_TS_EXTERNAL_SEND_FINISHED_DESCRIPTION);
        succeedExternalSendFinishedField = EventFields.Boolean("succeed", SUCCEED_EXTERNAL_SEND_FINISHED_DESCRIPTION);
        $this$map$iv = CollectionsKt.plus((Collection)((Collection)EntriesMappings.entries$2), (Iterable)((Iterable)EntriesMappings.entries$3));
        string2 = "error";
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            x = (Enum)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(x.name());
        }
        errorExternalSendFinishedField = EventFields.String(string2, CollectionsKt.toList((Iterable)((List)destination$iv$iv)), ERROR_EXTERNAL_SEND_FINISHED_DESCRIPTION);
        succeedExternalSendCommandCreationFinishedField = EventFields.Boolean("succeed", SUCCEED_EXTERNAL_SEND_COMMAND_CREATION_FINISHED_DESCRIPTION);
        $this$map$iv = EventFields.INSTANCE;
        String $i$f$map3 = "error";
        description$iv = ERROR_EXTERNAL_SEND_COMMAND_CREATION_FINISHED_DESCRIPTION;
        transform$iv = ((EventFields)((Object)$this$iv)).getDefaultEnumTransform();
        $i$f$Enum = false;
        errorExternalSendCommandCreationFinishedField = new EnumEventField<Object>((String)name$iv, EventLogUploadException.EventLogUploadErrorType.class, (String)description$iv, transform$iv);
        errorLoadingConfigFailedField = EventFields.StringValidatedByCustomRule("error", ClassNameRuleValidator.class);
        errorTSLoadingConfigFailedField = EventFields.Long("error_ts", ERROR_TS_LOADING_CONFIG_FAILED_DESCRIPTION);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogSystemCollector$Companion;", "", "<init>", "()V", "METADATA_LOADED_DESCRIPTION", "", "METADATA_UPDATED_DESCRIPTION", "STAGE_METADATA_LOAD_FAILED_DESCRIPTION", "ERROR_METADATA_LOAD_FAILED_DESCRIPTION", "METADATA_LOAD_FAILED_DESCRIPTION", "STAGE_METADATA_UPDATE_FAILED_DESCRIPTION", "ERROR_METADATA_UPDATE_FAILED_DESCRIPTION", "CODE_METADATA_UPDATE_FAILED_DESCRIPTION", "METADATA_UPDATE_FAILED_DESCRIPTION", "TOTAL_LOGS_SEND_DESCRIPTION", "SEND_LOGS_SEND_DESCRIPTION", "FAILED_LOGS_SEND_DESCRIPTION", "EXTERNAL_LOGS_SEND_DESCRIPTION", "SUCCEED_LOGS_SEND_DESCRIPTION", "ERRORS_LOGS_SEND_DESCRIPTION", "LOGS_SEND_DESCRIPTION", "SEND_TS_EXTERNAL_SEND_STARTED_DESCRIPTION", "EXTERNAL_SEND_STARTED_DESCRIPTION", "SEND_TS_EXTERNAL_SEND_FINISHED_DESCRIPTION", "SUCCEED_EXTERNAL_SEND_FINISHED_DESCRIPTION", "ERROR_EXTERNAL_SEND_FINISHED_DESCRIPTION", "EXTERNAL_SEND_FINISHED_DESCRIPTION", "EXTERNAL_SEND_COMMAND_CREATION_STARTED_DESCRIPTION", "SUCCEED_EXTERNAL_SEND_COMMAND_CREATION_FINISHED_DESCRIPTION", "ERROR_EXTERNAL_SEND_COMMAND_CREATION_FINISHED_DESCRIPTION", "EXTERNAL_SEND_COMMAND_CREATION_FINISHED_DESCRIPTION", "ERROR_TS_LOADING_CONFIG_FAILED_DESCRIPTION", "LOADING_CONFIG_FAILED_DESCRIPTION", "stageMetadataLoadFailedField", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventLogMetadataUpdateStage;", "errorMetadataLoadFailedField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "codeMetadataLoadFailedField", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "stageMetadataUpdateFailedField", "errorMetadataUpdateFailedField", "codeMetadataUpdateFailedField", "totalLogsSendField", "sendLogsSendField", "failedLogsSendField", "externalLogsSendField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "succeedLogsSendField", "pathsLogsField", "Lcom/intellij/internal/statistic/eventLog/events/AnonymizedListEventField;", "errorsLogsSendField", "Lcom/intellij/internal/statistic/eventLog/events/IntListEventField;", "sendTSExternalSendStarted", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "sendTSExternalSendFinishedField", "succeedExternalSendFinishedField", "errorExternalSendFinishedField", "succeedExternalSendCommandCreationFinishedField", "errorExternalSendCommandCreationFinishedField", "Lcom/intellij/internal/statistic/eventLog/uploader/EventLogUploadException$EventLogUploadErrorType;", "errorLoadingConfigFailedField", "errorTSLoadingConfigFailedField", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EventLogMetadataParseException.EventLogMetadataParseErrorType> entries$0;
        public static final /* synthetic */ EnumEntries<EventLogMetadataLoadException.EventLogMetadataLoadErrorType> entries$1;
        public static final /* synthetic */ EnumEntries<StatisticsResult.ResultCode> entries$2;
        public static final /* synthetic */ EnumEntries<EventLogExternalSendConfig.ParseErrorType> entries$3;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EventLogMetadataParseException.EventLogMetadataParseErrorType.values()));
            entries$1 = EnumEntriesKt.enumEntries((Enum[])EventLogMetadataLoadException.EventLogMetadataLoadErrorType.values());
            entries$2 = EnumEntriesKt.enumEntries((Enum[])StatisticsResult.ResultCode.values());
            entries$3 = EnumEntriesKt.enumEntries((Enum[])EventLogExternalSendConfig.ParseErrorType.values());
        }
    }
}

