/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import java.security.InvalidParameterException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J)\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u0002H\u00d6\u0001J\t\u0010!\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/intellij/internal/statistic/eventLog/events/LimitedIntEventField;", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "", "name", "", "range", "Lkotlin/ranges/IntRange;", "description", "<init>", "(Ljava/lang/String;Lkotlin/ranges/IntRange;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRange", "()Lkotlin/ranges/IntRange;", "getDescription", "validationRule", "", "getValidationRule", "()Ljava/util/List;", "addData", "", "fuData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "value", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.platform.statistics"})
public final class LimitedIntEventField
extends PrimitiveEventField<Integer> {
    @NotNull
    private final String name;
    @NotNull
    private final IntRange range;
    @Nullable
    private final String description;

    public LimitedIntEventField(@NotNull String name, @NotNull IntRange range, @NonNls @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(null, 1, null);
        this.name = name;
        this.range = range;
        this.description = description;
        if (this.range.isEmpty()) {
            throw new InvalidParameterException("Range should not be empty");
        }
        if (this.range.getLast() - this.range.getFirst() - 1 > 500) {
            throw new InvalidParameterException("Range should not contain more than 500 elements");
        }
    }

    public /* synthetic */ LimitedIntEventField(String string, IntRange intRange, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(string, intRange, string2);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final IntRange getRange() {
        return this.range;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<String> getValidationRule() {
        return CollectionsKt.listOf((Object)"{regexp#integer}");
    }

    @Override
    public void addData(@NotNull FeatureUsageData fuData, int value) {
        Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
        int boundedValue = RangesKt.coerceIn((int)value, (int)this.range.getFirst(), (int)this.range.getLast());
        fuData.addData(this.getName(), boundedValue);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final IntRange component2() {
        return this.range;
    }

    @Nullable
    public final String component3() {
        return this.description;
    }

    @NotNull
    public final LimitedIntEventField copy(@NotNull String name, @NotNull IntRange range, @NonNls @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new LimitedIntEventField(name, range, description);
    }

    public static /* synthetic */ LimitedIntEventField copy$default(LimitedIntEventField limitedIntEventField, String string, IntRange intRange, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = limitedIntEventField.name;
        }
        if ((n & 2) != 0) {
            intRange = limitedIntEventField.range;
        }
        if ((n & 4) != 0) {
            string2 = limitedIntEventField.description;
        }
        return limitedIntEventField.copy(string, intRange, string2);
    }

    @NotNull
    public String toString() {
        return "LimitedIntEventField(name=" + this.name + ", range=" + this.range + ", description=" + this.description + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.range.hashCode();
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LimitedIntEventField)) {
            return false;
        }
        LimitedIntEventField limitedIntEventField = (LimitedIntEventField)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)limitedIntEventField.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.range, (Object)limitedIntEventField.range)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.description, (Object)limitedIntEventField.description);
    }
}

