/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.FileContentThreadData;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.MonitorRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.commons.vfs2.util.RawMonitorInputStream;

public final class DefaultFileContent
implements FileContent {
    private static final Certificate[] EMPTY_CERTIFICATE_ARRAY = new Certificate[0];
    private static final int WRITE_BUFFER_SIZE = 4096;
    private final AbstractFileObject<?> fileObject;
    private FileContentInfo fileContentInfo;
    private final FileContentInfoFactory fileContentInfoFactory;
    private final ThreadLocal<FileContentThreadData> threadLocal = ThreadLocal.withInitial(FileContentThreadData::new);
    private int openStreams;

    public DefaultFileContent(AbstractFileObject file, FileContentInfoFactory fileContentInfoFactory) {
        this.fileObject = file;
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    private FileContentThreadData getFileContentThreadData() {
        return this.threadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamOpened() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            ++this.openStreams;
        }
        ((AbstractFileSystem)this.fileObject.getFileSystem()).streamOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            if (this.openStreams > 0) {
                --this.openStreams;
                if (this.openStreams < 1) {
                    this.fileObject.notifyAllStreamsClosed();
                }
            }
        }
        ((AbstractFileSystem)this.fileObject.getFileSystem()).streamClosed();
    }

    @Override
    public FileObject getFile() {
        return this.fileObject;
    }

    @Override
    public long getSize() throws FileSystemException {
        if (!this.fileObject.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/get-size-not-file.error", (Object)this.fileObject);
        }
        try {
            return this.fileObject.doGetContentSize();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/get-size.error", (Throwable)exc, this.fileObject);
        }
    }

    @Override
    public long getLastModifiedTime() throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-last-modified-no-exist.error", (Object)this.fileObject);
        }
        try {
            return this.fileObject.doGetLastModifiedTime();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-last-modified.error", this.fileObject, (Throwable)e);
        }
    }

    @Override
    public void setLastModifiedTime(long modTime) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-last-modified-no-exist.error", (Object)this.fileObject);
        }
        try {
            if (!this.fileObject.doSetLastModifiedTime(modTime)) {
                throw new FileSystemException("vfs.provider/set-last-modified.error", (Object)this.fileObject);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-last-modified.error", this.fileObject, (Throwable)e);
        }
    }

    @Override
    public Certificate[] getCertificates() throws FileSystemException {
        if (!this.fileObject.exists()) {
            throw new FileSystemException("vfs.provider/get-certificates-no-exist.error", (Object)this.fileObject);
        }
        try {
            Certificate[] certs = this.fileObject.doGetCertificates();
            if (certs != null) {
                return certs;
            }
            return EMPTY_CERTIFICATE_ARRAY;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-certificates.error", this.fileObject, (Throwable)e);
        }
    }

    @Override
    public InputStream getInputStream() throws FileSystemException {
        return this.buildInputStream(0);
    }

    @Override
    public InputStream getInputStream(int bufferSize) throws FileSystemException {
        return this.buildInputStream(bufferSize);
    }

    @Override
    public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
        RandomAccessContent rastr = this.fileObject.getRandomAccessContent(mode);
        FileRandomAccessContent rac = new FileRandomAccessContent(this.fileObject, rastr);
        this.getFileContentThreadData().add(rac);
        this.streamOpened();
        return rac;
    }

    @Override
    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
        return this.buildOutputStream(bAppend, 0);
    }

    @Override
    public OutputStream getOutputStream(int bufferSize) throws FileSystemException {
        return this.buildOutputStream(false, bufferSize);
    }

    @Override
    public OutputStream getOutputStream(boolean bAppend, int bufferSize) throws FileSystemException {
        return this.buildOutputStream(bAppend, bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws FileSystemException {
        FileSystemException caught = null;
        try {
            FileContentThreadData threadData = this.getFileContentThreadData();
            while (threadData.hasInputStream()) {
                InputStream inputStream = threadData.removeInputStream(0);
                try {
                    if (inputStream instanceof FileContentInputStream) {
                        ((FileContentInputStream)inputStream).close();
                        continue;
                    }
                    if (inputStream instanceof RawFileContentInputStream) {
                        ((RawFileContentInputStream)inputStream).close();
                        continue;
                    }
                    caught = new FileSystemException("Unsupported InputStream type: " + inputStream);
                }
                catch (FileSystemException ex) {
                    caught = ex;
                }
            }
            while (threadData.hasRandomAccessContent()) {
                FileRandomAccessContent randomAccessContent = (FileRandomAccessContent)threadData.removeRandomAccessContent(0);
                try {
                    randomAccessContent.close();
                }
                catch (FileSystemException ex) {
                    caught = ex;
                }
            }
            FileContentOutputStream outputStream = threadData.getOutputStream();
            if (outputStream != null) {
                threadData.setOutputStream(null);
                try {
                    outputStream.close();
                }
                catch (FileSystemException ex) {
                    caught = ex;
                }
            }
        }
        finally {
            this.threadLocal.remove();
        }
        if (caught != null) {
            throw caught;
        }
    }

    private InputStream buildInputStream(int bufferSize) throws FileSystemException {
        InputStream inputStream;
        InputStream inputStream2 = inputStream = bufferSize == 0 ? this.fileObject.getInputStream() : this.fileObject.getInputStream(bufferSize);
        FilterInputStream wrappedInputStream = inputStream instanceof BufferedInputStream ? new RawFileContentInputStream(this.fileObject, inputStream) : (bufferSize == 0 ? new FileContentInputStream(this.fileObject, inputStream) : new FileContentInputStream(this.fileObject, inputStream, bufferSize));
        this.getFileContentThreadData().add(wrappedInputStream);
        this.streamOpened();
        return wrappedInputStream;
    }

    private OutputStream buildOutputStream(boolean bAppend, int bufferSize) throws FileSystemException {
        FileContentThreadData threadData = this.getFileContentThreadData();
        if (threadData.getOutputStream() != null) {
            throw new FileSystemException("vfs.provider/write-in-use.error", (Object)this.fileObject);
        }
        OutputStream outstr = this.fileObject.getOutputStream(bAppend);
        FileContentOutputStream wrapped = bufferSize == 0 ? new FileContentOutputStream(this.fileObject, outstr) : new FileContentOutputStream(this.fileObject, outstr, bufferSize);
        threadData.setOutputStream(wrapped);
        this.streamOpened();
        return wrapped;
    }

    private void endInput(InputStream instr) {
        FileContentThreadData fileContentThreadData = this.threadLocal.get();
        if (fileContentThreadData != null) {
            fileContentThreadData.remove(instr);
        }
        if (fileContentThreadData == null || !fileContentThreadData.hasStreams()) {
            this.threadLocal.remove();
        }
        this.streamClosed();
    }

    private void endRandomAccess(RandomAccessContent rac) {
        FileContentThreadData fileContentThreadData = this.threadLocal.get();
        if (fileContentThreadData != null) {
            fileContentThreadData.remove(rac);
        }
        if (fileContentThreadData == null || !fileContentThreadData.hasStreams()) {
            this.threadLocal.remove();
        }
        this.streamClosed();
    }

    private void endOutput() throws Exception {
        FileContentThreadData fileContentThreadData = this.threadLocal.get();
        if (fileContentThreadData != null) {
            fileContentThreadData.setOutputStream(null);
        }
        if (fileContentThreadData == null || !fileContentThreadData.hasStreams()) {
            this.threadLocal.remove();
        }
        this.streamClosed();
        this.fileObject.endOutput();
    }

    @Override
    public boolean isOpen() {
        FileContentThreadData fileContentThreadData = this.threadLocal.get();
        if (fileContentThreadData != null && fileContentThreadData.hasStreams()) {
            return true;
        }
        this.threadLocal.remove();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpenGlobal() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            return this.openStreams > 0;
        }
    }

    @Override
    public FileContentInfo getContentInfo() {
        if (this.fileContentInfo == null) {
            try {
                this.fileContentInfo = this.fileContentInfoFactory.create(this);
            }
            catch (FileSystemException e) {
                e.printStackTrace();
            }
        }
        return this.fileContentInfo;
    }

    @Override
    public long write(FileContent fileContent) throws IOException {
        try (OutputStream output = fileContent.getOutputStream();){
            long l = this.write(output);
            return l;
        }
    }

    @Override
    public long write(FileObject file) throws IOException {
        return this.write(file.getContent());
    }

    @Override
    public long write(OutputStream output) throws IOException {
        return this.write(output, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(OutputStream output, int bufferSize) throws IOException {
        long count = 0L;
        try (InputStream input = this.getInputStream();){
            int n;
            byte[] buffer = new byte[bufferSize];
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
        }
        return count;
    }

    final class FileContentOutputStream
    extends MonitorOutputStream {
        private final FileObject file;

        FileContentOutputStream(FileObject file, OutputStream outstr) {
            super(outstr);
            this.file = file;
        }

        FileContentOutputStream(FileObject file, OutputStream outstr, int bufferSize) {
            super(outstr, bufferSize);
            this.file = file;
        }

        @Override
        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-outstr.error", (Object)this.file, (Throwable)e);
            }
        }

        @Override
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                try {
                    DefaultFileContent.this.endOutput();
                }
                catch (Exception e) {
                    throw new FileSystemException("vfs.provider/close-outstr.error", (Object)this.file, (Throwable)e);
                }
            }
        }
    }

    private final class FileRandomAccessContent
    extends MonitorRandomAccessContent {
        private final FileObject file;

        FileRandomAccessContent(FileObject file, RandomAccessContent content) {
            super(content);
            this.file = file;
        }

        @Override
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endRandomAccess(this);
            }
        }

        @Override
        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-rac.error", (Object)this.file, (Throwable)e);
            }
        }
    }

    private final class RawFileContentInputStream
    extends RawMonitorInputStream {
        private final FileObject file;

        RawFileContentInputStream(FileObject file, InputStream instr) {
            super(instr);
            this.file = file;
        }

        @Override
        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-instr.error", (Object)this.file, (Throwable)e);
            }
        }

        @Override
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endInput(this);
            }
        }
    }

    private final class FileContentInputStream
    extends MonitorInputStream {
        private final FileObject file;

        FileContentInputStream(FileObject file, InputStream instr) {
            super(instr);
            this.file = file;
        }

        FileContentInputStream(FileObject file, InputStream instr, int bufferSize) {
            super(instr, bufferSize);
            this.file = file;
        }

        @Override
        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-instr.error", (Object)this.file, (Throwable)e);
            }
        }

        @Override
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endInput(this);
            }
        }
    }
}

