/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"findTranspiledFile", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/openapi/vfs/VirtualFile;", "script", "Lorg/jetbrains/debugger/Script;", "getParentFunction", "Lcom/intellij/lang/javascript/psi/JSFunction;", "startElement", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.debugger"})
public final class MemberFilterVisitorKt {
    @NotNull
    public static final Promise<VirtualFile> findTranspiledFile(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return VmScriptFileSystemKt.getVmFile(script).ensureDownloaded();
    }

    private static final JSFunction getParentFunction(PsiElement startElement) {
        if (startElement instanceof PsiFile) {
            return null;
        }
        boolean ignoreJsFun = true;
        for (PsiElement element = startElement.getParent(); element != null; element = element.getParent()) {
            if (element instanceof JSFunction) {
                if (ignoreJsFun) {
                    ignoreJsFun = false;
                    continue;
                }
                return (JSFunction)element;
            }
            if (!(element instanceof JSParameterList) && !(element instanceof JSBlockStatement) && !(element instanceof JSExpression)) continue;
            ignoreJsFun = false;
        }
        return null;
    }

    public static final /* synthetic */ JSFunction access$getParentFunction(PsiElement startElement) {
        return MemberFilterVisitorKt.getParentFunction(startElement);
    }
}

