/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JavaScriptSuspendContext;
import com.intellij.javascript.debugger.ValueMarkersRefIds;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0013\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0015\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\r\u0010\u0018\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0019J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u001eH&R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/javascript/debugger/V8ValueMarkerProvider;", "Lcom/intellij/xdebugger/frame/XValueMarkerProvider;", "Lorg/jetbrains/debugger/VariableView;", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "markers", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "nextMarker", "markedObjectExpression", "", "canMark", "", "value", "markValue", "(Lorg/jetbrains/debugger/VariableView;)Ljava/lang/Integer;", "getMarker", "unmarkValue", "", "marker", "getMarkersRefIds", "Lcom/intellij/javascript/debugger/ValueMarkersRefIds;", "computeRefIds", "computeRefIds$intellij_javascript_debugger", "storeMarkedValue", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getRefId", "Lorg/jetbrains/debugger/values/Value;", "intellij.javascript.debugger"})
public abstract class V8ValueMarkerProvider
extends XValueMarkerProvider<VariableView, Integer> {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final IntOpenHashSet markers;
    private int nextMarker;
    @NotNull
    private final String markedObjectExpression;

    public V8ValueMarkerProvider(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        super(VariableView.class);
        this.debugProcess = debugProcess;
        this.markers = new IntOpenHashSet();
        this.markedObjectExpression = (this.debugProcess.isFilesOnlyInLocalFileSystem() ? "global" : "window") + ".__IDEA__MARKED__VALUES__";
    }

    public boolean canMark(@NotNull VariableView value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.getRefId(value.getValue()) != null && value.getEvaluationExpression() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Integer markValue(@NotNull VariableView value) {
        int n;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        IntOpenHashSet intOpenHashSet = this.markers;
        synchronized (intOpenHashSet) {
            boolean bl = false;
            int n2 = this.nextMarker;
            this.nextMarker = n2 + 1;
            int marker = n2;
            this.markers.add(marker);
            n = marker;
        }
        int marker = n;
        ValueMarkersRefIds valueMarkersRefIds = this.getMarkersRefIds();
        Intrinsics.checkNotNull((Object)valueMarkersRefIds);
        String string = this.getRefId(value.getValue());
        Intrinsics.checkNotNull((Object)string);
        valueMarkersRefIds.addMarker(marker, string);
        EvaluateContext evaluateContext = value.getEvaluateContext();
        String string2 = value.getEvaluationExpression();
        Intrinsics.checkNotNull((Object)string2);
        this.storeMarkedValue(evaluateContext, marker, string2);
        return marker;
    }

    @Nullable
    public Integer getMarker(@NotNull VariableView value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = this.getRefId(value.getValue());
        if (string == null) {
            return null;
        }
        String refId = string;
        ValueMarkersRefIds valueMarkersRefIds = this.getMarkersRefIds();
        Intrinsics.checkNotNull((Object)valueMarkersRefIds);
        return valueMarkersRefIds.getMarker(refId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmarkValue(@NotNull VariableView value, int marker) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ValueMarkersRefIds valueMarkersRefIds = this.getMarkersRefIds();
        if (valueMarkersRefIds != null) {
            valueMarkersRefIds.removeMarker(marker);
        }
        IntOpenHashSet intOpenHashSet = this.markers;
        synchronized (intOpenHashSet) {
            boolean bl = false;
            boolean bl2 = this.markers.remove(marker);
        }
        this.storeMarkedValue(value.getEvaluateContext(), marker, "null");
    }

    private final ValueMarkersRefIds getMarkersRefIds() {
        XSuspendContext xSuspendContext = this.debugProcess.getSession().getSuspendContext();
        Intrinsics.checkNotNull((Object)xSuspendContext, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.JavaScriptSuspendContext");
        return ((JavaScriptSuspendContext)xSuspendContext).getMarkersRefIds$intellij_javascript_debugger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ValueMarkersRefIds computeRefIds$intellij_javascript_debugger() {
        int[] nArray;
        ValueMarkersRefIds refIds = new ValueMarkersRefIds();
        IntOpenHashSet intOpenHashSet = this.markers;
        synchronized (intOpenHashSet) {
            boolean bl = false;
            nArray = this.markers.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : this.markers.toIntArray();
        }
        int[] ids = nArray;
        Intrinsics.checkNotNull((Object)ids);
        if (!(ids.length == 0)) {
            Vm vm = this.debugProcess.getMainVm();
            Intrinsics.checkNotNull((Object)vm);
            EvaluateContext evaluateContext = vm.getEvaluateContext();
            Intrinsics.checkNotNull((Object)evaluateContext);
            EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)this.markedObjectExpression, null, (boolean)false, null, (int)14, null).onSuccess(arg_0 -> V8ValueMarkerProvider.computeRefIds$lambda$7(arg_0 -> V8ValueMarkerProvider.computeRefIds$lambda$6(ids, refIds, this, arg_0), arg_0));
        }
        return refIds;
    }

    private final void storeMarkedValue(EvaluateContext evaluateContext, int marker, String value) {
        String expression = StringsKt.trimIndent((String)("\n    (function() {\n      var m = " + this.markedObjectExpression + ";\n      if (m == null) {\n        if (typeof WeakMap == \"undefined\") {\n          return;\n        }\n        m = new WeakMap();\n        " + this.markedObjectExpression + " = m;\n      }\n      m.set(" + value + ", " + marker + ");\n    })()\n      "));
        EvaluateContext.evaluate$default((EvaluateContext)evaluateContext, (String)expression, null, (boolean)false, null, (int)14, null).onError(arg_0 -> V8ValueMarkerProvider.storeMarkedValue$lambda$9(V8ValueMarkerProvider::storeMarkedValue$lambda$8, arg_0));
    }

    @Nullable
    public abstract String getRefId(@Nullable Value var1);

    private static final Unit computeRefIds$lambda$6$lambda$5$lambda$3(int[] $ids, ValueMarkersRefIds $refIds, V8ValueMarkerProvider this$0, List it) {
        Arrays.sort($ids);
        for (Variable property : it) {
            int id = StringUtil.parseInt((String)property.getName(), (int)-1);
            if (id == -1 || Arrays.binarySearch($ids, id) == -1) continue;
            String string = this$0.getRefId(property.getValue());
            Intrinsics.checkNotNull((Object)string);
            $refIds.addMarker(id, string);
        }
        return Unit.INSTANCE;
    }

    private static final void computeRefIds$lambda$6$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit computeRefIds$lambda$6(int[] $ids, ValueMarkersRefIds $refIds, V8ValueMarkerProvider this$0, EvaluateResult it) {
        block0: {
            Value value = it.getValue();
            ObjectValue objectValue = value instanceof ObjectValue ? (ObjectValue)value : null;
            if (objectValue == null) break block0;
            ObjectValue it2 = objectValue;
            boolean bl = false;
            it2.getProperties().onSuccess(arg_0 -> V8ValueMarkerProvider.computeRefIds$lambda$6$lambda$5$lambda$4(arg_0 -> V8ValueMarkerProvider.computeRefIds$lambda$6$lambda$5$lambda$3($ids, $refIds, this$0, arg_0), arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final void computeRefIds$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit storeMarkedValue$lambda$8(Throwable it) {
        JavaScriptDebugProcessKt.getLOG().info("Cannot set marker object: " + it);
        return Unit.INSTANCE;
    }

    private static final void storeMarkedValue$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

