/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console.legacy;

import com.intellij.execution.console.BasicGutterContentProvider;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.SegmentList;
import com.intellij.javascript.debugger.console.legacy.Annotation;
import com.intellij.javascript.debugger.console.legacy.LineAnnotation;
import com.intellij.javascript.debugger.console.legacy.LineAnnotationMaps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.util.Url;
import java.awt.Color;
import java.awt.Graphics;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0007H\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0007H\u0003J\u0018\u0010#\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010$\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010(\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006,"}, d2={"Lcom/intellij/javascript/debugger/console/legacy/EditorConsoleGutterProvider;", "Lcom/intellij/execution/console/BasicGutterContentProvider;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "isLineRelationshipComputable", "", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Ljava/util/concurrent/locks/ReentrantReadWriteLock;Z)V", "lineToAnnotation", "Lcom/intellij/javascript/debugger/console/legacy/LineAnnotationMaps;", "getLineToAnnotation$intellij_javascript_debugger", "()Lcom/intellij/javascript/debugger/console/legacy/LineAnnotationMaps;", "relatedLines", "Lcom/intellij/javascript/debugger/SegmentList;", "getRelatedLines$intellij_javascript_debugger", "()Lcom/intellij/javascript/debugger/SegmentList;", "doClear", "", "doClear$intellij_javascript_debugger", "documentCleared", "editor", "Lcom/intellij/openapi/editor/Editor;", "increaseLastMessageRepeatCount", "consoleView", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "hasText", "getText", "", "line", "", "getToolTip", "getStringInfo", "toolTip", "doAction", "drawIcon", "g", "Ljava/awt/Graphics;", "y", "doIsShowSeparatorLine", "document", "Lcom/intellij/openapi/editor/Document;", "getLineStartGutterOverlap", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nEditorConsoleGutterProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConsoleGutterProvider.kt\ncom/intellij/javascript/debugger/console/legacy/EditorConsoleGutterProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,535:1\n1#2:536\n*E\n"})
public final class EditorConsoleGutterProvider
extends BasicGutterContentProvider {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final LineAnnotationMaps lineToAnnotation;
    @NotNull
    private final SegmentList relatedLines;

    public EditorConsoleGutterProvider(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull ReentrantReadWriteLock lock, boolean isLineRelationshipComputable) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        super(isLineRelationshipComputable);
        this.debugProcess = debugProcess;
        this.lock = lock;
        this.lineToAnnotation = new LineAnnotationMaps();
        this.relatedLines = new SegmentList();
    }

    @NotNull
    public final LineAnnotationMaps getLineToAnnotation$intellij_javascript_debugger() {
        return this.lineToAnnotation;
    }

    @NotNull
    public final SegmentList getRelatedLines$intellij_javascript_debugger() {
        return this.relatedLines;
    }

    public final void doClear$intellij_javascript_debugger() {
        this.lineToAnnotation.clear();
        this.relatedLines.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentCleared(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.doClear$intellij_javascript_debugger();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public final void increaseLastMessageRepeatCount(@NotNull ConsoleViewImpl consoleView) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.lock.isWriteLockedByCurrentThread());
        Pair<Integer, LineAnnotation> annotation = this.lineToAnnotation.getLast();
        if (annotation == null) {
            return;
        }
        LineAnnotation lineAnnotation = (LineAnnotation)annotation.getSecond();
        lineAnnotation.setRepeatCount(lineAnnotation.getRepeatCount() + 1);
        int shownRepeatCount = lineAnnotation.getRepeatCount() + 1;
        if (shownRepeatCount < 10) {
            return;
        }
        int newRepeatCountLength = String.valueOf(shownRepeatCount).length();
        if (newRepeatCountLength <= String.valueOf(shownRepeatCount - 1).length()) {
            return;
        }
        int excess = newRepeatCountLength + 1 - 2;
        boolean bl2 = bl = excess > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int version = this.lineToAnnotation.getVersion();
        int consoleOffset = ((Number)annotation.getFirst()).intValue();
        ApplicationManager.getApplication().invokeLater(new Runnable(this, version, consoleView, consoleOffset, excess){
            final /* synthetic */ EditorConsoleGutterProvider this$0;
            final /* synthetic */ int $version;
            final /* synthetic */ ConsoleViewImpl $consoleView;
            final /* synthetic */ int $consoleOffset;
            final /* synthetic */ int $excess;
            {
                this.this$0 = $receiver;
                this.$version = $version;
                this.$consoleView = $consoleView;
                this.$consoleOffset = $consoleOffset;
                this.$excess = $excess;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                ReentrantReadWriteLock.WriteLock writeLock = EditorConsoleGutterProvider.access$getLock$p(this.this$0).writeLock();
                if (writeLock.tryLock(50L, TimeUnit.MILLISECONDS)) {
                    try {
                        if (this.$version != this.this$0.getLineToAnnotation$intellij_javascript_debugger().getVersion()) {
                            return;
                        }
                        this.$consoleView.flushDeferredText();
                        Editor editor = this.$consoleView.getEditor();
                        Intrinsics.checkNotNull((Object)editor);
                        Document document = editor.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                        Document document2 = document;
                        int lineNumber = document2.getLineNumber(this.$consoleOffset);
                        int lineStartOffset = document2.getLineStartOffset(lineNumber);
                        int missed = this.$excess - StringUtil.countChars((CharSequence)document2.getImmutableCharSequence(), (char)' ', (int)lineStartOffset, (boolean)true);
                        if (missed <= 0) return;
                        document2.insertString(lineStartOffset, (CharSequence)StringUtil.repeat((String)" ", (int)missed));
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                    finally {
                        writeLock.unlock();
                    }
                } else {
                    ApplicationManager.getApplication().invokeLater((Runnable)this);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasText() {
        boolean bl;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            bl = !this.lineToAnnotation.isEmpty();
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    @Nullable
    public String getText(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getStringInfo(line, editor, false);
    }

    @Nullable
    public String getToolTip(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getStringInfo(line, editor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NlsSafe
    private final String getStringInfo(int line, Editor editor, boolean toolTip) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Object object = this.lineToAnnotation.get(line, editor);
            if (object == null || (object = ((LineAnnotation)object).getAnno()) == null) {
                String string = null;
                return string;
            }
            Object annotation = object;
            String name = null;
            VirtualFile file = ((Annotation)annotation).getFile();
            if (toolTip) {
                if (((Annotation)annotation).getUrl() != null) {
                    name = ((Annotation)annotation).getUrl().trimParameters().toDecodedForm();
                } else {
                    VirtualFile virtualFile = file;
                    Intrinsics.checkNotNull((Object)virtualFile);
                    name = JsFileUtil.getShortenedFilePath(virtualFile, this.debugProcess.getSession().getProject());
                }
            } else {
                if (((Annotation)annotation).getUrl() == null) {
                    boolean bl2;
                    boolean bl3 = bl2 = file != null;
                    if (_Assertions.ENABLED && !bl2) {
                        String string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    VirtualFile virtualFile = file;
                    Intrinsics.checkNotNull((Object)virtualFile);
                    name = virtualFile.getName();
                } else {
                    name = ((Annotation)annotation).getUrl().trimParameters().toDecodedForm();
                }
                name = StringUtil.trimMiddle((String)name, (int)100);
            }
            String string = ((Annotation)annotation).getLine() < 0 ? name : name + ":" + (((Annotation)annotation).getLine() + 1);
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Annotation currentAnnotation = null;
        VirtualFile newFile = null;
        RangeMarker newPosition = null;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Annotation annotation;
            boolean bl = false;
            LineAnnotation lineAnnotation = this.lineToAnnotation.get(line, editor);
            currentAnnotation = annotation = lineAnnotation != null ? lineAnnotation.getAnno() : null;
            if (annotation != null) {
                VirtualFile file = annotation.getFile();
                if (file == null) {
                    Url url = annotation.getUrl();
                    Intrinsics.checkNotNull((Object)url);
                    file = this.debugProcess.findFileOrAny(url);
                    if (file == null) {
                        this.debugProcess.getSession().reportError(JSDebuggerBundle.message("console.editor.notification.error.cannot.navigate", new Object[0]));
                        return;
                    }
                    newFile = file;
                }
                Navigatable descriptor = null;
                if (annotation.getPosition() == null || annotation.getLine() < 0) {
                    OpenFileDescriptor ofd = new OpenFileDescriptor(this.debugProcess.getSession().getProject(), file, annotation.getLine(), annotation.getColumn());
                    descriptor = (Navigatable)ofd;
                    newPosition = ofd.getRangeMarker();
                } else {
                    PsiNavigationSupport psiNavigationSupport = PsiNavigationSupport.getInstance();
                    Project project = this.debugProcess.getSession().getProject();
                    RangeMarker rangeMarker = annotation.getPosition();
                    Intrinsics.checkNotNull((Object)rangeMarker);
                    descriptor = psiNavigationSupport.createNavigatable(project, file, rangeMarker.getStartOffset());
                }
                descriptor.navigate(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        if (newFile != null || newPosition != null) {
            ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
            readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int i = 0; i < n; ++i) {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Annotation anno;
                boolean bl = false;
                LineAnnotation lineAnnotation = this.lineToAnnotation.get(line, editor);
                Annotation annotation = anno = lineAnnotation != null ? lineAnnotation.getAnno() : null;
                if (anno != null && Intrinsics.areEqual((Object)anno, (Object)currentAnnotation)) {
                    if (newFile != null) {
                        anno.setFile(newFile);
                    }
                    if (newPosition != null) {
                        anno.setPosition(newPosition);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                for (int i = 0; i < n; ++i) {
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawIcon(int line, @NotNull Graphics g, int y, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            if (super.drawIcon(line, g, y, editor)) {
                boolean bl2 = true;
                return bl2;
            }
            LineAnnotation annotation = this.lineToAnnotation.get(line, editor);
            if (annotation == null || annotation.getRepeatCount() <= 0) {
                boolean bl3 = false;
                return bl3;
            }
            String text = String.valueOf(annotation.getRepeatCount() + 1);
            g.setColor((Color)JBColor.LIGHT_GRAY);
            g.drawString(text, 3, y);
            boolean bl4 = true;
            return bl4;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doIsShowSeparatorLine(int line, @NotNull Editor editor, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        int lineStartOffset = document.getLineStartOffset(line);
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            int rangeIndex = this.relatedLines.getRangeIndex(lineStartOffset);
            if (rangeIndex != -1) {
                boolean bl2 = !this.relatedLines.rangeContains(rangeIndex, document.getLineStartOffset(line + 1));
                return bl2;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return this.isLineRelationshipComputable;
    }

    public int getLineStartGutterOverlap(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return EditorUtil.getSpaceWidth((int)0, (Editor)editor) * 3;
    }

    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$p(EditorConsoleGutterProvider $this) {
        return $this.lock;
    }
}

