/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer.actions;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceFileFinder;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Url;
import java.awt.Dimension;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u00a8\u0006\f"}, d2={"visualizeMap", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "generatedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "sourceUrl", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "sourceFileFinder", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceFileFinder;", "intellij.javascript.debugger"})
public final class VisualizeSourceMapActionKt {
    public static final void visualizeMap(@NotNull SourceMap sourceMap, @NotNull VirtualFile generatedFile, @Nullable Url sourceUrl, @NotNull Project project, @Nullable SourceFileFinder sourceFileFinder) {
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkNotNullParameter((Object)generatedFile, (String)"generatedFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String dimensionKey = "SourceMapInspector.frame";
        if (DimensionService.getInstance().getSize(dimensionKey, project) == null) {
            JFrame jFrame = WindowManager.getInstance().getFrame(project);
            Dimension frameSize = jFrame != null ? jFrame.getSize() : null;
            DimensionService.getInstance().setSize(dimensionKey, frameSize, project);
        }
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        SourceMapInspector mapInspector = new SourceMapInspector(sourceMap, generatedFile, project, (Disposable)dialogBuilder, sourceFileFinder);
        Object[] objectArray = new Object[]{mapInspector.getGeneratedEditor().getVirtualFile().getName()};
        dialogBuilder.title(JSDebuggerBundle.message("js.scripts.visualize.dialog.title", objectArray)).centerPanel(mapInspector.createMainComponent(sourceUrl)).dimensionKey(dimensionKey).showNotModal();
    }

    public static /* synthetic */ void visualizeMap$default(SourceMap sourceMap, VirtualFile virtualFile, Url url, Project project, SourceFileFinder sourceFileFinder, int n, Object object) {
        if ((n & 0x10) != 0) {
            sourceFileFinder = null;
        }
        VisualizeSourceMapActionKt.visualizeMap(sourceMap, virtualFile, url, project, sourceFileFinder);
    }
}

