/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fH\u0000\u001a\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007\"\u0018\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\"\u000e\u0010\u0013\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"VariableView", "Lorg/jetbrains/debugger/VariableView;", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "getClassName", "", "value", "Lorg/jetbrains/debugger/values/ObjectValue;", "getObjectValueDescription", "trimFunctionDescription", "Lorg/jetbrains/debugger/values/Value;", "createNumberPresentation", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "ARRAY_DESCRIPTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "PROTO_PROP", "PROTOTYPE_PROP", "isPrototypeVariable", "", "variableName", "intellij.javascript.debugger.ui"})
public final class VariableViewKt {
    private static final Pattern ARRAY_DESCRIPTION_PATTERN = Pattern.compile("^[a-zA-Z\\d]+[\\[(]\\d+[\\])]$");
    @NotNull
    public static final String PROTO_PROP = "__proto__";
    @NotNull
    public static final String PROTOTYPE_PROP = "[[Prototype]]";

    @NotNull
    public static final VariableView VariableView(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new VariableView(string, variable, context);
    }

    @NotNull
    public static final String getClassName(@NotNull ObjectValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String className = value.getClassName();
        CharSequence charSequence = className;
        return charSequence == null || charSequence.length() == 0 ? "Object" : (Intrinsics.areEqual((Object)className, (Object)"console") ? "Console" : className);
    }

    @NotNull
    public static final String getObjectValueDescription(@NotNull ObjectValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String description = value.getValueString();
        CharSequence charSequence = description;
        return charSequence == null || charSequence.length() == 0 ? VariableViewKt.getClassName(value) : description;
    }

    @NotNull
    public static final String trimFunctionDescription(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.getValueString();
        if (string == null) {
            return "";
        }
        return VariableViewKt.trimFunctionDescription(string);
    }

    @NotNull
    public static final String trimFunctionDescription(@NotNull String value) {
        int endIndex;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        for (endIndex = 0; endIndex < value.length() && !StringUtil.isLineBreak((char)value.charAt(endIndex)); ++endIndex) {
        }
        while (endIndex > 0 && Character.isWhitespace(value.charAt(endIndex - 1))) {
            --endIndex;
        }
        String string = value.substring(0, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final XValuePresentation createNumberPresentation(String value) {
        return Intrinsics.areEqual((Object)value, (Object)"NaN") || Intrinsics.areEqual((Object)value, (Object)"Infinity") ? (XValuePresentation)new XKeywordValuePresentation(value) : (XValuePresentation)new XNumericValuePresentation(value);
    }

    public static final boolean isPrototypeVariable(@NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        return Intrinsics.areEqual((Object)variableName, (Object)PROTO_PROP) || Intrinsics.areEqual((Object)variableName, (Object)PROTOTYPE_PROP);
    }

    public static final /* synthetic */ Pattern access$getARRAY_DESCRIPTION_PATTERN$p() {
        return ARRAY_DESCRIPTION_PATTERN;
    }

    public static final /* synthetic */ XValuePresentation access$createNumberPresentation(String value) {
        return VariableViewKt.createNumberPresentation(value);
    }
}

