/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rollback;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.repo.GitRepository;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class GitRollbackEnvironment
implements RollbackEnvironment {
    @NotNull
    private final Project myProject;

    public GitRollbackEnvironment(@NotNull Project project) {
        if (project == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getRollbackOperationName() {
        String string = GitBundle.message("git.rollback", new Object[0]);
        if (string == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void rollbackModifiedWithoutCheckout(List<? extends VirtualFile> files, List<? super VcsException> exceptions, RollbackProgressListener listener2) {
        throw new UnsupportedOperationException("Explicit file checkout is not supported by Git.");
    }

    public void rollbackMissingFileDeletion(List<? extends FilePath> files, List<? super VcsException> exceptions, RollbackProgressListener listener2) {
        throw new UnsupportedOperationException("Missing file delete is not reported by Git.");
    }

    public void rollbackChanges(List<? extends Change> changes, List<VcsException> exceptions, @NotNull RollbackProgressListener listener2) {
        if (listener2 == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(2);
        }
        HashMap<VirtualFile, List<FilePath>> toUnindex = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toUnversion = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toRevert = new HashMap<VirtualFile, List<FilePath>>();
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        listener2.determinate();
        for (Change change : changes) {
            switch (change.getType()) {
                case NEW: {
                    this.registerFile(toUnversion, change.getAfterRevision().getFile(), exceptions);
                    break;
                }
                case MOVED: {
                    this.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    this.registerFile(toUnindex, change.getAfterRevision().getFile(), exceptions);
                    toDelete.add(change.getAfterRevision().getFile());
                    break;
                }
                case MODIFICATION: {
                    this.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    break;
                }
                case DELETED: {
                    this.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                }
            }
        }
        for (Map.Entry entry : toUnindex.entrySet()) {
            listener2.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue(), false);
            }
            catch (VcsException vcsException) {
                exceptions.add(vcsException);
            }
        }
        for (Map.Entry entry : toUnversion.entrySet()) {
            listener2.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue(), true);
            }
            catch (VcsException vcsException) {
                exceptions.add(vcsException);
            }
        }
        for (FilePath filePath : toDelete) {
            listener2.accept(filePath);
            try {
                File file = filePath.getIOFile();
                if (!file.exists() || file.delete()) continue;
                exceptions.add(new VcsException(GitBundle.message("error.cannot.delete.file", filePath.getPresentableUrl())));
            }
            catch (Exception exception) {
                exceptions.add(new VcsException(GitBundle.message("error.cannot.delete.file", filePath.getPresentableUrl()), (Throwable)exception));
            }
        }
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)VcsBundle.message((String)"activity.name.rollback", (Object[])new Object[0]));){
            for (Map.Entry<VirtualFile, List<FilePath>> entry : toRevert.entrySet()) {
                listener2.accept(entry.getValue());
                try {
                    this.revert(entry.getKey(), entry.getValue());
                }
                catch (VcsException vcsException) {
                    exceptions.add(vcsException);
                }
            }
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        HashSet<File> hashSet = new HashSet<File>();
        for (Change change : changes) {
            ContentRevision after;
            ContentRevision before = change.getBeforeRevision();
            if (before != null) {
                hashSet.add(new File(before.getFile().getPath()));
            }
            if ((after = change.getAfterRevision()) == null) continue;
            hashSet.add(new File(after.getFile().getPath()));
        }
        lfs.refreshIoFiles(hashSet);
        GitIndexFileSystemRefresher.refreshFilePaths(this.myProject, toUnindex);
        for (GitRepository gitRepository : GitUtil.getRepositoryManager(this.myProject).getRepositories()) {
            gitRepository.update();
        }
    }

    public void revert(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (root == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(3);
        }
        if (files == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(4);
        }
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, files)) {
            GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.CHECKOUT);
            handler.addParameters("HEAD");
            handler.endOptions();
            handler.addParameters(paths);
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
        }
    }

    private void unindex(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files, boolean toUnversioned) throws VcsException {
        if (root == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(5);
        }
        if (files == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(6);
        }
        GitFileUtils.deletePaths(this.myProject, root, files, "--cached", "-f");
        if (toUnversioned) {
            GitUntrackedFilesHolder untrackedFilesHolder;
            GitRepository repo2 = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(root);
            GitUntrackedFilesHolder gitUntrackedFilesHolder = untrackedFilesHolder = repo2 == null ? null : repo2.getUntrackedFilesHolder();
            if (untrackedFilesHolder != null) {
                untrackedFilesHolder.addUntracked(files);
            }
        }
    }

    private void registerFile(@NotNull Map<VirtualFile, List<FilePath>> files, @NotNull FilePath file, @NotNull List<? super VcsException> exceptions) {
        if (files == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(8);
        }
        if (exceptions == null) {
            GitRollbackEnvironment.$$$reportNull$$$0(9);
        }
        try {
            VirtualFile root = GitUtil.getRootForFile(this.myProject, file);
            List paths = files.computeIfAbsent(root, key -> new ArrayList());
            paths.add(file);
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rollback/GitRollbackEnvironment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rollback/GitRollbackEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "rollbackChanges";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unindex";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

