/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsShelveChangesSaver;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVersionSpecialty;
import git4idea.index.GitFileStatus;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GitShelveChangesSaver
extends GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitShelveChangesSaver.class);
    private final VcsShelveChangesSaver myVcsShelveChangesSaver;

    public GitShelveChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator, @NotNull @Nls String stashMessage) {
        if (project == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(2);
        }
        if (stashMessage == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(3);
        }
        super(project, git, indicator, GitSaveChangesPolicy.SHELVE, stashMessage);
        this.myVcsShelveChangesSaver = new VcsShelveChangesSaver(project, indicator, stashMessage){

            protected void doRollback(@NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull Collection<Change> shelvedChanges) {
                if (rootsToSave == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (shelvedChanges == null) {
                    1.$$$reportNull$$$0(1);
                }
                GitShelveChangesSaver.this.rollbackChanges(rootsToSave, shelvedChanges);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootsToSave";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "shelvedChanges";
                        break;
                    }
                }
                objectArray[1] = "git4idea/stash/GitShelveChangesSaver$1";
                objectArray[2] = "doRollback";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    protected void save(@NotNull Collection<? extends VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(4);
        }
        this.myVcsShelveChangesSaver.save(rootsToSave);
    }

    @Override
    public void load() {
        this.myVcsShelveChangesSaver.load();
    }

    @Override
    public boolean wereChangesSaved() {
        List shelvedLists = this.myVcsShelveChangesSaver.getShelvedLists();
        return !shelvedLists.isEmpty();
    }

    @Override
    public void showSavedChanges() {
        List shelvedLists = this.myVcsShelveChangesSaver.getShelvedLists();
        if (!shelvedLists.isEmpty()) {
            Comparator<ShelvedChangeList> nameComparator = Comparator.comparing(it -> it.getDisplayName(), String.CASE_INSENSITIVE_ORDER);
            List sorted = ContainerUtil.sorted((Collection)shelvedLists, nameComparator);
            ShelvedChangesViewManager.getInstance((Project)this.myProject).activateView((ShelvedChangeList)sorted.get(0));
        }
    }

    private void rollbackChanges(@NotNull Collection<? extends VirtualFile> rootsToSave, @NotNull Collection<Change> shelvedChanges) {
        if (rootsToSave == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(5);
        }
        if (shelvedChanges == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(6);
        }
        if (GitVersionSpecialty.RESTORE_SUPPORTED.existsIn(this.myProject)) {
            List filePaths = ChangesUtil.getPaths(shelvedChanges);
            Map<VirtualFile, List<FilePath>> map2 = GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, filePaths);
            for (VirtualFile virtualFile : rootsToSave) {
                List rootPaths = ContainerUtil.notNullize(map2.get(virtualFile));
                GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForRoot(virtualFile);
                if (repository == null || repository.getCurrentRevision() == null) {
                    GitShelveChangesSaver.resetHardLocal(this.myProject, virtualFile);
                    continue;
                }
                HashSet rootPathsSet = new HashSet(rootPaths);
                ArrayList<FilePath> pathsToUnstage = new ArrayList<FilePath>();
                for (GitFileStatus record : repository.getStagingAreaHolder().getAllRecords()) {
                    if (!record.isTracked() || record.getStagedStatus() == null || rootPathsSet.contains(record.getPath())) continue;
                    pathsToUnstage.add(record.getPath());
                }
                GitShelveChangesSaver.restoreStagedAndWorktree(this.myProject, virtualFile, rootPaths);
                GitShelveChangesSaver.restoreStaged(this.myProject, virtualFile, pathsToUnstage);
            }
        } else {
            for (VirtualFile virtualFile : rootsToSave) {
                GitShelveChangesSaver.resetHardLocal(this.myProject, virtualFile);
            }
        }
        for (VirtualFile virtualFile : rootsToSave) {
            VcsDirtyScopeManager.getInstance((Project)this.myProject).dirDirtyRecursively(virtualFile);
        }
    }

    private static void resetHardLocal(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(7);
        }
        if (root == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(8);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESET);
        handler.addParameters("--hard");
        handler.endOptions();
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        if (!result2.success()) {
            LOG.warn("Can't reset changes:" + result2.getErrorOutputAsJoinedString());
        }
    }

    private static void restoreStagedAndWorktree(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<FilePath> filePaths) {
        if (project == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(9);
        }
        if (root == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(10);
        }
        if (filePaths == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(11);
        }
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, filePaths)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESTORE);
            handler.addParameters("--staged", "--worktree", "--source=HEAD");
            handler.endOptions();
            handler.addParameters(paths);
            GitCommandResult result2 = Git.getInstance().runCommand(handler);
            if (result2.success()) continue;
            LOG.warn("Can't restore changes:" + result2.getErrorOutputAsJoinedString());
        }
    }

    private static void restoreStaged(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<FilePath> filePaths) {
        if (project == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(12);
        }
        if (root == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(13);
        }
        if (filePaths == null) {
            GitShelveChangesSaver.$$$reportNull$$$0(14);
        }
        for (List paths : VcsFileUtil.chunkPaths((VirtualFile)root, filePaths)) {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.RESTORE);
            handler.addParameters("--staged", "--source=HEAD");
            handler.endOptions();
            handler.addParameters(paths);
            GitCommandResult result2 = Git.getInstance().runCommand(handler);
            if (result2.success()) continue;
            LOG.warn("Can't restore changes:" + result2.getErrorOutputAsJoinedString());
        }
    }

    void setReportLocalHistoryActivity(boolean reportLocalHistoryActivity) {
        this.myVcsShelveChangesSaver.setReportLocalHistoryActivity(reportLocalHistoryActivity);
    }

    @NonNls
    public String toString() {
        return "ShelveChangesSaver. Lists: " + this.myVcsShelveChangesSaver.getShelvedLists();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stashMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChanges";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
        }
        objectArray2[1] = "git4idea/stash/GitShelveChangesSaver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "rollbackChanges";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "resetHardLocal";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreStagedAndWorktree";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreStaged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

