/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchesDashboardActions;
import git4idea.ui.branch.dashboard.BranchesDashboardController;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.BranchesTreeStateHolder;
import git4idea.ui.branch.dashboard.BranchesTreeStateProvider;
import git4idea.ui.branch.dashboard.FilteringBranchesTreeBase;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B4\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001eJ\u000e\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u001dJ\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\"H\u0002J\b\u0010)\u001a\u00020\"H\u0002J\u0012\u0010*\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\tH\u0014J\u0012\u0010,\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010-\u001a\u00020\"H\u0002J\u000e\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u001eJ\u001e\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020\u001e2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\"03H\u0002J\b\u00104\u001a\u00020\"H\u0002J\u0006\u00105\u001a\u00020\"J\u0006\u00106\u001a\u00020\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00067"}, d2={"Lgit4idea/ui/branch/dashboard/FilteringBranchesTree;", "Lgit4idea/ui/branch/dashboard/FilteringBranchesTreeBase;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "uiController", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "place", "", "Lorg/jetbrains/annotations/NonNls;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;Lgit4idea/ui/branch/dashboard/BranchesDashboardController;Ljava/lang/String;Lcom/intellij/openapi/Disposable;)V", "getComponent", "()Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "expandedPaths", "Ljava/util/HashSet;", "Ljavax/swing/tree/TreePath;", "Lkotlin/collections/HashSet;", "treeStateProvider", "Lgit4idea/ui/branch/dashboard/BranchesTreeStateProvider;", "treeStateHolder", "Lgit4idea/ui/branch/dashboard/BranchesTreeStateHolder;", "getTreeStateHolder", "()Lgit4idea/ui/branch/dashboard/BranchesTreeStateHolder;", "groupingConfig", "", "Lcom/intellij/dvcs/branch/GroupingKey;", "", "getGroupingConfig", "()Ljava/util/Map;", "toggleGrouping", "", "key", "state", "isGroupingEnabled", "installSearchField", "Lcom/intellij/ui/SearchTextField;", "setupTreeListeners", "restorePreviouslyExpandedPaths", "expandTreeOnSearchUpdateComplete", "pattern", "onSpeedSearchUpdateComplete", "updateSpeedSearchBackground", "update", "initial", "runPreservingTreeState", "loadSaved", "runnable", "Lkotlin/Function0;", "initDefaultTreeExpandState", "refreshTree", "refreshNodeDescriptorsModel", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nBranchesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/FilteringBranchesTree\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,519:1\n31#2,2:520\n31#2,2:522\n*S KotlinDebug\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/FilteringBranchesTree\n*L\n238#1:520,2\n235#1:522,2\n*E\n"})
public final class FilteringBranchesTree
extends FilteringBranchesTreeBase {
    @NotNull
    private final BranchesTreeComponent component;
    @NotNull
    private final BranchesDashboardController uiController;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final HashSet<TreePath> expandedPaths;
    @NotNull
    private final BranchesTreeStateProvider treeStateProvider;
    @NotNull
    private final Map<GroupingKey, Boolean> groupingConfig;

    /*
     * WARNING - void declaration
     */
    public FilteringBranchesTree(@NotNull Project project, @NotNull BranchesTreeComponent component2, @NotNull BranchesDashboardController uiController, @NotNull String place, @NotNull Disposable disposable) {
        void $this$groupingConfig_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)component2), (String)"component");
        Intrinsics.checkNotNullParameter((Object)uiController, (String)"uiController");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super((Tree)component2, project);
        this.component = component2;
        this.uiController = uiController;
        this.disposable = disposable;
        this.expandedPaths = new HashSet();
        this.treeStateProvider = new BranchesTreeStateProvider(this, this.disposable);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service22 = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GitBranchManager $i$f$service22 = (GitBranchManager)((Object)object);
        FilteringBranchesTree filteringBranchesTree = this;
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)GroupingKey.GROUPING_BY_DIRECTORY, (Object)$this$groupingConfig_u24lambda_u241.isGroupingEnabled(GroupingKey.GROUPING_BY_DIRECTORY)), TuplesKt.to((Object)GroupingKey.GROUPING_BY_REPOSITORY, (Object)$this$groupingConfig_u24lambda_u241.isGroupingEnabled(GroupingKey.GROUPING_BY_REPOSITORY))};
        filteringBranchesTree.groupingConfig = MapsKt.hashMapOf((Pair[])pairArray);
        ActionsKt.runInEdt$default(null, () -> FilteringBranchesTree._init_$lambda$2(this, place), (int)1, null);
    }

    @NotNull
    public final BranchesTreeComponent getComponent() {
        return this.component;
    }

    private final BranchesTreeStateHolder getTreeStateHolder() {
        Object object = BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.disposable, () -> FilteringBranchesTree._get_treeStateHolder_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runUnderDisposeAwareIndicator(...)");
        return (BranchesTreeStateHolder)object;
    }

    @Override
    @NotNull
    protected Map<GroupingKey, Boolean> getGroupingConfig() {
        return this.groupingConfig;
    }

    public final void toggleGrouping(@NotNull GroupingKey key, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Boolean bl = state2;
        this.getGroupingConfig().put(key, bl);
        this.refreshTree();
    }

    public final boolean isGroupingEnabled(@NotNull GroupingKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Intrinsics.areEqual((Object)this.getGroupingConfig().get(key), (Object)true);
    }

    @NotNull
    public SearchTextField installSearchField() {
        SearchTextField searchTextField = super.installSearchField();
        Intrinsics.checkNotNullExpressionValue((Object)searchTextField, (String)"installSearchField(...)");
        SearchTextField searchField = searchTextField;
        this.component.setSearchField(searchField);
        return searchField;
    }

    private final void setupTreeListeners() {
        this.component.addTreeExpansionListener(new TreeExpansionListener(this){
            final /* synthetic */ FilteringBranchesTree this$0;
            {
                this.this$0 = $receiver;
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FilteringBranchesTree.access$getExpandedPaths$p(this.this$0).add(event.getPath());
                FilteringBranchesTree.access$getTreeStateHolder(this.this$0).setStateProvider(FilteringBranchesTree.access$getTreeStateProvider$p(this.this$0));
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FilteringBranchesTree.access$getExpandedPaths$p(this.this$0).remove(event.getPath());
                FilteringBranchesTree.access$getTreeStateHolder(this.this$0).setStateProvider(FilteringBranchesTree.access$getTreeStateProvider$p(this.this$0));
            }
        });
        this.component.addTreeSelectionListener(arg_0 -> FilteringBranchesTree.setupTreeListeners$lambda$3(this, arg_0));
    }

    private final void restorePreviouslyExpandedPaths() {
        TreeUtil.restoreExpandedPaths((JTree)((JTree)((Object)this.component)), (List)CollectionsKt.toList((Iterable)this.expandedPaths));
    }

    protected void expandTreeOnSearchUpdateComplete(@Nullable String pattern) {
        this.restorePreviouslyExpandedPaths();
    }

    protected void onSpeedSearchUpdateComplete(@Nullable String pattern) {
        this.updateSpeedSearchBackground();
    }

    private final void updateSpeedSearchBackground() {
        SpeedSearchSupply speedSearchSupply = this.getSearchModel().getSpeedSearch();
        SpeedSearch speedSearch = speedSearchSupply instanceof SpeedSearch ? (SpeedSearch)speedSearchSupply : null;
        if (speedSearch == null) {
            return;
        }
        SpeedSearch speedSearch2 = speedSearch;
        SearchTextField searchTextField = this.component.getSearchField();
        if (searchTextField == null || (searchTextField = searchTextField.getTextEditor()) == null) {
            return;
        }
        SearchTextField textEditor = searchTextField;
        if (this.isEmptyModel()) {
            textEditor.setOpaque(true);
            speedSearch2.noHits();
        } else {
            textEditor.setOpaque(false);
            textEditor.setBackground(UIUtil.getTextFieldBackground());
        }
    }

    public final void update(boolean initial) {
        boolean branchesReloaded = this.uiController.reloadBranches();
        this.runPreservingTreeState(initial, (Function0<Unit>)((Function0)() -> FilteringBranchesTree.update$lambda$4(this)));
        if (branchesReloaded) {
            this.getTree().revalidate();
            this.getTree().repaint();
        }
    }

    private final void runPreservingTreeState(boolean loadSaved, Function0<Unit> runnable) {
        if (Registry.Companion.is("git.branches.panel.persist.tree.state")) {
            TreeState treeState = loadSaved ? this.getTreeStateHolder().getInitialTreeState() : TreeState.createOn((JTree)((JTree)this.getTree()), (DefaultMutableTreeNode)this.getRoot());
            runnable.invoke();
            if (treeState != null) {
                treeState.applyTo((JTree)this.getTree());
            } else {
                this.initDefaultTreeExpandState();
            }
        } else {
            runnable.invoke();
            if (loadSaved) {
                this.initDefaultTreeExpandState();
            }
        }
    }

    private final void initDefaultTreeExpandState() {
        if (TreeUtil.hasManyNodes((Tree)this.getTree(), (int)30000)) {
            TreeUtil.collapseAll((JTree)((JTree)this.getTree()), (int)1);
        } else {
            TreeUtil.expandAll((JTree)((JTree)this.getTree()));
        }
    }

    public final void refreshTree() {
        this.runPreservingTreeState(false, (Function0<Unit>)((Function0)() -> FilteringBranchesTree.refreshTree$lambda$5(this)));
    }

    public final void refreshNodeDescriptorsModel() {
        this.refreshNodeDescriptorsModel$intellij_vcs_git(this.uiController.getRefs(), this.uiController.getShowOnlyMy());
    }

    private static final BranchesTreeStateHolder _get_treeStateHolder_$lambda$0(FilteringBranchesTree this$0) {
        ComponentManager $this$service$iv = (ComponentManager)this$0.getProject();
        boolean $i$f$service = false;
        Class<BranchesTreeStateHolder> serviceClass$iv = BranchesTreeStateHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (BranchesTreeStateHolder)object;
    }

    private static final Unit _init_$lambda$2(FilteringBranchesTree this$0, String $place) {
        PopupHandler.installPopupMenu((JComponent)((JComponent)((Object)this$0.component)), (ActionGroup)new BranchesDashboardActions.BranchesTreeActionGroup(), (String)$place);
        this$0.setupTreeListeners();
        return Unit.INSTANCE;
    }

    private static final void setupTreeListeners$lambda$3(FilteringBranchesTree this$0, TreeSelectionEvent it) {
        this$0.getTreeStateHolder().setStateProvider(this$0.treeStateProvider);
    }

    private static final Unit update$lambda$4(FilteringBranchesTree this$0) {
        this$0.getSearchModel().updateStructure();
        return Unit.INSTANCE;
    }

    private static final Unit refreshTree$lambda$5(FilteringBranchesTree this$0) {
        this$0.getTree().getSelectionModel().clearSelection();
        this$0.refreshNodeDescriptorsModel();
        this$0.getSearchModel().updateStructure();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ HashSet access$getExpandedPaths$p(FilteringBranchesTree $this) {
        return $this.expandedPaths;
    }

    public static final /* synthetic */ BranchesTreeStateHolder access$getTreeStateHolder(FilteringBranchesTree $this) {
        return $this.getTreeStateHolder();
    }

    public static final /* synthetic */ BranchesTreeStateProvider access$getTreeStateProvider$p(FilteringBranchesTree $this) {
        return $this.treeStateProvider;
    }
}

