/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.composeFile.ComposeFileReferenceResolver;
import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.folding.YAMLFoldingBuilder;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

public class ComposeFileFoldingBuilder
extends YAMLFoldingBuilder {
    private final Map<String, ComposeFileReferenceResolver> myReferenceResolvers = new HashMap<String, ComposeFileReferenceResolver>();

    public ComposeFileFoldingBuilder() {
        for (ComposeFileReferenceResolver next : ComposeFileReferenceResolver.allReferenceResolvers()) {
            this.myReferenceResolvers.put(next.getDeclarationsMappingName(), next);
        }
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> result2, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (result2 == null) {
            ComposeFileFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            ComposeFileFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            ComposeFileFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (root instanceof YAMLFile && ComposeFileUtil.isDockerComposeYamlFile((YAMLFile)root)) {
            for (YAMLDocument nextDoc : ((YAMLFile)root).getDocuments()) {
                Collection topLevels = Optional.of(nextDoc).map(YAMLDocument::getTopLevelValue).map(o -> (YAMLMapping)ObjectUtils.tryCast((Object)o, YAMLMapping.class)).map(YAMLMapping::getKeyValues).orElse(Collections.emptyList());
                for (YAMLKeyValue next : topLevels) {
                    this.collectGroupFoldings(result2, next);
                }
            }
        }
    }

    private void collectGroupFoldings(@NotNull List<FoldingDescriptor> descriptors, @NotNull YAMLKeyValue keyValue) {
        if (descriptors == null) {
            ComposeFileFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (keyValue == null) {
            ComposeFileFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (!ComposeFileFoldingBuilder.hasChildKeys(keyValue)) {
            return;
        }
        ComposeFileReferenceResolver resolver = this.myReferenceResolvers.get(keyValue.getKeyText());
        if (resolver != null) {
            descriptors.add(new FoldingDescriptor((PsiElement)keyValue, keyValue.getTextRange()));
        }
    }

    @Nullable
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            ComposeFileFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (range == null) {
            ComposeFileFoldingBuilder.$$$reportNull$$$0(6);
        }
        PsiElement psi = node.getPsi();
        assert (psi instanceof YAMLKeyValue && ComposeFileFoldingBuilder.hasChildKeys((YAMLKeyValue)psi));
        YAMLKeyValue groupKeyValue = (YAMLKeyValue)psi;
        ComposeFileReferenceResolver resolver = this.myReferenceResolvers.get(groupKeyValue.getKeyText());
        Collection<YAMLKeyValue> instances = resolver.listAllCandidates((YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)psi, YAMLDocument.class));
        return groupKeyValue.getKeyText() + ": " + instances.stream().map(YAMLKeyValue::getKeyText).filter(text -> !StringUtil.isEmptyOrSpaces((String)text)).collect(Collectors.joining(", "));
    }

    private static boolean hasChildKeys(YAMLKeyValue keyValue) {
        YAMLValue value = keyValue.getValue();
        return value instanceof YAMLMapping && !((YAMLMapping)value).getKeyValues().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectGroupFoldings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

