/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.agent.util.DockerUtil;
import com.intellij.docker.deploymentSource.DockerFileDeploymentValidationKt;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerImageRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerFileDeploymentSourceType
extends DockerSingletonDeploymentSourceType {
    static final String ID = "dockerfile";

    public static DockerFileDeploymentSourceType getInstance() {
        return (DockerFileDeploymentSourceType)DockerFileDeploymentSourceType.findExtension(DockerFileDeploymentSourceType.class);
    }

    public DockerFileDeploymentSourceType() {
        super(ID, DockerBundle.message("DockerFileDeploymentSourceType.name", new Object[0]), DockerIcons.DockerFile_1);
    }

    @Override
    @Nullable
    public String suggestConfigurationName(@NotNull DockerDeploymentConfiguration configuration) {
        String sourceFilePath;
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(0);
        }
        if (StringUtil.isEmptyOrSpaces((String)(sourceFilePath = configuration.getSourceFilePath()))) {
            return null;
        }
        String lastTwo = DockerFileDeploymentSourceType.lastTwoSegments(sourceFilePath);
        return DockerBundle.message("DockerFileDeploymentSourceType.suggestRunConfigurationName", lastTwo);
    }

    @Override
    @NotNull
    public String getPresentableDeploymentName(@NotNull DockerDeploymentConfiguration configuration, @Nullable DockerRuntimeBase runtime) {
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(1);
        }
        String namePiece = configuration.isBuildOnly() ? DockerFileDeploymentSourceType.getPresentableImageNamePiece(configuration, runtime) : DockerFileDeploymentSourceType.getPresentableContainerNamePiece(configuration, runtime);
        String path = configuration.getSourceFilePath();
        String string = DockerBundle.message("DockerFileDeploymentSourceType.deploymentName", namePiece, path);
        if (string == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String getPresentableImageNamePiece(@NotNull DockerDeploymentConfiguration configuration, @Nullable DockerRuntimeBase runtime) {
        DockerImageRuntime imageRuntime;
        List<String> tags;
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(3);
        }
        @NlsSafe String result2 = runtime instanceof DockerImageRuntime ? ((tags = (imageRuntime = (DockerImageRuntime)runtime).getImageRepoTags().stream().map(DockerUtil::shortedId).sorted(String.CASE_INSENSITIVE_ORDER).toList()).size() > 1 ? tags.toString() : tags.stream().findAny().orElse(DockerUtil.shortedId(imageRuntime.getId()))) : configuration.getAllImageTagsJoined();
        String string = StringUtil.isEmptyOrSpaces((String)result2) ? (String)NAME_PIECE_UNKNOWN.get() : result2;
        if (string == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void checkDeploymentConfiguration(@NotNull Project project, @NotNull DockerDeploymentConfiguration configuration) throws RuntimeConfigurationException {
        if (project == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            DockerFileDeploymentSourceType.$$$reportNull$$$0(6);
        }
        super.checkDeploymentConfiguration(project, configuration);
        DockerFileDeploymentValidationKt.checkDockerFile(project, configuration);
        DockerFileDeploymentSourceType.checkImageTagFormat(configuration, false, false);
        DockerFileDeploymentSourceType.checkContainerNameFormat(configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deploymentSource/DockerFileDeploymentSourceType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deploymentSource/DockerFileDeploymentSourceType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDeploymentName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableImageNamePiece";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableDeploymentName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableImageNamePiece";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkDeploymentConfiguration";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

