/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.DynamicBundle;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.DockerCredentialsEditorLanguageContribution;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.FormWithAlignableLabelsColumn;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.StatusPanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCredentialsEditor
implements CredentialsEditor<DockerCredentialsHolder>,
PanelWithAnchor,
FormWithAlignableLabelsColumn {
    private static final ExtensionPointName<DockerCredentialsEditorLanguageContribution> EP_NAME = new ExtensionPointName("com.intellij.docker.remote.dockerCredentialsEditorLanguageContribution");
    private static final Logger LOG = Logger.getInstance(DockerCredentialsEditor.class);
    @NonNls
    public static final String DEFAULT_DOCKER_PROJECT_PATH = "/opt/project";
    @NonNls
    static final String DEFAULT_DOCKER_IMAGE_NAME = "python:3";
    private JBLabel myServerLabel;
    private ComboBox myDockerImageCombo;
    private JPanel myDockerAccountSelectionPlaceHolder;
    private JPanel myMainPanel;
    private JBLabel myImageLabel;
    @Nullable
    private final DockerCredentialsEditorLanguageContribution<?> myEditorLanguageContribution;
    private final StatusPanel myStatusPanel;
    private final CloudAccountSelectionEditor myDockerAccountSelectionEditor;
    private boolean mySuppressDockerAccountSelectedEvent;
    @NlsSafe
    private String myDockerImageNameToBeSelected;
    @Nullable
    private JComponent myAnchor;

    public DockerCredentialsEditor(@NotNull CredentialsLanguageContribution languageContribution, @NotNull StatusPanel statusPanel) {
        if (languageContribution == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(0);
        }
        if (statusPanel == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(1);
        }
        this.mySuppressDockerAccountSelectedEvent = false;
        this.$$$setupUI$$$();
        this.myEditorLanguageContribution = DockerCredentialsEditor.findEditorContribution(languageContribution);
        this.myStatusPanel = statusPanel;
        this.myDockerAccountSelectionEditor = new CloudAccountSelectionEditor(Collections.singletonList(DockerCloudType.getInstance()));
        this.myDockerAccountSelectionPlaceHolder.add(this.myDockerAccountSelectionEditor.getMainPanel());
        this.myDockerAccountSelectionEditor.setAccountSelectionListener(() -> {
            if (!this.mySuppressDockerAccountSelectedEvent) {
                RemoteServer account = this.myDockerAccountSelectionEditor.getSelectedAccount();
                if (account != null) {
                    LOG.debug("Docker account selected: " + account.getName());
                }
                this.onSelected();
            }
        });
    }

    @Nullable
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myImageLabel.setAnchor(anchor);
    }

    @NotNull
    public List<JBLabel> getLabelsColumn() {
        List<JBLabel> list2 = List.of(this.myServerLabel, this.myImageLabel);
        if (list2 == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Nullable
    private static DockerCredentialsEditorLanguageContribution findEditorContribution(@NotNull CredentialsLanguageContribution languageContribution) {
        if (languageContribution == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(3);
        }
        return (DockerCredentialsEditorLanguageContribution)EP_NAME.findFirstSafe(o -> o.getLanguageContribution() == languageContribution);
    }

    @NotNull
    @Nls
    public String getName() {
        String string = DockerCredentialsType.getInstance().getName();
        if (string == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void onSelected() {
        if (this.myEditorLanguageContribution != null) {
            this.updateDockerImagesCombo(this.myEditorLanguageContribution);
        }
    }

    public ValidationInfo validate() {
        RemoteServer selectedAccount = this.myDockerAccountSelectionEditor.getSelectedAccount();
        if (selectedAccount == null) {
            return new ValidationInfo(DockerBundle.message("DockerCredentialsEditor.validate.server.not.selected", new Object[0]), this.myDockerAccountSelectionEditor.getMainPanel());
        }
        if (StringUtil.isEmpty((String)((String)this.myDockerImageCombo.getSelectedItem()))) {
            return new ValidationInfo(DockerBundle.message("DockerCredentialsEditor.validate.image.not.specified", new Object[0]), (JComponent)this.myDockerImageCombo);
        }
        return null;
    }

    @NlsContexts.DialogMessage
    public String validateFinal(@NotNull Supplier<? extends RemoteSdkAdditionalData> supplier, @NotNull Consumer<? super String> helpersPathUpdateCallback) {
        if (supplier == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(5);
        }
        if (helpersPathUpdateCallback == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(6);
        }
        if (this.myEditorLanguageContribution != null) {
            helpersPathUpdateCallback.accept(this.myEditorLanguageContribution.getDefaultHelpersPath());
        }
        return null;
    }

    public void saveCredentials(DockerCredentialsHolder credentials) {
        RemoteServer account = this.myDockerAccountSelectionEditor.getSelectedAccount();
        String accountName = account == null ? null : account.getName();
        String imageName = StringUtil.notNullize((String)((String)this.myDockerImageCombo.getSelectedItem()));
        credentials.setAccountName(accountName);
        credentials.setImageName(imageName);
        credentials.setRemoteProjectPath(DEFAULT_DOCKER_PROJECT_PATH);
    }

    public void init(DockerCredentialsHolder credentials) {
        if (this.myEditorLanguageContribution != null) {
            this.myDockerImageNameToBeSelected = credentials.getImageName();
            this.mySuppressDockerAccountSelectedEvent = true;
            try {
                this.myDockerAccountSelectionEditor.setSelectedAccount(credentials.getAccountName());
                this.updateDockerImagesCombo(this.myEditorLanguageContribution);
            }
            finally {
                this.mySuppressDockerAccountSelectedEvent = false;
            }
        }
    }

    private void updateDockerImagesCombo(final @NotNull DockerCredentialsEditorLanguageContribution<?> editorLanguageContribution) {
        RemoteServer account;
        if (editorLanguageContribution == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(7);
        }
        if ((account = this.myDockerAccountSelectionEditor.getSelectedAccount()) == null) {
            return;
        }
        LOG.debug("Listing images for Docker account: " + account.getName());
        if (this.myDockerImageNameToBeSelected == null) {
            this.myDockerImageNameToBeSelected = (String)this.myDockerImageCombo.getSelectedItem();
        } else {
            this.myDockerImageCombo.setSelectedItem((Object)this.myDockerImageNameToBeSelected);
        }
        if (this.myMainPanel.isShowing()) {
            this.doUpdateImageList(editorLanguageContribution, (RemoteServer<DockerCloudConfiguration>)account);
        } else {
            this.myMainPanel.addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) > 0L && DockerCredentialsEditor.this.myMainPanel.isShowing()) {
                        Runnable runnable = () -> DockerCredentialsEditor.this.doUpdateImageList(editorLanguageContribution, (RemoteServer<DockerCloudConfiguration>)account);
                        Application app = ApplicationManager.getApplication();
                        if (app.isDispatchThread()) {
                            app.invokeLater(runnable, ModalityState.current());
                        }
                        DockerCredentialsEditor.this.myMainPanel.removeHierarchyListener(this);
                    }
                }
            });
        }
    }

    private void doUpdateImageList(@NotNull DockerCredentialsEditorLanguageContribution<?> editorLanguageContribution, RemoteServer<DockerCloudConfiguration> account) {
        if (editorLanguageContribution == null) {
            DockerCredentialsEditor.$$$reportNull$$$0(8);
        }
        StatusPanel.Action listImagesAction = this.myStatusPanel.progress(DockerBundle.message("DockerCredentialsEditor.listing.docker.images", new Object[0]));
        this.myDockerImageCombo.setEnabled(false);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                List<String[]> images2 = editorLanguageContribution.getImages((DockerCloudConfiguration)account.getConfiguration());
                ArrayList<String> collectedImages = new ArrayList<String>();
                for (String[] repoTags : images2) {
                    collectedImages.addAll(Arrays.asList(repoTags));
                }
                listImagesAction.done();
                LOG.debug("Docker images collected: " + collectedImages);
                ApplicationManager.getApplication().invokeLater(() -> {
                    LOG.debug("Populating Docker images combo box: " + collectedImages);
                    @NlsSafe String imageName = this.myDockerImageNameToBeSelected != null ? this.myDockerImageNameToBeSelected : (String)this.myDockerImageCombo.getSelectedItem();
                    this.myDockerImageCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(collectedImages));
                    if (imageName != null) {
                        this.myDockerImageCombo.setSelectedItem((Object)imageName);
                        this.myDockerImageNameToBeSelected = null;
                    } else if (collectedImages.isEmpty()) {
                        this.myDockerImageCombo.setSelectedItem((Object)editorLanguageContribution.getDefaultImageName());
                    }
                    this.myDockerImageCombo.setEnabled(true);
                }, ModalityState.stateForComponent((Component)this.getMainPanel()));
            }
            catch (ServerRuntimeException e) {
                listImagesAction.failed(e.getMessage());
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        ComboBox comboBox;
        JBLabel jBLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDockerAccountSelectionPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myImageLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerCredentialsEditor.class).getString("DockerCredentialsEditor.image.name.text"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerImageCombo = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel2.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myServerLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerCredentialsEditor.class).getString("DockerCredentialsEditor.server.text"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel2.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageContribution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusPanel";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerCredentialsEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPathUpdateCallback";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorLanguageContribution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerCredentialsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsColumn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findEditorContribution";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateFinal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateDockerImagesCombo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateImageList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

