/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ui.utils;

import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u0004\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a \u0010\n\u001a\u0004\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"getDeepestRendererComponentByEvent", "Ljavax/swing/JComponent;", "T", "Lcom/intellij/ui/components/JBList;", "rendererComponent", "Ljava/awt/Component;", "index", "", "e", "Ljava/awt/event/MouseEvent;", "getElementUnderMouse", "intellij.clouds.docker"})
public final class SwingUtilsKt {
    @Nullable
    public static final <T> JComponent getDeepestRendererComponentByEvent(@NotNull JBList<T> $this$getDeepestRendererComponentByEvent, @NotNull Component rendererComponent, int index, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter($this$getDeepestRendererComponentByEvent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rendererComponent, (String)"rendererComponent");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Rectangle nodeBounds = $this$getDeepestRendererComponentByEvent.getCellBounds(index, index);
        $this$getDeepestRendererComponentByEvent.add(rendererComponent);
        int shiftedXBound = nodeBounds.width > 0 ? nodeBounds.x + 1 : nodeBounds.x;
        int shiftedWidth = nodeBounds.width > 0 ? nodeBounds.width - 1 : nodeBounds.width;
        rendererComponent.setBounds(shiftedXBound, nodeBounds.y, shiftedWidth, nodeBounds.height);
        rendererComponent.validate();
        Point componentPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), rendererComponent);
        Component component2 = SwingUtilities.getDeepestComponentAt(rendererComponent, componentPoint.x, componentPoint.y);
        JComponent activeComponent = component2 instanceof JComponent ? (JComponent)component2 : null;
        $this$getDeepestRendererComponentByEvent.remove(rendererComponent);
        return activeComponent;
    }

    @Nullable
    public static final <T> JComponent getElementUnderMouse(@NotNull JBList<T> $this$getElementUnderMouse, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter($this$getElementUnderMouse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int index = $this$getElementUnderMouse.locationToIndex(e.getPoint());
        if (index == -1) {
            return null;
        }
        boolean isSelected = $this$getElementUnderMouse.getSelectedIndex() == index;
        ListModel model2 = $this$getElementUnderMouse.getModel();
        Component rendererComponent = $this$getElementUnderMouse.getCellRenderer().getListCellRendererComponent((JList)$this$getElementUnderMouse, model2.getElementAt(index), index, isSelected, false);
        Intrinsics.checkNotNull((Object)rendererComponent);
        return SwingUtilsKt.getDeepestRendererComponentByEvent($this$getElementUnderMouse, rendererComponent, index, e);
    }
}

