/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DisplayObjectFormatterConfig;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseObjectFormatterConfig
implements ObjectFormatterConfig {
    private static final DatabaseObjectFormatterConfig JS_SCRIPT_CONFIG = new DatabaseObjectFormatterConfig(ObjectFormatterMode.JS_SCRIPT);
    private static final DatabaseObjectFormatterConfig SQL_SCRIPT_CONFIG = new DatabaseObjectFormatterConfig(ObjectFormatterMode.SQL_SCRIPT);
    private static final DatabaseObjectFormatterConfig DEFAULT_CONFIG = new DatabaseObjectFormatterConfig(ObjectFormatterMode.DEFAULT);
    private static final DatabaseObjectFormatterConfig JSON_CONFIG = new DatabaseObjectFormatterConfig(ObjectFormatterMode.JSON);
    private static final DatabaseObjectFormatterConfig DISPLAY_CONFIG = new DatabaseDisplayObjectFormatterConfig();
    private final ObjectFormatterMode mode;

    public DatabaseObjectFormatterConfig(@NotNull ObjectFormatterMode mode) {
        if (mode == null) {
            DatabaseObjectFormatterConfig.$$$reportNull$$$0(0);
        }
        this.mode = mode;
    }

    @Override
    @NotNull
    public ObjectFormatterMode getMode() {
        ObjectFormatterMode objectFormatterMode = this.mode;
        if (objectFormatterMode == null) {
            DatabaseObjectFormatterConfig.$$$reportNull$$$0(1);
        }
        return objectFormatterMode;
    }

    @Override
    @Nullable
    public DataGridSettings getSettings() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseObjectFormatterConfig config = (DatabaseObjectFormatterConfig)o;
        return this.mode == config.mode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode});
    }

    public static ObjectFormatterConfig get(@NotNull ObjectFormatterMode mode) {
        if (mode == null) {
            DatabaseObjectFormatterConfig.$$$reportNull$$$0(2);
        }
        return mode == ObjectFormatterMode.JS_SCRIPT ? JS_SCRIPT_CONFIG : (mode == ObjectFormatterMode.SQL_SCRIPT ? SQL_SCRIPT_CONFIG : (mode == ObjectFormatterMode.DEFAULT ? DEFAULT_CONFIG : (mode == ObjectFormatterMode.JSON ? JSON_CONFIG : DISPLAY_CONFIG)));
    }

    @NotNull
    public static ObjectFormatterConfig toDisplayConfig(@NotNull ObjectFormatterConfig config) {
        DatabaseDisplayObjectFormatterConfig dbConfig;
        if (config == null) {
            DatabaseObjectFormatterConfig.$$$reportNull$$$0(3);
        }
        DisplayType displayType = (dbConfig = (DatabaseDisplayObjectFormatterConfig)ObjectUtils.tryCast((Object)config, DatabaseDisplayObjectFormatterConfig.class)) != null ? dbConfig.getDisplayType() : BinaryDisplayType.DETECT;
        boolean isModeDetectedAutomatically = dbConfig != null && dbConfig.isModeDetectedAutomatically;
        Set<BinaryDisplayType> allowedTypes = dbConfig != null ? dbConfig.allowedTypes : null;
        return new DatabaseDisplayObjectFormatterConfig(displayType, isModeDetectedAutomatically, allowedTypes, config.getSettings());
    }

    public static boolean isTypeAllowed(@NotNull ObjectFormatterConfig config, @NotNull BinaryDisplayType type) {
        DatabaseDisplayObjectFormatterConfig dbConfig;
        if (config == null) {
            DatabaseObjectFormatterConfig.$$$reportNull$$$0(4);
        }
        if (type == null) {
            DatabaseObjectFormatterConfig.$$$reportNull$$$0(5);
        }
        if ((dbConfig = (DatabaseDisplayObjectFormatterConfig)ObjectUtils.tryCast((Object)config, DatabaseDisplayObjectFormatterConfig.class)) == null) {
            return true;
        }
        DisplayType configType = dbConfig.getDisplayType();
        return configType == type || configType == BinaryDisplayType.DETECT || configType == BinaryDisplayType.HEX && dbConfig.isModeDetectedAutomatically() && (dbConfig.getAllowedTypes() == null || dbConfig.getAllowedTypes().contains(type));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DatabaseObjectFormatterConfig";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DatabaseObjectFormatterConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toDisplayConfig";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTypeAllowed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class DatabaseDisplayObjectFormatterConfig
    extends DatabaseObjectFormatterConfig
    implements DisplayObjectFormatterConfig {
        private final DisplayType displayType;
        private final boolean isModeDetectedAutomatically;
        private final Set<BinaryDisplayType> allowedTypes;
        private final DataGridSettings settings;

        public DatabaseDisplayObjectFormatterConfig() {
            this(null, false, null, null);
        }

        public DatabaseDisplayObjectFormatterConfig(@Nullable DisplayType displayType, boolean isModeDetectedAutomatically, @Nullable Set<BinaryDisplayType> allowedTypes, @Nullable DataGridSettings settings) {
            super(ObjectFormatterMode.DISPLAY);
            this.displayType = displayType;
            this.isModeDetectedAutomatically = isModeDetectedAutomatically;
            this.allowedTypes = allowedTypes;
            this.settings = settings;
        }

        @Override
        @Nullable
        public DisplayType getDisplayType() {
            return this.displayType;
        }

        public boolean isModeDetectedAutomatically() {
            return this.isModeDetectedAutomatically;
        }

        @Nullable
        public Set<BinaryDisplayType> getAllowedTypes() {
            return this.allowedTypes;
        }

        @Override
        @Nullable
        public DataGridSettings getSettings() {
            return this.settings;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DatabaseDisplayObjectFormatterConfig config = (DatabaseDisplayObjectFormatterConfig)o;
            return this.isModeDetectedAutomatically == config.isModeDetectedAutomatically && this.displayType == config.displayType && Objects.equals(this.allowedTypes, config.allowedTypes);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.displayType, this.isModeDetectedAutomatically, this.allowedTypes);
        }
    }
}

