/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.qml.QmlElementTypes;
import com.intellij.lang.qml.parsing.QmlParser;
import com.intellij.lang.qml.parsing.QmlStatementParser;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class QmlExpressionParser<T extends QmlParser<?, ?, ?, ?>>
extends ES6ExpressionParser<T> {
    private final boolean myUseQmlSpecifics;

    protected QmlExpressionParser(T parser, boolean useQmlSpecifics) {
        super(parser);
        this.myUseQmlSpecifics = useQmlSpecifics;
    }

    public boolean parsePrimaryExpression() {
        if (!this.myUseQmlSpecifics) {
            return super.parsePrimaryExpression();
        }
        IElementType firstToken = this.builder.getTokenType();
        if (this.isIdentifierToken(firstToken) || firstToken == JSTokenTypes.ANY_IDENTIFIER) {
            PsiBuilder.Marker refMarker = this.builder.mark();
            this.builder.advanceLexer();
            refMarker.done(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
            return true;
        }
        return super.parsePrimaryExpression();
    }

    protected IElementType getNameReferenceElementType() {
        return QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION;
    }

    protected boolean parseArrayElement() {
        if (!this.myUseQmlSpecifics) {
            return super.parseArrayElement();
        }
        if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER && this.builder.lookAhead(1) == JSTokenTypes.LBRACE) {
            PsiBuilder.Marker marker = this.builder.mark();
            PsiBuilder.Marker refMarker = this.builder.mark();
            this.builder.advanceLexer();
            refMarker.done(QmlElementTypes.QML_ELEMENT_REFERENCE_EXPRESSION);
            ((QmlStatementParser)((Object)((QmlParser)this.myJavaScriptParser).getStatementParser())).parseBlock();
            marker.done(QmlElementTypes.QML_ELEMENT_DECLARATION);
            return true;
        }
        return super.parseArrayElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJSObject() {
        PsiBuilder.Marker marker = this.builder.mark();
        try {
            this.builder.advanceLexer();
            IElementType firstToken = this.builder.getTokenType();
            IElementType secondToken = this.builder.lookAhead(1);
            PsiBuilder.Marker property = this.builder.mark();
            if (firstToken == JSTokenTypes.LBRACKET) {
                boolean lexerAdvanced = this.parsePropertyName();
                assert (lexerAdvanced) : "must be advanced after LBRACKET";
                if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
                    if (!this.parseFunctionPropertyNoMarker(property, true)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    if (!QmlExpressionParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.COLON, (String)"javascript.parser.message.expected.colon")) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.parseAssignmentExpression(true)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (((QmlParser)this.myJavaScriptParser).isIdentifierName(firstToken) && (secondToken == JSTokenTypes.COMMA || secondToken == JSTokenTypes.RBRACE)) {
                boolean lexerAdvanced = true;
                return lexerAdvanced;
            }
            if (!JSKeywordSets.PROPERTY_NAMES.contains(firstToken)) {
                boolean lexerAdvanced = false;
                return lexerAdvanced;
            }
            String errorMessage = this.validateLiteral();
            if (errorMessage != null) {
                boolean bl = false;
                return bl;
            }
            this.builder.advanceLexer();
            if (!QmlExpressionParser.checkMatches((PsiBuilder)this.builder, (IElementType)JSTokenTypes.COLON, (String)"javascript.parser.message.expected.colon")) {
                boolean bl = false;
                return bl;
            }
            if (!this.parseAssignmentExpression(true)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            marker.rollbackTo();
        }
    }

    protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
        if (!this.myUseQmlSpecifics) {
            return super.isReferenceQualifierSeparator(tokenType);
        }
        return false;
    }

    protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef, boolean isInExtendsOrImplementsList) {
        if (!this.myUseQmlSpecifics) {
            return super.parseDialectSpecificMemberExpressionPart(markerRef, isInExtendsOrImplementsList);
        }
        if (this.builder.getTokenType() != JSTokenTypes.DOT) {
            return false;
        }
        this.builder.advanceLexer();
        @Nullable IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.ANY_IDENTIFIER || ((QmlParser)this.myJavaScriptParser).isIdentifierName(tokenType)) {
            PsiBuilder.Marker childMarker = this.builder.mark();
            this.builder.advanceLexer();
            childMarker.done(this.getNameReferenceElementType());
        } else {
            this.builder.advanceLexer();
        }
        PsiBuilder.Marker marker = (PsiBuilder.Marker)markerRef.get();
        marker.done(this.getNameReferenceElementType());
        markerRef.set((Object)marker.precede());
        return true;
    }
}

