/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions.common;

import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesActionUtilKt;
import com.intellij.jupyter.core.core.impl.actions.RemoveOutputsUndoableAction;
import com.intellij.jupyter.core.core.impl.actions.RequiresCellViewUpdate;
import com.intellij.jupyter.core.core.impl.actions.select.NotebookCellLinesWithSelectionActionBase;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/common/NotebookDeleteCellAction;", "Lcom/intellij/jupyter/core/core/impl/actions/select/NotebookCellLinesWithSelectionActionBase;", "Lcom/intellij/jupyter/core/core/impl/actions/RequiresCellViewUpdate;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cellLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "cellSelection", "Lcom/intellij/notebooks/visualization/NotebookCellSelectionModel;", "intellij.jupyter.core"})
public class NotebookDeleteCellAction
extends NotebookCellLinesWithSelectionActionBase
implements RequiresCellViewUpdate {
    @Override
    public void actionPerformed(@NotNull AnActionEvent event, @NotNull EditorImpl editor, @NotNull NotebookCellLines cellLines, @NotNull NotebookCellSelectionModel cellSelection) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellLines, (String)"cellLines");
        Intrinsics.checkNotNullParameter((Object)cellSelection, (String)"cellSelection");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        WriteCommandAction.writeCommandAction((Project)project2).withName(this.getTemplateText()).run(() -> NotebookDeleteCellAction.actionPerformed$lambda$0(cellSelection, editor, project2, this));
    }

    @Override
    public void updateAffectedCells(@NotNull Editor editor, @NotNull List<Integer> cellOrdinals) {
        RequiresCellViewUpdate.DefaultImpls.updateAffectedCells(this, editor, cellOrdinals);
    }

    private static final void actionPerformed$lambda$0(NotebookCellSelectionModel $cellSelection, EditorImpl $editor, Project $project, NotebookDeleteCellAction this$0) {
        List selectedCells = $cellSelection.getSelectedCells();
        RemoveOutputsUndoableAction undoableAction = new RemoveOutputsUndoableAction($editor, selectedCells);
        UndoManager.getInstance((Project)$project).undoableActionPerformed((UndoableAction)undoableAction);
        NotebookCellLinesActionUtilKt.removeCells((Editor)$editor, selectedCells);
        if ($cellSelection.getPrimarySelectedCell().getOrdinal() == 0) {
            this$0.updateAffectedCells((Editor)$editor, CollectionsKt.listOf((Object)0));
        }
        if ($cellSelection.getPrimarySelectedCell().getLines().getLast() == $editor.getDocument().getLineCount() - 1) {
            this$0.updateAffectedCells((Editor)$editor, CollectionsKt.listOf((Object)$cellSelection.getPrimarySelectedCell().getOrdinal()));
        }
    }
}

