/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.doubleFile;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.core.impl.file.JupyterTemplateNotebookFileCreator;
import com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookOriginToSourceChangePropagator;
import com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.NotebookMetadataLanguageProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.helper.OtherKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterEvent;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookConverter;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookException;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchema;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchemaFactory;
import com.intellij.jupyter.core.jupyter.nbformat.NotebookChanged;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaVersion;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterFileRegistry;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Deprecated(message="Don't use it directly, use functions from JupyterFileExtensions.kt instead")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 U2\u00020\u0001:\u0001UB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0015\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b%J\u0015\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b(J\b\u0010.\u001a\u00020\"H\u0007J\b\u0010/\u001a\u00020\u0018H\u0016J\b\u00100\u001a\u00020'H\u0016J\u0010\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0006H\u0016J\u0010\u00103\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0006H\u0016J\u0010\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020'H\u0016J\u0012\u00106\u001a\u0004\u0018\u00010+2\u0006\u00107\u001a\u00020\u0018H\u0016J\u0012\u00108\u001a\u0004\u0018\u00010+2\u0006\u00107\u001a\u00020\u0018H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020+H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020+H\u0002J\u001a\u0010;\u001a\u00020\"2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020+H\u0014J\"\u0010?\u001a\u00020+2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010@\u001a\u00020+2\u0006\u0010A\u001a\u00020\u0018H\u0014J\"\u0010B\u001a\u00020+2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010@\u001a\u00020+2\u0006\u0010C\u001a\u00020\u0018H\u0014J*\u0010D\u001a\u00020+2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010E\u001a\u00020+2\u0006\u0010F\u001a\u00020+2\u0006\u0010G\u001a\u00020\u0018H\u0014J\"\u0010H\u001a\u00020\"2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020+2\u0006\u0010F\u001a\u00020+H\u0014J\"\u0010I\u001a\u00020\"2\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020+2\u0006\u0010J\u001a\u00020\u0018H\u0014J\u001b\u0010K\u001a\b\u0012\u0004\u0012\u00020M0L2\u0006\u0010N\u001a\u00020O\u00a2\u0006\u0004\bP\u0010QJ\u0010\u0010R\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010S\u001a\u00020T2\u0006\u0010N\u001a\u00020OH\u0002R<\u0010\u0004\u001a.\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\t\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR9\u0010\u000b\u001a'\u0012\u000e\u0012\f0\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\u000f\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u0002\b\b0\f\u00a2\u0006\u0002\b\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011RP\u0010\u0012\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000f0\u000f \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00130\u0013X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000f0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*8G\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006V"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFileSystem;", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "<init>", "()V", "vfsListeners", "", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "Ljava/util/List;", "fileCache", "Ljava/util/concurrent/ConcurrentMap;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFile;", "getFileCache$intellij_jupyter_core", "()Ljava/util/concurrent/ConcurrentMap;", "indexFileCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/github/benmanes/caffeine/cache/Cache;", "modifiedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "notImplementedReason", "", "getCached", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFileWithId;", "getOrCreateIndexFile", "backFile", "Lcom/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl;", "buildIndexFile", "markModified", "", "notebookVirtualFile", "markUnmodified", "markUnmodified$intellij_jupyter_core", "isModified", "", "isModified$intellij_jupyter_core", "allLoadedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAllLoadedFiles", "()Ljava/util/Collection;", "markAllUnmodified", "getProtocol", "isReadOnly", "addVirtualFileListener", "listener", "removeVirtualFileListener", "refresh", "asynchronous", "findFileByPath", "path", "refreshAndFindFileByPath", "getOrCreateNotebookFile", "getCachedDocumentContent", "deleteFile", "requestor", "", "vFile", "createChildDirectory", "vDir", "dirName", "createChildFile", "fileName", "copyFile", "virtualFile", "newParent", "copyName", "moveFile", "renameFile", "newName", "tryCreateJupyterNotebook", "Lkotlin/Result;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "reader", "Ljava/io/Reader;", "tryCreateJupyterNotebook-IoAF18A", "(Ljava/io/Reader;)Ljava/lang/Object;", "createJupyterNotebookFromReader", "readNotebookJson", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "Companion", "intellij.jupyter.core"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nNotebookVirtualFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookVirtualFileSystem.kt\ncom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFileSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,283:1\n1#2:284\n24#3:285\n*S KotlinDebug\n*F\n+ 1 NotebookVirtualFileSystem.kt\ncom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFileSystem\n*L\n275#1:285\n*E\n"})
public final class NotebookVirtualFileSystem
extends VirtualFileSystem {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<VirtualFileListener> vfsListeners;
    @NotNull
    private final ConcurrentMap<Integer, NotebookVirtualFile> fileCache;
    private Cache<Integer, NotebookVirtualFile> indexFileCache;
    @NotNull
    private final ConcurrentHashMap<Integer, NotebookVirtualFile> modifiedFiles;
    @NotNull
    private final String notImplementedReason;
    @NotNull
    private static final String NOTEBOOK_PROTOCOL = "notebook";
    @NotNull
    private static final Logger LOG;

    public NotebookVirtualFileSystem() {
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.vfsListeners = list;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentSoftValueMap(...)");
        this.fileCache = concurrentMap;
        this.indexFileCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).softValues().weigher((arg_0, arg_1) -> NotebookVirtualFileSystem.indexFileCache$lambda$1(NotebookVirtualFileSystem::indexFileCache$lambda$0, arg_0, arg_1)).maximumWeight(307200L).executor((Executor)AppExecutorUtil.getAppExecutorService()).build();
        this.modifiedFiles = new ConcurrentHashMap();
        this.notImplementedReason = "Makes no sense for Notebook file system";
    }

    @NotNull
    public final ConcurrentMap<Integer, NotebookVirtualFile> getFileCache$intellij_jupyter_core() {
        return this.fileCache;
    }

    @Nullable
    public final BackedNotebookVirtualFile getCached(@NotNull VirtualFileWithId file) {
        BackedNotebookVirtualFile backedNotebookVirtualFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        NotebookVirtualFile notebookVirtualFile = (NotebookVirtualFile)((Object)this.fileCache.get(file.getId()));
        if (notebookVirtualFile != null) {
            NotebookVirtualFile it = notebookVirtualFile;
            boolean bl = false;
            backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.create(it);
        } else {
            backedNotebookVirtualFile = null;
        }
        return backedNotebookVirtualFile;
    }

    @NotNull
    public final BackedNotebookVirtualFile getOrCreateIndexFile(@NotNull VirtualFileImpl backFile) {
        Intrinsics.checkNotNullParameter((Object)backFile, (String)"backFile");
        NotebookVirtualFile cached = (NotebookVirtualFile)((Object)this.indexFileCache.getIfPresent((Object)backFile.getId()));
        if (cached != null) {
            return BackedNotebookVirtualFile.Companion.create(cached);
        }
        NotebookVirtualFile notebookVirtualFile = this.buildIndexFile(backFile);
        this.indexFileCache.put((Object)backFile.getId(), (Object)notebookVirtualFile);
        return BackedNotebookVirtualFile.Companion.create(notebookVirtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NotebookVirtualFile buildIndexFile(VirtualFileImpl backFile) {
        Object object;
        Reader notebookContentReader = (Reader)ReadAction.compute(() -> NotebookVirtualFileSystem.buildIndexFile$lambda$3(this, backFile));
        Object object2 = notebookContentReader;
        Throwable throwable = null;
        try {
            Reader p0 = (Reader)object2;
            boolean $i$f$buildIndexFile$stub_for_inlining = false;
            boolean bl = false;
            object = this.tryCreateJupyterNotebook-IoAF18A(p0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        object2 = object;
        JupyterNotebookBase jupyterNotebookBase = (JupyterNotebookBase)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (jupyterNotebookBase == null) {
            jupyterNotebookBase = JupyterFileUtils.INSTANCE.createEmptyNotebook(new JupyterNotebookSchemaVersion(5, 9));
        }
        JupyterNotebookBase notebook = jupyterNotebookBase;
        return new NotebookVirtualFile((VirtualFile)backFile, notebook);
    }

    private final void markModified(NotebookVirtualFile notebookVirtualFile) {
        Map map = this.modifiedFiles;
        VirtualFile virtualFile = notebookVirtualFile.getOriginFile();
        Intrinsics.checkNotNull((Object)virtualFile, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
        map.put(((VirtualFileWithId)virtualFile).getId(), notebookVirtualFile);
    }

    public final void markUnmodified$intellij_jupyter_core(@NotNull NotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)notebookVirtualFile), (String)"notebookVirtualFile");
        VirtualFile virtualFile = notebookVirtualFile.getOriginFile();
        Intrinsics.checkNotNull((Object)virtualFile, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
        this.modifiedFiles.remove(((VirtualFileWithId)virtualFile).getId());
    }

    public final void markUnmodified$intellij_jupyter_core(@NotNull BackedNotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        VirtualFile virtualFile = notebookVirtualFile.getFile();
        Intrinsics.checkNotNull((Object)virtualFile, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookVirtualFile");
        this.markUnmodified$intellij_jupyter_core((NotebookVirtualFile)virtualFile);
    }

    public final boolean isModified$intellij_jupyter_core(@NotNull NotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)((Object)notebookVirtualFile), (String)"notebookVirtualFile");
        VirtualFile virtualFile = notebookVirtualFile.getOriginFile();
        Intrinsics.checkNotNull((Object)virtualFile, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
        return this.modifiedFiles.containsKey(((VirtualFileWithId)virtualFile).getId());
    }

    @TestOnly
    @NotNull
    public final Collection<VirtualFile> getAllLoadedFiles() {
        return CollectionsKt.toList((Iterable)this.fileCache.values());
    }

    @TestOnly
    public final void markAllUnmodified() {
        this.modifiedFiles.clear();
    }

    @NotNull
    public String getProtocol() {
        return NOTEBOOK_PROTOCOL;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            return;
        }
        this.vfsListeners.add(listener);
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            return;
        }
        this.vfsListeners.remove(listener);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            return null;
        }
        JupyterRemoteFileSystem jupyterRemoteFileSystem = JupyterRemoteFileSystem.Companion.getInstanceOrNull();
        if (jupyterRemoteFileSystem != null && (jupyterRemoteFileSystem = jupyterRemoteFileSystem.findFileByPath(path)) != null) {
            virtualFile = (VirtualFile)jupyterRemoteFileSystem;
        } else {
            virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile == null) {
                return null;
            }
        }
        VirtualFile file = virtualFile;
        return this.getOrCreateNotebookFile(file);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.findFileByPath(path);
    }

    private final NotebookVirtualFile getOrCreateNotebookFile(VirtualFile file) {
        Intrinsics.checkNotNull((Object)file, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
        int id = ((VirtualFileWithId)file).getId();
        this.indexFileCache.invalidate((Object)id);
        NotebookVirtualFile notebookVirtualFile = this.modifiedFiles.get(id);
        if (notebookVirtualFile != null) {
            NotebookVirtualFile it = notebookVirtualFile;
            boolean bl = false;
            return it;
        }
        Ref.ObjectRef generatedFile = new Ref.ObjectRef();
        NotebookVirtualFile returnedFile = this.fileCache.computeIfAbsent(id, arg_0 -> NotebookVirtualFileSystem.getOrCreateNotebookFile$lambda$8(arg_0 -> NotebookVirtualFileSystem.getOrCreateNotebookFile$lambda$7(file, this, generatedFile, arg_0), arg_0));
        if (returnedFile != null) {
            NotebookMetadataLanguageProvider.Utils.INSTANCE.setNotebookLanguage(returnedFile, returnedFile.getNotebook().getLanguage());
        }
        if (returnedFile != null && returnedFile == generatedFile.element) {
            returnedFile.getNotebook().getListeners().getChangeListeners().addListener(arg_0 -> NotebookVirtualFileSystem.getOrCreateNotebookFile$lambda$9(this, returnedFile, arg_0));
            file.putUserData(OtherKt.getNOTEBOOK_VIRTUAL_FILE_KEY(), (Object)BackedNotebookVirtualFile.Companion.create(returnedFile));
        }
        return returnedFile;
    }

    private final String getCachedDocumentContent(VirtualFile file) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Document document = fileDocumentManager2.getDocument(file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        if (fileDocumentManager2.isPartialPreviewOfALargeFile(document2)) {
            return null;
        }
        return document2.getText();
    }

    protected void deleteFile(@Nullable Object requestor, @NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        if (JupyterFileRegistry.INSTANCE.getUseSingleFile()) {
            return;
        }
        if (requestor instanceof NotebookOriginToSourceChangePropagator) {
            this.modifiedFiles.remove(((NotebookVirtualFile)vFile).getId());
        } else {
            LOG.error("Notebook virtual files should be deleted only on origin file deletion");
        }
    }

    @NotNull
    protected VirtualFile createChildDirectory(@Nullable Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)vDir, (String)"vDir");
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        throw new NotImplementedError("The operation is not implemented: " + this.notImplementedReason);
    }

    @NotNull
    protected VirtualFile createChildFile(@Nullable Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)vDir, (String)"vDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        throw new NotImplementedError("The operation is not implemented: " + this.notImplementedReason);
    }

    @NotNull
    protected VirtualFile copyFile(@Nullable Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        Intrinsics.checkNotNullParameter((Object)copyName, (String)"copyName");
        throw new NotImplementedError("The operation is not implemented: " + this.notImplementedReason);
    }

    protected void moveFile(@Nullable Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        throw new NotImplementedError("The operation is not implemented: " + this.notImplementedReason);
    }

    protected void renameFile(@Nullable Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        throw new NotImplementedError("The operation is not implemented: " + this.notImplementedReason);
    }

    @NotNull
    public final Object tryCreateJupyterNotebook-IoAF18A(@NotNull Reader reader) {
        Object object;
        block2: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            object = Result.Companion;
            try {
                Result.Companion $this$tryCreateJupyterNotebook_IoAF18A_u24lambda_u2410 = object;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)this.createJupyterNotebookFromReader(reader));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object exception = object2 = throwable;
            boolean bl = false;
            LOG.warn("Jupyter Notebook wasn't created", (Throwable)exception);
        }
        return object;
    }

    private final JupyterNotebookBase createJupyterNotebookFromReader(Reader reader) {
        ObjectNode json = this.readNotebookJson(reader);
        JupyterNotebookSchema schema = JupyterNotebookSchemaFactory.INSTANCE.createSchema(json);
        JupyterNotebookBase notebook = new JupyterNotebookBase(json, schema);
        JupyterNotebookConverter.Companion.convertAfterLoading(notebook);
        notebook.checkNotebook();
        return notebook;
    }

    private final ObjectNode readNotebookJson(Reader reader) throws JupyterNotebookException, JsonParseException {
        JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(reader);
        ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
        if (objectNode == null) {
            throw new JupyterNotebookException("Can't read notebook json. Expected ObjectNode, found '" + jsonNode + "'", null, 2, null);
        }
        return objectNode;
    }

    private static final int indexFileCache$lambda$0(int n, NotebookVirtualFile value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        return value.getNotebook().getJson().toString().length() / 1024;
    }

    private static final int indexFileCache$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final Reader buildIndexFile$lambda$3(NotebookVirtualFileSystem this$0, VirtualFileImpl $backFile) {
        Reader reader;
        String string = this$0.getCachedDocumentContent((VirtualFile)$backFile);
        if (string != null) {
            reader = new StringReader(string);
        } else {
            InputStream inputStream = $backFile.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            reader = new InputStreamReader(inputStream2, charset);
        }
        return reader;
    }

    private static final Reader getOrCreateNotebookFile$lambda$7$lambda$5(NotebookVirtualFileSystem this$0, VirtualFile $file) {
        Reader reader;
        String string = this$0.getCachedDocumentContent($file);
        if (string != null) {
            reader = new StringReader(string);
        } else {
            InputStream inputStream = $file.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            reader = new InputStreamReader(inputStream2, charset);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final NotebookVirtualFile getOrCreateNotebookFile$lambda$7(VirtualFile $file, NotebookVirtualFileSystem this$0, Ref.ObjectRef $generatedFile, Integer it) {
        Object object;
        JupyterTemplateNotebookFileCreator.Companion.setTemplateContent($file);
        Reader notebookContentReader = (Reader)ReadAction.compute(() -> NotebookVirtualFileSystem.getOrCreateNotebookFile$lambda$7$lambda$5(this$0, $file));
        Object object2 = notebookContentReader;
        Throwable throwable = null;
        try {
            Reader p0 = (Reader)object2;
            boolean bl = false;
            boolean $i$f$getOrCreateNotebookFile$lambda$7$stub_for_inlining$6 = false;
            object = this$0.tryCreateJupyterNotebook-IoAF18A(p0);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        object2 = object;
        JupyterNotebookBase jupyterNotebookBase = (JupyterNotebookBase)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (jupyterNotebookBase == null) {
            return null;
        }
        JupyterNotebookBase notebook = jupyterNotebookBase;
        NotebookVirtualFile result2 = new NotebookVirtualFile($file, notebook);
        $generatedFile.element = result2;
        return result2;
    }

    private static final NotebookVirtualFile getOrCreateNotebookFile$lambda$8(Function1 $tmp0, Object p0) {
        return (NotebookVirtualFile)((Object)$tmp0.invoke(p0));
    }

    private static final void getOrCreateNotebookFile$lambda$9(NotebookVirtualFileSystem this$0, NotebookVirtualFile $returnedFile, JupyterEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof NotebookChanged)) {
            throw new NoWhenBranchMatchedException();
        }
        this$0.markModified($returnedFile);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFileSystem$Companion;", "", "<init>", "()V", "NOTEBOOK_PROTOCOL", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getNotebookVirtualFileSystem", "Lcom/intellij/jupyter/core/core/impl/file/doubleFile/NotebookVirtualFileSystem;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotebookVirtualFileSystem getNotebookVirtualFileSystem() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(NotebookVirtualFileSystem.NOTEBOOK_PROTOCOL);
            Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.core.impl.file.doubleFile.NotebookVirtualFileSystem");
            return (NotebookVirtualFileSystem)virtualFileSystem;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

