/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.lang.Language;
import com.intellij.notebook.editor.BackFileViewProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.NotebookLanguageProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/NotebookMetadataLanguageProvider;", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/NotebookLanguageProvider;", "<init>", "()V", "getTemplateLanguage", "Lcom/intellij/lang/Language;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "onlyCache", "", "Utils", "intellij.jupyter.core"})
public final class NotebookMetadataLanguageProvider
implements NotebookLanguageProvider {
    @Nullable
    public Language getTemplateLanguage(@NotNull VirtualFile file, boolean onlyCache) {
        Language language;
        Language calculatedLanguage;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile original = JupyterFileUtils.INSTANCE.getOriginalFile(file);
        Language cachedLanguage = Utils.INSTANCE.getNotebookLanguage(original);
        if (cachedLanguage != null) {
            return cachedLanguage;
        }
        if (onlyCache) {
            return null;
        }
        JupyterNotebookBase jupyterNotebookBase = JupyterFileUtils.INSTANCE.readNotebookOrNull(original);
        Object object = calculatedLanguage = jupyterNotebookBase != null ? jupyterNotebookBase.getLanguage() : null;
        if (calculatedLanguage != null) {
            Utils.INSTANCE.setNotebookLanguage(original, calculatedLanguage);
        }
        if ((language = calculatedLanguage) == null) {
            language = Language.ANY;
        }
        return language;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006R\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/core/jupyter/NotebookMetadataLanguageProvider$Utils;", "", "<init>", "()V", "NOTEBOOK_LANGUAGE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/lang/Language;", "getNOTEBOOK_LANGUAGE", "()Lcom/intellij/openapi/util/Key;", "getNotebookLanguage", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "setNotebookLanguage", "", "language", "intellij.jupyter.core"})
    public static final class Utils {
        @NotNull
        public static final Utils INSTANCE = new Utils();
        @NotNull
        private static final Key<Language> NOTEBOOK_LANGUAGE = new Key("NOTEBOOK_LANGUAGE");

        private Utils() {
        }

        @NotNull
        public final Key<Language> getNOTEBOOK_LANGUAGE() {
            return NOTEBOOK_LANGUAGE;
        }

        @Nullable
        public final Language getNotebookLanguage(@Nullable VirtualFile file) {
            Language language;
            Object object;
            Object object2;
            VirtualFile curFile = file;
            while (curFile instanceof LightVirtualFile && !Intrinsics.areEqual((Object)curFile, (Object)((LightVirtualFile)curFile).getOriginalFile())) {
                object2 = (Language)((LightVirtualFile)curFile).getUserData(NOTEBOOK_LANGUAGE);
                if (object2 != null) {
                    VirtualFile it = object2;
                    boolean bl = false;
                    return it;
                }
                if (((LightVirtualFile)curFile).getOriginalFile() == null) break;
            }
            if ((object2 = curFile) != null && (object = (Language)object2.getUserData(NOTEBOOK_LANGUAGE)) != null) {
                Language it = object;
                boolean bl = false;
                return it;
            }
            VirtualFile virtualFile = curFile;
            if (virtualFile == null || (virtualFile = (VirtualFile)virtualFile.getUserData(BackFileViewProvider.FRONT_FILE_KEY)) == null) {
                virtualFile = curFile;
            }
            if ((object2 = (curFile = virtualFile)) != null && (object = JupyterFileExtensionsKt.getOriginalVirtualFile((VirtualFile)object2)) != null && (language = (Language)object.getUserData(NOTEBOOK_LANGUAGE)) != null) {
                Language it = language;
                boolean bl = false;
                return it;
            }
            if (curFile == null) {
                return null;
            }
            object2 = BackedNotebookVirtualFile.Companion.takeIfBacked(curFile);
            if (object2 != null && (object = object2.getNotebookOrNull()) != null && (language = object.getLanguage()) != null) {
                Language it = language;
                boolean bl = false;
                return it;
            }
            return null;
        }

        public final void setNotebookLanguage(@NotNull VirtualFile file, @Nullable Language language) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            VirtualFile curFile = file;
            while (curFile instanceof LightVirtualFile) {
                curFile.putUserData(NOTEBOOK_LANGUAGE, (Object)language);
                if (Intrinsics.areEqual((Object)curFile, (Object)((LightVirtualFile)curFile).getOriginalFile()) || ((LightVirtualFile)curFile).getOriginalFile() == null) break;
            }
            curFile.putUserData(NOTEBOOK_LANGUAGE, (Object)language);
            JupyterFileExtensionsKt.getOriginalVirtualFile(curFile).putUserData(NOTEBOOK_LANGUAGE, (Object)language);
        }
    }
}

