/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.filecontentsapi;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.CachingFileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.DirectoryModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileContentsApiKt;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileWriterOutputStream;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.LeafContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.NotebookModel;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\t2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0016J\u0018\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bH\u0016J\b\u0010%\u001a\u00020\u0019H\u0016J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/TreeCachingFileContentsApi;", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/CachingFileContentsApi;", "forward", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileContentsApi;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileContentsApi;)V", "directoryContents", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/ContentsApiModel;", "getFileNode", "T", "path", "content", "", "type", "Ljava/lang/Class;", "(Ljava/lang/String;ZLjava/lang/Class;)Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/ContentsApiModel;", "fileWriter", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/FileWriterOutputStream;", "writeNotebook", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/NotebookModel;", "notebookJson", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "updateCache", "", "model", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/LeafContentsApiModel;", "createDirectory", "Lcom/intellij/jupyter/core/jupyter/connections/filecontentsapi/DirectoryModel;", "delete", "rename", "oldPath", "newPath", "copy", "originalPath", "targetDirectory", "invalidateAll", "invalidateForPath", "recursive", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nFileContentsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContentsApi.kt\ncom/intellij/jupyter/core/jupyter/connections/filecontentsapi/TreeCachingFileContentsApi\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,614:1\n61#2,5:615\n61#2,5:620\n61#2,5:625\n61#2,5:630\n61#2,5:635\n61#2,5:641\n61#2,5:646\n61#2,5:654\n1#3:640\n774#4:651\n865#4,2:652\n*S KotlinDebug\n*F\n+ 1 FileContentsApi.kt\ncom/intellij/jupyter/core/jupyter/connections/filecontentsapi/TreeCachingFileContentsApi\n*L\n462#1:615,5\n488#1:620,5\n517#1:625,5\n520#1:630,5\n528#1:635,5\n538#1:641,5\n559#1:646,5\n570#1:654,5\n567#1:651\n567#1:652,2\n*E\n"})
public final class TreeCachingFileContentsApi
implements CachingFileContentsApi {
    @NotNull
    private final FileContentsApi forward;
    @NotNull
    private final Cache<String, ContentsApiModel> directoryContents;

    public TreeCachingFileContentsApi(@NotNull FileContentsApi forward) {
        Intrinsics.checkNotNullParameter((Object)forward, (String)"forward");
        this.forward = forward;
        Cache cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.directoryContents = cache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public <T extends ContentsApiModel> T getFileNode(@NotNull String path, boolean content, @NotNull Class<T> type) {
        Collection collection;
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        String normalizedPath = FileContentsApiKt.access$normalizePath(path);
        if (!content) {
            ContentsApiModel cached;
            ContentsApiModel contentsApiModel = cached = (ContentsApiModel)this.directoryContents.getIfPresent((Object)normalizedPath);
            if (Intrinsics.areEqual(type, contentsApiModel != null ? contentsApiModel.getClass() : null)) {
                Logger $this$debug_u24default$iv = FileContentsApiKt.access$getLOG$p();
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Returning the cached model from getFileNode(\"" + normalizedPath + "\").", e$iv);
                }
                T t = type.cast(cached);
                Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
                return (T)((ContentsApiModel)t);
            }
        }
        T result2 = this.forward.getFileNode(path, content, type);
        if (content) {
            Intrinsics.checkNotNull(result2, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel");
            T $this$debug_u24default$iv = result2;
            if ($this$debug_u24default$iv instanceof DirectoryModel) {
                object = new DirectoryModel(result2.getName(), null, result2.getLastModified());
            } else if ($this$debug_u24default$iv instanceof FileModel) {
                object = new FileModel(result2.getName(), null, result2.getLastModified());
            } else {
                if (!($this$debug_u24default$iv instanceof NotebookModel)) throw new NoWhenBranchMatchedException();
                object = new NotebookModel(result2.getName(), null, result2.getLastModified());
            }
        } else {
            object = result2;
        }
        this.directoryContents.put((Object)normalizedPath, object);
        Intrinsics.checkNotNull(result2, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel");
        T r = result2;
        if (r instanceof DirectoryModel) {
            collection = ((DirectoryModel)r).getContent();
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
        } else {
            if (!(r instanceof LeafContentsApiModel)) throw new NoWhenBranchMatchedException();
            collection = CollectionsKt.emptyList();
        }
        Collection resultChildren = collection;
        for (ContentsApiModel child : resultChildren) {
            char[] bl = new char[]{'/'};
            this.directoryContents.put((Object)StringsKt.trimStart((String)(normalizedPath + "/" + child.getName()), (char[])bl), (Object)child);
        }
        Logger $this$debug_u24default$iv = FileContentsApiKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if (!$this$debug_u24default$iv.isDebugEnabled()) return result2;
        Logger logger = $this$debug_u24default$iv;
        boolean bl = false;
        logger.debug("Caching a model from getFileNode(\"" + normalizedPath + "\").", e$iv);
        return result2;
    }

    @Override
    @NotNull
    public FileWriterOutputStream fileWriter(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileWriterOutputStream stream = this.forward.fileWriter(path);
        return new FileWriterOutputStream(stream, this, path){
            final /* synthetic */ FileWriterOutputStream $stream;
            final /* synthetic */ TreeCachingFileContentsApi this$0;
            final /* synthetic */ String $path;
            {
                this.$stream = $stream;
                this.this$0 = $receiver;
                this.$path = $path;
            }

            public LeafContentsApiModel getModel() {
                return this.$stream.getModel();
            }

            public void write(int b) {
                this.$stream.write(b);
                Unit unit = Unit.INSTANCE;
                TreeCachingFileContentsApi treeCachingFileContentsApi = this.this$0;
                String string = this.$path;
                Unit it = unit;
                boolean bl = false;
                TreeCachingFileContentsApi.access$updateCache(treeCachingFileContentsApi, string, this.getModel());
            }

            public void write(byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                this.$stream.write(b, off, len);
                Unit unit = Unit.INSTANCE;
                TreeCachingFileContentsApi treeCachingFileContentsApi = this.this$0;
                String string = this.$path;
                Unit it = unit;
                boolean bl = false;
                TreeCachingFileContentsApi.access$updateCache(treeCachingFileContentsApi, string, this.getModel());
            }

            public void flush() {
                this.$stream.flush();
                Unit unit = Unit.INSTANCE;
                TreeCachingFileContentsApi treeCachingFileContentsApi = this.this$0;
                String string = this.$path;
                Unit it = unit;
                boolean bl = false;
                TreeCachingFileContentsApi.access$updateCache(treeCachingFileContentsApi, string, this.getModel());
            }

            public void close() {
                this.$stream.close();
                Unit unit = Unit.INSTANCE;
                TreeCachingFileContentsApi treeCachingFileContentsApi = this.this$0;
                String string = this.$path;
                Unit it = unit;
                boolean bl = false;
                TreeCachingFileContentsApi.access$updateCache(treeCachingFileContentsApi, string, this.getModel());
            }
        };
    }

    @Override
    @NotNull
    public NotebookModel writeNotebook(@NotNull String path, @NotNull ObjectNode notebookJson) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)notebookJson, (String)"notebookJson");
        NotebookModel newModel = this.forward.writeNotebook(path, notebookJson);
        this.updateCache(path, newModel);
        return newModel;
    }

    private final void updateCache(String path, LeafContentsApiModel model) {
        String normalizedPath = FileContentsApiKt.access$normalizePath(path);
        if (model != null) {
            boolean bl;
            LeafContentsApiModel leafContentsApiModel = model;
            if (leafContentsApiModel instanceof FileModel) {
                bl = ((FileModel)model).getContent() == null;
            } else if (leafContentsApiModel instanceof NotebookModel) {
                bl = ((NotebookModel)model).getContent() == null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (!bl) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            this.directoryContents.put((Object)normalizedPath, (Object)model);
            Logger $this$debug_u24default$iv = FileContentsApiKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("Caching a model from fileWriter(\"" + normalizedPath + "\").", e$iv);
            }
        } else {
            Logger $this$debug_u24default$iv = FileContentsApiKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Invalidating the cached model from fileWriter(\"" + normalizedPath + "\").", e$iv);
            }
            this.directoryContents.invalidate((Object)normalizedPath);
        }
    }

    @Override
    @NotNull
    public DirectoryModel createDirectory(@NotNull String path) {
        DirectoryModel directoryModel;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DirectoryModel it = directoryModel = this.forward.createDirectory(path);
        boolean bl = false;
        if (!(it.getContent() == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        String normalizedPath = FileContentsApiKt.access$normalizePath(path);
        Logger $this$debug_u24default$iv = FileContentsApiKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug("Caching a model from createDirectory(\"" + normalizedPath + "\").", e$iv);
        }
        this.directoryContents.put((Object)normalizedPath, (Object)it);
        return directoryModel;
    }

    @Override
    public void delete(@NotNull String path) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.forward.delete(path);
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        this.directoryContents.invalidate((Object)FileContentsApiKt.access$normalizePath(path));
    }

    @Override
    @NotNull
    public ContentsApiModel rename(@NotNull String oldPath, @NotNull String newPath) {
        ContentsApiModel contentsApiModel;
        Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        ContentsApiModel it = contentsApiModel = this.forward.rename(oldPath, newPath);
        boolean bl = false;
        String normalizedOldPath = FileContentsApiKt.access$normalizePath(oldPath);
        this.directoryContents.invalidate((Object)normalizedOldPath);
        String normalizedNewPath = FileContentsApiKt.access$normalizePath(newPath);
        Logger $this$debug_u24default$iv = FileContentsApiKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug("Invalidating the cached model and caching a new model from rename(\"" + normalizedOldPath + "\", \"" + normalizedNewPath + "\").", e$iv);
        }
        this.directoryContents.put((Object)normalizedNewPath, (Object)it);
        return contentsApiModel;
    }

    @Override
    @NotNull
    public ContentsApiModel copy(@NotNull String originalPath, @NotNull String targetDirectory) {
        ContentsApiModel contentsApiModel;
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        ContentsApiModel it = contentsApiModel = this.forward.copy(originalPath, targetDirectory);
        boolean bl = false;
        String normalizedTargetDirectoryPath = FileContentsApiKt.access$normalizePath(targetDirectory);
        FileContentsApiKt.access$getLOG$p().debug("Invalidating the cached model and caching a new model from copy(\"" + originalPath + "\", \"" + targetDirectory + "\").");
        this.directoryContents.invalidate((Object)normalizedTargetDirectoryPath);
        return contentsApiModel;
    }

    @Override
    public void invalidateAll() {
        FileContentsApiKt.access$getLOG$p().debug("Invalidating all cached models by invalidateAll().");
        this.directoryContents.invalidateAll();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void invalidateForPath(@NotNull String path, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String normalizedPath = FileContentsApiKt.access$normalizePath(path);
        if (!recursive) {
            Logger $this$debug_u24default$iv = FileContentsApiKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Invalidating the cached model for \"" + path + "\"", e$iv);
            }
            this.directoryContents.invalidate((Object)normalizedPath);
        } else if (((CharSequence)normalizedPath).length() == 0) {
            FileContentsApiKt.access$getLOG$p().debug("Invalidating all cached models by invalidateAll(\"\", recursive=true).");
            this.invalidateAll();
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.directoryContents.asMap().keySet();
            boolean $i$f$filter = false;
            Iterable bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(StringsKt.startsWith$default((String)it, (String)normalizedPath, (boolean)false, (int)2, null) && (it.length() == normalizedPath.length() || it.charAt(normalizedPath.length()) == '/'))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List keys = (List)destination$iv$iv;
            Logger $this$debug_u24default$iv = FileContentsApiKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl3 = false;
                logger.debug("Invalidating " + keys.size() + " cached models for \"" + path + "\", recursively.", e$iv);
            }
            this.directoryContents.invalidateAll((Iterable)keys);
        }
    }

    public static final /* synthetic */ void access$updateCache(TreeCachingFileContentsApi $this, String path, LeafContentsApiModel model) {
        $this.updateCache(path, model);
    }
}

