/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.text;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterTextOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.text.JupyterTextOutputConsoleView;
import com.intellij.jupyter.core.jupyter.editor.outputs.util.ConsoleViewUtilsKt;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKey;
import com.intellij.notebooks.visualization.outputs.NotebookOutputInlayShowable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 B*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001BB+\b\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\"J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J \u0010,\u001a\u00020\u00192\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\b\b\u0002\u00100\u001a\u000201H\u0004J\u001a\u00102\u001a\u00020\u00192\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00190\nJ\b\u00104\u001a\u00020\u001bH\u0016J\b\u00105\u001a\u00020\u0019H\u0016J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000207H\u0016J \u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020:H\u0016J \u0010?\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020:H\u0016J\b\u0010@\u001a\u00020\u001bH\u0016J\b\u0010A\u001a\u00020\u001bH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R/\u0010\u0015\u001a#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00190\n0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006C"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/text/TextOutputComponent;", "Console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "Ljavax/swing/JPanel;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputInlayShowable;", "Lcom/intellij/openapi/Disposable;", "Ljavax/swing/Scrollable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "consoleSupplier", "Lkotlin/Function1;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lkotlin/jvm/functions/Function1;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "console", "getConsole", "()Lcom/intellij/execution/impl/ConsoleViewImpl;", "setConsole", "(Lcom/intellij/execution/impl/ConsoleViewImpl;)V", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "consoleCreatedCallbacks", "", "Lkotlin/ParameterName;", "name", "", "value", "", "shown", "getShown", "()Z", "setShown", "(Z)V", "currentDataKey", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "getCurrentDataKey", "()Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;", "setCurrentDataKey", "(Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDataKey;)V", "needsUpdating", "outputDataKey", "setTextContent", "output", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterTextOutputDataKey;", "setContent", "strings", "", "", "processOutputType", "Lcom/intellij/execution/process/ProcessOutputType;", "applyToConsole", "action", "isValidateRoot", "dispose", "getPreferredSize", "Ljava/awt/Dimension;", "getPreferredScrollableViewportSize", "getScrollableUnitIncrement", "", "visibleRect", "Ljava/awt/Rectangle;", "orientation", "direction", "getScrollableBlockIncrement", "getScrollableTracksViewportWidth", "getScrollableTracksViewportHeight", "Companion", "intellij.jupyter.core"})
public class TextOutputComponent<Console extends ConsoleViewImpl>
extends JPanel
implements NotebookOutputInlayShowable,
Disposable,
Scrollable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final Function1<TextOutputComponent<Console>, Console> consoleSupplier;
    @Nullable
    private Console console;
    @NotNull
    private final List<Function1<Console, Unit>> consoleCreatedCallbacks;
    private boolean shown;
    @Nullable
    private NotebookOutputDataKey currentDataKey;
    public static final int SCROLL_PANE_BORDER_HEIGHT = 5;
    @NotNull
    private static final ThreadPoolExecutor installFiltersThreadPool;

    protected TextOutputComponent(@NotNull EditorImpl editor, @NotNull Function1<? super TextOutputComponent<Console>, ? extends Console> consoleSupplier) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(consoleSupplier, (String)"consoleSupplier");
        super(new BorderLayout());
        this.editor = editor;
        this.consoleSupplier = consoleSupplier;
        this.consoleCreatedCallbacks = new ArrayList();
        this.setOpaque(false);
    }

    @NotNull
    protected final EditorImpl getEditor() {
        return this.editor;
    }

    @Nullable
    public final Console getConsole() {
        return this.console;
    }

    public final void setConsole(@Nullable Console Console2) {
        this.console = Console2;
    }

    public boolean getShown() {
        return this.shown;
    }

    public void setShown(boolean value) {
        if (this.shown || this.shown == value || !value) {
            return;
        }
        this.shown = true;
        ConsoleViewImpl consoleView = (ConsoleViewImpl)this.consoleSupplier.invoke((Object)this);
        Disposer.register((Disposable)this, (Disposable)((Disposable)consoleView));
        this.console = consoleView;
        Companion.updateFiltersLater(consoleView);
        for (Function1<Console, Unit> callback2 : this.consoleCreatedCallbacks) {
            callback2.invoke((Object)consoleView);
        }
        this.consoleCreatedCallbacks.clear();
        this.add((Component)consoleView.getComponent(), "Center");
    }

    @Nullable
    protected final NotebookOutputDataKey getCurrentDataKey() {
        return this.currentDataKey;
    }

    protected final void setCurrentDataKey(@Nullable NotebookOutputDataKey notebookOutputDataKey) {
        this.currentDataKey = notebookOutputDataKey;
    }

    public final boolean needsUpdating(@NotNull NotebookOutputDataKey outputDataKey) {
        Intrinsics.checkNotNullParameter((Object)outputDataKey, (String)"outputDataKey");
        return !Intrinsics.areEqual((Object)this.currentDataKey, (Object)outputDataKey);
    }

    public final void setTextContent(@NotNull JupyterTextOutputDataKey output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.currentDataKey = output;
        this.setContent(output.getStrings(), JupyterTextOutputDataKey.OutputType.Companion.getProcessOutputType(output.getStreamType()));
    }

    protected final void setContent(@NotNull List<String> strings, @NotNull ProcessOutputType processOutputType) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)processOutputType, (String)"processOutputType");
        this.applyToConsole(arg_0 -> TextOutputComponent.setContent$lambda$0(strings, processOutputType, arg_0));
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, strings.size() * this.editor.getLineHeight()));
    }

    public static /* synthetic */ void setContent$default(TextOutputComponent textOutputComponent, List list, ProcessOutputType processOutputType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setContent");
        }
        if ((n & 2) != 0) {
            processOutputType = ProcessOutputType.STDOUT;
        }
        textOutputComponent.setContent(list, processOutputType);
    }

    public final void applyToConsole(@NotNull Function1<? super Console, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Console console = this.console;
        if (console == null) {
            this.consoleCreatedCallbacks.add(action);
        } else {
            action.invoke(console);
        }
    }

    @Override
    public boolean isValidateRoot() {
        return false;
    }

    public void dispose() {
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Console Console2 = this.console;
        if (Console2 == null) {
            Dimension dimension = super.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            return dimension;
        }
        Console console = Console2;
        Dimension dimension = ((JComponent)console).getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        return dimension;
    }

    @Override
    @NotNull
    public Dimension getPreferredScrollableViewportSize() {
        JScrollPane scrollPane;
        Dimension dimension;
        Dimension it = dimension = this.getPreferredSize();
        boolean bl = false;
        Container container = this.getParent();
        Container container2 = container != null ? container.getParent() : null;
        JScrollPane jScrollPane = scrollPane = container2 instanceof JScrollPane ? (JScrollPane)container2 : null;
        if (scrollPane != null) {
            it.width = scrollPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
        }
        return dimension;
    }

    @Override
    public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private static final Unit setContent$lambda$0(List $strings, ProcessOutputType $processOutputType, ConsoleViewImpl console) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        ConsoleViewUtilsKt.setContent(console, $strings, $processOutputType);
        return Unit.INSTANCE;
    }

    static {
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)(TextOutputComponent.class.getName() + ".installFiltersThreadPool"));
        Intrinsics.checkNotNullExpressionValue((Object)threadPoolExecutor, (String)"newSingleThreadExecutor(...)");
        installFiltersThreadPool = threadPoolExecutor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/text/TextOutputComponent$Companion;", "", "<init>", "()V", "SCROLL_PANE_BORDER_HEIGHT", "", "createComponent", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/text/TextOutputComponent;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "installFiltersThreadPool", "Ljava/util/concurrent/ThreadPoolExecutor;", "Lorg/jetbrains/annotations/NotNull;", "updateFiltersLater", "", "console", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextOutputComponent<ConsoleViewImpl> createComponent(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            TextOutputComponent<ConsoleViewImpl> component2 = new TextOutputComponent<ConsoleViewImpl>(editor, arg_0 -> Companion.createComponent$lambda$0(project2, editor, arg_0));
            return component2;
        }

        public final void updateFiltersLater(@NotNull ConsoleViewImpl console) {
            Intrinsics.checkNotNullParameter((Object)console, (String)"console");
            ReadAction.nonBlocking(() -> Companion.updateFiltersLater$lambda$1(console)).expireWith((Disposable)console).finishOnUiThread(ModalityState.stateForComponent((Component)((Component)console)), arg_0 -> Companion.updateFiltersLater$lambda$3(arg_0 -> Companion.updateFiltersLater$lambda$2(console, arg_0), arg_0)).submit((Executor)installFiltersThreadPool);
        }

        private static final ConsoleViewImpl createComponent$lambda$0(Project $project, EditorImpl $editor, TextOutputComponent textOutput) {
            Intrinsics.checkNotNullParameter((Object)textOutput, (String)"textOutput");
            return new JupyterTextOutputConsoleView($project, $editor, textOutput);
        }

        private static final List updateFiltersLater$lambda$1(ConsoleViewImpl $console) {
            return ConsoleViewUtil.computeConsoleFilters((Project)$console.getProject(), (ConsoleView)((ConsoleView)$console), (GlobalSearchScope)GlobalSearchScope.allScope((Project)$console.getProject()));
        }

        private static final Unit updateFiltersLater$lambda$2(ConsoleViewImpl $console, List filters) {
            for (Filter filter : filters) {
                $console.addMessageFilter(filter);
            }
            return Unit.INSTANCE;
        }

        private static final void updateFiltersLater$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

