/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenViewComponent;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/H\u0016R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffscreenPopupComponent;", "Ljavax/swing/JComponent;", "<init>", "()V", "value", "", "screenScale", "getScreenScale", "()F", "setScreenScale$intellij_jupyter_core", "(F)V", "Ljava/awt/image/BufferedImage;", "popupImage", "getPopupImage", "()Ljava/awt/image/BufferedImage;", "popupRect", "Ljava/awt/Rectangle;", "getPopupRect", "()Ljava/awt/Rectangle;", "setPopupRect", "(Ljava/awt/Rectangle;)V", "eventsTarget", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;", "getEventsTarget", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;", "setEventsTarget", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;)V", "mousePointShift", "Ljava/awt/Point;", "getMousePointShift", "()Ljava/awt/Point;", "setMousePointShift", "(Ljava/awt/Point;)V", "forwardMouseEvent", "", "e", "Ljava/awt/event/MouseEvent;", "updatePopupImage", "rect", "buffer", "Ljava/nio/ByteBuffer;", "scaleDown", "", "getPreferredSize", "Ljava/awt/Dimension;", "paint", "g", "Ljava/awt/Graphics;", "intellij.jupyter.core"})
@ApiStatus.Internal
public final class JcefOffscreenPopupComponent
extends JComponent {
    private float screenScale = JBUIScale.sysScale();
    @Nullable
    private BufferedImage popupImage;
    @Nullable
    private Rectangle popupRect;
    @Nullable
    private JcefOffScreenViewComponent eventsTarget;
    @NotNull
    private Point mousePointShift = new Point(0, 0);

    public JcefOffscreenPopupComponent() {
        this.setFocusable(true);
        this.putClientProperty("AuxEditorComponent", true);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.forwardKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.forwardKeyEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.forwardKeyEvent(e);
            }

            private final void forwardKeyEvent(KeyEvent e) {
                block0: {
                    JcefOffScreenViewComponent jcefOffScreenViewComponent = this.getEventsTarget();
                    if (jcefOffScreenViewComponent == null) break block0;
                    jcefOffScreenViewComponent.dispatchEvent(e);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.forwardMouseEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.forwardMouseEvent(e);
            }
        });
        this.addMouseWheelListener(arg_0 -> JcefOffscreenPopupComponent._init_$lambda$0(this, arg_0));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.forwardMouseEvent(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.forwardMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.forwardMouseEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.forwardMouseEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.forwardMouseEvent(e);
            }
        });
    }

    public final float getScreenScale() {
        return this.screenScale;
    }

    public final void setScreenScale$intellij_jupyter_core(float f) {
        this.screenScale = f;
    }

    @Nullable
    public final BufferedImage getPopupImage() {
        return this.popupImage;
    }

    @Nullable
    public final Rectangle getPopupRect() {
        return this.popupRect;
    }

    public final void setPopupRect(@Nullable Rectangle rectangle) {
        this.popupRect = rectangle;
    }

    @Nullable
    public final JcefOffScreenViewComponent getEventsTarget() {
        return this.eventsTarget;
    }

    public final void setEventsTarget(@Nullable JcefOffScreenViewComponent jcefOffScreenViewComponent) {
        this.eventsTarget = jcefOffScreenViewComponent;
    }

    @NotNull
    public final Point getMousePointShift() {
        return this.mousePointShift;
    }

    public final void setMousePointShift(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"<set-?>");
        this.mousePointShift = point;
    }

    private final void forwardMouseEvent(MouseEvent e) {
        block0: {
            JcefOffScreenViewComponent jcefOffScreenViewComponent = this.eventsTarget;
            if (jcefOffScreenViewComponent == null) break block0;
            jcefOffScreenViewComponent.forwardMouseEvent(e, false, this.mousePointShift.x, this.mousePointShift.y);
        }
    }

    public final void updatePopupImage(@NotNull Rectangle rect, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BufferedImage currentPopup = this.popupImage;
        BufferedImage popupImage = currentPopup != null && currentPopup.getWidth() >= rect.width && currentPopup.getHeight() >= rect.height ? currentPopup : new BufferedImage(rect.width, rect.height, 1);
        IntBuffer source = buffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        DataBuffer dataBuffer = popupImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
        DataBufferInt dest = (DataBufferInt)dataBuffer;
        int rectBottom = rect.y + rect.height;
        int rectRight = rect.x + rect.width;
        for (int y = rect.y; y < rectBottom; ++y) {
            int lineStart = y * popupImage.getWidth();
            int lineEnd = lineStart + rectRight;
            int from = lineStart + rect.x;
            int length = lineEnd - from;
            source.position(from).get(dest.getData(), from, length);
        }
        this.popupImage = popupImage;
    }

    private final int scaleDown(int value) {
        return MathKt.roundToInt((float)((float)value / this.screenScale));
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        BufferedImage bufferedImage = this.popupImage;
        if (bufferedImage == null) {
            return new Dimension(1, 1);
        }
        BufferedImage image = bufferedImage;
        return new Dimension(this.scaleDown(image.getWidth()), this.scaleDown(image.getHeight()));
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paint(g);
        BufferedImage bufferedImage = this.popupImage;
        if (bufferedImage == null) {
            return;
        }
        BufferedImage image = bufferedImage;
        g.drawImage(image, 0, 0, this.getWidth(), this.getHeight(), null);
    }

    private static final void _init_$lambda$0(JcefOffscreenPopupComponent this$0, MouseWheelEvent e) {
        block0: {
            JcefOffScreenViewComponent jcefOffScreenViewComponent = this$0.eventsTarget;
            if (jcefOffScreenViewComponent == null) break block0;
            Intrinsics.checkNotNull((Object)e);
            jcefOffScreenViewComponent.forwardMouseWheelEvent(e, this$0.mousePointShift.x, this$0.mousePointShift.y);
        }
    }
}

