/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.MacroInfo;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXFormulaParser;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PredefinedTeXFormulaParser {
    public static final String RESOURCE_NAME = "PredefinedTeXFormulas.xml";
    private Element root;
    private String type;

    public PredefinedTeXFormulaParser(InputStream file, String type) throws ResourceParseException {
        try {
            this.type = type;
            DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
            factory2.setIgnoringElementContentWhitespace(true);
            factory2.setIgnoringComments(true);
            this.root = factory2.newDocumentBuilder().parse(file).getDocumentElement();
        }
        catch (Exception e) {
            throw new XMLResourceParseException("", e);
        }
    }

    public PredefinedTeXFormulaParser(String PredefFile, String type) throws ResourceParseException {
        this(PredefinedTeXFormulaParser.class.getResourceAsStream(PredefFile), type);
    }

    public void parse(Map predefinedTeXFormulas) {
        String enabledAll = PredefinedTeXFormulaParser.getAttrValueAndCheckIfNotNull("enabled", this.root);
        if ("true".equals(enabledAll)) {
            NodeList list = this.root.getElementsByTagName(this.type);
            for (int i = 0; i < list.getLength(); ++i) {
                Element formula = (Element)list.item(i);
                String enabled = PredefinedTeXFormulaParser.getAttrValueAndCheckIfNotNull("enabled", formula);
                if (!"true".equals(enabled)) continue;
                String name = PredefinedTeXFormulaParser.getAttrValueAndCheckIfNotNull("name", formula);
                if ("TeXFormula".equals(this.type)) {
                    predefinedTeXFormulas.put(name, (TeXFormula)new TeXFormulaParser(name, formula, this.type).parse());
                    continue;
                }
                predefinedTeXFormulas.put(name, (MacroInfo)new TeXFormulaParser(name, formula, this.type).parse());
            }
        }
    }

    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        String attrValue = element.getAttribute(attrName);
        if (attrValue.equals("")) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), attrName, null);
        }
        return attrValue;
    }
}

