/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.util.ReflectionUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.add.AddClient;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.api.RepositoryFeaturesClient;
import org.jetbrains.idea.svn.api.SvnClient;
import org.jetbrains.idea.svn.api.VersionClient;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.change.ChangeListClient;
import org.jetbrains.idea.svn.checkin.CheckinClient;
import org.jetbrains.idea.svn.checkin.ImportClient;
import org.jetbrains.idea.svn.checkout.CheckoutClient;
import org.jetbrains.idea.svn.checkout.ExportClient;
import org.jetbrains.idea.svn.cleanup.CleanupClient;
import org.jetbrains.idea.svn.conflict.ConflictClient;
import org.jetbrains.idea.svn.content.ContentClient;
import org.jetbrains.idea.svn.copy.CopyMoveClient;
import org.jetbrains.idea.svn.delete.DeleteClient;
import org.jetbrains.idea.svn.diff.DiffClient;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.info.InfoClient;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.lock.LockClient;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.revert.RevertClient;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.update.RelocateClient;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;

public abstract class ClientFactory {
    @NotNull
    protected SvnVcs myVcs;
    protected AddClient addClient;
    protected AnnotateClient annotateClient;
    protected ContentClient contentClient;
    protected HistoryClient historyClient;
    protected RevertClient revertClient;
    protected DeleteClient deleteClient;
    protected StatusClient statusClient;
    protected InfoClient infoClient;
    protected CopyMoveClient copyMoveClient;
    protected ConflictClient conflictClient;
    protected PropertyClient propertyClient;
    protected MergeClient mergeClient;
    protected ChangeListClient changeListClient;
    protected CheckoutClient checkoutClient;
    protected LockClient myLockClient;
    protected CleanupClient myCleanupClient;
    protected RelocateClient myRelocateClient;
    protected VersionClient myVersionClient;
    protected ImportClient myImportClient;
    protected ExportClient myExportClient;
    protected UpgradeClient myUpgradeClient;
    protected BrowseClient myBrowseClient;
    protected DiffClient myDiffClient;
    protected CheckinClient myCheckinClient;
    protected RepositoryFeaturesClient myRepositoryFeaturesClient;
    @NotNull
    private final Map<Class, Class> myClientImplementations;

    protected ClientFactory(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            ClientFactory.$$$reportNull$$$0(0);
        }
        this.myClientImplementations = new HashMap<Class, Class>();
        this.myVcs = vcs;
        this.setup();
    }

    protected abstract void setup();

    protected <T extends SvnClient> void put(@NotNull Class<T> type, @NotNull Class<? extends T> implementation) {
        if (type == null) {
            ClientFactory.$$$reportNull$$$0(1);
        }
        if (implementation == null) {
            ClientFactory.$$$reportNull$$$0(2);
        }
        this.myClientImplementations.put(type, implementation);
    }

    @NotNull
    protected <T extends SvnClient> Class<? extends T> get(@NotNull Class<T> type) {
        Class implementation;
        if (type == null) {
            ClientFactory.$$$reportNull$$$0(3);
        }
        if ((implementation = this.myClientImplementations.get(type)) == null) {
            throw new IllegalArgumentException("No implementation registered for " + type);
        }
        Class clazz = implementation;
        if (clazz == null) {
            ClientFactory.$$$reportNull$$$0(4);
        }
        return clazz;
    }

    @NotNull
    public <T extends SvnClient> T create(@NotNull Class<T> type, boolean isActive) {
        if (type == null) {
            ClientFactory.$$$reportNull$$$0(5);
        }
        SvnClient client = this.prepare((SvnClient)ReflectionUtil.newInstance(this.get(type)));
        client.setIsActive(isActive);
        SvnClient svnClient = client;
        if (svnClient == null) {
            ClientFactory.$$$reportNull$$$0(6);
        }
        return (T)svnClient;
    }

    @NotNull
    public AddClient createAddClient() {
        AddClient addClient = this.prepare(this.addClient);
        if (addClient == null) {
            ClientFactory.$$$reportNull$$$0(7);
        }
        return addClient;
    }

    @NotNull
    public AnnotateClient createAnnotateClient() {
        AnnotateClient annotateClient = this.prepare(this.annotateClient);
        if (annotateClient == null) {
            ClientFactory.$$$reportNull$$$0(8);
        }
        return annotateClient;
    }

    @NotNull
    public ContentClient createContentClient() {
        ContentClient contentClient = this.prepare(this.contentClient);
        if (contentClient == null) {
            ClientFactory.$$$reportNull$$$0(9);
        }
        return contentClient;
    }

    @NotNull
    public HistoryClient createHistoryClient() {
        HistoryClient historyClient = this.prepare(this.historyClient);
        if (historyClient == null) {
            ClientFactory.$$$reportNull$$$0(10);
        }
        return historyClient;
    }

    @NotNull
    public RevertClient createRevertClient() {
        RevertClient revertClient = this.prepare(this.revertClient);
        if (revertClient == null) {
            ClientFactory.$$$reportNull$$$0(11);
        }
        return revertClient;
    }

    @NotNull
    public StatusClient createStatusClient() {
        StatusClient statusClient = this.prepare(this.statusClient);
        if (statusClient == null) {
            ClientFactory.$$$reportNull$$$0(12);
        }
        return statusClient;
    }

    @NotNull
    public InfoClient createInfoClient() {
        InfoClient infoClient = this.prepare(this.infoClient);
        if (infoClient == null) {
            ClientFactory.$$$reportNull$$$0(13);
        }
        return infoClient;
    }

    @NotNull
    public abstract UpdateClient createUpdateClient();

    @NotNull
    public DeleteClient createDeleteClient() {
        DeleteClient deleteClient = this.prepare(this.deleteClient);
        if (deleteClient == null) {
            ClientFactory.$$$reportNull$$$0(14);
        }
        return deleteClient;
    }

    @NotNull
    public CopyMoveClient createCopyMoveClient() {
        CopyMoveClient copyMoveClient = this.prepare(this.copyMoveClient);
        if (copyMoveClient == null) {
            ClientFactory.$$$reportNull$$$0(15);
        }
        return copyMoveClient;
    }

    @NotNull
    public ConflictClient createConflictClient() {
        ConflictClient conflictClient = this.prepare(this.conflictClient);
        if (conflictClient == null) {
            ClientFactory.$$$reportNull$$$0(16);
        }
        return conflictClient;
    }

    @NotNull
    public PropertyClient createPropertyClient() {
        PropertyClient propertyClient = this.prepare(this.propertyClient);
        if (propertyClient == null) {
            ClientFactory.$$$reportNull$$$0(17);
        }
        return propertyClient;
    }

    @NotNull
    public MergeClient createMergeClient() {
        MergeClient mergeClient = this.prepare(this.mergeClient);
        if (mergeClient == null) {
            ClientFactory.$$$reportNull$$$0(18);
        }
        return mergeClient;
    }

    @NotNull
    public ChangeListClient createChangeListClient() {
        ChangeListClient changeListClient = this.prepare(this.changeListClient);
        if (changeListClient == null) {
            ClientFactory.$$$reportNull$$$0(19);
        }
        return changeListClient;
    }

    @NotNull
    public CheckoutClient createCheckoutClient() {
        CheckoutClient checkoutClient = this.prepare(this.checkoutClient);
        if (checkoutClient == null) {
            ClientFactory.$$$reportNull$$$0(20);
        }
        return checkoutClient;
    }

    @NotNull
    public LockClient createLockClient() {
        LockClient lockClient = this.prepare(this.myLockClient);
        if (lockClient == null) {
            ClientFactory.$$$reportNull$$$0(21);
        }
        return lockClient;
    }

    @NotNull
    public CleanupClient createCleanupClient() {
        CleanupClient cleanupClient = this.prepare(this.myCleanupClient);
        if (cleanupClient == null) {
            ClientFactory.$$$reportNull$$$0(22);
        }
        return cleanupClient;
    }

    @NotNull
    public RelocateClient createRelocateClient() {
        RelocateClient relocateClient = this.prepare(this.myRelocateClient);
        if (relocateClient == null) {
            ClientFactory.$$$reportNull$$$0(23);
        }
        return relocateClient;
    }

    @NotNull
    public VersionClient createVersionClient() {
        VersionClient versionClient = this.prepare(this.myVersionClient);
        if (versionClient == null) {
            ClientFactory.$$$reportNull$$$0(24);
        }
        return versionClient;
    }

    @NotNull
    public ImportClient createImportClient() {
        ImportClient importClient = this.prepare(this.myImportClient);
        if (importClient == null) {
            ClientFactory.$$$reportNull$$$0(25);
        }
        return importClient;
    }

    @NotNull
    public ExportClient createExportClient() {
        ExportClient exportClient = this.prepare(this.myExportClient);
        if (exportClient == null) {
            ClientFactory.$$$reportNull$$$0(26);
        }
        return exportClient;
    }

    @NotNull
    public UpgradeClient createUpgradeClient() {
        UpgradeClient upgradeClient = this.prepare(this.myUpgradeClient);
        if (upgradeClient == null) {
            ClientFactory.$$$reportNull$$$0(27);
        }
        return upgradeClient;
    }

    @NotNull
    public BrowseClient createBrowseClient() {
        BrowseClient browseClient = this.prepare(this.myBrowseClient);
        if (browseClient == null) {
            ClientFactory.$$$reportNull$$$0(28);
        }
        return browseClient;
    }

    @NotNull
    public DiffClient createDiffClient() {
        DiffClient diffClient = this.prepare(this.myDiffClient);
        if (diffClient == null) {
            ClientFactory.$$$reportNull$$$0(29);
        }
        return diffClient;
    }

    @NotNull
    public CheckinClient createCheckinClient() {
        CheckinClient checkinClient = this.prepare(this.myCheckinClient);
        if (checkinClient == null) {
            ClientFactory.$$$reportNull$$$0(30);
        }
        return checkinClient;
    }

    @NotNull
    public RepositoryFeaturesClient createRepositoryFeaturesClient() {
        RepositoryFeaturesClient repositoryFeaturesClient = this.prepare(this.myRepositoryFeaturesClient);
        if (repositoryFeaturesClient == null) {
            ClientFactory.$$$reportNull$$$0(31);
        }
        return repositoryFeaturesClient;
    }

    @NotNull
    protected <T extends SvnClient> T prepare(@NotNull T client) {
        if (client == null) {
            ClientFactory.$$$reportNull$$$0(32);
        }
        client.setVcs(this.myVcs);
        client.setFactory(this);
        client.setIsActive(true);
        T t = client;
        if (t == null) {
            ClientFactory.$$$reportNull$$$0(33);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementation";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/api/ClientFactory";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/api/ClientFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddClient";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotateClient";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentClient";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createHistoryClient";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createRevertClient";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createStatusClient";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoClient";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeleteClient";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyMoveClient";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createConflictClient";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createPropertyClient";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeClient";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangeListClient";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckoutClient";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createLockClient";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createCleanupClient";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createRelocateClient";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createVersionClient";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportClient";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createExportClient";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpgradeClient";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createBrowseClient";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffClient";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckinClient";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createRepositoryFeaturesClient";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33 -> new IllegalStateException(string);
        };
    }
}

