/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.SvnBundle;

public class SimpleCredentialsDialog
extends DialogWrapper
implements DocumentListener {
    private boolean myAllowSave;
    private String myUserName;
    private Mode myMode;
    private String myRealm;
    private JTextField myUserNameText;
    private JCheckBox myAllowSaveCheckBox;
    private JPasswordField myPasswordText;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.authentication";

    public SimpleCredentialsDialog(Project project) {
        super(project, true);
        this.setResizable(false);
    }

    public void setup(String realm, String userName, boolean allowSave) {
        this.setup(Mode.DEFAULT, realm, userName, allowSave);
    }

    public void setup(Mode mode, String realm, String userName, boolean allowSave) {
        this.myMode = mode;
        this.myRealm = realm;
        this.myUserName = userName;
        this.myAllowSave = allowSave;
        this.getHelpAction().setEnabled(true);
        this.init();
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = JBUI.insets((int)2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 2;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        JLabel label = new JLabel(SvnBundle.message("label.auth.authentication.realm", this.myRealm));
        panel2.add((Component)label, gb);
        ++gb.gridy;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        label = new JLabel(SvnBundle.message(this.myMode.equals((Object)Mode.SSH_PASSPHRASE) ? "label.ssh.key.file" : "label.auth.user.name", new Object[0]));
        panel2.add((Component)label, gb);
        gb.gridx = 1;
        gb.weightx = 1.0;
        gb.fill = 2;
        this.myUserNameText = new JTextField();
        panel2.add((Component)this.myUserNameText, gb);
        label.setLabelFor(this.myUserNameText);
        if (this.myUserName != null) {
            this.myUserNameText.setText(this.myUserName);
        }
        this.myUserNameText.selectAll();
        this.myUserNameText.getDocument().addDocumentListener(this);
        this.myUserNameText.setEnabled(this.myMode.equals((Object)Mode.DEFAULT));
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.fill = 0;
        gb.gridwidth = 1;
        label = new JLabel(SvnBundle.message(this.myMode.equals((Object)Mode.SSH_PASSPHRASE) ? "label.ssh.passphrase" : "label.auth.password", new Object[0]));
        panel2.add((Component)label, gb);
        gb.gridx = 1;
        gb.weightx = 1.0;
        gb.fill = 2;
        this.myPasswordText = new JPasswordField();
        panel2.add((Component)this.myPasswordText, gb);
        label.setLabelFor(this.myPasswordText);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 2;
        gb.weightx = 1.0;
        gb.fill = 2;
        this.myAllowSaveCheckBox = new JCheckBox(SvnBundle.message("checkbox.auth.keep.for.current.session", new Object[0]));
        panel2.add((Component)this.myAllowSaveCheckBox, gb);
        ++gb.gridy;
        if (!this.myAllowSave) {
            JLabel cannotSaveLabel = new JLabel(SvnBundle.message("svn.cannot.save.credentials.store-auth-creds", new Object[0]));
            cannotSaveLabel.setForeground(NamedColorUtil.getInactiveTextColor());
            panel2.add((Component)cannotSaveLabel, gb);
            ++gb.gridy;
        }
        panel2.add((Component)new JSeparator(), gb);
        this.myAllowSaveCheckBox.setSelected(false);
        this.myAllowSaveCheckBox.setEnabled(this.myAllowSave);
        return panel2;
    }

    protected String getDimensionServiceKey() {
        return "svn.passwordDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUserNameText.isEnabled() ? this.myUserNameText : this.myPasswordText;
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public boolean isOKActionEnabled() {
        return this.myUserNameText != null && this.myUserNameText.getText().trim().length() > 0 && this.myPasswordText != null && this.myPasswordText.getPassword() != null;
    }

    public String getUserName() {
        return this.isOK() && this.myUserNameText != null ? this.myUserNameText.getText() : null;
    }

    public String getPassword() {
        char[] pwd;
        if (this.isOK() && this.myPasswordText != null && (pwd = this.myPasswordText.getPassword()) != null) {
            return new String(pwd);
        }
        return null;
    }

    public boolean isSaveAllowed() {
        return this.isOK() && this.myAllowSave && this.myAllowSaveCheckBox != null && this.myAllowSaveCheckBox.isSelected();
    }

    public void setSaveEnabled(boolean enabled) {
        this.myAllowSaveCheckBox.setEnabled(enabled);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    private void updateOKButton() {
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }

    public static enum Mode {
        SSH_PASSPHRASE,
        SSH_PASSWORD,
        DEFAULT;

    }
}

