/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest.api2;

import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.rest.JiraRestApi;
import com.intellij.tasks.jira.rest.api2.model.JiraIssueApi2;
import com.intellij.tasks.jira.rest.api2.model.JiraTransitionsWrapperApi2;
import com.intellij.tasks.jira.rest.model.JiraIssue;
import com.intellij.tasks.jira.rest.model.JiraResponseWrapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraRestApi2
extends JiraRestApi {
    private static final Logger LOG = Logger.getInstance(JiraIssueApi2.class);
    private static final Type ISSUES_WRAPPER_TYPE = new TypeToken<JiraResponseWrapper.Issues<JiraIssueApi2>>(){}.getType();

    public JiraRestApi2(JiraRepository repository) {
        super(repository);
    }

    @Override
    @NotNull
    protected GetMethod getMultipleIssuesSearchMethod(String jql, int max) {
        GetMethod method = super.getMultipleIssuesSearchMethod(jql, max);
        method.setQueryString(method.getQueryString() + "&fields=id,key,summary,description,created,updated,duedate,resolutiondate,assignee,reporter,issuetype,comment,status");
        GetMethod getMethod = method;
        if (getMethod == null) {
            JiraRestApi2.$$$reportNull$$$0(0);
        }
        return getMethod;
    }

    @Override
    @NotNull
    protected List<JiraIssue> parseIssues(String response) {
        JiraResponseWrapper.Issues wrapper = (JiraResponseWrapper.Issues)JiraRepository.GSON.fromJson(response, ISSUES_WRAPPER_TYPE);
        return new ArrayList<JiraIssue>(wrapper.getIssues());
    }

    @Override
    @NotNull
    protected GetMethod getSingleIssueSearchMethod(String key) {
        GetMethod method = super.getSingleIssueSearchMethod(key);
        String oldParams = method.getQueryString() == null ? "" : method.getQueryString();
        method.setQueryString(oldParams + "&fields=id,key,summary,description,created,updated,duedate,resolutiondate,assignee,reporter,issuetype,comment,status");
        GetMethod getMethod = method;
        if (getMethod == null) {
            JiraRestApi2.$$$reportNull$$$0(1);
        }
        return getMethod;
    }

    @Override
    @Nullable
    protected JiraIssue parseIssue(String response) {
        return (JiraIssue)JiraRepository.GSON.fromJson(response, JiraIssueApi2.class);
    }

    @Override
    @NotNull
    protected String getRequestForStateTransition(@NotNull CustomTaskState state) {
        if (state == null) {
            JiraRestApi2.$$$reportNull$$$0(2);
        }
        assert (StringUtil.isNotEmpty((String)state.getId()));
        String stateId = state.getId();
        int index = stateId.indexOf(58);
        if (index >= 0) {
            String string = "{  \"transition\": {\"id\": \"" + stateId.substring(0, index) + "\"},   \"fields\": {\"resolution\": {\"name\": \"" + stateId.substring(index + 1) + "\"}}}";
            if (string == null) {
                JiraRestApi2.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = "{\"transition\": {\"id\": \"" + stateId + "\"}}";
        if (string == null) {
            JiraRestApi2.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        if (task == null) {
            JiraRestApi2.$$$reportNull$$$0(5);
        }
        GetMethod method = new GetMethod(this.myRepository.getRestUrl("issue", task.getId(), "transitions"));
        method.setQueryString("expand=transitions.fields");
        String response = this.myRepository.executeMethod(method);
        JiraTransitionsWrapperApi2 wrapper = (JiraTransitionsWrapperApi2)JiraRepository.GSON.fromJson(response, JiraTransitionsWrapperApi2.class);
        Set<CustomTaskState> set = wrapper.getTransitions();
        if (set == null) {
            JiraRestApi2.$$$reportNull$$$0(6);
        }
        return set;
    }

    @Override
    public void updateTimeSpend(@NotNull LocalTask task, @NotNull String timeSpent, String comment) throws Exception {
        if (task == null) {
            JiraRestApi2.$$$reportNull$$$0(7);
        }
        if (timeSpent == null) {
            JiraRestApi2.$$$reportNull$$$0(8);
        }
        LOG.debug(String.format("Time spend: %s, comment: %s", timeSpent, comment));
        PostMethod method = new PostMethod(this.myRepository.getRestUrl("issue", task.getId(), "worklog"));
        String request = StringUtil.isEmpty((String)comment) ? String.format("{\"timeSpent\" : \"" + timeSpent + "\"}", timeSpent) : String.format("{\"timeSpent\": \"%s\", \"comment\": \"%s\"}", timeSpent, StringUtil.escapeQuotes((String)comment));
        method.setRequestEntity(JiraRestApi2.createJsonEntity(request));
        this.myRepository.executeMethod(method);
    }

    @Override
    @NotNull
    public JiraRemoteApi.ApiType getType() {
        JiraRemoteApi.ApiType apiType = JiraRemoteApi.ApiType.REST_2_0;
        if (apiType == null) {
            JiraRestApi2.$$$reportNull$$$0(9);
        }
        return apiType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/jira/rest/api2/JiraRestApi2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeSpent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultipleIssuesSearchMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleIssueSearchMethod";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/jira/rest/api2/JiraRestApi2";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestForStateTransition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTaskStates";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRequestForStateTransition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTaskStates";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateTimeSpend";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

