The code for establishing a connection with the browser is very complex, confusing and completely cursed.

Below is an attempt to describe the general flow:

```mermaid
flowchart TD
  classDef async fill: lightgray;
  PropertiesComponent[(PropertiesComponent)]
  start(["connect()"])
  readPort[/"savedPort = readPersistedData()"/]
  checkSavedPort{"savedPort < 0"}
  reuseBrowser["reusedExistingBrowserInstance = true"]
  tryToConnectToExistingBrowser["channel = tryToConnect(savedPort, 2 attempts)"]
  checkChannelNotNull{"channel != null"}
  awaitFirst>await first]
  class awaitFirst async;
  awaitFirst --> async1
  awaitFirst --> async2(["`
    await for AsyncPromise&lt; WipVm &gt; that 
    is executed in the
    ChromeLocalVmConnection::ChannelHandler
    `"])

  subgraph async1
    delay500ms["delay(500ms)"]
    closeChannel["channel.close()"]
  end
  delay500ms --> closeChannel
  closeChannel --> launchBrowserOnNewPortAndOpen
  start --> readPort
  readPort -.-> PropertiesComponent
  readPort --> checkSavedPort
  checkSavedPort -- <0 --> launchBrowserOnNewPortAndOpen
  checkSavedPort -- >0 --> reuseBrowser
  reuseBrowser --> tryToConnectToExistingBrowser
  tryToConnectToExistingBrowser --> checkChannelNotNull
  checkChannelNotNull -- channel = = null --> launchBrowserAndOpen
  checkChannelNotNull -- channel ! = null --> awaitFirst

  subgraph launchBrowserAndOpen
    startBrowser[[start new browser process]]
    dontReuseBrowser["reusedExistingBrowserInstance = false"]
    awaitFirst2>await first]
    class awaitFirst2 async;
    delay9s["delay(9s)"]
    suggestAnotherPort["suggest to try another port"]
    clearPersistedData[/"clearPersistedData()"/]
    restartSession(["restart debug session"])
    startBrowser --> dontReuseBrowser
    dontReuseBrowser --> awaitFirst2
    awaitFirst2 --> delay9s
    delay9s --> suggestAnotherPort
    suggestAnotherPort --> clearPersistedData
    clearPersistedData --> restartSession
    openVmConnection["RemoteVmConnection#open()"]
    awaitFirst2 --> openVmConnection
    openVmConnection --> async3(["`
    await for AsyncPromise&lt; WipVm &gt; that 
    is executed in the
    ChromeLocalVmConnection::ChannelHandler
    and retry if unsuccessfull
    `"])
  end

  subgraph launchBrowserOnNewPortAndOpen
    findNewPort["newPort = findAvailableSocketPort()"]
    writeNewPort[/"writePersistedData(newPort)"/]
    findNewPort --> writeNewPort
  end

  writeNewPort --> launchBrowserAndOpen
  writeNewPort -.-> PropertiesComponent
  clearPersistedData -.-> PropertiesComponent
```

So, when the connection is finally established, all execution paths converge to the ChannelHandler, which is defined
in `ChromeLocalVmConnection#createChannelHandler`.
As soon as the channel becomes active, the handler sends the following request (`WipRemoteVmConnection#sendGetJson`):

```http request
GET localhost:{{$port}}/json
Accept: */*
Host: localhost:{{$port}}
```

Which returns the list of available debug targets.
Here is an example response:

```json
[
  {
    "description": "",
    "devtoolsFrontendUrl": "/devtools/inspector.html?ws=localhost:54746/devtools/page/D12555F957026D787361E2C8EC829F9B",
    "id": "D12555F957026D787361E2C8EC829F9B",
    "title": "about:blank",
    "type": "page",
    "url": "about:blank",
    "webSocketDebuggerUrl": "ws://localhost:54746/devtools/page/D12555F957026D787361E2C8EC829F9B"
  },
  {
    "description": "",
    "devtoolsFrontendUrl": "/devtools/inspector.html?ws=localhost:54746/devtools/page/2A2527353F83D3732B91020D01E759E8",
    "id": "2A2527353F83D3732B91020D01E759E8",
    "title": "Welcome to Chrome",
    "type": "page",
    "url": "chrome://welcome/",
    "webSocketDebuggerUrl": "ws://localhost:54746/devtools/page/2A2527353F83D3732B91020D01E759E8"
  }
]
```

After this, a complex sequence of operations begins again, which is better expressed in a diagram:

```mermaid
flowchart TD
  classDef async fill: lightgray;
  targetsReceived([JSON with debug targets received])
  checkReusedExistingBrowserInstance{"reusedExistingBrowserInstance"}
  targetsReceived --> checkReusedExistingBrowserInstance
  checkReusedExistingBrowserInstance -- true --> connectToPageCall1
  checkReusedExistingBrowserInstance -- false --> setNewPageRequested
  connectToPageCall1{"connectToPage(...)"}
  connectToPageCall2{"connectToPage(...)"}
  setNewPageRequested["newPageRequested = true"]
  setNewPageRequested --> connectToPageCall2
  connectToPageCall2 -- true --> OK
  connectToPageCall2 -- false --> checkTimeout5000ms
  checkTimeout5000ms{"now - startTimeMillis < 5000"}
  checkTimeout5000ms -- ok --> sendFetchTargetsRequest
  checkTimeout5000ms -- timeout --> TIMEOUT
  sendFetchTargetsRequest["`send GET /json`"]
  sendFetchTargetsRequest -...-> targetsReceived
%% /json/new?about:blank
  sendNewPageRequest["`send new page request
  PUT /json/new?about:blank`"]
  setNewPageRequested2["newPageRequested = true"]
  connectToPageCall1 -- true --> checkReloadAndReuse
  connectToPageCall1 -- false --> sendNewPageRequest
  sendNewPageRequest --> setNewPageRequested2
  setNewPageRequested2 -...-> targetsReceived
  checkReloadAndReuse{"reloadReusedPage && !newPageRequested"}
  checkReloadAndReuse -- true, addReadyListener to vm --> addVmReadyListener
  checkReloadAndReuse -- false --> OK

  subgraph addVmReadyListener["VmReady listener"]
    checkVmUrl{"vm.currentUrl == url"}
    sendReloadPage["send Reload(ignoreCache=true)"]
    sendSkipPauses["send SetSkipAllPauses(session.areBreakpointsMuted())"]
    navigateToUrl["WipVmBootstrap(vm).navigate(url!!)"]
    checkVmUrl -- true --> sendReloadPage
    checkVmUrl -- false --> navigateToUrl
  end

  sendReloadPage --> sendSkipPauses
  addVmReadyListener --> OK
  OK([Connected])
  TIMEOUT([Timeout])
```

And finally at `connectToPage` we parse json with debug targets and perform call of `processPageConnections` which selects the appropriate
tab and connects debugger ([connectDebugger](WipRemoteVmConnection.kt) method).

As you can see, dear reader, the connection process is extremely complex, so its code needs to be reworked.
So, here are some plans to get a better code:

- eliminate blocking code, migrate to netty nio
- get rid of promises, rewrite with coroutines to simplify threading and parallel tasks
- some parts are used only in legacy code (for ex. Meteor.js debugger), so we need to get rid of transitively legacy code
- retry/debounce policies should be reviewed because they overlap and conflict on some execution paths.