# CEF offscreen render in notebook outputs

Markdown and HTML outputs, such as advanced interactive charts, are rendered in CEF (Chromium Embedded Framework), built into our JB SDK.

A separate cef_server process is started (can be found in the task manager), which is essentially an invisible browser.
We load HTML and scripts into it, and it gives us an image as a byte buffer, from which we cut out the necessary rectangles and show them in
the editor as block inlays, among the text.

We save memory, so the browser has the size of the editor, which is guaranteed to be enough to display any output in the editor.
There are currently two channels for communicating with the browser

* via a server socket
* via rpc/jni we execute js, and receive callbacks via the CEF API, including the our main callback, “you have received a new image (
  image_bytes)”

All communication takes place in different and unpredictable streams. We cannot influence the signatures of native callbacks, and in the
mentioned “you have received a new image” we receive just a bytebuffer with an image and nothing more.

There are two special moments we need to care about:

1. We scroll the editor and at the same time send the command “scroll” to the browser, and the browser sends us an image in response
2. The JS output on the CEF side starts to change the size, and sends us a command to the socket “my new size is this”, and on the other
   hand, the image is sent through the native callback (all out of sync)

At the same time, various special effects arose that the outputs were drawn in the wrong place because the browser scroll position and the
editor scroll position did not match. There was a mess on the screen, half of one output could be drawn in the cell of another.
The only possible synchronization of two points was made

1. In the image, in one of the pixels, we began to encode scrollPosition. Thus, we could not think about the scroll, but take exactly the
   one with which the output was drawn in CEF and project it onto the laptop.
2. In the same picture, in another pixel, we began to encode the hash of the exact boundaries of the outputs and began to skip the pictures
   that the browser sends, for which the hash of the output boundaries does not match ours in Java (after all, this meant that the browser
   simply did not send us the correct boundaries of the changing outputs yet, and we need to wait for the boundaries to match in the browser
   and in the client)

Here a small peculiarity arose - the pixels in which we encode the hashes and the scroll are noticeable, and therefore I placed them in the
lower right corner, where no one will ever look, and often they are generally outside the screen.
Following this, a peculiarity arose in that on hidpi monitors I incorrectly calculated the positions of the pixels, because these
calculations did not assume non-standard screen scale / hidpi and instead of a special pixel, a regular one was taken.

And now we are in a situation where, despite all the fixes, some users still face the situation that their markdown is not displayed. There
could be several reasons:

1. The person has Ubuntu 24.*, on which AppArmor is enabled, which simply does not allow the process to start
   https://youtrack.jetbrains.com/articles/JBR-A-11
   Here we are powerless, I made a notification for laptops, but it is only for versions 251 and newer
   https://youtrack.jetbrains.com/issue/PY-78058/Jupyter-Notify-user-about-unavailability-of-CEF-because-of-AppArmor
2. The person does not have Ubuntu, but for some reason the antivirus or some software does not allow the CEF process to start
3. The person has a custom JRE without CEF at all, or CEF is disabled in the registry (key ide.browser.jcef.enabled) (the probability of
   this is extremely small)
4. The person has unique monitor parameters (the last user had a resolution 2510x1377 and the scale is still 225% and I still don’t know if
   it was hiDpi or not), and for some reason the control pixels are incorrectly located, although I don’t really understand how this is
   possible.

However, in order to fix the last situation and get rid of all these hiDpi, we are now taking four steps.

1. Place pixels at the very beginning of the byte array and at the very end, so that it is impossible to distort their position with any
   scales and resolutions
2. Cover them with the background color when receiving from CEF, so that there are no artifacts visible to the user in the image
3. Add one-time logging to FUS in case a situation with the impossibility of rendering due to multiple hash mismatches does arise
4. If a situation arises, disable hash checking for the current session (yes, when changing the output size, artifacts in the form of one
   output overlapping another are possible, but at least there will be no gray squares)