"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperationInfo = exports.Operation = void 0;
var react_1 = __importDefault(require("react"));
var Message_1 = require("../Messages/Message");
var Security_1 = require("../Servers/Security");
var components_1 = require("../../components");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var constants_1 = require("../../constants");
var types_1 = require("../../types");
var Operation = function (props) {
    var config = (0, contexts_1.useConfig)();
    var _a = props.type, type = _a === void 0 ? types_1.PayloadType.PUBLISH : _a, operation = props.operation, channelName = props.channelName, channel = props.channel;
    if (!operation || !channel) {
        return null;
    }
    var servers = typeof channel.servers === 'function' && channel.servers();
    var security = typeof operation.security === 'function' && operation.security();
    var parameters = helpers_1.SchemaHelpers.parametersToSchema(channel.parameters());
    return (react_1.default.createElement("div", null,
        react_1.default.createElement("div", { className: "panel-item--center px-8" },
            react_1.default.createElement(exports.OperationInfo, __assign({}, props)),
            servers && servers.length > 0 ? (react_1.default.createElement("div", { className: "mt-2 text-sm" },
                react_1.default.createElement("p", null, "Available only on servers:"),
                react_1.default.createElement("ul", { className: "flex flex-wrap leading-normal" }, servers.map(function (server) { return (react_1.default.createElement("li", { className: "inline-block mt-2 mr-2", key: server },
                    react_1.default.createElement("a", { href: "#".concat(helpers_1.CommonHelpers.getIdentifier('server-' + server, config)), className: "border border-solid border-blue-300 hover:bg-blue-300 hover:text-blue-600 text-blue-500 font-bold no-underline text-xs rounded px-3 py-1 cursor-pointer" },
                        react_1.default.createElement("span", { className: "underline" }, server)))); })))) : null,
            parameters && (react_1.default.createElement("div", { className: "mt-2", id: helpers_1.CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-parameters"), config) },
                react_1.default.createElement(components_1.Schema, { schemaName: "Parameters", schema: parameters, expanded: true }))),
            security && (react_1.default.createElement("div", { className: "mt-2", id: helpers_1.CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-security"), config) },
                react_1.default.createElement(Security_1.Security, { security: security, header: "Additional security requirements" }))),
            channel.hasBindings() && (react_1.default.createElement("div", { className: "mt-2" },
                react_1.default.createElement(components_1.Bindings, { name: "Channel specific information", bindings: channel.bindings() }))),
            react_1.default.createElement(components_1.Extensions, { name: "Channel Extensions", item: channel }),
            operation.hasBindings() && (react_1.default.createElement("div", { className: "mt-2" },
                react_1.default.createElement(components_1.Bindings, { name: "Operation specific information", bindings: operation.bindings() }))),
            react_1.default.createElement(components_1.Extensions, { name: "Operation Extensions", item: operation }),
            operation.hasTags() && (react_1.default.createElement("div", { className: "mt-2" },
                react_1.default.createElement(components_1.Tags, { tags: operation.tags() })))),
        react_1.default.createElement("div", { className: "w-full mt-4", id: helpers_1.CommonHelpers.getIdentifier("operation-".concat(type, "-").concat(channelName, "-message"), config) }, operation.hasMultipleMessages() ? (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement("p", { className: "px-8" },
                "Accepts ",
                react_1.default.createElement("strong", null, "one of"),
                " the following messages:"),
            react_1.default.createElement("ul", null, operation.messages().map(function (msg, idx) { return (react_1.default.createElement("li", { className: "mt-4", key: idx },
                react_1.default.createElement(Message_1.Message, { message: msg, index: idx, showExamples: true }))); })))) : (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement("p", { className: "px-8" }, "Accepts the following message:"),
            react_1.default.createElement("div", { className: "mt-2" },
                react_1.default.createElement(Message_1.Message, { message: operation.message(0), showExamples: true })))))));
};
exports.Operation = Operation;
var OperationInfo = function (_a) {
    var _b = _a.type, type = _b === void 0 ? types_1.PayloadType.PUBLISH : _b, operation = _a.operation, channelName = _a.channelName, channel = _a.channel;
    var config = (0, contexts_1.useConfig)();
    var operationSummary = operation.summary();
    var externalDocs = operation.externalDocs();
    var operationId = operation.id();
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: "mb-4" },
            react_1.default.createElement("h3", null,
                react_1.default.createElement("span", { className: "font-mono border uppercase p-1 rounded mr-2 ".concat(type === types_1.PayloadType.PUBLISH
                        ? 'border-blue-600 text-blue-500'
                        : 'border-green-600 text-green-600'), title: type }, type === types_1.PayloadType.PUBLISH
                    ? config.publishLabel || constants_1.PUBLISH_LABEL_DEFAULT_TEXT
                    : config.subscribeLabel || constants_1.SUBSCRIBE_LABEL_DEFAULT_TEXT),
                ' ',
                react_1.default.createElement("span", { className: "font-mono text-base" }, channelName))),
        channel.hasDescription() && (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement(components_1.Markdown, null, channel.description()))),
        operationSummary && (react_1.default.createElement("p", { className: "text-gray-600 text-sm mt-2" }, operationSummary)),
        operation.hasDescription() && (react_1.default.createElement("div", { className: "mt-2" },
            react_1.default.createElement(components_1.Markdown, null, operation.description()))),
        externalDocs && (react_1.default.createElement("ul", { className: "leading-normal mt-2 mb-4 space-x-2 space-y-2" }, externalDocs && (react_1.default.createElement("li", { className: "inline-block" },
            react_1.default.createElement(components_1.Href, { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 font-bold no-underline text-xs uppercase rounded px-3 py-1", href: externalDocs.url() },
                react_1.default.createElement("span", null, constants_1.EXTERAL_DOCUMENTATION_TEXT)))))),
        operationId && (react_1.default.createElement("div", { className: "border bg-gray-100 rounded px-4 py-2 mt-2" },
            react_1.default.createElement("div", { className: "text-sm text-gray-700" },
                "Operation ID",
                react_1.default.createElement("span", { className: "border text-orange-600 rounded text-xs ml-2 py-0 px-2" }, operationId))))));
};
exports.OperationInfo = OperationInfo;
//# sourceMappingURL=Operation.js.map