// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package omicsiface provides an interface to enable mocking the Amazon Omics service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package omicsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/omics"
)

// OmicsAPI provides an interface to enable mocking the
// omics.Omics service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Omics.
//	func myFunc(svc omicsiface.OmicsAPI) bool {
//	    // Make svc.AbortMultipartReadSetUpload request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := omics.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockOmicsClient struct {
//	    omicsiface.OmicsAPI
//	}
//	func (m *mockOmicsClient) AbortMultipartReadSetUpload(input *omics.AbortMultipartReadSetUploadInput) (*omics.AbortMultipartReadSetUploadOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockOmicsClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type OmicsAPI interface {
	AbortMultipartReadSetUpload(*omics.AbortMultipartReadSetUploadInput) (*omics.AbortMultipartReadSetUploadOutput, error)
	AbortMultipartReadSetUploadWithContext(aws.Context, *omics.AbortMultipartReadSetUploadInput, ...request.Option) (*omics.AbortMultipartReadSetUploadOutput, error)
	AbortMultipartReadSetUploadRequest(*omics.AbortMultipartReadSetUploadInput) (*request.Request, *omics.AbortMultipartReadSetUploadOutput)

	BatchDeleteReadSet(*omics.BatchDeleteReadSetInput) (*omics.BatchDeleteReadSetOutput, error)
	BatchDeleteReadSetWithContext(aws.Context, *omics.BatchDeleteReadSetInput, ...request.Option) (*omics.BatchDeleteReadSetOutput, error)
	BatchDeleteReadSetRequest(*omics.BatchDeleteReadSetInput) (*request.Request, *omics.BatchDeleteReadSetOutput)

	CancelAnnotationImportJob(*omics.CancelAnnotationImportJobInput) (*omics.CancelAnnotationImportJobOutput, error)
	CancelAnnotationImportJobWithContext(aws.Context, *omics.CancelAnnotationImportJobInput, ...request.Option) (*omics.CancelAnnotationImportJobOutput, error)
	CancelAnnotationImportJobRequest(*omics.CancelAnnotationImportJobInput) (*request.Request, *omics.CancelAnnotationImportJobOutput)

	CancelRun(*omics.CancelRunInput) (*omics.CancelRunOutput, error)
	CancelRunWithContext(aws.Context, *omics.CancelRunInput, ...request.Option) (*omics.CancelRunOutput, error)
	CancelRunRequest(*omics.CancelRunInput) (*request.Request, *omics.CancelRunOutput)

	CancelVariantImportJob(*omics.CancelVariantImportJobInput) (*omics.CancelVariantImportJobOutput, error)
	CancelVariantImportJobWithContext(aws.Context, *omics.CancelVariantImportJobInput, ...request.Option) (*omics.CancelVariantImportJobOutput, error)
	CancelVariantImportJobRequest(*omics.CancelVariantImportJobInput) (*request.Request, *omics.CancelVariantImportJobOutput)

	CompleteMultipartReadSetUpload(*omics.CompleteMultipartReadSetUploadInput) (*omics.CompleteMultipartReadSetUploadOutput, error)
	CompleteMultipartReadSetUploadWithContext(aws.Context, *omics.CompleteMultipartReadSetUploadInput, ...request.Option) (*omics.CompleteMultipartReadSetUploadOutput, error)
	CompleteMultipartReadSetUploadRequest(*omics.CompleteMultipartReadSetUploadInput) (*request.Request, *omics.CompleteMultipartReadSetUploadOutput)

	CreateAnnotationStore(*omics.CreateAnnotationStoreInput) (*omics.CreateAnnotationStoreOutput, error)
	CreateAnnotationStoreWithContext(aws.Context, *omics.CreateAnnotationStoreInput, ...request.Option) (*omics.CreateAnnotationStoreOutput, error)
	CreateAnnotationStoreRequest(*omics.CreateAnnotationStoreInput) (*request.Request, *omics.CreateAnnotationStoreOutput)

	CreateMultipartReadSetUpload(*omics.CreateMultipartReadSetUploadInput) (*omics.CreateMultipartReadSetUploadOutput, error)
	CreateMultipartReadSetUploadWithContext(aws.Context, *omics.CreateMultipartReadSetUploadInput, ...request.Option) (*omics.CreateMultipartReadSetUploadOutput, error)
	CreateMultipartReadSetUploadRequest(*omics.CreateMultipartReadSetUploadInput) (*request.Request, *omics.CreateMultipartReadSetUploadOutput)

	CreateReferenceStore(*omics.CreateReferenceStoreInput) (*omics.CreateReferenceStoreOutput, error)
	CreateReferenceStoreWithContext(aws.Context, *omics.CreateReferenceStoreInput, ...request.Option) (*omics.CreateReferenceStoreOutput, error)
	CreateReferenceStoreRequest(*omics.CreateReferenceStoreInput) (*request.Request, *omics.CreateReferenceStoreOutput)

	CreateRunGroup(*omics.CreateRunGroupInput) (*omics.CreateRunGroupOutput, error)
	CreateRunGroupWithContext(aws.Context, *omics.CreateRunGroupInput, ...request.Option) (*omics.CreateRunGroupOutput, error)
	CreateRunGroupRequest(*omics.CreateRunGroupInput) (*request.Request, *omics.CreateRunGroupOutput)

	CreateSequenceStore(*omics.CreateSequenceStoreInput) (*omics.CreateSequenceStoreOutput, error)
	CreateSequenceStoreWithContext(aws.Context, *omics.CreateSequenceStoreInput, ...request.Option) (*omics.CreateSequenceStoreOutput, error)
	CreateSequenceStoreRequest(*omics.CreateSequenceStoreInput) (*request.Request, *omics.CreateSequenceStoreOutput)

	CreateVariantStore(*omics.CreateVariantStoreInput) (*omics.CreateVariantStoreOutput, error)
	CreateVariantStoreWithContext(aws.Context, *omics.CreateVariantStoreInput, ...request.Option) (*omics.CreateVariantStoreOutput, error)
	CreateVariantStoreRequest(*omics.CreateVariantStoreInput) (*request.Request, *omics.CreateVariantStoreOutput)

	CreateWorkflow(*omics.CreateWorkflowInput) (*omics.CreateWorkflowOutput, error)
	CreateWorkflowWithContext(aws.Context, *omics.CreateWorkflowInput, ...request.Option) (*omics.CreateWorkflowOutput, error)
	CreateWorkflowRequest(*omics.CreateWorkflowInput) (*request.Request, *omics.CreateWorkflowOutput)

	DeleteAnnotationStore(*omics.DeleteAnnotationStoreInput) (*omics.DeleteAnnotationStoreOutput, error)
	DeleteAnnotationStoreWithContext(aws.Context, *omics.DeleteAnnotationStoreInput, ...request.Option) (*omics.DeleteAnnotationStoreOutput, error)
	DeleteAnnotationStoreRequest(*omics.DeleteAnnotationStoreInput) (*request.Request, *omics.DeleteAnnotationStoreOutput)

	DeleteReference(*omics.DeleteReferenceInput) (*omics.DeleteReferenceOutput, error)
	DeleteReferenceWithContext(aws.Context, *omics.DeleteReferenceInput, ...request.Option) (*omics.DeleteReferenceOutput, error)
	DeleteReferenceRequest(*omics.DeleteReferenceInput) (*request.Request, *omics.DeleteReferenceOutput)

	DeleteReferenceStore(*omics.DeleteReferenceStoreInput) (*omics.DeleteReferenceStoreOutput, error)
	DeleteReferenceStoreWithContext(aws.Context, *omics.DeleteReferenceStoreInput, ...request.Option) (*omics.DeleteReferenceStoreOutput, error)
	DeleteReferenceStoreRequest(*omics.DeleteReferenceStoreInput) (*request.Request, *omics.DeleteReferenceStoreOutput)

	DeleteRun(*omics.DeleteRunInput) (*omics.DeleteRunOutput, error)
	DeleteRunWithContext(aws.Context, *omics.DeleteRunInput, ...request.Option) (*omics.DeleteRunOutput, error)
	DeleteRunRequest(*omics.DeleteRunInput) (*request.Request, *omics.DeleteRunOutput)

	DeleteRunGroup(*omics.DeleteRunGroupInput) (*omics.DeleteRunGroupOutput, error)
	DeleteRunGroupWithContext(aws.Context, *omics.DeleteRunGroupInput, ...request.Option) (*omics.DeleteRunGroupOutput, error)
	DeleteRunGroupRequest(*omics.DeleteRunGroupInput) (*request.Request, *omics.DeleteRunGroupOutput)

	DeleteSequenceStore(*omics.DeleteSequenceStoreInput) (*omics.DeleteSequenceStoreOutput, error)
	DeleteSequenceStoreWithContext(aws.Context, *omics.DeleteSequenceStoreInput, ...request.Option) (*omics.DeleteSequenceStoreOutput, error)
	DeleteSequenceStoreRequest(*omics.DeleteSequenceStoreInput) (*request.Request, *omics.DeleteSequenceStoreOutput)

	DeleteVariantStore(*omics.DeleteVariantStoreInput) (*omics.DeleteVariantStoreOutput, error)
	DeleteVariantStoreWithContext(aws.Context, *omics.DeleteVariantStoreInput, ...request.Option) (*omics.DeleteVariantStoreOutput, error)
	DeleteVariantStoreRequest(*omics.DeleteVariantStoreInput) (*request.Request, *omics.DeleteVariantStoreOutput)

	DeleteWorkflow(*omics.DeleteWorkflowInput) (*omics.DeleteWorkflowOutput, error)
	DeleteWorkflowWithContext(aws.Context, *omics.DeleteWorkflowInput, ...request.Option) (*omics.DeleteWorkflowOutput, error)
	DeleteWorkflowRequest(*omics.DeleteWorkflowInput) (*request.Request, *omics.DeleteWorkflowOutput)

	GetAnnotationImportJob(*omics.GetAnnotationImportJobInput) (*omics.GetAnnotationImportJobOutput, error)
	GetAnnotationImportJobWithContext(aws.Context, *omics.GetAnnotationImportJobInput, ...request.Option) (*omics.GetAnnotationImportJobOutput, error)
	GetAnnotationImportJobRequest(*omics.GetAnnotationImportJobInput) (*request.Request, *omics.GetAnnotationImportJobOutput)

	GetAnnotationStore(*omics.GetAnnotationStoreInput) (*omics.GetAnnotationStoreOutput, error)
	GetAnnotationStoreWithContext(aws.Context, *omics.GetAnnotationStoreInput, ...request.Option) (*omics.GetAnnotationStoreOutput, error)
	GetAnnotationStoreRequest(*omics.GetAnnotationStoreInput) (*request.Request, *omics.GetAnnotationStoreOutput)

	GetReadSet(*omics.GetReadSetInput) (*omics.GetReadSetOutput, error)
	GetReadSetWithContext(aws.Context, *omics.GetReadSetInput, ...request.Option) (*omics.GetReadSetOutput, error)
	GetReadSetRequest(*omics.GetReadSetInput) (*request.Request, *omics.GetReadSetOutput)

	GetReadSetActivationJob(*omics.GetReadSetActivationJobInput) (*omics.GetReadSetActivationJobOutput, error)
	GetReadSetActivationJobWithContext(aws.Context, *omics.GetReadSetActivationJobInput, ...request.Option) (*omics.GetReadSetActivationJobOutput, error)
	GetReadSetActivationJobRequest(*omics.GetReadSetActivationJobInput) (*request.Request, *omics.GetReadSetActivationJobOutput)

	GetReadSetExportJob(*omics.GetReadSetExportJobInput) (*omics.GetReadSetExportJobOutput, error)
	GetReadSetExportJobWithContext(aws.Context, *omics.GetReadSetExportJobInput, ...request.Option) (*omics.GetReadSetExportJobOutput, error)
	GetReadSetExportJobRequest(*omics.GetReadSetExportJobInput) (*request.Request, *omics.GetReadSetExportJobOutput)

	GetReadSetImportJob(*omics.GetReadSetImportJobInput) (*omics.GetReadSetImportJobOutput, error)
	GetReadSetImportJobWithContext(aws.Context, *omics.GetReadSetImportJobInput, ...request.Option) (*omics.GetReadSetImportJobOutput, error)
	GetReadSetImportJobRequest(*omics.GetReadSetImportJobInput) (*request.Request, *omics.GetReadSetImportJobOutput)

	GetReadSetMetadata(*omics.GetReadSetMetadataInput) (*omics.GetReadSetMetadataOutput, error)
	GetReadSetMetadataWithContext(aws.Context, *omics.GetReadSetMetadataInput, ...request.Option) (*omics.GetReadSetMetadataOutput, error)
	GetReadSetMetadataRequest(*omics.GetReadSetMetadataInput) (*request.Request, *omics.GetReadSetMetadataOutput)

	GetReference(*omics.GetReferenceInput) (*omics.GetReferenceOutput, error)
	GetReferenceWithContext(aws.Context, *omics.GetReferenceInput, ...request.Option) (*omics.GetReferenceOutput, error)
	GetReferenceRequest(*omics.GetReferenceInput) (*request.Request, *omics.GetReferenceOutput)

	GetReferenceImportJob(*omics.GetReferenceImportJobInput) (*omics.GetReferenceImportJobOutput, error)
	GetReferenceImportJobWithContext(aws.Context, *omics.GetReferenceImportJobInput, ...request.Option) (*omics.GetReferenceImportJobOutput, error)
	GetReferenceImportJobRequest(*omics.GetReferenceImportJobInput) (*request.Request, *omics.GetReferenceImportJobOutput)

	GetReferenceMetadata(*omics.GetReferenceMetadataInput) (*omics.GetReferenceMetadataOutput, error)
	GetReferenceMetadataWithContext(aws.Context, *omics.GetReferenceMetadataInput, ...request.Option) (*omics.GetReferenceMetadataOutput, error)
	GetReferenceMetadataRequest(*omics.GetReferenceMetadataInput) (*request.Request, *omics.GetReferenceMetadataOutput)

	GetReferenceStore(*omics.GetReferenceStoreInput) (*omics.GetReferenceStoreOutput, error)
	GetReferenceStoreWithContext(aws.Context, *omics.GetReferenceStoreInput, ...request.Option) (*omics.GetReferenceStoreOutput, error)
	GetReferenceStoreRequest(*omics.GetReferenceStoreInput) (*request.Request, *omics.GetReferenceStoreOutput)

	GetRun(*omics.GetRunInput) (*omics.GetRunOutput, error)
	GetRunWithContext(aws.Context, *omics.GetRunInput, ...request.Option) (*omics.GetRunOutput, error)
	GetRunRequest(*omics.GetRunInput) (*request.Request, *omics.GetRunOutput)

	GetRunGroup(*omics.GetRunGroupInput) (*omics.GetRunGroupOutput, error)
	GetRunGroupWithContext(aws.Context, *omics.GetRunGroupInput, ...request.Option) (*omics.GetRunGroupOutput, error)
	GetRunGroupRequest(*omics.GetRunGroupInput) (*request.Request, *omics.GetRunGroupOutput)

	GetRunTask(*omics.GetRunTaskInput) (*omics.GetRunTaskOutput, error)
	GetRunTaskWithContext(aws.Context, *omics.GetRunTaskInput, ...request.Option) (*omics.GetRunTaskOutput, error)
	GetRunTaskRequest(*omics.GetRunTaskInput) (*request.Request, *omics.GetRunTaskOutput)

	GetSequenceStore(*omics.GetSequenceStoreInput) (*omics.GetSequenceStoreOutput, error)
	GetSequenceStoreWithContext(aws.Context, *omics.GetSequenceStoreInput, ...request.Option) (*omics.GetSequenceStoreOutput, error)
	GetSequenceStoreRequest(*omics.GetSequenceStoreInput) (*request.Request, *omics.GetSequenceStoreOutput)

	GetVariantImportJob(*omics.GetVariantImportJobInput) (*omics.GetVariantImportJobOutput, error)
	GetVariantImportJobWithContext(aws.Context, *omics.GetVariantImportJobInput, ...request.Option) (*omics.GetVariantImportJobOutput, error)
	GetVariantImportJobRequest(*omics.GetVariantImportJobInput) (*request.Request, *omics.GetVariantImportJobOutput)

	GetVariantStore(*omics.GetVariantStoreInput) (*omics.GetVariantStoreOutput, error)
	GetVariantStoreWithContext(aws.Context, *omics.GetVariantStoreInput, ...request.Option) (*omics.GetVariantStoreOutput, error)
	GetVariantStoreRequest(*omics.GetVariantStoreInput) (*request.Request, *omics.GetVariantStoreOutput)

	GetWorkflow(*omics.GetWorkflowInput) (*omics.GetWorkflowOutput, error)
	GetWorkflowWithContext(aws.Context, *omics.GetWorkflowInput, ...request.Option) (*omics.GetWorkflowOutput, error)
	GetWorkflowRequest(*omics.GetWorkflowInput) (*request.Request, *omics.GetWorkflowOutput)

	ListAnnotationImportJobs(*omics.ListAnnotationImportJobsInput) (*omics.ListAnnotationImportJobsOutput, error)
	ListAnnotationImportJobsWithContext(aws.Context, *omics.ListAnnotationImportJobsInput, ...request.Option) (*omics.ListAnnotationImportJobsOutput, error)
	ListAnnotationImportJobsRequest(*omics.ListAnnotationImportJobsInput) (*request.Request, *omics.ListAnnotationImportJobsOutput)

	ListAnnotationImportJobsPages(*omics.ListAnnotationImportJobsInput, func(*omics.ListAnnotationImportJobsOutput, bool) bool) error
	ListAnnotationImportJobsPagesWithContext(aws.Context, *omics.ListAnnotationImportJobsInput, func(*omics.ListAnnotationImportJobsOutput, bool) bool, ...request.Option) error

	ListAnnotationStores(*omics.ListAnnotationStoresInput) (*omics.ListAnnotationStoresOutput, error)
	ListAnnotationStoresWithContext(aws.Context, *omics.ListAnnotationStoresInput, ...request.Option) (*omics.ListAnnotationStoresOutput, error)
	ListAnnotationStoresRequest(*omics.ListAnnotationStoresInput) (*request.Request, *omics.ListAnnotationStoresOutput)

	ListAnnotationStoresPages(*omics.ListAnnotationStoresInput, func(*omics.ListAnnotationStoresOutput, bool) bool) error
	ListAnnotationStoresPagesWithContext(aws.Context, *omics.ListAnnotationStoresInput, func(*omics.ListAnnotationStoresOutput, bool) bool, ...request.Option) error

	ListMultipartReadSetUploads(*omics.ListMultipartReadSetUploadsInput) (*omics.ListMultipartReadSetUploadsOutput, error)
	ListMultipartReadSetUploadsWithContext(aws.Context, *omics.ListMultipartReadSetUploadsInput, ...request.Option) (*omics.ListMultipartReadSetUploadsOutput, error)
	ListMultipartReadSetUploadsRequest(*omics.ListMultipartReadSetUploadsInput) (*request.Request, *omics.ListMultipartReadSetUploadsOutput)

	ListMultipartReadSetUploadsPages(*omics.ListMultipartReadSetUploadsInput, func(*omics.ListMultipartReadSetUploadsOutput, bool) bool) error
	ListMultipartReadSetUploadsPagesWithContext(aws.Context, *omics.ListMultipartReadSetUploadsInput, func(*omics.ListMultipartReadSetUploadsOutput, bool) bool, ...request.Option) error

	ListReadSetActivationJobs(*omics.ListReadSetActivationJobsInput) (*omics.ListReadSetActivationJobsOutput, error)
	ListReadSetActivationJobsWithContext(aws.Context, *omics.ListReadSetActivationJobsInput, ...request.Option) (*omics.ListReadSetActivationJobsOutput, error)
	ListReadSetActivationJobsRequest(*omics.ListReadSetActivationJobsInput) (*request.Request, *omics.ListReadSetActivationJobsOutput)

	ListReadSetActivationJobsPages(*omics.ListReadSetActivationJobsInput, func(*omics.ListReadSetActivationJobsOutput, bool) bool) error
	ListReadSetActivationJobsPagesWithContext(aws.Context, *omics.ListReadSetActivationJobsInput, func(*omics.ListReadSetActivationJobsOutput, bool) bool, ...request.Option) error

	ListReadSetExportJobs(*omics.ListReadSetExportJobsInput) (*omics.ListReadSetExportJobsOutput, error)
	ListReadSetExportJobsWithContext(aws.Context, *omics.ListReadSetExportJobsInput, ...request.Option) (*omics.ListReadSetExportJobsOutput, error)
	ListReadSetExportJobsRequest(*omics.ListReadSetExportJobsInput) (*request.Request, *omics.ListReadSetExportJobsOutput)

	ListReadSetExportJobsPages(*omics.ListReadSetExportJobsInput, func(*omics.ListReadSetExportJobsOutput, bool) bool) error
	ListReadSetExportJobsPagesWithContext(aws.Context, *omics.ListReadSetExportJobsInput, func(*omics.ListReadSetExportJobsOutput, bool) bool, ...request.Option) error

	ListReadSetImportJobs(*omics.ListReadSetImportJobsInput) (*omics.ListReadSetImportJobsOutput, error)
	ListReadSetImportJobsWithContext(aws.Context, *omics.ListReadSetImportJobsInput, ...request.Option) (*omics.ListReadSetImportJobsOutput, error)
	ListReadSetImportJobsRequest(*omics.ListReadSetImportJobsInput) (*request.Request, *omics.ListReadSetImportJobsOutput)

	ListReadSetImportJobsPages(*omics.ListReadSetImportJobsInput, func(*omics.ListReadSetImportJobsOutput, bool) bool) error
	ListReadSetImportJobsPagesWithContext(aws.Context, *omics.ListReadSetImportJobsInput, func(*omics.ListReadSetImportJobsOutput, bool) bool, ...request.Option) error

	ListReadSetUploadParts(*omics.ListReadSetUploadPartsInput) (*omics.ListReadSetUploadPartsOutput, error)
	ListReadSetUploadPartsWithContext(aws.Context, *omics.ListReadSetUploadPartsInput, ...request.Option) (*omics.ListReadSetUploadPartsOutput, error)
	ListReadSetUploadPartsRequest(*omics.ListReadSetUploadPartsInput) (*request.Request, *omics.ListReadSetUploadPartsOutput)

	ListReadSetUploadPartsPages(*omics.ListReadSetUploadPartsInput, func(*omics.ListReadSetUploadPartsOutput, bool) bool) error
	ListReadSetUploadPartsPagesWithContext(aws.Context, *omics.ListReadSetUploadPartsInput, func(*omics.ListReadSetUploadPartsOutput, bool) bool, ...request.Option) error

	ListReadSets(*omics.ListReadSetsInput) (*omics.ListReadSetsOutput, error)
	ListReadSetsWithContext(aws.Context, *omics.ListReadSetsInput, ...request.Option) (*omics.ListReadSetsOutput, error)
	ListReadSetsRequest(*omics.ListReadSetsInput) (*request.Request, *omics.ListReadSetsOutput)

	ListReadSetsPages(*omics.ListReadSetsInput, func(*omics.ListReadSetsOutput, bool) bool) error
	ListReadSetsPagesWithContext(aws.Context, *omics.ListReadSetsInput, func(*omics.ListReadSetsOutput, bool) bool, ...request.Option) error

	ListReferenceImportJobs(*omics.ListReferenceImportJobsInput) (*omics.ListReferenceImportJobsOutput, error)
	ListReferenceImportJobsWithContext(aws.Context, *omics.ListReferenceImportJobsInput, ...request.Option) (*omics.ListReferenceImportJobsOutput, error)
	ListReferenceImportJobsRequest(*omics.ListReferenceImportJobsInput) (*request.Request, *omics.ListReferenceImportJobsOutput)

	ListReferenceImportJobsPages(*omics.ListReferenceImportJobsInput, func(*omics.ListReferenceImportJobsOutput, bool) bool) error
	ListReferenceImportJobsPagesWithContext(aws.Context, *omics.ListReferenceImportJobsInput, func(*omics.ListReferenceImportJobsOutput, bool) bool, ...request.Option) error

	ListReferenceStores(*omics.ListReferenceStoresInput) (*omics.ListReferenceStoresOutput, error)
	ListReferenceStoresWithContext(aws.Context, *omics.ListReferenceStoresInput, ...request.Option) (*omics.ListReferenceStoresOutput, error)
	ListReferenceStoresRequest(*omics.ListReferenceStoresInput) (*request.Request, *omics.ListReferenceStoresOutput)

	ListReferenceStoresPages(*omics.ListReferenceStoresInput, func(*omics.ListReferenceStoresOutput, bool) bool) error
	ListReferenceStoresPagesWithContext(aws.Context, *omics.ListReferenceStoresInput, func(*omics.ListReferenceStoresOutput, bool) bool, ...request.Option) error

	ListReferences(*omics.ListReferencesInput) (*omics.ListReferencesOutput, error)
	ListReferencesWithContext(aws.Context, *omics.ListReferencesInput, ...request.Option) (*omics.ListReferencesOutput, error)
	ListReferencesRequest(*omics.ListReferencesInput) (*request.Request, *omics.ListReferencesOutput)

	ListReferencesPages(*omics.ListReferencesInput, func(*omics.ListReferencesOutput, bool) bool) error
	ListReferencesPagesWithContext(aws.Context, *omics.ListReferencesInput, func(*omics.ListReferencesOutput, bool) bool, ...request.Option) error

	ListRunGroups(*omics.ListRunGroupsInput) (*omics.ListRunGroupsOutput, error)
	ListRunGroupsWithContext(aws.Context, *omics.ListRunGroupsInput, ...request.Option) (*omics.ListRunGroupsOutput, error)
	ListRunGroupsRequest(*omics.ListRunGroupsInput) (*request.Request, *omics.ListRunGroupsOutput)

	ListRunGroupsPages(*omics.ListRunGroupsInput, func(*omics.ListRunGroupsOutput, bool) bool) error
	ListRunGroupsPagesWithContext(aws.Context, *omics.ListRunGroupsInput, func(*omics.ListRunGroupsOutput, bool) bool, ...request.Option) error

	ListRunTasks(*omics.ListRunTasksInput) (*omics.ListRunTasksOutput, error)
	ListRunTasksWithContext(aws.Context, *omics.ListRunTasksInput, ...request.Option) (*omics.ListRunTasksOutput, error)
	ListRunTasksRequest(*omics.ListRunTasksInput) (*request.Request, *omics.ListRunTasksOutput)

	ListRunTasksPages(*omics.ListRunTasksInput, func(*omics.ListRunTasksOutput, bool) bool) error
	ListRunTasksPagesWithContext(aws.Context, *omics.ListRunTasksInput, func(*omics.ListRunTasksOutput, bool) bool, ...request.Option) error

	ListRuns(*omics.ListRunsInput) (*omics.ListRunsOutput, error)
	ListRunsWithContext(aws.Context, *omics.ListRunsInput, ...request.Option) (*omics.ListRunsOutput, error)
	ListRunsRequest(*omics.ListRunsInput) (*request.Request, *omics.ListRunsOutput)

	ListRunsPages(*omics.ListRunsInput, func(*omics.ListRunsOutput, bool) bool) error
	ListRunsPagesWithContext(aws.Context, *omics.ListRunsInput, func(*omics.ListRunsOutput, bool) bool, ...request.Option) error

	ListSequenceStores(*omics.ListSequenceStoresInput) (*omics.ListSequenceStoresOutput, error)
	ListSequenceStoresWithContext(aws.Context, *omics.ListSequenceStoresInput, ...request.Option) (*omics.ListSequenceStoresOutput, error)
	ListSequenceStoresRequest(*omics.ListSequenceStoresInput) (*request.Request, *omics.ListSequenceStoresOutput)

	ListSequenceStoresPages(*omics.ListSequenceStoresInput, func(*omics.ListSequenceStoresOutput, bool) bool) error
	ListSequenceStoresPagesWithContext(aws.Context, *omics.ListSequenceStoresInput, func(*omics.ListSequenceStoresOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*omics.ListTagsForResourceInput) (*omics.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *omics.ListTagsForResourceInput, ...request.Option) (*omics.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*omics.ListTagsForResourceInput) (*request.Request, *omics.ListTagsForResourceOutput)

	ListVariantImportJobs(*omics.ListVariantImportJobsInput) (*omics.ListVariantImportJobsOutput, error)
	ListVariantImportJobsWithContext(aws.Context, *omics.ListVariantImportJobsInput, ...request.Option) (*omics.ListVariantImportJobsOutput, error)
	ListVariantImportJobsRequest(*omics.ListVariantImportJobsInput) (*request.Request, *omics.ListVariantImportJobsOutput)

	ListVariantImportJobsPages(*omics.ListVariantImportJobsInput, func(*omics.ListVariantImportJobsOutput, bool) bool) error
	ListVariantImportJobsPagesWithContext(aws.Context, *omics.ListVariantImportJobsInput, func(*omics.ListVariantImportJobsOutput, bool) bool, ...request.Option) error

	ListVariantStores(*omics.ListVariantStoresInput) (*omics.ListVariantStoresOutput, error)
	ListVariantStoresWithContext(aws.Context, *omics.ListVariantStoresInput, ...request.Option) (*omics.ListVariantStoresOutput, error)
	ListVariantStoresRequest(*omics.ListVariantStoresInput) (*request.Request, *omics.ListVariantStoresOutput)

	ListVariantStoresPages(*omics.ListVariantStoresInput, func(*omics.ListVariantStoresOutput, bool) bool) error
	ListVariantStoresPagesWithContext(aws.Context, *omics.ListVariantStoresInput, func(*omics.ListVariantStoresOutput, bool) bool, ...request.Option) error

	ListWorkflows(*omics.ListWorkflowsInput) (*omics.ListWorkflowsOutput, error)
	ListWorkflowsWithContext(aws.Context, *omics.ListWorkflowsInput, ...request.Option) (*omics.ListWorkflowsOutput, error)
	ListWorkflowsRequest(*omics.ListWorkflowsInput) (*request.Request, *omics.ListWorkflowsOutput)

	ListWorkflowsPages(*omics.ListWorkflowsInput, func(*omics.ListWorkflowsOutput, bool) bool) error
	ListWorkflowsPagesWithContext(aws.Context, *omics.ListWorkflowsInput, func(*omics.ListWorkflowsOutput, bool) bool, ...request.Option) error

	StartAnnotationImportJob(*omics.StartAnnotationImportJobInput) (*omics.StartAnnotationImportJobOutput, error)
	StartAnnotationImportJobWithContext(aws.Context, *omics.StartAnnotationImportJobInput, ...request.Option) (*omics.StartAnnotationImportJobOutput, error)
	StartAnnotationImportJobRequest(*omics.StartAnnotationImportJobInput) (*request.Request, *omics.StartAnnotationImportJobOutput)

	StartReadSetActivationJob(*omics.StartReadSetActivationJobInput) (*omics.StartReadSetActivationJobOutput, error)
	StartReadSetActivationJobWithContext(aws.Context, *omics.StartReadSetActivationJobInput, ...request.Option) (*omics.StartReadSetActivationJobOutput, error)
	StartReadSetActivationJobRequest(*omics.StartReadSetActivationJobInput) (*request.Request, *omics.StartReadSetActivationJobOutput)

	StartReadSetExportJob(*omics.StartReadSetExportJobInput) (*omics.StartReadSetExportJobOutput, error)
	StartReadSetExportJobWithContext(aws.Context, *omics.StartReadSetExportJobInput, ...request.Option) (*omics.StartReadSetExportJobOutput, error)
	StartReadSetExportJobRequest(*omics.StartReadSetExportJobInput) (*request.Request, *omics.StartReadSetExportJobOutput)

	StartReadSetImportJob(*omics.StartReadSetImportJobInput) (*omics.StartReadSetImportJobOutput, error)
	StartReadSetImportJobWithContext(aws.Context, *omics.StartReadSetImportJobInput, ...request.Option) (*omics.StartReadSetImportJobOutput, error)
	StartReadSetImportJobRequest(*omics.StartReadSetImportJobInput) (*request.Request, *omics.StartReadSetImportJobOutput)

	StartReferenceImportJob(*omics.StartReferenceImportJobInput) (*omics.StartReferenceImportJobOutput, error)
	StartReferenceImportJobWithContext(aws.Context, *omics.StartReferenceImportJobInput, ...request.Option) (*omics.StartReferenceImportJobOutput, error)
	StartReferenceImportJobRequest(*omics.StartReferenceImportJobInput) (*request.Request, *omics.StartReferenceImportJobOutput)

	StartRun(*omics.StartRunInput) (*omics.StartRunOutput, error)
	StartRunWithContext(aws.Context, *omics.StartRunInput, ...request.Option) (*omics.StartRunOutput, error)
	StartRunRequest(*omics.StartRunInput) (*request.Request, *omics.StartRunOutput)

	StartVariantImportJob(*omics.StartVariantImportJobInput) (*omics.StartVariantImportJobOutput, error)
	StartVariantImportJobWithContext(aws.Context, *omics.StartVariantImportJobInput, ...request.Option) (*omics.StartVariantImportJobOutput, error)
	StartVariantImportJobRequest(*omics.StartVariantImportJobInput) (*request.Request, *omics.StartVariantImportJobOutput)

	TagResource(*omics.TagResourceInput) (*omics.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *omics.TagResourceInput, ...request.Option) (*omics.TagResourceOutput, error)
	TagResourceRequest(*omics.TagResourceInput) (*request.Request, *omics.TagResourceOutput)

	UntagResource(*omics.UntagResourceInput) (*omics.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *omics.UntagResourceInput, ...request.Option) (*omics.UntagResourceOutput, error)
	UntagResourceRequest(*omics.UntagResourceInput) (*request.Request, *omics.UntagResourceOutput)

	UpdateAnnotationStore(*omics.UpdateAnnotationStoreInput) (*omics.UpdateAnnotationStoreOutput, error)
	UpdateAnnotationStoreWithContext(aws.Context, *omics.UpdateAnnotationStoreInput, ...request.Option) (*omics.UpdateAnnotationStoreOutput, error)
	UpdateAnnotationStoreRequest(*omics.UpdateAnnotationStoreInput) (*request.Request, *omics.UpdateAnnotationStoreOutput)

	UpdateRunGroup(*omics.UpdateRunGroupInput) (*omics.UpdateRunGroupOutput, error)
	UpdateRunGroupWithContext(aws.Context, *omics.UpdateRunGroupInput, ...request.Option) (*omics.UpdateRunGroupOutput, error)
	UpdateRunGroupRequest(*omics.UpdateRunGroupInput) (*request.Request, *omics.UpdateRunGroupOutput)

	UpdateVariantStore(*omics.UpdateVariantStoreInput) (*omics.UpdateVariantStoreOutput, error)
	UpdateVariantStoreWithContext(aws.Context, *omics.UpdateVariantStoreInput, ...request.Option) (*omics.UpdateVariantStoreOutput, error)
	UpdateVariantStoreRequest(*omics.UpdateVariantStoreInput) (*request.Request, *omics.UpdateVariantStoreOutput)

	UpdateWorkflow(*omics.UpdateWorkflowInput) (*omics.UpdateWorkflowOutput, error)
	UpdateWorkflowWithContext(aws.Context, *omics.UpdateWorkflowInput, ...request.Option) (*omics.UpdateWorkflowOutput, error)
	UpdateWorkflowRequest(*omics.UpdateWorkflowInput) (*request.Request, *omics.UpdateWorkflowOutput)

	UploadReadSetPart(*omics.UploadReadSetPartInput) (*omics.UploadReadSetPartOutput, error)
	UploadReadSetPartWithContext(aws.Context, *omics.UploadReadSetPartInput, ...request.Option) (*omics.UploadReadSetPartOutput, error)
	UploadReadSetPartRequest(*omics.UploadReadSetPartInput) (*request.Request, *omics.UploadReadSetPartOutput)

	WaitUntilAnnotationImportJobCreated(*omics.GetAnnotationImportJobInput) error
	WaitUntilAnnotationImportJobCreatedWithContext(aws.Context, *omics.GetAnnotationImportJobInput, ...request.WaiterOption) error

	WaitUntilAnnotationStoreCreated(*omics.GetAnnotationStoreInput) error
	WaitUntilAnnotationStoreCreatedWithContext(aws.Context, *omics.GetAnnotationStoreInput, ...request.WaiterOption) error

	WaitUntilAnnotationStoreDeleted(*omics.GetAnnotationStoreInput) error
	WaitUntilAnnotationStoreDeletedWithContext(aws.Context, *omics.GetAnnotationStoreInput, ...request.WaiterOption) error

	WaitUntilReadSetActivationJobCompleted(*omics.GetReadSetActivationJobInput) error
	WaitUntilReadSetActivationJobCompletedWithContext(aws.Context, *omics.GetReadSetActivationJobInput, ...request.WaiterOption) error

	WaitUntilReadSetExportJobCompleted(*omics.GetReadSetExportJobInput) error
	WaitUntilReadSetExportJobCompletedWithContext(aws.Context, *omics.GetReadSetExportJobInput, ...request.WaiterOption) error

	WaitUntilReadSetImportJobCompleted(*omics.GetReadSetImportJobInput) error
	WaitUntilReadSetImportJobCompletedWithContext(aws.Context, *omics.GetReadSetImportJobInput, ...request.WaiterOption) error

	WaitUntilReferenceImportJobCompleted(*omics.GetReferenceImportJobInput) error
	WaitUntilReferenceImportJobCompletedWithContext(aws.Context, *omics.GetReferenceImportJobInput, ...request.WaiterOption) error

	WaitUntilRunCompleted(*omics.GetRunInput) error
	WaitUntilRunCompletedWithContext(aws.Context, *omics.GetRunInput, ...request.WaiterOption) error

	WaitUntilRunRunning(*omics.GetRunInput) error
	WaitUntilRunRunningWithContext(aws.Context, *omics.GetRunInput, ...request.WaiterOption) error

	WaitUntilTaskCompleted(*omics.GetRunTaskInput) error
	WaitUntilTaskCompletedWithContext(aws.Context, *omics.GetRunTaskInput, ...request.WaiterOption) error

	WaitUntilTaskRunning(*omics.GetRunTaskInput) error
	WaitUntilTaskRunningWithContext(aws.Context, *omics.GetRunTaskInput, ...request.WaiterOption) error

	WaitUntilVariantImportJobCreated(*omics.GetVariantImportJobInput) error
	WaitUntilVariantImportJobCreatedWithContext(aws.Context, *omics.GetVariantImportJobInput, ...request.WaiterOption) error

	WaitUntilVariantStoreCreated(*omics.GetVariantStoreInput) error
	WaitUntilVariantStoreCreatedWithContext(aws.Context, *omics.GetVariantStoreInput, ...request.WaiterOption) error

	WaitUntilVariantStoreDeleted(*omics.GetVariantStoreInput) error
	WaitUntilVariantStoreDeletedWithContext(aws.Context, *omics.GetVariantStoreInput, ...request.WaiterOption) error

	WaitUntilWorkflowActive(*omics.GetWorkflowInput) error
	WaitUntilWorkflowActiveWithContext(aws.Context, *omics.GetWorkflowInput, ...request.WaiterOption) error
}

var _ OmicsAPI = (*omics.Omics)(nil)
