// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package recyclebin

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRule for more information on using the CreateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRuleRequest method.
//	req, resp := client.CreateRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/CreateRule
func (c *RecycleBin) CreateRuleRequest(input *CreateRuleInput) (req *request.Request, output *CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	output = &CreateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRule API operation for Amazon Recycle Bin.
//
// Creates a Recycle Bin retention rule. For more information, see Create Recycle
// Bin retention rules (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-create-rule)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Recycle Bin's
// API operation CreateRule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more of the parameters in the request is not valid.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota for the number of tags per resource
//     to be exceeded.
//
//   - InternalServerException
//     The service could not respond to the request due to an internal problem.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/CreateRule
func (c *RecycleBin) CreateRule(input *CreateRuleInput) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	return out, req.Send()
}

// CreateRuleWithContext is the same as CreateRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) CreateRuleWithContext(ctx aws.Context, input *CreateRuleInput, opts ...request.Option) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRule for more information on using the DeleteRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRuleRequest method.
//	req, resp := client.DeleteRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/DeleteRule
func (c *RecycleBin) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/rules/{identifier}",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	output = &DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRule API operation for Amazon Recycle Bin.
//
// Deletes a Recycle Bin retention rule. For more information, see Delete Recycle
// Bin retention rules (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-delete-rule)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Recycle Bin's
// API operation DeleteRule for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The service could not respond to the request due to an internal problem.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     One or more of the parameters in the request is not valid.
//
//   - ConflictException
//     The specified retention rule lock request can't be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/DeleteRule
func (c *RecycleBin) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) DeleteRuleWithContext(ctx aws.Context, input *DeleteRuleInput, opts ...request.Option) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRule = "GetRule"

// GetRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRule for more information on using the GetRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRuleRequest method.
//	req, resp := client.GetRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/GetRule
func (c *RecycleBin) GetRuleRequest(input *GetRuleInput) (req *request.Request, output *GetRuleOutput) {
	op := &request.Operation{
		Name:       opGetRule,
		HTTPMethod: "GET",
		HTTPPath:   "/rules/{identifier}",
	}

	if input == nil {
		input = &GetRuleInput{}
	}

	output = &GetRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRule API operation for Amazon Recycle Bin.
//
// Gets information about a Recycle Bin retention rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Recycle Bin's
// API operation GetRule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more of the parameters in the request is not valid.
//
//   - InternalServerException
//     The service could not respond to the request due to an internal problem.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/GetRule
func (c *RecycleBin) GetRule(input *GetRuleInput) (*GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	return out, req.Send()
}

// GetRuleWithContext is the same as GetRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) GetRuleWithContext(ctx aws.Context, input *GetRuleInput, opts ...request.Option) (*GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRules for more information on using the ListRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRulesRequest method.
//	req, resp := client.ListRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/ListRules
func (c *RecycleBin) ListRulesRequest(input *ListRulesInput) (req *request.Request, output *ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "POST",
		HTTPPath:   "/list-rules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRulesInput{}
	}

	output = &ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for Amazon Recycle Bin.
//
// Lists the Recycle Bin retention rules in the Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Recycle Bin's
// API operation ListRules for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more of the parameters in the request is not valid.
//
//   - InternalServerException
//     The service could not respond to the request due to an internal problem.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/ListRules
func (c *RecycleBin) ListRules(input *ListRulesInput) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	return out, req.Send()
}

// ListRulesWithContext is the same as ListRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) ListRulesWithContext(ctx aws.Context, input *ListRulesInput, opts ...request.Option) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRulesPages iterates over the pages of a ListRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRules operation.
//	pageNum := 0
//	err := client.ListRulesPages(params,
//	    func(page *recyclebin.ListRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RecycleBin) ListRulesPages(input *ListRulesInput, fn func(*ListRulesOutput, bool) bool) error {
	return c.ListRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRulesPagesWithContext same as ListRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) ListRulesPagesWithContext(ctx aws.Context, input *ListRulesInput, fn func(*ListRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/ListTagsForResource
func (c *RecycleBin) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Recycle Bin.
//
// Lists the tags assigned to a retention rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Recycle Bin's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more of the parameters in the request is not valid.
//
//   - InternalServerException
//     The service could not respond to the request due to an internal problem.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/ListTagsForResource
func (c *RecycleBin) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opLockRule = "LockRule"

// LockRuleRequest generates a "aws/request.Request" representing the
// client's request for the LockRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LockRule for more information on using the LockRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the LockRuleRequest method.
//	req, resp := client.LockRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/LockRule
func (c *RecycleBin) LockRuleRequest(input *LockRuleInput) (req *request.Request, output *LockRuleOutput) {
	op := &request.Operation{
		Name:       opLockRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/rules/{identifier}/lock",
	}

	if input == nil {
		input = &LockRuleInput{}
	}

	output = &LockRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// LockRule API operation for Amazon Recycle Bin.
//
// Locks a retention rule. A locked retention rule can't be modified or deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Recycle Bin's
// API operation LockRule for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The service could not respond to the request due to an internal problem.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     One or more of the parameters in the request is not valid.
//
//   - ConflictException
//     The specified retention rule lock request can't be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/LockRule
func (c *RecycleBin) LockRule(input *LockRuleInput) (*LockRuleOutput, error) {
	req, out := c.LockRuleRequest(input)
	return out, req.Send()
}

// LockRuleWithContext is the same as LockRule with the addition of
// the ability to pass a context and additional request options.
//
// See LockRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) LockRuleWithContext(ctx aws.Context, input *LockRuleInput, opts ...request.Option) (*LockRuleOutput, error) {
	req, out := c.LockRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/TagResource
func (c *RecycleBin) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Recycle Bin.
//
// Assigns tags to the specified retention rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Recycle Bin's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more of the parameters in the request is not valid.
//
//   - InternalServerException
//     The service could not respond to the request due to an internal problem.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ServiceQuotaExceededException
//     The request would cause a service quota for the number of tags per resource
//     to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/TagResource
func (c *RecycleBin) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnlockRule = "UnlockRule"

// UnlockRuleRequest generates a "aws/request.Request" representing the
// client's request for the UnlockRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnlockRule for more information on using the UnlockRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UnlockRuleRequest method.
//	req, resp := client.UnlockRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/UnlockRule
func (c *RecycleBin) UnlockRuleRequest(input *UnlockRuleInput) (req *request.Request, output *UnlockRuleOutput) {
	op := &request.Operation{
		Name:       opUnlockRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/rules/{identifier}/unlock",
	}

	if input == nil {
		input = &UnlockRuleInput{}
	}

	output = &UnlockRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UnlockRule API operation for Amazon Recycle Bin.
//
// Unlocks a retention rule. After a retention rule is unlocked, it can be modified
// or deleted only after the unlock delay period expires.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Recycle Bin's
// API operation UnlockRule for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The service could not respond to the request due to an internal problem.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ValidationException
//     One or more of the parameters in the request is not valid.
//
//   - ConflictException
//     The specified retention rule lock request can't be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/UnlockRule
func (c *RecycleBin) UnlockRule(input *UnlockRuleInput) (*UnlockRuleOutput, error) {
	req, out := c.UnlockRuleRequest(input)
	return out, req.Send()
}

// UnlockRuleWithContext is the same as UnlockRule with the addition of
// the ability to pass a context and additional request options.
//
// See UnlockRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) UnlockRuleWithContext(ctx aws.Context, input *UnlockRuleInput, opts ...request.Option) (*UnlockRuleOutput, error) {
	req, out := c.UnlockRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/UntagResource
func (c *RecycleBin) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Recycle Bin.
//
// Unassigns a tag from a retention rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Recycle Bin's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more of the parameters in the request is not valid.
//
//   - InternalServerException
//     The service could not respond to the request due to an internal problem.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/UntagResource
func (c *RecycleBin) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRule = "UpdateRule"

// UpdateRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRule for more information on using the UpdateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRuleRequest method.
//	req, resp := client.UpdateRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/UpdateRule
func (c *RecycleBin) UpdateRuleRequest(input *UpdateRuleInput) (req *request.Request, output *UpdateRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateRule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/rules/{identifier}",
	}

	if input == nil {
		input = &UpdateRuleInput{}
	}

	output = &UpdateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRule API operation for Amazon Recycle Bin.
//
// Updates an existing Recycle Bin retention rule. You can update a retention
// rule's description, resource tags, and retention period at any time after
// creation. You can't update a retention rule's resource type after creation.
// For more information, see Update Recycle Bin retention rules (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-update-rule)
// in the Amazon Elastic Compute Cloud User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Recycle Bin's
// API operation UpdateRule for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     One or more of the parameters in the request is not valid.
//
//   - InternalServerException
//     The service could not respond to the request due to an internal problem.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ConflictException
//     The specified retention rule lock request can't be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/rbin-2021-06-15/UpdateRule
func (c *RecycleBin) UpdateRule(input *UpdateRuleInput) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	return out, req.Send()
}

// UpdateRuleWithContext is the same as UpdateRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RecycleBin) UpdateRuleWithContext(ctx aws.Context, input *UpdateRuleInput, opts ...request.Option) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The specified retention rule lock request can't be completed.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"ConflictExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// The retention rule description.
	Description *string `type:"string"`

	// Information about the retention rule lock configuration.
	LockConfiguration *LockConfiguration `type:"structure"`

	// Specifies the resource tags to use to identify resources that are to be retained
	// by a tag-level retention rule. For tag-level retention rules, only deleted
	// resources, of the specified resource type, that have one or more of the specified
	// tag key and value pairs are retained. If a resource is deleted, but it does
	// not have any of the specified tag key and value pairs, it is immediately
	// deleted without being retained by the retention rule.
	//
	// You can add the same tag key and value pair to a maximum or five retention
	// rules.
	//
	// To create a Region-level retention rule, omit this parameter. A Region-level
	// retention rule does not have any resource tags specified. It retains all
	// deleted resources of the specified resource type in the Region in which the
	// rule is created, even if the resources are not tagged.
	ResourceTags []*ResourceTag `type:"list"`

	// The resource type to be retained by the retention rule. Currently, only Amazon
	// EBS snapshots and EBS-backed AMIs are supported. To retain snapshots, specify
	// EBS_SNAPSHOT. To retain EBS-backed AMIs, specify EC2_IMAGE.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceType"`

	// Information about the retention period for which the retention rule is to
	// retain resources.
	//
	// RetentionPeriod is a required field
	RetentionPeriod *RetentionPeriod `type:"structure" required:"true"`

	// Information about the tags to assign to the retention rule.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleInput"}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.RetentionPeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriod"))
	}
	if s.LockConfiguration != nil {
		if err := s.LockConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LockConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RetentionPeriod != nil {
		if err := s.RetentionPeriod.Validate(); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateRuleInput) SetDescription(v string) *CreateRuleInput {
	s.Description = &v
	return s
}

// SetLockConfiguration sets the LockConfiguration field's value.
func (s *CreateRuleInput) SetLockConfiguration(v *LockConfiguration) *CreateRuleInput {
	s.LockConfiguration = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *CreateRuleInput) SetResourceTags(v []*ResourceTag) *CreateRuleInput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CreateRuleInput) SetResourceType(v string) *CreateRuleInput {
	s.ResourceType = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CreateRuleInput) SetRetentionPeriod(v *RetentionPeriod) *CreateRuleInput {
	s.RetentionPeriod = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleInput) SetTags(v []*Tag) *CreateRuleInput {
	s.Tags = v
	return s
}

type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The retention rule description.
	Description *string `type:"string"`

	// The unique ID of the retention rule.
	Identifier *string `type:"string"`

	// Information about the retention rule lock configuration.
	LockConfiguration *LockConfiguration `type:"structure"`

	// The lock state for the retention rule.
	//
	//    * locked - The retention rule is locked and can't be modified or deleted.
	//
	//    * pending_unlock - The retention rule has been unlocked but it is still
	//    within the unlock delay period. The retention rule can be modified or
	//    deleted only after the unlock delay period has expired.
	//
	//    * unlocked - The retention rule is unlocked and it can be modified or
	//    deleted by any user with the required permissions.
	//
	//    * null - The retention rule has never been locked. Once a retention rule
	//    has been locked, it can transition between the locked and unlocked states
	//    only; it can never transition back to null.
	LockState *string `type:"string" enum:"LockState"`

	// Information about the resource tags used to identify resources that are retained
	// by the retention rule.
	ResourceTags []*ResourceTag `type:"list"`

	// The resource type retained by the retention rule.
	ResourceType *string `type:"string" enum:"ResourceType"`

	// Information about the retention period for which the retention rule is to
	// retain resources.
	RetentionPeriod *RetentionPeriod `type:"structure"`

	// The state of the retention rule. Only retention rules that are in the available
	// state retain resources.
	Status *string `type:"string" enum:"RuleStatus"`

	// Information about the tags assigned to the retention rule.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateRuleOutput) SetDescription(v string) *CreateRuleOutput {
	s.Description = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *CreateRuleOutput) SetIdentifier(v string) *CreateRuleOutput {
	s.Identifier = &v
	return s
}

// SetLockConfiguration sets the LockConfiguration field's value.
func (s *CreateRuleOutput) SetLockConfiguration(v *LockConfiguration) *CreateRuleOutput {
	s.LockConfiguration = v
	return s
}

// SetLockState sets the LockState field's value.
func (s *CreateRuleOutput) SetLockState(v string) *CreateRuleOutput {
	s.LockState = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *CreateRuleOutput) SetResourceTags(v []*ResourceTag) *CreateRuleOutput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CreateRuleOutput) SetResourceType(v string) *CreateRuleOutput {
	s.ResourceType = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CreateRuleOutput) SetRetentionPeriod(v *RetentionPeriod) *CreateRuleOutput {
	s.RetentionPeriod = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateRuleOutput) SetStatus(v string) *CreateRuleOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleOutput) SetTags(v []*Tag) *CreateRuleOutput {
	s.Tags = v
	return s
}

type DeleteRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the retention rule.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *DeleteRuleInput) SetIdentifier(v string) *DeleteRuleInput {
	s.Identifier = &v
	return s
}

type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

type GetRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the retention rule.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRuleInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetRuleInput) SetIdentifier(v string) *GetRuleInput {
	s.Identifier = &v
	return s
}

type GetRuleOutput struct {
	_ struct{} `type:"structure"`

	// The retention rule description.
	Description *string `type:"string"`

	// The unique ID of the retention rule.
	Identifier *string `type:"string"`

	// Information about the retention rule lock configuration.
	LockConfiguration *LockConfiguration `type:"structure"`

	// The date and time at which the unlock delay is set to expire. Only returned
	// for retention rules that have been unlocked and that are still within the
	// unlock delay period.
	LockEndTime *time.Time `type:"timestamp"`

	// The lock state for the retention rule.
	//
	//    * locked - The retention rule is locked and can't be modified or deleted.
	//
	//    * pending_unlock - The retention rule has been unlocked but it is still
	//    within the unlock delay period. The retention rule can be modified or
	//    deleted only after the unlock delay period has expired.
	//
	//    * unlocked - The retention rule is unlocked and it can be modified or
	//    deleted by any user with the required permissions.
	//
	//    * null - The retention rule has never been locked. Once a retention rule
	//    has been locked, it can transition between the locked and unlocked states
	//    only; it can never transition back to null.
	LockState *string `type:"string" enum:"LockState"`

	// Information about the resource tags used to identify resources that are retained
	// by the retention rule.
	ResourceTags []*ResourceTag `type:"list"`

	// The resource type retained by the retention rule.
	ResourceType *string `type:"string" enum:"ResourceType"`

	// Information about the retention period for which the retention rule is to
	// retain resources.
	RetentionPeriod *RetentionPeriod `type:"structure"`

	// The state of the retention rule. Only retention rules that are in the available
	// state retain resources.
	Status *string `type:"string" enum:"RuleStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRuleOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetRuleOutput) SetDescription(v string) *GetRuleOutput {
	s.Description = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *GetRuleOutput) SetIdentifier(v string) *GetRuleOutput {
	s.Identifier = &v
	return s
}

// SetLockConfiguration sets the LockConfiguration field's value.
func (s *GetRuleOutput) SetLockConfiguration(v *LockConfiguration) *GetRuleOutput {
	s.LockConfiguration = v
	return s
}

// SetLockEndTime sets the LockEndTime field's value.
func (s *GetRuleOutput) SetLockEndTime(v time.Time) *GetRuleOutput {
	s.LockEndTime = &v
	return s
}

// SetLockState sets the LockState field's value.
func (s *GetRuleOutput) SetLockState(v string) *GetRuleOutput {
	s.LockState = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *GetRuleOutput) SetResourceTags(v []*ResourceTag) *GetRuleOutput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetRuleOutput) SetResourceType(v string) *GetRuleOutput {
	s.ResourceType = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *GetRuleOutput) SetRetentionPeriod(v *RetentionPeriod) *GetRuleOutput {
	s.RetentionPeriod = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetRuleOutput) SetStatus(v string) *GetRuleOutput {
	s.Status = &v
	return s
}

// The service could not respond to the request due to an internal problem.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListRulesInput struct {
	_ struct{} `type:"structure"`

	// The lock state of the retention rules to list. Only retention rules with
	// the specified lock state are returned.
	LockState *string `type:"string" enum:"LockState"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// Information about the resource tags used to identify resources that are retained
	// by the retention rule.
	ResourceTags []*ResourceTag `type:"list"`

	// The resource type retained by the retention rule. Only retention rules that
	// retain the specified resource type are listed. Currently, only Amazon EBS
	// snapshots and EBS-backed AMIs are supported. To list retention rules that
	// retain snapshots, specify EBS_SNAPSHOT. To list retention rules that retain
	// EBS-backed AMIs, specify EC2_IMAGE.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLockState sets the LockState field's value.
func (s *ListRulesInput) SetLockState(v string) *ListRulesInput {
	s.LockState = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRulesInput) SetMaxResults(v int64) *ListRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesInput) SetNextToken(v string) *ListRulesInput {
	s.NextToken = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ListRulesInput) SetResourceTags(v []*ResourceTag) *ListRulesInput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListRulesInput) SetResourceType(v string) *ListRulesInput {
	s.ResourceType = &v
	return s
}

type ListRulesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `type:"string"`

	// Information about the retention rules.
	Rules []*RuleSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRulesOutput) SetNextToken(v string) *ListRulesOutput {
	s.NextToken = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ListRulesOutput) SetRules(v []*RuleSummary) *ListRulesOutput {
	s.Rules = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the retention rule.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags assigned to the retention rule.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Information about a retention rule lock configuration.
type LockConfiguration struct {
	_ struct{} `type:"structure"`

	// Information about the retention rule unlock delay.
	//
	// UnlockDelay is a required field
	UnlockDelay *UnlockDelay `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LockConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LockConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LockConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LockConfiguration"}
	if s.UnlockDelay == nil {
		invalidParams.Add(request.NewErrParamRequired("UnlockDelay"))
	}
	if s.UnlockDelay != nil {
		if err := s.UnlockDelay.Validate(); err != nil {
			invalidParams.AddNested("UnlockDelay", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnlockDelay sets the UnlockDelay field's value.
func (s *LockConfiguration) SetUnlockDelay(v *UnlockDelay) *LockConfiguration {
	s.UnlockDelay = v
	return s
}

type LockRuleInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the retention rule.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`

	// Information about the retention rule lock configuration.
	//
	// LockConfiguration is a required field
	LockConfiguration *LockConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LockRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LockRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LockRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LockRuleInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.LockConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("LockConfiguration"))
	}
	if s.LockConfiguration != nil {
		if err := s.LockConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LockConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *LockRuleInput) SetIdentifier(v string) *LockRuleInput {
	s.Identifier = &v
	return s
}

// SetLockConfiguration sets the LockConfiguration field's value.
func (s *LockRuleInput) SetLockConfiguration(v *LockConfiguration) *LockRuleInput {
	s.LockConfiguration = v
	return s
}

type LockRuleOutput struct {
	_ struct{} `type:"structure"`

	// The retention rule description.
	Description *string `type:"string"`

	// The unique ID of the retention rule.
	Identifier *string `type:"string"`

	// Information about the retention rule lock configuration.
	LockConfiguration *LockConfiguration `type:"structure"`

	// The lock state for the retention rule.
	//
	//    * locked - The retention rule is locked and can't be modified or deleted.
	//
	//    * pending_unlock - The retention rule has been unlocked but it is still
	//    within the unlock delay period. The retention rule can be modified or
	//    deleted only after the unlock delay period has expired.
	//
	//    * unlocked - The retention rule is unlocked and it can be modified or
	//    deleted by any user with the required permissions.
	//
	//    * null - The retention rule has never been locked. Once a retention rule
	//    has been locked, it can transition between the locked and unlocked states
	//    only; it can never transition back to null.
	LockState *string `type:"string" enum:"LockState"`

	// Information about the resource tags used to identify resources that are retained
	// by the retention rule.
	ResourceTags []*ResourceTag `type:"list"`

	// The resource type retained by the retention rule.
	ResourceType *string `type:"string" enum:"ResourceType"`

	// Information about the retention period for which the retention rule is to
	// retain resources.
	RetentionPeriod *RetentionPeriod `type:"structure"`

	// The state of the retention rule. Only retention rules that are in the available
	// state retain resources.
	Status *string `type:"string" enum:"RuleStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LockRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LockRuleOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *LockRuleOutput) SetDescription(v string) *LockRuleOutput {
	s.Description = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *LockRuleOutput) SetIdentifier(v string) *LockRuleOutput {
	s.Identifier = &v
	return s
}

// SetLockConfiguration sets the LockConfiguration field's value.
func (s *LockRuleOutput) SetLockConfiguration(v *LockConfiguration) *LockRuleOutput {
	s.LockConfiguration = v
	return s
}

// SetLockState sets the LockState field's value.
func (s *LockRuleOutput) SetLockState(v string) *LockRuleOutput {
	s.LockState = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *LockRuleOutput) SetResourceTags(v []*ResourceTag) *LockRuleOutput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *LockRuleOutput) SetResourceType(v string) *LockRuleOutput {
	s.ResourceType = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *LockRuleOutput) SetRetentionPeriod(v *RetentionPeriod) *LockRuleOutput {
	s.RetentionPeriod = v
	return s
}

// SetStatus sets the Status field's value.
func (s *LockRuleOutput) SetStatus(v string) *LockRuleOutput {
	s.Status = &v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"ResourceNotFoundExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the resource tags used to identify resources that are retained
// by the retention rule.
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// ResourceTagKey is a required field
	ResourceTagKey *string `type:"string" required:"true"`

	// The tag value.
	ResourceTagValue *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceTag"}
	if s.ResourceTagKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceTagKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceTagKey sets the ResourceTagKey field's value.
func (s *ResourceTag) SetResourceTagKey(v string) *ResourceTag {
	s.ResourceTagKey = &v
	return s
}

// SetResourceTagValue sets the ResourceTagValue field's value.
func (s *ResourceTag) SetResourceTagValue(v string) *ResourceTag {
	s.ResourceTagValue = &v
	return s
}

// Information about the retention period for which the retention rule is to
// retain resources.
type RetentionPeriod struct {
	_ struct{} `type:"structure"`

	// The unit of time in which the retention period is measured. Currently, only
	// DAYS is supported.
	//
	// RetentionPeriodUnit is a required field
	RetentionPeriodUnit *string `type:"string" required:"true" enum:"RetentionPeriodUnit"`

	// The period value for which the retention rule is to retain resources. The
	// period is measured using the unit specified for RetentionPeriodUnit.
	//
	// RetentionPeriodValue is a required field
	RetentionPeriodValue *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetentionPeriod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetentionPeriod) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetentionPeriod) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetentionPeriod"}
	if s.RetentionPeriodUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriodUnit"))
	}
	if s.RetentionPeriodValue == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionPeriodValue"))
	}
	if s.RetentionPeriodValue != nil && *s.RetentionPeriodValue < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RetentionPeriodValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionPeriodUnit sets the RetentionPeriodUnit field's value.
func (s *RetentionPeriod) SetRetentionPeriodUnit(v string) *RetentionPeriod {
	s.RetentionPeriodUnit = &v
	return s
}

// SetRetentionPeriodValue sets the RetentionPeriodValue field's value.
func (s *RetentionPeriod) SetRetentionPeriodValue(v int64) *RetentionPeriod {
	s.RetentionPeriodValue = &v
	return s
}

// Information about a Recycle Bin retention rule.
type RuleSummary struct {
	_ struct{} `type:"structure"`

	// The retention rule description.
	Description *string `type:"string"`

	// The unique ID of the retention rule.
	Identifier *string `type:"string"`

	// The lock state for the retention rule.
	//
	//    * locked - The retention rule is locked and can't be modified or deleted.
	//
	//    * pending_unlock - The retention rule has been unlocked but it is still
	//    within the unlock delay period. The retention rule can be modified or
	//    deleted only after the unlock delay period has expired.
	//
	//    * unlocked - The retention rule is unlocked and it can be modified or
	//    deleted by any user with the required permissions.
	//
	//    * null - The retention rule has never been locked. Once a retention rule
	//    has been locked, it can transition between the locked and unlocked states
	//    only; it can never transition back to null.
	LockState *string `type:"string" enum:"LockState"`

	// Information about the retention period for which the retention rule is to
	// retain resources.
	RetentionPeriod *RetentionPeriod `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *RuleSummary) SetDescription(v string) *RuleSummary {
	s.Description = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *RuleSummary) SetIdentifier(v string) *RuleSummary {
	s.Identifier = &v
	return s
}

// SetLockState sets the LockState field's value.
func (s *RuleSummary) SetLockState(v string) *RuleSummary {
	s.LockState = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *RuleSummary) SetRetentionPeriod(v *RetentionPeriod) *RuleSummary {
	s.RetentionPeriod = v
	return s
}

// The request would cause a service quota for the number of tags per resource
// to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"ServiceQuotaExceededExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about the tags to assign to the retention rule.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The tag value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the retention rule.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Information about the tags to assign to the retention rule.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Information about the retention rule unlock delay. The unlock delay is the
// period after which a retention rule can be modified or edited after it has
// been unlocked by a user with the required permissions. The retention rule
// can't be modified or deleted during the unlock delay.
type UnlockDelay struct {
	_ struct{} `type:"structure"`

	// The unit of time in which to measure the unlock delay. Currently, the unlock
	// delay can be measure only in days.
	//
	// UnlockDelayUnit is a required field
	UnlockDelayUnit *string `type:"string" required:"true" enum:"UnlockDelayUnit"`

	// The unlock delay period, measured in the unit specified for UnlockDelayUnit.
	//
	// UnlockDelayValue is a required field
	UnlockDelayValue *int64 `min:"7" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnlockDelay) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnlockDelay) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnlockDelay) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnlockDelay"}
	if s.UnlockDelayUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("UnlockDelayUnit"))
	}
	if s.UnlockDelayValue == nil {
		invalidParams.Add(request.NewErrParamRequired("UnlockDelayValue"))
	}
	if s.UnlockDelayValue != nil && *s.UnlockDelayValue < 7 {
		invalidParams.Add(request.NewErrParamMinValue("UnlockDelayValue", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnlockDelayUnit sets the UnlockDelayUnit field's value.
func (s *UnlockDelay) SetUnlockDelayUnit(v string) *UnlockDelay {
	s.UnlockDelayUnit = &v
	return s
}

// SetUnlockDelayValue sets the UnlockDelayValue field's value.
func (s *UnlockDelay) SetUnlockDelayValue(v int64) *UnlockDelay {
	s.UnlockDelayValue = &v
	return s
}

type UnlockRuleInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the retention rule.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnlockRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnlockRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnlockRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnlockRuleInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *UnlockRuleInput) SetIdentifier(v string) *UnlockRuleInput {
	s.Identifier = &v
	return s
}

type UnlockRuleOutput struct {
	_ struct{} `type:"structure"`

	// The retention rule description.
	Description *string `type:"string"`

	// The unique ID of the retention rule.
	Identifier *string `type:"string"`

	// Information about the retention rule lock configuration.
	LockConfiguration *LockConfiguration `type:"structure"`

	// The date and time at which the unlock delay is set to expire. Only returned
	// for retention rules that have been unlocked and that are still within the
	// unlock delay period.
	LockEndTime *time.Time `type:"timestamp"`

	// The lock state for the retention rule.
	//
	//    * locked - The retention rule is locked and can't be modified or deleted.
	//
	//    * pending_unlock - The retention rule has been unlocked but it is still
	//    within the unlock delay period. The retention rule can be modified or
	//    deleted only after the unlock delay period has expired.
	//
	//    * unlocked - The retention rule is unlocked and it can be modified or
	//    deleted by any user with the required permissions.
	//
	//    * null - The retention rule has never been locked. Once a retention rule
	//    has been locked, it can transition between the locked and unlocked states
	//    only; it can never transition back to null.
	LockState *string `type:"string" enum:"LockState"`

	// Information about the resource tags used to identify resources that are retained
	// by the retention rule.
	ResourceTags []*ResourceTag `type:"list"`

	// The resource type retained by the retention rule.
	ResourceType *string `type:"string" enum:"ResourceType"`

	// Information about the retention period for which the retention rule is to
	// retain resources.
	RetentionPeriod *RetentionPeriod `type:"structure"`

	// The state of the retention rule. Only retention rules that are in the available
	// state retain resources.
	Status *string `type:"string" enum:"RuleStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnlockRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnlockRuleOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UnlockRuleOutput) SetDescription(v string) *UnlockRuleOutput {
	s.Description = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *UnlockRuleOutput) SetIdentifier(v string) *UnlockRuleOutput {
	s.Identifier = &v
	return s
}

// SetLockConfiguration sets the LockConfiguration field's value.
func (s *UnlockRuleOutput) SetLockConfiguration(v *LockConfiguration) *UnlockRuleOutput {
	s.LockConfiguration = v
	return s
}

// SetLockEndTime sets the LockEndTime field's value.
func (s *UnlockRuleOutput) SetLockEndTime(v time.Time) *UnlockRuleOutput {
	s.LockEndTime = &v
	return s
}

// SetLockState sets the LockState field's value.
func (s *UnlockRuleOutput) SetLockState(v string) *UnlockRuleOutput {
	s.LockState = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *UnlockRuleOutput) SetResourceTags(v []*ResourceTag) *UnlockRuleOutput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *UnlockRuleOutput) SetResourceType(v string) *UnlockRuleOutput {
	s.ResourceType = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *UnlockRuleOutput) SetRetentionPeriod(v *RetentionPeriod) *UnlockRuleOutput {
	s.RetentionPeriod = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UnlockRuleOutput) SetStatus(v string) *UnlockRuleOutput {
	s.Status = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the retention rule.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tag keys of the tags to unassign. All tags that have the specified tag
	// key are unassigned.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateRuleInput struct {
	_ struct{} `type:"structure"`

	// The retention rule description.
	Description *string `type:"string"`

	// The unique ID of the retention rule.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"identifier" type:"string" required:"true"`

	// Specifies the resource tags to use to identify resources that are to be retained
	// by a tag-level retention rule. For tag-level retention rules, only deleted
	// resources, of the specified resource type, that have one or more of the specified
	// tag key and value pairs are retained. If a resource is deleted, but it does
	// not have any of the specified tag key and value pairs, it is immediately
	// deleted without being retained by the retention rule.
	//
	// You can add the same tag key and value pair to a maximum or five retention
	// rules.
	//
	// To create a Region-level retention rule, omit this parameter. A Region-level
	// retention rule does not have any resource tags specified. It retains all
	// deleted resources of the specified resource type in the Region in which the
	// rule is created, even if the resources are not tagged.
	ResourceTags []*ResourceTag `type:"list"`

	//
	// This parameter is currently not supported. You can't update a retention rule's
	// resource type after creation.
	ResourceType *string `type:"string" enum:"ResourceType"`

	// Information about the retention period for which the retention rule is to
	// retain resources.
	RetentionPeriod *RetentionPeriod `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RetentionPeriod != nil {
		if err := s.RetentionPeriod.Validate(); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleInput) SetDescription(v string) *UpdateRuleInput {
	s.Description = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *UpdateRuleInput) SetIdentifier(v string) *UpdateRuleInput {
	s.Identifier = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *UpdateRuleInput) SetResourceTags(v []*ResourceTag) *UpdateRuleInput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *UpdateRuleInput) SetResourceType(v string) *UpdateRuleInput {
	s.ResourceType = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *UpdateRuleInput) SetRetentionPeriod(v *RetentionPeriod) *UpdateRuleInput {
	s.RetentionPeriod = v
	return s
}

type UpdateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The retention rule description.
	Description *string `type:"string"`

	// The unique ID of the retention rule.
	Identifier *string `type:"string"`

	// The date and time at which the unlock delay is set to expire. Only returned
	// for retention rules that have been unlocked and that are still within the
	// unlock delay period.
	LockEndTime *time.Time `type:"timestamp"`

	// The lock state for the retention rule.
	//
	//    * locked - The retention rule is locked and can't be modified or deleted.
	//
	//    * pending_unlock - The retention rule has been unlocked but it is still
	//    within the unlock delay period. The retention rule can be modified or
	//    deleted only after the unlock delay period has expired.
	//
	//    * unlocked - The retention rule is unlocked and it can be modified or
	//    deleted by any user with the required permissions.
	//
	//    * null - The retention rule has never been locked. Once a retention rule
	//    has been locked, it can transition between the locked and unlocked states
	//    only; it can never transition back to null.
	LockState *string `type:"string" enum:"LockState"`

	// Information about the resource tags used to identify resources that are retained
	// by the retention rule.
	ResourceTags []*ResourceTag `type:"list"`

	// The resource type retained by the retention rule.
	ResourceType *string `type:"string" enum:"ResourceType"`

	// Information about the retention period for which the retention rule is to
	// retain resources.
	RetentionPeriod *RetentionPeriod `type:"structure"`

	// The state of the retention rule. Only retention rules that are in the available
	// state retain resources.
	Status *string `type:"string" enum:"RuleStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRuleOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleOutput) SetDescription(v string) *UpdateRuleOutput {
	s.Description = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *UpdateRuleOutput) SetIdentifier(v string) *UpdateRuleOutput {
	s.Identifier = &v
	return s
}

// SetLockEndTime sets the LockEndTime field's value.
func (s *UpdateRuleOutput) SetLockEndTime(v time.Time) *UpdateRuleOutput {
	s.LockEndTime = &v
	return s
}

// SetLockState sets the LockState field's value.
func (s *UpdateRuleOutput) SetLockState(v string) *UpdateRuleOutput {
	s.LockState = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *UpdateRuleOutput) SetResourceTags(v []*ResourceTag) *UpdateRuleOutput {
	s.ResourceTags = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *UpdateRuleOutput) SetResourceType(v string) *UpdateRuleOutput {
	s.ResourceType = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *UpdateRuleOutput) SetRetentionPeriod(v *RetentionPeriod) *UpdateRuleOutput {
	s.RetentionPeriod = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateRuleOutput) SetStatus(v string) *UpdateRuleOutput {
	s.Status = &v
	return s
}

// One or more of the parameters in the request is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ConflictExceptionReasonInvalidRuleState is a ConflictExceptionReason enum value
	ConflictExceptionReasonInvalidRuleState = "INVALID_RULE_STATE"
)

// ConflictExceptionReason_Values returns all elements of the ConflictExceptionReason enum
func ConflictExceptionReason_Values() []string {
	return []string{
		ConflictExceptionReasonInvalidRuleState,
	}
}

const (
	// LockStateLocked is a LockState enum value
	LockStateLocked = "locked"

	// LockStatePendingUnlock is a LockState enum value
	LockStatePendingUnlock = "pending_unlock"

	// LockStateUnlocked is a LockState enum value
	LockStateUnlocked = "unlocked"
)

// LockState_Values returns all elements of the LockState enum
func LockState_Values() []string {
	return []string{
		LockStateLocked,
		LockStatePendingUnlock,
		LockStateUnlocked,
	}
}

const (
	// ResourceNotFoundExceptionReasonRuleNotFound is a ResourceNotFoundExceptionReason enum value
	ResourceNotFoundExceptionReasonRuleNotFound = "RULE_NOT_FOUND"
)

// ResourceNotFoundExceptionReason_Values returns all elements of the ResourceNotFoundExceptionReason enum
func ResourceNotFoundExceptionReason_Values() []string {
	return []string{
		ResourceNotFoundExceptionReasonRuleNotFound,
	}
}

const (
	// ResourceTypeEbsSnapshot is a ResourceType enum value
	ResourceTypeEbsSnapshot = "EBS_SNAPSHOT"

	// ResourceTypeEc2Image is a ResourceType enum value
	ResourceTypeEc2Image = "EC2_IMAGE"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeEbsSnapshot,
		ResourceTypeEc2Image,
	}
}

const (
	// RetentionPeriodUnitDays is a RetentionPeriodUnit enum value
	RetentionPeriodUnitDays = "DAYS"
)

// RetentionPeriodUnit_Values returns all elements of the RetentionPeriodUnit enum
func RetentionPeriodUnit_Values() []string {
	return []string{
		RetentionPeriodUnitDays,
	}
}

const (
	// RuleStatusPending is a RuleStatus enum value
	RuleStatusPending = "pending"

	// RuleStatusAvailable is a RuleStatus enum value
	RuleStatusAvailable = "available"
)

// RuleStatus_Values returns all elements of the RuleStatus enum
func RuleStatus_Values() []string {
	return []string{
		RuleStatusPending,
		RuleStatusAvailable,
	}
}

const (
	// ServiceQuotaExceededExceptionReasonServiceQuotaExceeded is a ServiceQuotaExceededExceptionReason enum value
	ServiceQuotaExceededExceptionReasonServiceQuotaExceeded = "SERVICE_QUOTA_EXCEEDED"
)

// ServiceQuotaExceededExceptionReason_Values returns all elements of the ServiceQuotaExceededExceptionReason enum
func ServiceQuotaExceededExceptionReason_Values() []string {
	return []string{
		ServiceQuotaExceededExceptionReasonServiceQuotaExceeded,
	}
}

const (
	// UnlockDelayUnitDays is a UnlockDelayUnit enum value
	UnlockDelayUnitDays = "DAYS"
)

// UnlockDelayUnit_Values returns all elements of the UnlockDelayUnit enum
func UnlockDelayUnit_Values() []string {
	return []string{
		UnlockDelayUnitDays,
	}
}

const (
	// ValidationExceptionReasonInvalidPageToken is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidPageToken = "INVALID_PAGE_TOKEN"

	// ValidationExceptionReasonInvalidParameterValue is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidParameterValue = "INVALID_PARAMETER_VALUE"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonInvalidPageToken,
		ValidationExceptionReasonInvalidParameterValue,
	}
}
