/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MT_NCURSES_CLIENT_INTERFACE_H
#define MT_NCURSES_CLIENT_INTERFACE_H

#include <curses.h>

#define NCURSES_PAUSE_TIME   2

extern void init_screen (void);
extern void close_screen (int sig);

extern void cls (void);
extern void set_color (int color);
extern void cls_line (int line);

extern void mvaddstr_center (int line, char *st);
extern void mvaddstr_vertcenter (int col, char *st);

extern void wait_key_press (char ch, char *msg);


#endif /* MT_NCURSES_CLIENT_INTERFACE_H */
