/*
   bogosort - sorts or doesn't sort files or its standard input

   Copyright (C) 2000, 2001, 2002 Ulrik Haugen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <sys/types.h>
#include "system.h"

#if HAVE_GETOPT_H
# include <getopt.h>
#else
# include "getopt.h"
#endif /* HAVE_GETOPT_H */

#include <stdio.h>
#include "getlines.h"
#include "sortedp.h"

char *xmalloc();
char *xrealloc();
char *xstrdup();

/* The name the program was run with, stripped of any leading path. */
char *program_name;

int
main(int argc, char **argv)
{
    char **lines = NULL;
    int numlines = 0;
    char *temp = NULL;
    char *iname = NULL;
    FILE *ifile = NULL;

    temp = program_name = argv[0];	/* The name the program was run with */
    while (*temp != '\0')		/* stripped of any leading path.     */
	if (*(temp++) == '/')
	    program_name = temp;
    /* get input file */
    if (argc != 2) {
	fprintf(stderr, "%s, usage: %s filename\n", program_name, program_name);
	exit(EXIT_FAILURE);
    }

    iname = argv[1];
    ifile = fopen(iname, "r");
    if (!ifile) {
	fprintf(stderr, "%s cannot open %s for reading\n", program_name, iname);
	exit(EXIT_FAILURE);
    }

    lines = getlines(ifile);

    for (numlines = 0; lines[numlines] != NULL; numlines++) ;

    if (sortedp(lines))
	return EXIT_SUCCESS;
    return EXIT_FAILURE;
}

