dnl acinclude.m4 -- various bits of this have been borrowed from the m4
dnl configuration files for KDE and GNOME

AC_DEFUN([AC_CHECK_COMPILERS],
[
  AC_ARG_ENABLE(debug,[  --enable-debug 	  creates debugging code [default=no]],
  [ 
   if test $enableval = "no"; dnl 
     then ac_use_debug_code="no"
     else ac_use_debug_code="yes"
   fi
  ], [ac_use_debug_code="no"])

  dnl Just for configure --help

  dnl this prevents stupid AC_PROG_CC from adding "-g" to the default CFLAGS
  c_flags_in=$CFLAGS

  AC_PROG_CC
  AC_PROG_CPP

  CFLAGS=$c_flags_in

  if test -z "$CFLAGS"; then 
    if test "$GCC" = "yes"; then
      if test "$ac_use_debug_code" = "yes"; then
        CFLAGS="-g $CFLAGS"
      else
        CFLAGS="-O2 $CFLAGS"
      fi
    else 
      if test "$ac_use_debug_code" = "yes"; then
        AC_CHECK_C_COMPILER_FLAG(g,
          [
            CFLAGS="-g $CFLAGS"
        ])
      else 
        AC_CHECK_C_COMPILER_FLAG(O2,
          [
            CFLAGS="-O2 $CFLAGS"
        ])
      fi
    fi
    AC_CHECK_C_COMPILER_FLAG(pthread,
      [
        CFLAGS="$CFLAGS -pthread"
    ])
    AC_CHECK_C_COMPILER_FLAG(Wno-deprecated-declarations,
      [
        CFLAGS="$CFLAGS -Wno-deprecated-declarations"
    ])
    if test "$GCC" = "yes"; then
       CFLAGS="$CFLAGS -Wall"
    fi
  fi

  dnl this prevents stupid AC_PROG_CXX from adding "-g" to the default CXXFLAGS
  cxx_flags_in=$CXXFLAGS

  AC_PROG_CXX
  AC_PROG_CXXCPP

  CXXFLAGS=$cxx_flags_in

  if test -z "$CXXFLAGS"; then 
    if test "$GXX" = "yes"; then
      if test "$ac_use_debug_code" = "yes"; then
        CXXFLAGS="-g $CXXFLAGS"
      else
        CXXFLAGS="-O2 $CXXFLAGS"
        if test -z "$LDFLAGS"; then 
          LDFLAGS="-s"
        fi
      fi
    else 
      if test "$ac_use_debug_code" = "yes"; then
        AC_CHECK_COMPILER_FLAG(g,
          [
            CXXFLAGS="-g $CXXFLAGS"
        ])
      else 
        AC_CHECK_COMPILER_FLAG(O2,
          [
            CXXFLAGS="-O2 $CXXFLAGS"
        ])
      fi
    fi

    AC_CHECK_COMPILER_FLAG(fexceptions,
      [
        CXXFLAGS="$CXXFLAGS -fexceptions"
    ])

    AC_CHECK_COMPILER_FLAG(frtti,
      [
        CXXFLAGS="$CXXFLAGS -frtti"
    ])

    AC_CHECK_COMPILER_FLAG(fsigned-char,
      [
        CXXFLAGS="$CXXFLAGS -fsigned-char"
    ])

    AC_CHECK_COMPILER_FLAG(fno-check-new,
      [
        CXXFLAGS="$CXXFLAGS -fno-check-new"
    ])

    AC_CHECK_COMPILER_FLAG(Wno-deprecated,
      [
        CXXFLAGS="$CXXFLAGS -Wno-deprecated"
    ])

    AC_CHECK_COMPILER_FLAG(Wno-deprecated-declarations,
      [
        CXXFLAGS="$CXXFLAGS -Wno-deprecated-declarations"
    ])

    AC_CHECK_COMPILER_FLAG(pthread,
      [
        CXXFLAGS="$CXXFLAGS -pthread"
    ])

    AC_CHECK_COMPILER_FLAG(std=c++11,
    [
      CXXFLAGS="$CXXFLAGS -std=c++11"
    ],
    [
      AC_CHECK_COMPILER_FLAG(std=c++0x,
      [
        CXXFLAGS="$CXXFLAGS -std=c++0x"
      ])
    ])

    if test "$GXX" = "yes"; then
       CXXFLAGS="$CXXFLAGS -Wall"
    fi
  fi  
])

AC_DEFUN([AC_CHECK_COMPILER_FLAG],
[
AC_MSG_CHECKING(whether $CXX supports -$1)
flag_cache=`echo $1 | sed 'y%.=/+-%___p_%'`
AC_CACHE_VAL(ac_cv_prog_cxx_$flag_cache,
[
echo 'int main() { return 0; }' >conftest.cc
eval "ac_cv_prog_cxx_$flag_cache=no"
if test -z "`$CXX -$1 -c conftest.cc 2>&1`"; then
  if test -z "`$CXX -$1 -o conftest conftest.o 2>&1`"; then
    eval "ac_cv_prog_cxx_$flag_cache=yes"
  fi
fi
rm -f conftest*
])
if eval "test \"`echo '$ac_cv_prog_cxx_'$flag_cache`\" = yes"; then
 AC_MSG_RESULT(yes)
 :
 $2
else
 AC_MSG_RESULT(no)
 :
 $3
fi
])

AC_DEFUN([AC_CHECK_C_COMPILER_FLAG],
[
AC_MSG_CHECKING(whether $CC supports -$1)
flag_cache=`echo $1 | sed 'y%.=/+-%___p_%'`
AC_CACHE_VAL(ac_cv_prog_c_$flag_cache,
[
echo 'int main(void) { return 0; }' >conftest.c
eval "ac_cv_prog_c_$flag_cache=no"
if test -z "`$CC -$1 -c conftest.c 2>&1`"; then
  if test -z "`$CC -$1 -o conftest conftest.o 2>&1`"; then
    eval "ac_cv_prog_c_$flag_cache=yes"
  fi
fi
rm -f conftest*
])
if eval "test \"`echo '$ac_cv_prog_c_'$flag_cache`\" = yes"; then
 AC_MSG_RESULT(yes)
 :
 $2
else
 AC_MSG_RESULT(no)
 :
 $3
fi
])

AC_DEFUN([AC_CLOSING_MESSAGE],
[
echo
echo "    Configuration complete."
echo
echo "    To compile, enter \`make', and then enter \`make install'"
echo "      -- \`make install' must be run as root."
echo
echo "    To reconfigure, enter \`make clean' and then run \`./configure' again."
echo
])

dnl PKG_CHECK_MODULES(GSTUFF, gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
dnl defines GSTUFF_LIBS, GSTUFF_CFLAGS, see pkg-config man page
dnl also defines GSTUFF_PKG_ERRORS on error
AC_DEFUN([PKG_CHECK_MODULES], [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(for $2)

        if $PKG_CONFIG --exists "$2" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes

            AC_MSG_CHECKING($1_CFLAGS)
            $1_CFLAGS=`$PKG_CONFIG --cflags "$2"`
            AC_MSG_RESULT($$1_CFLAGS)

            AC_MSG_CHECKING($1_LIBS)
            $1_LIBS=`$PKG_CONFIG --libs "$2"`
            AC_MSG_RESULT($$1_LIBS)
        else
            $1_CFLAGS=""
            $1_LIBS=""
            AC_MSG_RESULT([no])
        fi

        AC_SUBST($1_CFLAGS)
        AC_SUBST($1_LIBS)
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$3], , :, [$3])
  else
     ifelse([$4], , AC_MSG_ERROR([Library requirements ($2) not met; consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a nonstandard prefix so pkg-config can find them.]), [$4])
  fi
])

dnl PKG_CHECK_VERSION does the same as PKG_CHECK_MODULES except
dnl that it does not set *_CFLAGS and *_LIBS variables
dnl PKG_CHECK_VERSION(gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
AC_DEFUN([PKG_CHECK_VERSION], [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(for $1)

        if $PKG_CONFIG --exists "$1" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes
        else
            AC_MSG_RESULT([no])
        fi
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$2], , :, [$2])
  else
     ifelse([$3], , AC_MSG_ERROR([Library requirements ($1) not met; consider adjusting the PKG_CONFIG_PATH environment variable if 
your libraries are in a nonstandard prefix so pkg-config can find them.]), [$3])
  fi
])

AC_DEFUN([AC_CHECK_LIBNOTIFY],
[
  PKG_CHECK_MODULES(LIBNOTIFY, libnotify >= 0.7.1,
  [
    AC_DEFINE([HAVE_LIBNOTIFY], [1], [Define to 1 if you have libnotify.])	
  ],
  [:])
])

AC_DEFUN([AC_CHECK_GTK_VERSION],
[
  AC_MSG_CHECKING(which version of gtk+ to compile against)

  AC_ARG_WITH(gtk-version,
  [  --with-gtk-version      whether to use gtk2 or gtk3 [(gtk3, gtk2, auto)] [[default=auto]]],
  [
    if test "x$withval" = "xgtk2" || test "x$withval" = "xgtk+2";  then
      AC_MSG_RESULT([gtk2])
      PKG_CHECK_MODULES(GTK, gtk+-2.0 >= 2.12.0)
      AC_CHECK_CXX_GTK_UTILS_GTK2(
      [:],
      [
        AC_MSG_ERROR([GTK+2 chosen: c++-gtk-utils >= 2.0.9 or c++-gtk-utils-2.2 >= 2.1.0 must be installed 
and compiled against GTK+2; consider adjusting the PKG_CONFIG_PATH environment variable if your 
libraries are in a nonstandard prefix so pkg-config can find them])
      ])
    elif test "x$withval" = "xgtk3" || test "x$withval" = "xgtk+3";  then
      AC_MSG_RESULT([gtk3])
      PKG_CHECK_MODULES(GTK, gtk+-3.0 >= 2.99.0)
      AC_CHECK_CXX_GTK_UTILS_GTK3(
      [:],
      [
        AC_MSG_ERROR([GTK+3 chosen: c++-gtk-utils >= 2.0.9 or c++-gtk-utils-2.2 >= 2.1.0 must be installed 
and compiled against GTK+3; consider adjusting the PKG_CONFIG_PATH environment variable if your 
libraries are in a nonstandard prefix so pkg-config can find them])
      ])
    elif test "x$withval" = "xauto";  then
      AC_MSG_RESULT([auto])
      AC_CHECK_CXX_GTK_UTILS_GTK3(
      [
        PKG_CHECK_MODULES(GTK, gtk+-3.0 >= 2.99.0)
      ],
      [
        AC_CHECK_CXX_GTK_UTILS_GTK2(
        [
          PKG_CHECK_MODULES(GTK, gtk+-2.0 >= 2.12.0)
	],
	[
          AC_MSG_ERROR([c++-gtk-utils >= 2.0.9 or c++-gtk-utils-2.2 >= 2.1.0 must be installed;
consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a 
nonstandard prefix so pkg-config can find them])
	])
      ])
    else
      AC_MSG_ERROR([incorrect gtk+ version specified - should be gtk2, gtk3 or auto])
    fi
  ],
  [
    AC_MSG_RESULT([auto])
    AC_CHECK_CXX_GTK_UTILS_GTK3(
    [
      PKG_CHECK_MODULES(GTK, gtk+-3.0 >= 2.99.0)
    ],
    [
      AC_CHECK_CXX_GTK_UTILS_GTK2(
      [
        PKG_CHECK_MODULES(GTK, gtk+-2.0 >= 2.12.0)
      ],
      [
        AC_MSG_ERROR([c++-gtk-utils >= 2.0.9 or c++-gtk-utils-2.2 >= 2.1.0 must be installed;
consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a 
nonstandard prefix so pkg-config can find them])
      ])
    ])
  ])
])

dnl AC_CHECK_CXX_GTK_UTILS_GTK3(action-if, action-if-not)
dnl this macro checks whether c++-gtk-utils >= 2.0.9 is available for GTK3
dnl If the call suceeds it sets the normal PKG_CHECK_MODULES values for
dnl c++-gtk-utils, and then executes action-if, if set. If the call fails,
dnl it executes action-if-not if set, otherwise it does nothing.
AC_DEFUN([AC_CHECK_CXX_GTK_UTILS_GTK3], 
[
  PKG_CHECK_MODULES(CXX_GTK_UTILS, c++-gtk-utils-3-2.2 >= 2.1.0,
  [
    AC_DEFINE([HAVE_CXX_GTK_UTILS_22], [1], [Define to 1 if you have c++-gtk-utils-2.2])
    ifelse([$1], , :, [$1])
  ],
  [
    PKG_CHECK_MODULES(CXX_GTK_UTILS, c++-gtk-utils-3-2.0 >= 2.0.9,
    [
      AC_DEFINE([HAVE_CXX_GTK_UTILS_20], [1], [Define to 1 if you have c++-gtk-utils-2.0])
      ifelse([$1], , :, [$1])
    ],
    [
      ifelse([$2], , :, [$2])
    ])
  ])
])

dnl AC_CHECK_CXX_GTK_UTILS_GTK2(action-if, action-if-not)
dnl this macro checks whether c++-gtk-utils >= 2.0.9 is available for GTK2
dnl If the call suceeds it sets the normal PKG_CHECK_MODULES values for
dnl c++-gtk-utils, and then executes action-if, if set. If the call fails,
dnl it executes action-if-not if set, otherwise it does nothing.
AC_DEFUN([AC_CHECK_CXX_GTK_UTILS_GTK2], 
[
  PKG_CHECK_MODULES(CXX_GTK_UTILS, c++-gtk-utils-2-2.2 >= 2.1.0,
  [
    AC_DEFINE([HAVE_CXX_GTK_UTILS_22], [1], [Define to 1 if you have c++-gtk-utils-2.2])
    ifelse([$1], , :, [$1])
  ],
  [
    PKG_CHECK_MODULES(CXX_GTK_UTILS, c++-gtk-utils-2-2.0 >= 2.0.9,
    [
      AC_DEFINE([HAVE_CXX_GTK_UTILS_20], [1], [Define to 1 if you have c++-gtk-utils-2.0])
      ifelse([$1], , :, [$1])
    ],
    [
      ifelse([$2], , :, [$2])
    ])
  ])
])

AC_DEFUN([AC_CHECK_RANGE_FOR_SUPPORT], 
[
  AC_MSG_CHECKING([for C++11 range-for support])
  AC_LANG_CPLUSPLUS
  AC_COMPILE_IFELSE(
  [
    AC_LANG_PROGRAM(
    [[
      #include <vector>
    ]],
    [[
      std::vector<int> vec;
      vec.push_back(0);
      for (auto& elt: vec) {++elt;}
    ]])
  ],
  [ 
    AC_MSG_RESULT([yes])
  ],
  [
    AC_MSG_ERROR([compiler does not support C++11 range-for expressions - if gcc is installed, gcc >= 4.6 required])
  ]) dnl end AC_COMPILE_IFELSE
])

AC_DEFUN([AC_CHECK_LAMBDA_SUPPORT], 
[
  AC_MSG_CHECKING([for C++11 lambda support])
  AC_LANG_CPLUSPLUS
  AC_COMPILE_IFELSE(
  [
    AC_LANG_PROGRAM(
    [],
    [[
      auto l = []() ->int {int i = 0; return i;};
      auto i = l();
    ]])
  ],
  [ 
    AC_MSG_RESULT([yes])
  ],
  [
    AC_MSG_ERROR([compiler does not support C++11 lambda expressions - if gcc is installed, gcc >= 4.5 required])
  ]) dnl end AC_COMPILE_IFELSE
])
