/*
  Copyright (C) 2009, 2010 and 2012 Chris Vine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef DIALOGS_H
#define DIALOGS_H

#include "prog_defs.h"

#include <gtk/gtk.h>

#include <c++-gtk-utils/window.h>

namespace InfoDialogCB {
  extern "C" void info_dialog_selected(GtkDialog*, int, void*);
}

class InfoDialog: public WinBase {
protected:
  virtual void on_delete_event();
public:
  // Objects of this class are not for copying
  InfoDialog(const InfoDialog&) = delete;
  InfoDialog& operator=(const InfoDialog&) = delete;

  friend void InfoDialogCB::info_dialog_selected(GtkDialog*, int, void*);

  // if the modal argument passed is false, then don't bother with a parent (pass 0)
  InfoDialog(const char* text, const char* caption,
	     GtkMessageType message_type, GtkWindow* parent, bool modal = true);
};

namespace PromptDialogCB {
  extern "C" void prompt_dialog_selected(GtkDialog*, int, void*);
}

class PromptDialog: public WinBase {
  bool result;
protected:
  virtual int get_exec_val() const;
  virtual void on_delete_event();
public:
  // Objects of this class are not for copying
  PromptDialog(const PromptDialog&) = delete;
  PromptDialog& operator=(const PromptDialog&) = delete;

  friend void PromptDialogCB::prompt_dialog_selected(GtkDialog*, int, void*);

  // if the modal argument passed is false, then don't bother with a parent (pass 0)
  PromptDialog(const char* text, const char* caption,
	       GtkWindow* parent, bool modal = true);
};

namespace AboutDialogCB {
  extern "C" void about_dialog_selected(GtkDialog*, int, void*);
}

class AboutDialog: public WinBase {
protected:
  virtual void on_delete_event();
public:
  // Objects of this class are not for copying
  AboutDialog(const AboutDialog&) = delete;
  AboutDialog& operator=(const AboutDialog&) = delete;

  friend void AboutDialogCB::about_dialog_selected(GtkDialog*, int, void*);

  // if the modal argument passed is false, then don't bother with a parent (pass the default of 0)
  AboutDialog(GtkWindow* parent = 0, bool modal = false);
};

#endif
