/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.ImageIcon;

public class Splash {
    protected Image m_splashImage;
    protected Window m_window;
    protected String m_version = "";

    public Splash(Frame parent, String imagefilename, boolean dialog) {
        this.m_window = dialog ? new MyDialog(parent) : new MyWindow(parent);
        ImageIcon icon = new ImageIcon(this.getClass().getResource(imagefilename));
        this.m_splashImage = icon.getImage();
        MediaTracker loader = new MediaTracker(this.m_window);
        loader.addImage(this.m_splashImage, 0);
        try {
            loader.waitForAll();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void show() {
        Dimension screendim = Toolkit.getDefaultToolkit().getScreenSize();
        this.m_window.setSize(this.m_splashImage.getWidth(this.m_window), this.m_splashImage.getHeight(this.m_window));
        this.m_window.setLocation((screendim.width - this.m_splashImage.getWidth(this.m_window)) / 2, (screendim.height - this.m_splashImage.getHeight(this.m_window)) / 2);
        this.m_window.setVisible(true);
    }

    public void dispose() {
        this.m_window.dispose();
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public void toFront() {
        this.m_window.toFront();
    }

    public class MyDialog
    extends Dialog {
        public MyDialog(Frame f) {
            super(f, true);
            this.setResizable(false);
        }

        public void paint(Graphics g) {
            g.drawImage(Splash.this.m_splashImage, 0, 0, this);
        }
    }

    public class MyWindow
    extends Window {
        public MyWindow(Frame f) {
            super(f);
        }

        public void paint(Graphics g) {
            g.drawImage(Splash.this.m_splashImage, 0, 0, this);
            g.setFont(g.getFont().deriveFont(1).deriveFont(16.0f));
            FontMetrics fm = g.getFontMetrics();
            int width = fm.stringWidth(Splash.this.m_version) + 20;
            int height = fm.getHeight();
            g.setColor(Color.black);
            g.drawString(Splash.this.m_version, this.getWidth() - width, this.getHeight() - height);
        }
    }
}

