// Copyright The Mumble Developers. All rights reserved.
// Use of this source code is governed by a BSD-style license
// that can be found in the LICENSE file at the root of the
// Mumble source tree or at <https://www.mumble.info/LICENSE>.

#ifndef MUMBLE_MUMBLE_BANEDITOR_H_
#define MUMBLE_MUMBLE_BANEDITOR_H_

#include <set>

#include "Ban.h"

#include "ui_BanEditor.h"

namespace MumbleProto {
class BanList;
}

struct BanComparator {
	bool operator()(Ban const &lhs, Ban const &rhs) const { return lhs.toKey() < rhs.toKey(); }
};

class BanEditor : public QDialog, public Ui::BanEditor {
private:
	Q_OBJECT
	Q_DISABLE_COPY(BanEditor)

	static constexpr int IPV4_MASK_TO_IPV6_MASK = 96;

	std::set< Ban, BanComparator > m_bans;
	int maskDefaultValue;

	void validate();
	Ban toBan(bool &);
	std::set< Ban >::iterator atIndex(int idx);
	int indexOf(const Ban &ban);

public:
	BanEditor(const MumbleProto::BanList &msbl, QWidget *p = nullptr);
public slots:
	void accept();
	void on_qlwBans_currentRowChanged();
	void on_qpbAdd_clicked();
	void on_qpbUpdate_clicked();
	void on_qpbRemove_clicked();
	void refreshBanList();
	void on_qdteEnd_editingFinished();
	void on_qpbClear_clicked();
private slots:
	void on_qleHash_textChanged(QString);
	void on_qleSearch_textChanged(const QString &match);
	void on_qleReason_textChanged(QString);
	void on_qleIP_textChanged(QString);
	void on_qleUser_textChanged(QString);
};

#endif
