# in projects where [ $mb_use_custom_cfgdefs = yes ],
# cfgdefs.sh is invoked from within ./configure via
# . $mb_project_dir/project/cfgdefs.sh

# a successful return from cfgdefs.sh will be followed
# by a second invocation of the config_copy() function,
# reflecting any changes to common config variables
# made by cfgdefs.sh.

# finally, cfgdefs.sh may update the contents of the
# config-time generated cfgdefs.mk.


ltdl_drop_in_replacement='no'

for arg ; do
	case "$arg" in
		--as-ltdl-drop-in-replacement )
			ltdl_drop_in_replacement='yes' ;;

		*)
			error_msg ${arg#}: "unsupported config argument."
			exit 2
	esac
done


cfgdefs_output_custom_defs()
{
	sed \
		-e 's/@ltdl_drop_in_replacement@/'"$ltdl_drop_in_replacement"'/g' \
		"$mb_project_dir/project/config/cfgdefs.in"                       \
	| sed -e 's/[ \t]*$//g'                                                   \
			>> "$mb_pwd/cfgdefs.mk"
}


# cfgdefs.in --> cfgdefs.mk
cfgdefs_output_custom_defs

# all done
return 0
