// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v2/services/google_ads_service.proto

package services

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v2/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for [GoogleAdsService.Search][google.ads.googleads.v2.services.GoogleAdsService.Search].
type SearchGoogleAdsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer being queried.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The query string.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Token of the page to retrieve. If not specified, the first
	// page of results will be returned. Use the value obtained from
	// `next_page_token` in the previous response in order to request
	// the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Number of elements to retrieve in a single page.
	// When too large a page is requested, the server may decide to
	// further limit the number of returned resources.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If true, the request is validated but not executed.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// If true, summary row will be included in the response.
	// Otherwise(false or not specified) summary row will not be returned.
	ReturnSummaryRow bool `protobuf:"varint,6,opt,name=return_summary_row,json=returnSummaryRow,proto3" json:"return_summary_row,omitempty"`
}

func (x *SearchGoogleAdsRequest) Reset() {
	*x = SearchGoogleAdsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchGoogleAdsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchGoogleAdsRequest) ProtoMessage() {}

func (x *SearchGoogleAdsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchGoogleAdsRequest.ProtoReflect.Descriptor instead.
func (*SearchGoogleAdsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescGZIP(), []int{0}
}

func (x *SearchGoogleAdsRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *SearchGoogleAdsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchGoogleAdsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchGoogleAdsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchGoogleAdsRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *SearchGoogleAdsRequest) GetReturnSummaryRow() bool {
	if x != nil {
		return x.ReturnSummaryRow
	}
	return false
}

// Response message for [GoogleAdsService.Search][google.ads.googleads.v2.services.GoogleAdsService.Search].
type SearchGoogleAdsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of rows that matched the query.
	Results []*GoogleAdsRow `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Pagination token used to retrieve the next page of results.
	// Pass the content of this string as the `page_token` attribute of
	// the next request. `next_page_token` is not returned for the last
	// page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of results that match the query ignoring the LIMIT
	// clause.
	TotalResultsCount int64 `protobuf:"varint,3,opt,name=total_results_count,json=totalResultsCount,proto3" json:"total_results_count,omitempty"`
	// FieldMask that represents what fields were requested by the user.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// Summary row that contains summary of metrics in results.
	// Summary of metrics means aggregation of metrics across all results,
	// here aggregation could be sum, average, rate, etc.
	SummaryRow *GoogleAdsRow `protobuf:"bytes,6,opt,name=summary_row,json=summaryRow,proto3" json:"summary_row,omitempty"`
}

func (x *SearchGoogleAdsResponse) Reset() {
	*x = SearchGoogleAdsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchGoogleAdsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchGoogleAdsResponse) ProtoMessage() {}

func (x *SearchGoogleAdsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchGoogleAdsResponse.ProtoReflect.Descriptor instead.
func (*SearchGoogleAdsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescGZIP(), []int{1}
}

func (x *SearchGoogleAdsResponse) GetResults() []*GoogleAdsRow {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchGoogleAdsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchGoogleAdsResponse) GetTotalResultsCount() int64 {
	if x != nil {
		return x.TotalResultsCount
	}
	return 0
}

func (x *SearchGoogleAdsResponse) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

func (x *SearchGoogleAdsResponse) GetSummaryRow() *GoogleAdsRow {
	if x != nil {
		return x.SummaryRow
	}
	return nil
}

// A returned row from the query.
type GoogleAdsRow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The account budget in the query.
	AccountBudget *resources.AccountBudget `protobuf:"bytes,42,opt,name=account_budget,json=accountBudget,proto3" json:"account_budget,omitempty"`
	// The account budget proposal referenced in the query.
	AccountBudgetProposal *resources.AccountBudgetProposal `protobuf:"bytes,43,opt,name=account_budget_proposal,json=accountBudgetProposal,proto3" json:"account_budget_proposal,omitempty"`
	// The ad group referenced in the query.
	AdGroup *resources.AdGroup `protobuf:"bytes,3,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The ad referenced in the query.
	AdGroupAd *resources.AdGroupAd `protobuf:"bytes,16,opt,name=ad_group_ad,json=adGroupAd,proto3" json:"ad_group_ad,omitempty"`
	// The ad group ad asset view in the query.
	AdGroupAdAssetView *resources.AdGroupAdAssetView `protobuf:"bytes,131,opt,name=ad_group_ad_asset_view,json=adGroupAdAssetView,proto3" json:"ad_group_ad_asset_view,omitempty"`
	// The ad group ad label referenced in the query.
	AdGroupAdLabel *resources.AdGroupAdLabel `protobuf:"bytes,120,opt,name=ad_group_ad_label,json=adGroupAdLabel,proto3" json:"ad_group_ad_label,omitempty"`
	// The ad group audience view referenced in the query.
	AdGroupAudienceView *resources.AdGroupAudienceView `protobuf:"bytes,57,opt,name=ad_group_audience_view,json=adGroupAudienceView,proto3" json:"ad_group_audience_view,omitempty"`
	// The bid modifier referenced in the query.
	AdGroupBidModifier *resources.AdGroupBidModifier `protobuf:"bytes,24,opt,name=ad_group_bid_modifier,json=adGroupBidModifier,proto3" json:"ad_group_bid_modifier,omitempty"`
	// The criterion referenced in the query.
	AdGroupCriterion *resources.AdGroupCriterion `protobuf:"bytes,17,opt,name=ad_group_criterion,json=adGroupCriterion,proto3" json:"ad_group_criterion,omitempty"`
	// The ad group criterion label referenced in the query.
	AdGroupCriterionLabel *resources.AdGroupCriterionLabel `protobuf:"bytes,121,opt,name=ad_group_criterion_label,json=adGroupCriterionLabel,proto3" json:"ad_group_criterion_label,omitempty"`
	// The ad group criterion simulation referenced in the query.
	AdGroupCriterionSimulation *resources.AdGroupCriterionSimulation `protobuf:"bytes,110,opt,name=ad_group_criterion_simulation,json=adGroupCriterionSimulation,proto3" json:"ad_group_criterion_simulation,omitempty"`
	// The ad group extension setting referenced in the query.
	AdGroupExtensionSetting *resources.AdGroupExtensionSetting `protobuf:"bytes,112,opt,name=ad_group_extension_setting,json=adGroupExtensionSetting,proto3" json:"ad_group_extension_setting,omitempty"`
	// The ad group feed referenced in the query.
	AdGroupFeed *resources.AdGroupFeed `protobuf:"bytes,67,opt,name=ad_group_feed,json=adGroupFeed,proto3" json:"ad_group_feed,omitempty"`
	// The ad group label referenced in the query.
	AdGroupLabel *resources.AdGroupLabel `protobuf:"bytes,115,opt,name=ad_group_label,json=adGroupLabel,proto3" json:"ad_group_label,omitempty"`
	// The ad group simulation referenced in the query.
	AdGroupSimulation *resources.AdGroupSimulation `protobuf:"bytes,107,opt,name=ad_group_simulation,json=adGroupSimulation,proto3" json:"ad_group_simulation,omitempty"`
	// The ad parameter referenced in the query.
	AdParameter *resources.AdParameter `protobuf:"bytes,130,opt,name=ad_parameter,json=adParameter,proto3" json:"ad_parameter,omitempty"`
	// The age range view referenced in the query.
	AgeRangeView *resources.AgeRangeView `protobuf:"bytes,48,opt,name=age_range_view,json=ageRangeView,proto3" json:"age_range_view,omitempty"`
	// The ad schedule view referenced in the query.
	AdScheduleView *resources.AdScheduleView `protobuf:"bytes,89,opt,name=ad_schedule_view,json=adScheduleView,proto3" json:"ad_schedule_view,omitempty"`
	// The domain category referenced in the query.
	DomainCategory *resources.DomainCategory `protobuf:"bytes,91,opt,name=domain_category,json=domainCategory,proto3" json:"domain_category,omitempty"`
	// The asset referenced in the query.
	Asset *resources.Asset `protobuf:"bytes,105,opt,name=asset,proto3" json:"asset,omitempty"`
	// The bidding strategy referenced in the query.
	BiddingStrategy *resources.BiddingStrategy `protobuf:"bytes,18,opt,name=bidding_strategy,json=biddingStrategy,proto3" json:"bidding_strategy,omitempty"`
	// The billing setup referenced in the query.
	BillingSetup *resources.BillingSetup `protobuf:"bytes,41,opt,name=billing_setup,json=billingSetup,proto3" json:"billing_setup,omitempty"`
	// The campaign budget referenced in the query.
	CampaignBudget *resources.CampaignBudget `protobuf:"bytes,19,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// The campaign referenced in the query.
	Campaign *resources.Campaign `protobuf:"bytes,2,opt,name=campaign,proto3" json:"campaign,omitempty"`
	// The campaign audience view referenced in the query.
	CampaignAudienceView *resources.CampaignAudienceView `protobuf:"bytes,69,opt,name=campaign_audience_view,json=campaignAudienceView,proto3" json:"campaign_audience_view,omitempty"`
	// The campaign bid modifier referenced in the query.
	CampaignBidModifier *resources.CampaignBidModifier `protobuf:"bytes,26,opt,name=campaign_bid_modifier,json=campaignBidModifier,proto3" json:"campaign_bid_modifier,omitempty"`
	// The campaign criterion referenced in the query.
	CampaignCriterion *resources.CampaignCriterion `protobuf:"bytes,20,opt,name=campaign_criterion,json=campaignCriterion,proto3" json:"campaign_criterion,omitempty"`
	// The campaign criterion simulation referenced in the query.
	CampaignCriterionSimulation *resources.CampaignCriterionSimulation `protobuf:"bytes,111,opt,name=campaign_criterion_simulation,json=campaignCriterionSimulation,proto3" json:"campaign_criterion_simulation,omitempty"`
	// The campaign draft referenced in the query.
	CampaignDraft *resources.CampaignDraft `protobuf:"bytes,49,opt,name=campaign_draft,json=campaignDraft,proto3" json:"campaign_draft,omitempty"`
	// The campaign experiment referenced in the query.
	CampaignExperiment *resources.CampaignExperiment `protobuf:"bytes,84,opt,name=campaign_experiment,json=campaignExperiment,proto3" json:"campaign_experiment,omitempty"`
	// The campaign extension setting referenced in the query.
	CampaignExtensionSetting *resources.CampaignExtensionSetting `protobuf:"bytes,113,opt,name=campaign_extension_setting,json=campaignExtensionSetting,proto3" json:"campaign_extension_setting,omitempty"`
	// The campaign feed referenced in the query.
	CampaignFeed *resources.CampaignFeed `protobuf:"bytes,63,opt,name=campaign_feed,json=campaignFeed,proto3" json:"campaign_feed,omitempty"`
	// The campaign label referenced in the query.
	CampaignLabel *resources.CampaignLabel `protobuf:"bytes,108,opt,name=campaign_label,json=campaignLabel,proto3" json:"campaign_label,omitempty"`
	// Campaign Shared Set referenced in AWQL query.
	CampaignSharedSet *resources.CampaignSharedSet `protobuf:"bytes,30,opt,name=campaign_shared_set,json=campaignSharedSet,proto3" json:"campaign_shared_set,omitempty"`
	// The carrier constant referenced in the query.
	CarrierConstant *resources.CarrierConstant `protobuf:"bytes,66,opt,name=carrier_constant,json=carrierConstant,proto3" json:"carrier_constant,omitempty"`
	// The ChangeStatus referenced in the query.
	ChangeStatus *resources.ChangeStatus `protobuf:"bytes,37,opt,name=change_status,json=changeStatus,proto3" json:"change_status,omitempty"`
	// The conversion action referenced in the query.
	ConversionAction *resources.ConversionAction `protobuf:"bytes,103,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// The ClickView referenced in the query.
	ClickView *resources.ClickView `protobuf:"bytes,122,opt,name=click_view,json=clickView,proto3" json:"click_view,omitempty"`
	// The CustomInterest referenced in the query.
	CustomInterest *resources.CustomInterest `protobuf:"bytes,104,opt,name=custom_interest,json=customInterest,proto3" json:"custom_interest,omitempty"`
	// The customer referenced in the query.
	Customer *resources.Customer `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// The CustomerManagerLink referenced in the query.
	CustomerManagerLink *resources.CustomerManagerLink `protobuf:"bytes,61,opt,name=customer_manager_link,json=customerManagerLink,proto3" json:"customer_manager_link,omitempty"`
	// The CustomerClientLink referenced in the query.
	CustomerClientLink *resources.CustomerClientLink `protobuf:"bytes,62,opt,name=customer_client_link,json=customerClientLink,proto3" json:"customer_client_link,omitempty"`
	// The CustomerClient referenced in the query.
	CustomerClient *resources.CustomerClient `protobuf:"bytes,70,opt,name=customer_client,json=customerClient,proto3" json:"customer_client,omitempty"`
	// The customer extension setting referenced in the query.
	CustomerExtensionSetting *resources.CustomerExtensionSetting `protobuf:"bytes,114,opt,name=customer_extension_setting,json=customerExtensionSetting,proto3" json:"customer_extension_setting,omitempty"`
	// The customer feed referenced in the query.
	CustomerFeed *resources.CustomerFeed `protobuf:"bytes,64,opt,name=customer_feed,json=customerFeed,proto3" json:"customer_feed,omitempty"`
	// The customer label referenced in the query.
	CustomerLabel *resources.CustomerLabel `protobuf:"bytes,124,opt,name=customer_label,json=customerLabel,proto3" json:"customer_label,omitempty"`
	// The customer negative criterion referenced in the query.
	CustomerNegativeCriterion *resources.CustomerNegativeCriterion `protobuf:"bytes,88,opt,name=customer_negative_criterion,json=customerNegativeCriterion,proto3" json:"customer_negative_criterion,omitempty"`
	// The detail placement view referenced in the query.
	DetailPlacementView *resources.DetailPlacementView `protobuf:"bytes,118,opt,name=detail_placement_view,json=detailPlacementView,proto3" json:"detail_placement_view,omitempty"`
	// The display keyword view referenced in the query.
	DisplayKeywordView *resources.DisplayKeywordView `protobuf:"bytes,47,opt,name=display_keyword_view,json=displayKeywordView,proto3" json:"display_keyword_view,omitempty"`
	// The distance view referenced in the query.
	DistanceView *resources.DistanceView `protobuf:"bytes,132,opt,name=distance_view,json=distanceView,proto3" json:"distance_view,omitempty"`
	// The dynamic search ads search term view referenced in the query.
	DynamicSearchAdsSearchTermView *resources.DynamicSearchAdsSearchTermView `protobuf:"bytes,106,opt,name=dynamic_search_ads_search_term_view,json=dynamicSearchAdsSearchTermView,proto3" json:"dynamic_search_ads_search_term_view,omitempty"`
	// The expanded landing page view referenced in the query.
	ExpandedLandingPageView *resources.ExpandedLandingPageView `protobuf:"bytes,128,opt,name=expanded_landing_page_view,json=expandedLandingPageView,proto3" json:"expanded_landing_page_view,omitempty"`
	// The extension feed item referenced in the query.
	ExtensionFeedItem *resources.ExtensionFeedItem `protobuf:"bytes,85,opt,name=extension_feed_item,json=extensionFeedItem,proto3" json:"extension_feed_item,omitempty"`
	// The feed referenced in the query.
	Feed *resources.Feed `protobuf:"bytes,46,opt,name=feed,proto3" json:"feed,omitempty"`
	// The feed item referenced in the query.
	FeedItem *resources.FeedItem `protobuf:"bytes,50,opt,name=feed_item,json=feedItem,proto3" json:"feed_item,omitempty"`
	// The feed item target referenced in the query.
	FeedItemTarget *resources.FeedItemTarget `protobuf:"bytes,116,opt,name=feed_item_target,json=feedItemTarget,proto3" json:"feed_item_target,omitempty"`
	// The feed mapping referenced in the query.
	FeedMapping *resources.FeedMapping `protobuf:"bytes,58,opt,name=feed_mapping,json=feedMapping,proto3" json:"feed_mapping,omitempty"`
	// The feed placeholder view referenced in the query.
	FeedPlaceholderView *resources.FeedPlaceholderView `protobuf:"bytes,97,opt,name=feed_placeholder_view,json=feedPlaceholderView,proto3" json:"feed_placeholder_view,omitempty"`
	// The gender view referenced in the query.
	GenderView *resources.GenderView `protobuf:"bytes,40,opt,name=gender_view,json=genderView,proto3" json:"gender_view,omitempty"`
	// The geo target constant referenced in the query.
	GeoTargetConstant *resources.GeoTargetConstant `protobuf:"bytes,23,opt,name=geo_target_constant,json=geoTargetConstant,proto3" json:"geo_target_constant,omitempty"`
	// The geographic view referenced in the query.
	GeographicView *resources.GeographicView `protobuf:"bytes,125,opt,name=geographic_view,json=geographicView,proto3" json:"geographic_view,omitempty"`
	// The group placement view referenced in the query.
	GroupPlacementView *resources.GroupPlacementView `protobuf:"bytes,119,opt,name=group_placement_view,json=groupPlacementView,proto3" json:"group_placement_view,omitempty"`
	// The hotel group view referenced in the query.
	HotelGroupView *resources.HotelGroupView `protobuf:"bytes,51,opt,name=hotel_group_view,json=hotelGroupView,proto3" json:"hotel_group_view,omitempty"`
	// The hotel performance view referenced in the query.
	HotelPerformanceView *resources.HotelPerformanceView `protobuf:"bytes,71,opt,name=hotel_performance_view,json=hotelPerformanceView,proto3" json:"hotel_performance_view,omitempty"`
	// The keyword view referenced in the query.
	KeywordView *resources.KeywordView `protobuf:"bytes,21,opt,name=keyword_view,json=keywordView,proto3" json:"keyword_view,omitempty"`
	// The keyword plan referenced in the query.
	KeywordPlan *resources.KeywordPlan `protobuf:"bytes,32,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
	// The keyword plan campaign referenced in the query.
	KeywordPlanCampaign *resources.KeywordPlanCampaign `protobuf:"bytes,33,opt,name=keyword_plan_campaign,json=keywordPlanCampaign,proto3" json:"keyword_plan_campaign,omitempty"`
	// The keyword plan negative keyword referenced in the query.
	KeywordPlanNegativeKeyword *resources.KeywordPlanNegativeKeyword `protobuf:"bytes,34,opt,name=keyword_plan_negative_keyword,json=keywordPlanNegativeKeyword,proto3" json:"keyword_plan_negative_keyword,omitempty"`
	// The keyword plan ad group referenced in the query.
	KeywordPlanAdGroup *resources.KeywordPlanAdGroup `protobuf:"bytes,35,opt,name=keyword_plan_ad_group,json=keywordPlanAdGroup,proto3" json:"keyword_plan_ad_group,omitempty"`
	// The keyword plan keyword referenced in the query.
	KeywordPlanKeyword *resources.KeywordPlanKeyword `protobuf:"bytes,36,opt,name=keyword_plan_keyword,json=keywordPlanKeyword,proto3" json:"keyword_plan_keyword,omitempty"`
	// The label referenced in the query.
	Label *resources.Label `protobuf:"bytes,52,opt,name=label,proto3" json:"label,omitempty"`
	// The landing page view referenced in the query.
	LandingPageView *resources.LandingPageView `protobuf:"bytes,126,opt,name=landing_page_view,json=landingPageView,proto3" json:"landing_page_view,omitempty"`
	// The language constant referenced in the query.
	LanguageConstant *resources.LanguageConstant `protobuf:"bytes,55,opt,name=language_constant,json=languageConstant,proto3" json:"language_constant,omitempty"`
	// The location view referenced in the query.
	LocationView *resources.LocationView `protobuf:"bytes,123,opt,name=location_view,json=locationView,proto3" json:"location_view,omitempty"`
	// The managed placement view referenced in the query.
	ManagedPlacementView *resources.ManagedPlacementView `protobuf:"bytes,53,opt,name=managed_placement_view,json=managedPlacementView,proto3" json:"managed_placement_view,omitempty"`
	// The media file referenced in the query.
	MediaFile *resources.MediaFile `protobuf:"bytes,90,opt,name=media_file,json=mediaFile,proto3" json:"media_file,omitempty"`
	// The mobile app category constant referenced in the query.
	MobileAppCategoryConstant *resources.MobileAppCategoryConstant `protobuf:"bytes,87,opt,name=mobile_app_category_constant,json=mobileAppCategoryConstant,proto3" json:"mobile_app_category_constant,omitempty"`
	// The mobile device constant referenced in the query.
	MobileDeviceConstant *resources.MobileDeviceConstant `protobuf:"bytes,98,opt,name=mobile_device_constant,json=mobileDeviceConstant,proto3" json:"mobile_device_constant,omitempty"`
	// The mutate job referenced in the query.
	MutateJob *resources.MutateJob `protobuf:"bytes,127,opt,name=mutate_job,json=mutateJob,proto3" json:"mutate_job,omitempty"`
	// The operating system version constant referenced in the query.
	OperatingSystemVersionConstant *resources.OperatingSystemVersionConstant `protobuf:"bytes,86,opt,name=operating_system_version_constant,json=operatingSystemVersionConstant,proto3" json:"operating_system_version_constant,omitempty"`
	// The paid organic search term view referenced in the query.
	PaidOrganicSearchTermView *resources.PaidOrganicSearchTermView `protobuf:"bytes,129,opt,name=paid_organic_search_term_view,json=paidOrganicSearchTermView,proto3" json:"paid_organic_search_term_view,omitempty"`
	// The parental status view referenced in the query.
	ParentalStatusView *resources.ParentalStatusView `protobuf:"bytes,45,opt,name=parental_status_view,json=parentalStatusView,proto3" json:"parental_status_view,omitempty"`
	// The Product Bidding Category referenced in the query.
	ProductBiddingCategoryConstant *resources.ProductBiddingCategoryConstant `protobuf:"bytes,109,opt,name=product_bidding_category_constant,json=productBiddingCategoryConstant,proto3" json:"product_bidding_category_constant,omitempty"`
	// The product group view referenced in the query.
	ProductGroupView *resources.ProductGroupView `protobuf:"bytes,54,opt,name=product_group_view,json=productGroupView,proto3" json:"product_group_view,omitempty"`
	// The recommendation referenced in the query.
	Recommendation *resources.Recommendation `protobuf:"bytes,22,opt,name=recommendation,proto3" json:"recommendation,omitempty"`
	// The search term view referenced in the query.
	SearchTermView *resources.SearchTermView `protobuf:"bytes,68,opt,name=search_term_view,json=searchTermView,proto3" json:"search_term_view,omitempty"`
	// The shared set referenced in the query.
	SharedCriterion *resources.SharedCriterion `protobuf:"bytes,29,opt,name=shared_criterion,json=sharedCriterion,proto3" json:"shared_criterion,omitempty"`
	// The shared set referenced in the query.
	SharedSet *resources.SharedSet `protobuf:"bytes,27,opt,name=shared_set,json=sharedSet,proto3" json:"shared_set,omitempty"`
	// The shopping performance view referenced in the query.
	ShoppingPerformanceView *resources.ShoppingPerformanceView `protobuf:"bytes,117,opt,name=shopping_performance_view,json=shoppingPerformanceView,proto3" json:"shopping_performance_view,omitempty"`
	// The topic view referenced in the query.
	TopicView *resources.TopicView `protobuf:"bytes,44,opt,name=topic_view,json=topicView,proto3" json:"topic_view,omitempty"`
	// The user interest referenced in the query.
	UserInterest *resources.UserInterest `protobuf:"bytes,59,opt,name=user_interest,json=userInterest,proto3" json:"user_interest,omitempty"`
	// The user list referenced in the query.
	UserList *resources.UserList `protobuf:"bytes,38,opt,name=user_list,json=userList,proto3" json:"user_list,omitempty"`
	// The user location view referenced in the query.
	UserLocationView *resources.UserLocationView `protobuf:"bytes,135,opt,name=user_location_view,json=userLocationView,proto3" json:"user_location_view,omitempty"`
	// The remarketing action referenced in the query.
	RemarketingAction *resources.RemarketingAction `protobuf:"bytes,60,opt,name=remarketing_action,json=remarketingAction,proto3" json:"remarketing_action,omitempty"`
	// The topic constant referenced in the query.
	TopicConstant *resources.TopicConstant `protobuf:"bytes,31,opt,name=topic_constant,json=topicConstant,proto3" json:"topic_constant,omitempty"`
	// The video referenced in the query.
	Video *resources.Video `protobuf:"bytes,39,opt,name=video,proto3" json:"video,omitempty"`
	// The metrics.
	Metrics *common.Metrics `protobuf:"bytes,4,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// The segments.
	Segments *common.Segments `protobuf:"bytes,102,opt,name=segments,proto3" json:"segments,omitempty"`
}

func (x *GoogleAdsRow) Reset() {
	*x = GoogleAdsRow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleAdsRow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleAdsRow) ProtoMessage() {}

func (x *GoogleAdsRow) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleAdsRow.ProtoReflect.Descriptor instead.
func (*GoogleAdsRow) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescGZIP(), []int{2}
}

func (x *GoogleAdsRow) GetAccountBudget() *resources.AccountBudget {
	if x != nil {
		return x.AccountBudget
	}
	return nil
}

func (x *GoogleAdsRow) GetAccountBudgetProposal() *resources.AccountBudgetProposal {
	if x != nil {
		return x.AccountBudgetProposal
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroup() *resources.AdGroup {
	if x != nil {
		return x.AdGroup
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupAd() *resources.AdGroupAd {
	if x != nil {
		return x.AdGroupAd
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupAdAssetView() *resources.AdGroupAdAssetView {
	if x != nil {
		return x.AdGroupAdAssetView
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupAdLabel() *resources.AdGroupAdLabel {
	if x != nil {
		return x.AdGroupAdLabel
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupAudienceView() *resources.AdGroupAudienceView {
	if x != nil {
		return x.AdGroupAudienceView
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupBidModifier() *resources.AdGroupBidModifier {
	if x != nil {
		return x.AdGroupBidModifier
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupCriterion() *resources.AdGroupCriterion {
	if x != nil {
		return x.AdGroupCriterion
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupCriterionLabel() *resources.AdGroupCriterionLabel {
	if x != nil {
		return x.AdGroupCriterionLabel
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupCriterionSimulation() *resources.AdGroupCriterionSimulation {
	if x != nil {
		return x.AdGroupCriterionSimulation
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupExtensionSetting() *resources.AdGroupExtensionSetting {
	if x != nil {
		return x.AdGroupExtensionSetting
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupFeed() *resources.AdGroupFeed {
	if x != nil {
		return x.AdGroupFeed
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupLabel() *resources.AdGroupLabel {
	if x != nil {
		return x.AdGroupLabel
	}
	return nil
}

func (x *GoogleAdsRow) GetAdGroupSimulation() *resources.AdGroupSimulation {
	if x != nil {
		return x.AdGroupSimulation
	}
	return nil
}

func (x *GoogleAdsRow) GetAdParameter() *resources.AdParameter {
	if x != nil {
		return x.AdParameter
	}
	return nil
}

func (x *GoogleAdsRow) GetAgeRangeView() *resources.AgeRangeView {
	if x != nil {
		return x.AgeRangeView
	}
	return nil
}

func (x *GoogleAdsRow) GetAdScheduleView() *resources.AdScheduleView {
	if x != nil {
		return x.AdScheduleView
	}
	return nil
}

func (x *GoogleAdsRow) GetDomainCategory() *resources.DomainCategory {
	if x != nil {
		return x.DomainCategory
	}
	return nil
}

func (x *GoogleAdsRow) GetAsset() *resources.Asset {
	if x != nil {
		return x.Asset
	}
	return nil
}

func (x *GoogleAdsRow) GetBiddingStrategy() *resources.BiddingStrategy {
	if x != nil {
		return x.BiddingStrategy
	}
	return nil
}

func (x *GoogleAdsRow) GetBillingSetup() *resources.BillingSetup {
	if x != nil {
		return x.BillingSetup
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignBudget() *resources.CampaignBudget {
	if x != nil {
		return x.CampaignBudget
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaign() *resources.Campaign {
	if x != nil {
		return x.Campaign
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignAudienceView() *resources.CampaignAudienceView {
	if x != nil {
		return x.CampaignAudienceView
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignBidModifier() *resources.CampaignBidModifier {
	if x != nil {
		return x.CampaignBidModifier
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignCriterion() *resources.CampaignCriterion {
	if x != nil {
		return x.CampaignCriterion
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignCriterionSimulation() *resources.CampaignCriterionSimulation {
	if x != nil {
		return x.CampaignCriterionSimulation
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignDraft() *resources.CampaignDraft {
	if x != nil {
		return x.CampaignDraft
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignExperiment() *resources.CampaignExperiment {
	if x != nil {
		return x.CampaignExperiment
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignExtensionSetting() *resources.CampaignExtensionSetting {
	if x != nil {
		return x.CampaignExtensionSetting
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignFeed() *resources.CampaignFeed {
	if x != nil {
		return x.CampaignFeed
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignLabel() *resources.CampaignLabel {
	if x != nil {
		return x.CampaignLabel
	}
	return nil
}

func (x *GoogleAdsRow) GetCampaignSharedSet() *resources.CampaignSharedSet {
	if x != nil {
		return x.CampaignSharedSet
	}
	return nil
}

func (x *GoogleAdsRow) GetCarrierConstant() *resources.CarrierConstant {
	if x != nil {
		return x.CarrierConstant
	}
	return nil
}

func (x *GoogleAdsRow) GetChangeStatus() *resources.ChangeStatus {
	if x != nil {
		return x.ChangeStatus
	}
	return nil
}

func (x *GoogleAdsRow) GetConversionAction() *resources.ConversionAction {
	if x != nil {
		return x.ConversionAction
	}
	return nil
}

func (x *GoogleAdsRow) GetClickView() *resources.ClickView {
	if x != nil {
		return x.ClickView
	}
	return nil
}

func (x *GoogleAdsRow) GetCustomInterest() *resources.CustomInterest {
	if x != nil {
		return x.CustomInterest
	}
	return nil
}

func (x *GoogleAdsRow) GetCustomer() *resources.Customer {
	if x != nil {
		return x.Customer
	}
	return nil
}

func (x *GoogleAdsRow) GetCustomerManagerLink() *resources.CustomerManagerLink {
	if x != nil {
		return x.CustomerManagerLink
	}
	return nil
}

func (x *GoogleAdsRow) GetCustomerClientLink() *resources.CustomerClientLink {
	if x != nil {
		return x.CustomerClientLink
	}
	return nil
}

func (x *GoogleAdsRow) GetCustomerClient() *resources.CustomerClient {
	if x != nil {
		return x.CustomerClient
	}
	return nil
}

func (x *GoogleAdsRow) GetCustomerExtensionSetting() *resources.CustomerExtensionSetting {
	if x != nil {
		return x.CustomerExtensionSetting
	}
	return nil
}

func (x *GoogleAdsRow) GetCustomerFeed() *resources.CustomerFeed {
	if x != nil {
		return x.CustomerFeed
	}
	return nil
}

func (x *GoogleAdsRow) GetCustomerLabel() *resources.CustomerLabel {
	if x != nil {
		return x.CustomerLabel
	}
	return nil
}

func (x *GoogleAdsRow) GetCustomerNegativeCriterion() *resources.CustomerNegativeCriterion {
	if x != nil {
		return x.CustomerNegativeCriterion
	}
	return nil
}

func (x *GoogleAdsRow) GetDetailPlacementView() *resources.DetailPlacementView {
	if x != nil {
		return x.DetailPlacementView
	}
	return nil
}

func (x *GoogleAdsRow) GetDisplayKeywordView() *resources.DisplayKeywordView {
	if x != nil {
		return x.DisplayKeywordView
	}
	return nil
}

func (x *GoogleAdsRow) GetDistanceView() *resources.DistanceView {
	if x != nil {
		return x.DistanceView
	}
	return nil
}

func (x *GoogleAdsRow) GetDynamicSearchAdsSearchTermView() *resources.DynamicSearchAdsSearchTermView {
	if x != nil {
		return x.DynamicSearchAdsSearchTermView
	}
	return nil
}

func (x *GoogleAdsRow) GetExpandedLandingPageView() *resources.ExpandedLandingPageView {
	if x != nil {
		return x.ExpandedLandingPageView
	}
	return nil
}

func (x *GoogleAdsRow) GetExtensionFeedItem() *resources.ExtensionFeedItem {
	if x != nil {
		return x.ExtensionFeedItem
	}
	return nil
}

func (x *GoogleAdsRow) GetFeed() *resources.Feed {
	if x != nil {
		return x.Feed
	}
	return nil
}

func (x *GoogleAdsRow) GetFeedItem() *resources.FeedItem {
	if x != nil {
		return x.FeedItem
	}
	return nil
}

func (x *GoogleAdsRow) GetFeedItemTarget() *resources.FeedItemTarget {
	if x != nil {
		return x.FeedItemTarget
	}
	return nil
}

func (x *GoogleAdsRow) GetFeedMapping() *resources.FeedMapping {
	if x != nil {
		return x.FeedMapping
	}
	return nil
}

func (x *GoogleAdsRow) GetFeedPlaceholderView() *resources.FeedPlaceholderView {
	if x != nil {
		return x.FeedPlaceholderView
	}
	return nil
}

func (x *GoogleAdsRow) GetGenderView() *resources.GenderView {
	if x != nil {
		return x.GenderView
	}
	return nil
}

func (x *GoogleAdsRow) GetGeoTargetConstant() *resources.GeoTargetConstant {
	if x != nil {
		return x.GeoTargetConstant
	}
	return nil
}

func (x *GoogleAdsRow) GetGeographicView() *resources.GeographicView {
	if x != nil {
		return x.GeographicView
	}
	return nil
}

func (x *GoogleAdsRow) GetGroupPlacementView() *resources.GroupPlacementView {
	if x != nil {
		return x.GroupPlacementView
	}
	return nil
}

func (x *GoogleAdsRow) GetHotelGroupView() *resources.HotelGroupView {
	if x != nil {
		return x.HotelGroupView
	}
	return nil
}

func (x *GoogleAdsRow) GetHotelPerformanceView() *resources.HotelPerformanceView {
	if x != nil {
		return x.HotelPerformanceView
	}
	return nil
}

func (x *GoogleAdsRow) GetKeywordView() *resources.KeywordView {
	if x != nil {
		return x.KeywordView
	}
	return nil
}

func (x *GoogleAdsRow) GetKeywordPlan() *resources.KeywordPlan {
	if x != nil {
		return x.KeywordPlan
	}
	return nil
}

func (x *GoogleAdsRow) GetKeywordPlanCampaign() *resources.KeywordPlanCampaign {
	if x != nil {
		return x.KeywordPlanCampaign
	}
	return nil
}

func (x *GoogleAdsRow) GetKeywordPlanNegativeKeyword() *resources.KeywordPlanNegativeKeyword {
	if x != nil {
		return x.KeywordPlanNegativeKeyword
	}
	return nil
}

func (x *GoogleAdsRow) GetKeywordPlanAdGroup() *resources.KeywordPlanAdGroup {
	if x != nil {
		return x.KeywordPlanAdGroup
	}
	return nil
}

func (x *GoogleAdsRow) GetKeywordPlanKeyword() *resources.KeywordPlanKeyword {
	if x != nil {
		return x.KeywordPlanKeyword
	}
	return nil
}

func (x *GoogleAdsRow) GetLabel() *resources.Label {
	if x != nil {
		return x.Label
	}
	return nil
}

func (x *GoogleAdsRow) GetLandingPageView() *resources.LandingPageView {
	if x != nil {
		return x.LandingPageView
	}
	return nil
}

func (x *GoogleAdsRow) GetLanguageConstant() *resources.LanguageConstant {
	if x != nil {
		return x.LanguageConstant
	}
	return nil
}

func (x *GoogleAdsRow) GetLocationView() *resources.LocationView {
	if x != nil {
		return x.LocationView
	}
	return nil
}

func (x *GoogleAdsRow) GetManagedPlacementView() *resources.ManagedPlacementView {
	if x != nil {
		return x.ManagedPlacementView
	}
	return nil
}

func (x *GoogleAdsRow) GetMediaFile() *resources.MediaFile {
	if x != nil {
		return x.MediaFile
	}
	return nil
}

func (x *GoogleAdsRow) GetMobileAppCategoryConstant() *resources.MobileAppCategoryConstant {
	if x != nil {
		return x.MobileAppCategoryConstant
	}
	return nil
}

func (x *GoogleAdsRow) GetMobileDeviceConstant() *resources.MobileDeviceConstant {
	if x != nil {
		return x.MobileDeviceConstant
	}
	return nil
}

func (x *GoogleAdsRow) GetMutateJob() *resources.MutateJob {
	if x != nil {
		return x.MutateJob
	}
	return nil
}

func (x *GoogleAdsRow) GetOperatingSystemVersionConstant() *resources.OperatingSystemVersionConstant {
	if x != nil {
		return x.OperatingSystemVersionConstant
	}
	return nil
}

func (x *GoogleAdsRow) GetPaidOrganicSearchTermView() *resources.PaidOrganicSearchTermView {
	if x != nil {
		return x.PaidOrganicSearchTermView
	}
	return nil
}

func (x *GoogleAdsRow) GetParentalStatusView() *resources.ParentalStatusView {
	if x != nil {
		return x.ParentalStatusView
	}
	return nil
}

func (x *GoogleAdsRow) GetProductBiddingCategoryConstant() *resources.ProductBiddingCategoryConstant {
	if x != nil {
		return x.ProductBiddingCategoryConstant
	}
	return nil
}

func (x *GoogleAdsRow) GetProductGroupView() *resources.ProductGroupView {
	if x != nil {
		return x.ProductGroupView
	}
	return nil
}

func (x *GoogleAdsRow) GetRecommendation() *resources.Recommendation {
	if x != nil {
		return x.Recommendation
	}
	return nil
}

func (x *GoogleAdsRow) GetSearchTermView() *resources.SearchTermView {
	if x != nil {
		return x.SearchTermView
	}
	return nil
}

func (x *GoogleAdsRow) GetSharedCriterion() *resources.SharedCriterion {
	if x != nil {
		return x.SharedCriterion
	}
	return nil
}

func (x *GoogleAdsRow) GetSharedSet() *resources.SharedSet {
	if x != nil {
		return x.SharedSet
	}
	return nil
}

func (x *GoogleAdsRow) GetShoppingPerformanceView() *resources.ShoppingPerformanceView {
	if x != nil {
		return x.ShoppingPerformanceView
	}
	return nil
}

func (x *GoogleAdsRow) GetTopicView() *resources.TopicView {
	if x != nil {
		return x.TopicView
	}
	return nil
}

func (x *GoogleAdsRow) GetUserInterest() *resources.UserInterest {
	if x != nil {
		return x.UserInterest
	}
	return nil
}

func (x *GoogleAdsRow) GetUserList() *resources.UserList {
	if x != nil {
		return x.UserList
	}
	return nil
}

func (x *GoogleAdsRow) GetUserLocationView() *resources.UserLocationView {
	if x != nil {
		return x.UserLocationView
	}
	return nil
}

func (x *GoogleAdsRow) GetRemarketingAction() *resources.RemarketingAction {
	if x != nil {
		return x.RemarketingAction
	}
	return nil
}

func (x *GoogleAdsRow) GetTopicConstant() *resources.TopicConstant {
	if x != nil {
		return x.TopicConstant
	}
	return nil
}

func (x *GoogleAdsRow) GetVideo() *resources.Video {
	if x != nil {
		return x.Video
	}
	return nil
}

func (x *GoogleAdsRow) GetMetrics() *common.Metrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *GoogleAdsRow) GetSegments() *common.Segments {
	if x != nil {
		return x.Segments
	}
	return nil
}

// Request message for [GoogleAdsService.Mutate][google.ads.googleads.v2.services.GoogleAdsService.Mutate].
type MutateGoogleAdsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the customer whose resources are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual resources.
	MutateOperations []*MutateOperation `protobuf:"bytes,2,rep,name=mutate_operations,json=mutateOperations,proto3" json:"mutate_operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *MutateGoogleAdsRequest) Reset() {
	*x = MutateGoogleAdsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateGoogleAdsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateGoogleAdsRequest) ProtoMessage() {}

func (x *MutateGoogleAdsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateGoogleAdsRequest.ProtoReflect.Descriptor instead.
func (*MutateGoogleAdsRequest) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescGZIP(), []int{3}
}

func (x *MutateGoogleAdsRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *MutateGoogleAdsRequest) GetMutateOperations() []*MutateOperation {
	if x != nil {
		return x.MutateOperations
	}
	return nil
}

func (x *MutateGoogleAdsRequest) GetPartialFailure() bool {
	if x != nil {
		return x.PartialFailure
	}
	return false
}

func (x *MutateGoogleAdsRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Response message for [GoogleAdsService.Mutate][google.ads.googleads.v2.services.GoogleAdsService.Mutate].
type MutateGoogleAdsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g., auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All responses for the mutate.
	MutateOperationResponses []*MutateOperationResponse `protobuf:"bytes,1,rep,name=mutate_operation_responses,json=mutateOperationResponses,proto3" json:"mutate_operation_responses,omitempty"`
}

func (x *MutateGoogleAdsResponse) Reset() {
	*x = MutateGoogleAdsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateGoogleAdsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateGoogleAdsResponse) ProtoMessage() {}

func (x *MutateGoogleAdsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateGoogleAdsResponse.ProtoReflect.Descriptor instead.
func (*MutateGoogleAdsResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescGZIP(), []int{4}
}

func (x *MutateGoogleAdsResponse) GetPartialFailureError() *status.Status {
	if x != nil {
		return x.PartialFailureError
	}
	return nil
}

func (x *MutateGoogleAdsResponse) GetMutateOperationResponses() []*MutateOperationResponse {
	if x != nil {
		return x.MutateOperationResponses
	}
	return nil
}

// A single operation (create, update, remove) on a resource.
type MutateOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mutate operation.
	//
	// Types that are assignable to Operation:
	//	*MutateOperation_AdGroupAdLabelOperation
	//	*MutateOperation_AdGroupAdOperation
	//	*MutateOperation_AdGroupBidModifierOperation
	//	*MutateOperation_AdGroupCriterionLabelOperation
	//	*MutateOperation_AdGroupCriterionOperation
	//	*MutateOperation_AdGroupExtensionSettingOperation
	//	*MutateOperation_AdGroupFeedOperation
	//	*MutateOperation_AdGroupLabelOperation
	//	*MutateOperation_AdGroupOperation
	//	*MutateOperation_AdParameterOperation
	//	*MutateOperation_AssetOperation
	//	*MutateOperation_BiddingStrategyOperation
	//	*MutateOperation_CampaignBidModifierOperation
	//	*MutateOperation_CampaignBudgetOperation
	//	*MutateOperation_CampaignCriterionOperation
	//	*MutateOperation_CampaignDraftOperation
	//	*MutateOperation_CampaignExperimentOperation
	//	*MutateOperation_CampaignExtensionSettingOperation
	//	*MutateOperation_CampaignFeedOperation
	//	*MutateOperation_CampaignLabelOperation
	//	*MutateOperation_CampaignOperation
	//	*MutateOperation_CampaignSharedSetOperation
	//	*MutateOperation_ConversionActionOperation
	//	*MutateOperation_CustomerExtensionSettingOperation
	//	*MutateOperation_CustomerFeedOperation
	//	*MutateOperation_CustomerLabelOperation
	//	*MutateOperation_CustomerNegativeCriterionOperation
	//	*MutateOperation_CustomerOperation
	//	*MutateOperation_ExtensionFeedItemOperation
	//	*MutateOperation_FeedItemOperation
	//	*MutateOperation_FeedItemTargetOperation
	//	*MutateOperation_FeedMappingOperation
	//	*MutateOperation_FeedOperation
	//	*MutateOperation_LabelOperation
	//	*MutateOperation_MediaFileOperation
	//	*MutateOperation_RemarketingActionOperation
	//	*MutateOperation_SharedCriterionOperation
	//	*MutateOperation_SharedSetOperation
	//	*MutateOperation_UserListOperation
	Operation isMutateOperation_Operation `protobuf_oneof:"operation"`
}

func (x *MutateOperation) Reset() {
	*x = MutateOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateOperation) ProtoMessage() {}

func (x *MutateOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateOperation.ProtoReflect.Descriptor instead.
func (*MutateOperation) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescGZIP(), []int{5}
}

func (m *MutateOperation) GetOperation() isMutateOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *MutateOperation) GetAdGroupAdLabelOperation() *AdGroupAdLabelOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AdGroupAdLabelOperation); ok {
		return x.AdGroupAdLabelOperation
	}
	return nil
}

func (x *MutateOperation) GetAdGroupAdOperation() *AdGroupAdOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AdGroupAdOperation); ok {
		return x.AdGroupAdOperation
	}
	return nil
}

func (x *MutateOperation) GetAdGroupBidModifierOperation() *AdGroupBidModifierOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AdGroupBidModifierOperation); ok {
		return x.AdGroupBidModifierOperation
	}
	return nil
}

func (x *MutateOperation) GetAdGroupCriterionLabelOperation() *AdGroupCriterionLabelOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AdGroupCriterionLabelOperation); ok {
		return x.AdGroupCriterionLabelOperation
	}
	return nil
}

func (x *MutateOperation) GetAdGroupCriterionOperation() *AdGroupCriterionOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AdGroupCriterionOperation); ok {
		return x.AdGroupCriterionOperation
	}
	return nil
}

func (x *MutateOperation) GetAdGroupExtensionSettingOperation() *AdGroupExtensionSettingOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AdGroupExtensionSettingOperation); ok {
		return x.AdGroupExtensionSettingOperation
	}
	return nil
}

func (x *MutateOperation) GetAdGroupFeedOperation() *AdGroupFeedOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AdGroupFeedOperation); ok {
		return x.AdGroupFeedOperation
	}
	return nil
}

func (x *MutateOperation) GetAdGroupLabelOperation() *AdGroupLabelOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AdGroupLabelOperation); ok {
		return x.AdGroupLabelOperation
	}
	return nil
}

func (x *MutateOperation) GetAdGroupOperation() *AdGroupOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AdGroupOperation); ok {
		return x.AdGroupOperation
	}
	return nil
}

func (x *MutateOperation) GetAdParameterOperation() *AdParameterOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AdParameterOperation); ok {
		return x.AdParameterOperation
	}
	return nil
}

func (x *MutateOperation) GetAssetOperation() *AssetOperation {
	if x, ok := x.GetOperation().(*MutateOperation_AssetOperation); ok {
		return x.AssetOperation
	}
	return nil
}

func (x *MutateOperation) GetBiddingStrategyOperation() *BiddingStrategyOperation {
	if x, ok := x.GetOperation().(*MutateOperation_BiddingStrategyOperation); ok {
		return x.BiddingStrategyOperation
	}
	return nil
}

func (x *MutateOperation) GetCampaignBidModifierOperation() *CampaignBidModifierOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CampaignBidModifierOperation); ok {
		return x.CampaignBidModifierOperation
	}
	return nil
}

func (x *MutateOperation) GetCampaignBudgetOperation() *CampaignBudgetOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CampaignBudgetOperation); ok {
		return x.CampaignBudgetOperation
	}
	return nil
}

func (x *MutateOperation) GetCampaignCriterionOperation() *CampaignCriterionOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CampaignCriterionOperation); ok {
		return x.CampaignCriterionOperation
	}
	return nil
}

func (x *MutateOperation) GetCampaignDraftOperation() *CampaignDraftOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CampaignDraftOperation); ok {
		return x.CampaignDraftOperation
	}
	return nil
}

func (x *MutateOperation) GetCampaignExperimentOperation() *CampaignExperimentOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CampaignExperimentOperation); ok {
		return x.CampaignExperimentOperation
	}
	return nil
}

func (x *MutateOperation) GetCampaignExtensionSettingOperation() *CampaignExtensionSettingOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CampaignExtensionSettingOperation); ok {
		return x.CampaignExtensionSettingOperation
	}
	return nil
}

func (x *MutateOperation) GetCampaignFeedOperation() *CampaignFeedOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CampaignFeedOperation); ok {
		return x.CampaignFeedOperation
	}
	return nil
}

func (x *MutateOperation) GetCampaignLabelOperation() *CampaignLabelOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CampaignLabelOperation); ok {
		return x.CampaignLabelOperation
	}
	return nil
}

func (x *MutateOperation) GetCampaignOperation() *CampaignOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CampaignOperation); ok {
		return x.CampaignOperation
	}
	return nil
}

func (x *MutateOperation) GetCampaignSharedSetOperation() *CampaignSharedSetOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CampaignSharedSetOperation); ok {
		return x.CampaignSharedSetOperation
	}
	return nil
}

func (x *MutateOperation) GetConversionActionOperation() *ConversionActionOperation {
	if x, ok := x.GetOperation().(*MutateOperation_ConversionActionOperation); ok {
		return x.ConversionActionOperation
	}
	return nil
}

func (x *MutateOperation) GetCustomerExtensionSettingOperation() *CustomerExtensionSettingOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CustomerExtensionSettingOperation); ok {
		return x.CustomerExtensionSettingOperation
	}
	return nil
}

func (x *MutateOperation) GetCustomerFeedOperation() *CustomerFeedOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CustomerFeedOperation); ok {
		return x.CustomerFeedOperation
	}
	return nil
}

func (x *MutateOperation) GetCustomerLabelOperation() *CustomerLabelOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CustomerLabelOperation); ok {
		return x.CustomerLabelOperation
	}
	return nil
}

func (x *MutateOperation) GetCustomerNegativeCriterionOperation() *CustomerNegativeCriterionOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CustomerNegativeCriterionOperation); ok {
		return x.CustomerNegativeCriterionOperation
	}
	return nil
}

func (x *MutateOperation) GetCustomerOperation() *CustomerOperation {
	if x, ok := x.GetOperation().(*MutateOperation_CustomerOperation); ok {
		return x.CustomerOperation
	}
	return nil
}

func (x *MutateOperation) GetExtensionFeedItemOperation() *ExtensionFeedItemOperation {
	if x, ok := x.GetOperation().(*MutateOperation_ExtensionFeedItemOperation); ok {
		return x.ExtensionFeedItemOperation
	}
	return nil
}

func (x *MutateOperation) GetFeedItemOperation() *FeedItemOperation {
	if x, ok := x.GetOperation().(*MutateOperation_FeedItemOperation); ok {
		return x.FeedItemOperation
	}
	return nil
}

func (x *MutateOperation) GetFeedItemTargetOperation() *FeedItemTargetOperation {
	if x, ok := x.GetOperation().(*MutateOperation_FeedItemTargetOperation); ok {
		return x.FeedItemTargetOperation
	}
	return nil
}

func (x *MutateOperation) GetFeedMappingOperation() *FeedMappingOperation {
	if x, ok := x.GetOperation().(*MutateOperation_FeedMappingOperation); ok {
		return x.FeedMappingOperation
	}
	return nil
}

func (x *MutateOperation) GetFeedOperation() *FeedOperation {
	if x, ok := x.GetOperation().(*MutateOperation_FeedOperation); ok {
		return x.FeedOperation
	}
	return nil
}

func (x *MutateOperation) GetLabelOperation() *LabelOperation {
	if x, ok := x.GetOperation().(*MutateOperation_LabelOperation); ok {
		return x.LabelOperation
	}
	return nil
}

func (x *MutateOperation) GetMediaFileOperation() *MediaFileOperation {
	if x, ok := x.GetOperation().(*MutateOperation_MediaFileOperation); ok {
		return x.MediaFileOperation
	}
	return nil
}

func (x *MutateOperation) GetRemarketingActionOperation() *RemarketingActionOperation {
	if x, ok := x.GetOperation().(*MutateOperation_RemarketingActionOperation); ok {
		return x.RemarketingActionOperation
	}
	return nil
}

func (x *MutateOperation) GetSharedCriterionOperation() *SharedCriterionOperation {
	if x, ok := x.GetOperation().(*MutateOperation_SharedCriterionOperation); ok {
		return x.SharedCriterionOperation
	}
	return nil
}

func (x *MutateOperation) GetSharedSetOperation() *SharedSetOperation {
	if x, ok := x.GetOperation().(*MutateOperation_SharedSetOperation); ok {
		return x.SharedSetOperation
	}
	return nil
}

func (x *MutateOperation) GetUserListOperation() *UserListOperation {
	if x, ok := x.GetOperation().(*MutateOperation_UserListOperation); ok {
		return x.UserListOperation
	}
	return nil
}

type isMutateOperation_Operation interface {
	isMutateOperation_Operation()
}

type MutateOperation_AdGroupAdLabelOperation struct {
	// An ad group ad label mutate operation.
	AdGroupAdLabelOperation *AdGroupAdLabelOperation `protobuf:"bytes,17,opt,name=ad_group_ad_label_operation,json=adGroupAdLabelOperation,proto3,oneof"`
}

type MutateOperation_AdGroupAdOperation struct {
	// An ad group ad mutate operation.
	AdGroupAdOperation *AdGroupAdOperation `protobuf:"bytes,1,opt,name=ad_group_ad_operation,json=adGroupAdOperation,proto3,oneof"`
}

type MutateOperation_AdGroupBidModifierOperation struct {
	// An ad group bid modifier mutate operation.
	AdGroupBidModifierOperation *AdGroupBidModifierOperation `protobuf:"bytes,2,opt,name=ad_group_bid_modifier_operation,json=adGroupBidModifierOperation,proto3,oneof"`
}

type MutateOperation_AdGroupCriterionLabelOperation struct {
	// An ad group criterion label mutate operation.
	AdGroupCriterionLabelOperation *AdGroupCriterionLabelOperation `protobuf:"bytes,18,opt,name=ad_group_criterion_label_operation,json=adGroupCriterionLabelOperation,proto3,oneof"`
}

type MutateOperation_AdGroupCriterionOperation struct {
	// An ad group criterion mutate operation.
	AdGroupCriterionOperation *AdGroupCriterionOperation `protobuf:"bytes,3,opt,name=ad_group_criterion_operation,json=adGroupCriterionOperation,proto3,oneof"`
}

type MutateOperation_AdGroupExtensionSettingOperation struct {
	// An ad group extension setting mutate operation.
	AdGroupExtensionSettingOperation *AdGroupExtensionSettingOperation `protobuf:"bytes,19,opt,name=ad_group_extension_setting_operation,json=adGroupExtensionSettingOperation,proto3,oneof"`
}

type MutateOperation_AdGroupFeedOperation struct {
	// An ad group feed mutate operation.
	AdGroupFeedOperation *AdGroupFeedOperation `protobuf:"bytes,20,opt,name=ad_group_feed_operation,json=adGroupFeedOperation,proto3,oneof"`
}

type MutateOperation_AdGroupLabelOperation struct {
	// An ad group label mutate operation.
	AdGroupLabelOperation *AdGroupLabelOperation `protobuf:"bytes,21,opt,name=ad_group_label_operation,json=adGroupLabelOperation,proto3,oneof"`
}

type MutateOperation_AdGroupOperation struct {
	// An ad group mutate operation.
	AdGroupOperation *AdGroupOperation `protobuf:"bytes,5,opt,name=ad_group_operation,json=adGroupOperation,proto3,oneof"`
}

type MutateOperation_AdParameterOperation struct {
	// An ad parameter mutate operation.
	AdParameterOperation *AdParameterOperation `protobuf:"bytes,22,opt,name=ad_parameter_operation,json=adParameterOperation,proto3,oneof"`
}

type MutateOperation_AssetOperation struct {
	// An asset mutate operation.
	AssetOperation *AssetOperation `protobuf:"bytes,23,opt,name=asset_operation,json=assetOperation,proto3,oneof"`
}

type MutateOperation_BiddingStrategyOperation struct {
	// A bidding strategy mutate operation.
	BiddingStrategyOperation *BiddingStrategyOperation `protobuf:"bytes,6,opt,name=bidding_strategy_operation,json=biddingStrategyOperation,proto3,oneof"`
}

type MutateOperation_CampaignBidModifierOperation struct {
	// A campaign bid modifier mutate operation.
	CampaignBidModifierOperation *CampaignBidModifierOperation `protobuf:"bytes,7,opt,name=campaign_bid_modifier_operation,json=campaignBidModifierOperation,proto3,oneof"`
}

type MutateOperation_CampaignBudgetOperation struct {
	// A campaign budget mutate operation.
	CampaignBudgetOperation *CampaignBudgetOperation `protobuf:"bytes,8,opt,name=campaign_budget_operation,json=campaignBudgetOperation,proto3,oneof"`
}

type MutateOperation_CampaignCriterionOperation struct {
	// A campaign criterion mutate operation.
	CampaignCriterionOperation *CampaignCriterionOperation `protobuf:"bytes,13,opt,name=campaign_criterion_operation,json=campaignCriterionOperation,proto3,oneof"`
}

type MutateOperation_CampaignDraftOperation struct {
	// A campaign draft mutate operation.
	CampaignDraftOperation *CampaignDraftOperation `protobuf:"bytes,24,opt,name=campaign_draft_operation,json=campaignDraftOperation,proto3,oneof"`
}

type MutateOperation_CampaignExperimentOperation struct {
	// A campaign experiment mutate operation.
	CampaignExperimentOperation *CampaignExperimentOperation `protobuf:"bytes,25,opt,name=campaign_experiment_operation,json=campaignExperimentOperation,proto3,oneof"`
}

type MutateOperation_CampaignExtensionSettingOperation struct {
	// A campaign extension setting mutate operation.
	CampaignExtensionSettingOperation *CampaignExtensionSettingOperation `protobuf:"bytes,26,opt,name=campaign_extension_setting_operation,json=campaignExtensionSettingOperation,proto3,oneof"`
}

type MutateOperation_CampaignFeedOperation struct {
	// A campaign feed mutate operation.
	CampaignFeedOperation *CampaignFeedOperation `protobuf:"bytes,27,opt,name=campaign_feed_operation,json=campaignFeedOperation,proto3,oneof"`
}

type MutateOperation_CampaignLabelOperation struct {
	// A campaign label mutate operation.
	CampaignLabelOperation *CampaignLabelOperation `protobuf:"bytes,28,opt,name=campaign_label_operation,json=campaignLabelOperation,proto3,oneof"`
}

type MutateOperation_CampaignOperation struct {
	// A campaign mutate operation.
	CampaignOperation *CampaignOperation `protobuf:"bytes,10,opt,name=campaign_operation,json=campaignOperation,proto3,oneof"`
}

type MutateOperation_CampaignSharedSetOperation struct {
	// A campaign shared set mutate operation.
	CampaignSharedSetOperation *CampaignSharedSetOperation `protobuf:"bytes,11,opt,name=campaign_shared_set_operation,json=campaignSharedSetOperation,proto3,oneof"`
}

type MutateOperation_ConversionActionOperation struct {
	// A conversion action mutate operation.
	ConversionActionOperation *ConversionActionOperation `protobuf:"bytes,12,opt,name=conversion_action_operation,json=conversionActionOperation,proto3,oneof"`
}

type MutateOperation_CustomerExtensionSettingOperation struct {
	// A customer extension setting mutate operation.
	CustomerExtensionSettingOperation *CustomerExtensionSettingOperation `protobuf:"bytes,30,opt,name=customer_extension_setting_operation,json=customerExtensionSettingOperation,proto3,oneof"`
}

type MutateOperation_CustomerFeedOperation struct {
	// A customer feed mutate operation.
	CustomerFeedOperation *CustomerFeedOperation `protobuf:"bytes,31,opt,name=customer_feed_operation,json=customerFeedOperation,proto3,oneof"`
}

type MutateOperation_CustomerLabelOperation struct {
	// A customer label mutate operation.
	CustomerLabelOperation *CustomerLabelOperation `protobuf:"bytes,32,opt,name=customer_label_operation,json=customerLabelOperation,proto3,oneof"`
}

type MutateOperation_CustomerNegativeCriterionOperation struct {
	// A customer negative criterion mutate operation.
	CustomerNegativeCriterionOperation *CustomerNegativeCriterionOperation `protobuf:"bytes,34,opt,name=customer_negative_criterion_operation,json=customerNegativeCriterionOperation,proto3,oneof"`
}

type MutateOperation_CustomerOperation struct {
	// A customer mutate operation.
	CustomerOperation *CustomerOperation `protobuf:"bytes,35,opt,name=customer_operation,json=customerOperation,proto3,oneof"`
}

type MutateOperation_ExtensionFeedItemOperation struct {
	// An extension feed item mutate operation.
	ExtensionFeedItemOperation *ExtensionFeedItemOperation `protobuf:"bytes,36,opt,name=extension_feed_item_operation,json=extensionFeedItemOperation,proto3,oneof"`
}

type MutateOperation_FeedItemOperation struct {
	// A feed item mutate operation.
	FeedItemOperation *FeedItemOperation `protobuf:"bytes,37,opt,name=feed_item_operation,json=feedItemOperation,proto3,oneof"`
}

type MutateOperation_FeedItemTargetOperation struct {
	// A feed item target mutate operation.
	FeedItemTargetOperation *FeedItemTargetOperation `protobuf:"bytes,38,opt,name=feed_item_target_operation,json=feedItemTargetOperation,proto3,oneof"`
}

type MutateOperation_FeedMappingOperation struct {
	// A feed mapping mutate operation.
	FeedMappingOperation *FeedMappingOperation `protobuf:"bytes,39,opt,name=feed_mapping_operation,json=feedMappingOperation,proto3,oneof"`
}

type MutateOperation_FeedOperation struct {
	// A feed mutate operation.
	FeedOperation *FeedOperation `protobuf:"bytes,40,opt,name=feed_operation,json=feedOperation,proto3,oneof"`
}

type MutateOperation_LabelOperation struct {
	// A label mutate operation.
	LabelOperation *LabelOperation `protobuf:"bytes,41,opt,name=label_operation,json=labelOperation,proto3,oneof"`
}

type MutateOperation_MediaFileOperation struct {
	// A media file mutate operation.
	MediaFileOperation *MediaFileOperation `protobuf:"bytes,42,opt,name=media_file_operation,json=mediaFileOperation,proto3,oneof"`
}

type MutateOperation_RemarketingActionOperation struct {
	// A remarketing action mutate operation.
	RemarketingActionOperation *RemarketingActionOperation `protobuf:"bytes,43,opt,name=remarketing_action_operation,json=remarketingActionOperation,proto3,oneof"`
}

type MutateOperation_SharedCriterionOperation struct {
	// A shared criterion mutate operation.
	SharedCriterionOperation *SharedCriterionOperation `protobuf:"bytes,14,opt,name=shared_criterion_operation,json=sharedCriterionOperation,proto3,oneof"`
}

type MutateOperation_SharedSetOperation struct {
	// A shared set mutate operation.
	SharedSetOperation *SharedSetOperation `protobuf:"bytes,15,opt,name=shared_set_operation,json=sharedSetOperation,proto3,oneof"`
}

type MutateOperation_UserListOperation struct {
	// A user list mutate operation.
	UserListOperation *UserListOperation `protobuf:"bytes,16,opt,name=user_list_operation,json=userListOperation,proto3,oneof"`
}

func (*MutateOperation_AdGroupAdLabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupAdOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupBidModifierOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupCriterionLabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupExtensionSettingOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupFeedOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupLabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdParameterOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AssetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_BiddingStrategyOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignBidModifierOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignBudgetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignDraftOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignExperimentOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignExtensionSettingOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignFeedOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignLabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignSharedSetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_ConversionActionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CustomerExtensionSettingOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CustomerFeedOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CustomerLabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CustomerNegativeCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CustomerOperation) isMutateOperation_Operation() {}

func (*MutateOperation_ExtensionFeedItemOperation) isMutateOperation_Operation() {}

func (*MutateOperation_FeedItemOperation) isMutateOperation_Operation() {}

func (*MutateOperation_FeedItemTargetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_FeedMappingOperation) isMutateOperation_Operation() {}

func (*MutateOperation_FeedOperation) isMutateOperation_Operation() {}

func (*MutateOperation_LabelOperation) isMutateOperation_Operation() {}

func (*MutateOperation_MediaFileOperation) isMutateOperation_Operation() {}

func (*MutateOperation_RemarketingActionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_SharedCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_SharedSetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_UserListOperation) isMutateOperation_Operation() {}

// Response message for the resource mutate.
type MutateOperationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The mutate response.
	//
	// Types that are assignable to Response:
	//	*MutateOperationResponse_AdGroupAdLabelResult
	//	*MutateOperationResponse_AdGroupAdResult
	//	*MutateOperationResponse_AdGroupBidModifierResult
	//	*MutateOperationResponse_AdGroupCriterionLabelResult
	//	*MutateOperationResponse_AdGroupCriterionResult
	//	*MutateOperationResponse_AdGroupExtensionSettingResult
	//	*MutateOperationResponse_AdGroupFeedResult
	//	*MutateOperationResponse_AdGroupLabelResult
	//	*MutateOperationResponse_AdGroupResult
	//	*MutateOperationResponse_AdParameterResult
	//	*MutateOperationResponse_AssetResult
	//	*MutateOperationResponse_BiddingStrategyResult
	//	*MutateOperationResponse_CampaignBidModifierResult
	//	*MutateOperationResponse_CampaignBudgetResult
	//	*MutateOperationResponse_CampaignCriterionResult
	//	*MutateOperationResponse_CampaignDraftResult
	//	*MutateOperationResponse_CampaignExperimentResult
	//	*MutateOperationResponse_CampaignExtensionSettingResult
	//	*MutateOperationResponse_CampaignFeedResult
	//	*MutateOperationResponse_CampaignLabelResult
	//	*MutateOperationResponse_CampaignResult
	//	*MutateOperationResponse_CampaignSharedSetResult
	//	*MutateOperationResponse_ConversionActionResult
	//	*MutateOperationResponse_CustomerExtensionSettingResult
	//	*MutateOperationResponse_CustomerFeedResult
	//	*MutateOperationResponse_CustomerLabelResult
	//	*MutateOperationResponse_CustomerNegativeCriterionResult
	//	*MutateOperationResponse_CustomerResult
	//	*MutateOperationResponse_ExtensionFeedItemResult
	//	*MutateOperationResponse_FeedItemResult
	//	*MutateOperationResponse_FeedItemTargetResult
	//	*MutateOperationResponse_FeedMappingResult
	//	*MutateOperationResponse_FeedResult
	//	*MutateOperationResponse_LabelResult
	//	*MutateOperationResponse_MediaFileResult
	//	*MutateOperationResponse_RemarketingActionResult
	//	*MutateOperationResponse_SharedCriterionResult
	//	*MutateOperationResponse_SharedSetResult
	//	*MutateOperationResponse_UserListResult
	Response isMutateOperationResponse_Response `protobuf_oneof:"response"`
}

func (x *MutateOperationResponse) Reset() {
	*x = MutateOperationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MutateOperationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateOperationResponse) ProtoMessage() {}

func (x *MutateOperationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateOperationResponse.ProtoReflect.Descriptor instead.
func (*MutateOperationResponse) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescGZIP(), []int{6}
}

func (m *MutateOperationResponse) GetResponse() isMutateOperationResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *MutateOperationResponse) GetAdGroupAdLabelResult() *MutateAdGroupAdLabelResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AdGroupAdLabelResult); ok {
		return x.AdGroupAdLabelResult
	}
	return nil
}

func (x *MutateOperationResponse) GetAdGroupAdResult() *MutateAdGroupAdResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AdGroupAdResult); ok {
		return x.AdGroupAdResult
	}
	return nil
}

func (x *MutateOperationResponse) GetAdGroupBidModifierResult() *MutateAdGroupBidModifierResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AdGroupBidModifierResult); ok {
		return x.AdGroupBidModifierResult
	}
	return nil
}

func (x *MutateOperationResponse) GetAdGroupCriterionLabelResult() *MutateAdGroupCriterionLabelResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AdGroupCriterionLabelResult); ok {
		return x.AdGroupCriterionLabelResult
	}
	return nil
}

func (x *MutateOperationResponse) GetAdGroupCriterionResult() *MutateAdGroupCriterionResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AdGroupCriterionResult); ok {
		return x.AdGroupCriterionResult
	}
	return nil
}

func (x *MutateOperationResponse) GetAdGroupExtensionSettingResult() *MutateAdGroupExtensionSettingResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AdGroupExtensionSettingResult); ok {
		return x.AdGroupExtensionSettingResult
	}
	return nil
}

func (x *MutateOperationResponse) GetAdGroupFeedResult() *MutateAdGroupFeedResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AdGroupFeedResult); ok {
		return x.AdGroupFeedResult
	}
	return nil
}

func (x *MutateOperationResponse) GetAdGroupLabelResult() *MutateAdGroupLabelResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AdGroupLabelResult); ok {
		return x.AdGroupLabelResult
	}
	return nil
}

func (x *MutateOperationResponse) GetAdGroupResult() *MutateAdGroupResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AdGroupResult); ok {
		return x.AdGroupResult
	}
	return nil
}

func (x *MutateOperationResponse) GetAdParameterResult() *MutateAdParameterResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AdParameterResult); ok {
		return x.AdParameterResult
	}
	return nil
}

func (x *MutateOperationResponse) GetAssetResult() *MutateAssetResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_AssetResult); ok {
		return x.AssetResult
	}
	return nil
}

func (x *MutateOperationResponse) GetBiddingStrategyResult() *MutateBiddingStrategyResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_BiddingStrategyResult); ok {
		return x.BiddingStrategyResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCampaignBidModifierResult() *MutateCampaignBidModifierResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CampaignBidModifierResult); ok {
		return x.CampaignBidModifierResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCampaignBudgetResult() *MutateCampaignBudgetResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CampaignBudgetResult); ok {
		return x.CampaignBudgetResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCampaignCriterionResult() *MutateCampaignCriterionResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CampaignCriterionResult); ok {
		return x.CampaignCriterionResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCampaignDraftResult() *MutateCampaignDraftResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CampaignDraftResult); ok {
		return x.CampaignDraftResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCampaignExperimentResult() *MutateCampaignExperimentResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CampaignExperimentResult); ok {
		return x.CampaignExperimentResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCampaignExtensionSettingResult() *MutateCampaignExtensionSettingResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CampaignExtensionSettingResult); ok {
		return x.CampaignExtensionSettingResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCampaignFeedResult() *MutateCampaignFeedResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CampaignFeedResult); ok {
		return x.CampaignFeedResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCampaignLabelResult() *MutateCampaignLabelResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CampaignLabelResult); ok {
		return x.CampaignLabelResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCampaignResult() *MutateCampaignResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CampaignResult); ok {
		return x.CampaignResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCampaignSharedSetResult() *MutateCampaignSharedSetResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CampaignSharedSetResult); ok {
		return x.CampaignSharedSetResult
	}
	return nil
}

func (x *MutateOperationResponse) GetConversionActionResult() *MutateConversionActionResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_ConversionActionResult); ok {
		return x.ConversionActionResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCustomerExtensionSettingResult() *MutateCustomerExtensionSettingResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CustomerExtensionSettingResult); ok {
		return x.CustomerExtensionSettingResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCustomerFeedResult() *MutateCustomerFeedResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CustomerFeedResult); ok {
		return x.CustomerFeedResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCustomerLabelResult() *MutateCustomerLabelResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CustomerLabelResult); ok {
		return x.CustomerLabelResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCustomerNegativeCriterionResult() *MutateCustomerNegativeCriteriaResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CustomerNegativeCriterionResult); ok {
		return x.CustomerNegativeCriterionResult
	}
	return nil
}

func (x *MutateOperationResponse) GetCustomerResult() *MutateCustomerResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_CustomerResult); ok {
		return x.CustomerResult
	}
	return nil
}

func (x *MutateOperationResponse) GetExtensionFeedItemResult() *MutateExtensionFeedItemResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_ExtensionFeedItemResult); ok {
		return x.ExtensionFeedItemResult
	}
	return nil
}

func (x *MutateOperationResponse) GetFeedItemResult() *MutateFeedItemResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_FeedItemResult); ok {
		return x.FeedItemResult
	}
	return nil
}

func (x *MutateOperationResponse) GetFeedItemTargetResult() *MutateFeedItemTargetResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_FeedItemTargetResult); ok {
		return x.FeedItemTargetResult
	}
	return nil
}

func (x *MutateOperationResponse) GetFeedMappingResult() *MutateFeedMappingResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_FeedMappingResult); ok {
		return x.FeedMappingResult
	}
	return nil
}

func (x *MutateOperationResponse) GetFeedResult() *MutateFeedResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_FeedResult); ok {
		return x.FeedResult
	}
	return nil
}

func (x *MutateOperationResponse) GetLabelResult() *MutateLabelResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_LabelResult); ok {
		return x.LabelResult
	}
	return nil
}

func (x *MutateOperationResponse) GetMediaFileResult() *MutateMediaFileResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_MediaFileResult); ok {
		return x.MediaFileResult
	}
	return nil
}

func (x *MutateOperationResponse) GetRemarketingActionResult() *MutateRemarketingActionResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_RemarketingActionResult); ok {
		return x.RemarketingActionResult
	}
	return nil
}

func (x *MutateOperationResponse) GetSharedCriterionResult() *MutateSharedCriterionResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_SharedCriterionResult); ok {
		return x.SharedCriterionResult
	}
	return nil
}

func (x *MutateOperationResponse) GetSharedSetResult() *MutateSharedSetResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_SharedSetResult); ok {
		return x.SharedSetResult
	}
	return nil
}

func (x *MutateOperationResponse) GetUserListResult() *MutateUserListResult {
	if x, ok := x.GetResponse().(*MutateOperationResponse_UserListResult); ok {
		return x.UserListResult
	}
	return nil
}

type isMutateOperationResponse_Response interface {
	isMutateOperationResponse_Response()
}

type MutateOperationResponse_AdGroupAdLabelResult struct {
	// The result for the ad group ad label mutate.
	AdGroupAdLabelResult *MutateAdGroupAdLabelResult `protobuf:"bytes,17,opt,name=ad_group_ad_label_result,json=adGroupAdLabelResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupAdResult struct {
	// The result for the ad group ad mutate.
	AdGroupAdResult *MutateAdGroupAdResult `protobuf:"bytes,1,opt,name=ad_group_ad_result,json=adGroupAdResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupBidModifierResult struct {
	// The result for the ad group bid modifier mutate.
	AdGroupBidModifierResult *MutateAdGroupBidModifierResult `protobuf:"bytes,2,opt,name=ad_group_bid_modifier_result,json=adGroupBidModifierResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupCriterionLabelResult struct {
	// The result for the ad group criterion label mutate.
	AdGroupCriterionLabelResult *MutateAdGroupCriterionLabelResult `protobuf:"bytes,18,opt,name=ad_group_criterion_label_result,json=adGroupCriterionLabelResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupCriterionResult struct {
	// The result for the ad group criterion mutate.
	AdGroupCriterionResult *MutateAdGroupCriterionResult `protobuf:"bytes,3,opt,name=ad_group_criterion_result,json=adGroupCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupExtensionSettingResult struct {
	// The result for the ad group extension setting mutate.
	AdGroupExtensionSettingResult *MutateAdGroupExtensionSettingResult `protobuf:"bytes,19,opt,name=ad_group_extension_setting_result,json=adGroupExtensionSettingResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupFeedResult struct {
	// The result for the ad group feed mutate.
	AdGroupFeedResult *MutateAdGroupFeedResult `protobuf:"bytes,20,opt,name=ad_group_feed_result,json=adGroupFeedResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupLabelResult struct {
	// The result for the ad group label mutate.
	AdGroupLabelResult *MutateAdGroupLabelResult `protobuf:"bytes,21,opt,name=ad_group_label_result,json=adGroupLabelResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupResult struct {
	// The result for the ad group mutate.
	AdGroupResult *MutateAdGroupResult `protobuf:"bytes,5,opt,name=ad_group_result,json=adGroupResult,proto3,oneof"`
}

type MutateOperationResponse_AdParameterResult struct {
	// The result for the ad parameter mutate.
	AdParameterResult *MutateAdParameterResult `protobuf:"bytes,22,opt,name=ad_parameter_result,json=adParameterResult,proto3,oneof"`
}

type MutateOperationResponse_AssetResult struct {
	// The result for the asset mutate.
	AssetResult *MutateAssetResult `protobuf:"bytes,23,opt,name=asset_result,json=assetResult,proto3,oneof"`
}

type MutateOperationResponse_BiddingStrategyResult struct {
	// The result for the bidding strategy mutate.
	BiddingStrategyResult *MutateBiddingStrategyResult `protobuf:"bytes,6,opt,name=bidding_strategy_result,json=biddingStrategyResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignBidModifierResult struct {
	// The result for the campaign bid modifier mutate.
	CampaignBidModifierResult *MutateCampaignBidModifierResult `protobuf:"bytes,7,opt,name=campaign_bid_modifier_result,json=campaignBidModifierResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignBudgetResult struct {
	// The result for the campaign budget mutate.
	CampaignBudgetResult *MutateCampaignBudgetResult `protobuf:"bytes,8,opt,name=campaign_budget_result,json=campaignBudgetResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignCriterionResult struct {
	// The result for the campaign criterion mutate.
	CampaignCriterionResult *MutateCampaignCriterionResult `protobuf:"bytes,13,opt,name=campaign_criterion_result,json=campaignCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignDraftResult struct {
	// The result for the campaign draft mutate.
	CampaignDraftResult *MutateCampaignDraftResult `protobuf:"bytes,24,opt,name=campaign_draft_result,json=campaignDraftResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignExperimentResult struct {
	// The result for the campaign experiment mutate.
	CampaignExperimentResult *MutateCampaignExperimentResult `protobuf:"bytes,25,opt,name=campaign_experiment_result,json=campaignExperimentResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignExtensionSettingResult struct {
	// The result for the campaign extension setting mutate.
	CampaignExtensionSettingResult *MutateCampaignExtensionSettingResult `protobuf:"bytes,26,opt,name=campaign_extension_setting_result,json=campaignExtensionSettingResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignFeedResult struct {
	// The result for the campaign feed mutate.
	CampaignFeedResult *MutateCampaignFeedResult `protobuf:"bytes,27,opt,name=campaign_feed_result,json=campaignFeedResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignLabelResult struct {
	// The result for the campaign label mutate.
	CampaignLabelResult *MutateCampaignLabelResult `protobuf:"bytes,28,opt,name=campaign_label_result,json=campaignLabelResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignResult struct {
	// The result for the campaign mutate.
	CampaignResult *MutateCampaignResult `protobuf:"bytes,10,opt,name=campaign_result,json=campaignResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignSharedSetResult struct {
	// The result for the campaign shared set mutate.
	CampaignSharedSetResult *MutateCampaignSharedSetResult `protobuf:"bytes,11,opt,name=campaign_shared_set_result,json=campaignSharedSetResult,proto3,oneof"`
}

type MutateOperationResponse_ConversionActionResult struct {
	// The result for the conversion action mutate.
	ConversionActionResult *MutateConversionActionResult `protobuf:"bytes,12,opt,name=conversion_action_result,json=conversionActionResult,proto3,oneof"`
}

type MutateOperationResponse_CustomerExtensionSettingResult struct {
	// The result for the customer extension setting mutate.
	CustomerExtensionSettingResult *MutateCustomerExtensionSettingResult `protobuf:"bytes,30,opt,name=customer_extension_setting_result,json=customerExtensionSettingResult,proto3,oneof"`
}

type MutateOperationResponse_CustomerFeedResult struct {
	// The result for the customer feed mutate.
	CustomerFeedResult *MutateCustomerFeedResult `protobuf:"bytes,31,opt,name=customer_feed_result,json=customerFeedResult,proto3,oneof"`
}

type MutateOperationResponse_CustomerLabelResult struct {
	// The result for the customer label mutate.
	CustomerLabelResult *MutateCustomerLabelResult `protobuf:"bytes,32,opt,name=customer_label_result,json=customerLabelResult,proto3,oneof"`
}

type MutateOperationResponse_CustomerNegativeCriterionResult struct {
	// The result for the customer negative criterion mutate.
	CustomerNegativeCriterionResult *MutateCustomerNegativeCriteriaResult `protobuf:"bytes,34,opt,name=customer_negative_criterion_result,json=customerNegativeCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_CustomerResult struct {
	// The result for the customer mutate.
	CustomerResult *MutateCustomerResult `protobuf:"bytes,35,opt,name=customer_result,json=customerResult,proto3,oneof"`
}

type MutateOperationResponse_ExtensionFeedItemResult struct {
	// The result for the extension feed item mutate.
	ExtensionFeedItemResult *MutateExtensionFeedItemResult `protobuf:"bytes,36,opt,name=extension_feed_item_result,json=extensionFeedItemResult,proto3,oneof"`
}

type MutateOperationResponse_FeedItemResult struct {
	// The result for the feed item mutate.
	FeedItemResult *MutateFeedItemResult `protobuf:"bytes,37,opt,name=feed_item_result,json=feedItemResult,proto3,oneof"`
}

type MutateOperationResponse_FeedItemTargetResult struct {
	// The result for the feed item target mutate.
	FeedItemTargetResult *MutateFeedItemTargetResult `protobuf:"bytes,38,opt,name=feed_item_target_result,json=feedItemTargetResult,proto3,oneof"`
}

type MutateOperationResponse_FeedMappingResult struct {
	// The result for the feed mapping mutate.
	FeedMappingResult *MutateFeedMappingResult `protobuf:"bytes,39,opt,name=feed_mapping_result,json=feedMappingResult,proto3,oneof"`
}

type MutateOperationResponse_FeedResult struct {
	// The result for the feed mutate.
	FeedResult *MutateFeedResult `protobuf:"bytes,40,opt,name=feed_result,json=feedResult,proto3,oneof"`
}

type MutateOperationResponse_LabelResult struct {
	// The result for the label mutate.
	LabelResult *MutateLabelResult `protobuf:"bytes,41,opt,name=label_result,json=labelResult,proto3,oneof"`
}

type MutateOperationResponse_MediaFileResult struct {
	// The result for the media file mutate.
	MediaFileResult *MutateMediaFileResult `protobuf:"bytes,42,opt,name=media_file_result,json=mediaFileResult,proto3,oneof"`
}

type MutateOperationResponse_RemarketingActionResult struct {
	// The result for the remarketing action mutate.
	RemarketingActionResult *MutateRemarketingActionResult `protobuf:"bytes,43,opt,name=remarketing_action_result,json=remarketingActionResult,proto3,oneof"`
}

type MutateOperationResponse_SharedCriterionResult struct {
	// The result for the shared criterion mutate.
	SharedCriterionResult *MutateSharedCriterionResult `protobuf:"bytes,14,opt,name=shared_criterion_result,json=sharedCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_SharedSetResult struct {
	// The result for the shared set mutate.
	SharedSetResult *MutateSharedSetResult `protobuf:"bytes,15,opt,name=shared_set_result,json=sharedSetResult,proto3,oneof"`
}

type MutateOperationResponse_UserListResult struct {
	// The result for the user list mutate.
	UserListResult *MutateUserListResult `protobuf:"bytes,16,opt,name=user_list_result,json=userListResult,proto3,oneof"`
}

func (*MutateOperationResponse_AdGroupAdLabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupAdResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupBidModifierResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupCriterionLabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupExtensionSettingResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupFeedResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupLabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdParameterResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AssetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_BiddingStrategyResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignBidModifierResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignBudgetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignDraftResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignExperimentResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignExtensionSettingResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignFeedResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignLabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignSharedSetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_ConversionActionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CustomerExtensionSettingResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CustomerFeedResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CustomerLabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CustomerNegativeCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CustomerResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_ExtensionFeedItemResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_FeedItemResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_FeedItemTargetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_FeedMappingResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_FeedResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_LabelResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_MediaFileResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_RemarketingActionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_SharedCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_SharedSetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_UserListResult) isMutateOperationResponse_Response() {}

var File_google_ads_googleads_v2_services_google_ads_service_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v2_services_google_ads_service_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x2c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x73, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x62, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x61, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x67, 0x65,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x62, 0x69,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x64, 0x72, 0x61, 0x66, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x76, 0x69,
	0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x64, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x4b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x64, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73, 0x5f,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x76, 0x69, 0x65, 0x77,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64,
	0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65,
	0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74,
	0x65, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x66, 0x65, 0x65, 0x64,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x66, 0x65, 0x65, 0x64,
	0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x67, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x67, 0x65, 0x6f,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x68, 0x6f,
	0x74, 0x65, 0x6c, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e,
	0x5f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x6b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x45, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x6e, 0x65, 0x67,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6c, 0x61, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6d, 0x6f, 0x62,
	0x69, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x45,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x70, 0x61, 0x69, 0x64, 0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62,
	0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x76, 0x69,
	0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x40, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61,
	0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x47,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x49, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x64,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67,
	0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d,
	0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x5f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32,
	0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x49, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x4a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65, 0x65, 0x64,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f,
	0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x66, 0x65,
	0x65, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2f, 0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63,
	0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe8, 0x01,
	0x0a, 0x16, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x19,
	0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65,
	0x74, 0x75, 0x72, 0x6e, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x72, 0x6f, 0x77,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x6f, 0x77, 0x22, 0xc7, 0x02, 0x0a, 0x17, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x52, 0x6f, 0x77, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x4f, 0x0a, 0x0b, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x72, 0x6f, 0x77,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x52, 0x6f, 0x77, 0x52, 0x0a, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52,
	0x6f, 0x77, 0x22, 0xc5, 0x4a, 0x0a, 0x0c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x52, 0x6f, 0x77, 0x12, 0x57, 0x0a, 0x0e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x62,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x0d, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x70, 0x0a, 0x17,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x70,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x15, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x45,
	0x0a, 0x08, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x07, 0x61, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x4c, 0x0a, 0x0b, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x61, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x52, 0x09, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x41, 0x64, 0x12, 0x6a, 0x0a, 0x16, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x61, 0x64, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x83, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x41, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x12, 0x61, 0x64, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x5c, 0x0a, 0x11, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x18, 0x78, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x0e, 0x61,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x6b, 0x0a,
	0x16, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x39, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63,
	0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x13, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x75,
	0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x68, 0x0a, 0x15, 0x61, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x52, 0x12, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x12, 0x61, 0x0a, 0x12, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x12, 0x71, 0x0a, 0x18, 0x61, 0x64, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x18, 0x79, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x52, 0x15, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x80, 0x01, 0x0a, 0x1d, 0x61,
	0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x6e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x1a, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x6f, 0x6e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x77, 0x0a,
	0x1a, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x70, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x17, 0x61,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x52, 0x0a, 0x0d, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x18, 0x43, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x65, 0x65, 0x64, 0x52, 0x0b, 0x61,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x65, 0x65, 0x64, 0x12, 0x55, 0x0a, 0x0e, 0x61, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x73, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x52, 0x0c, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x12, 0x64, 0x0a, 0x13, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x73, 0x69,
	0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x6b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x53, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0c, 0x61, 0x64, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x82, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x41, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0b,
	0x61, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x0e, 0x61,
	0x67, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x30, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x67, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x12, 0x5b, 0x0a, 0x10, 0x61, 0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x59, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x41, 0x64, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x0e, 0x61, 0x64, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x5a, 0x0a, 0x0f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x18, 0x5b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x0e, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x3e, 0x0a, 0x05, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x18, 0x69, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x61, 0x73, 0x73, 0x65, 0x74, 0x12, 0x5d, 0x0a, 0x10, 0x62,
	0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x0f, 0x62, 0x69, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x54, 0x0a, 0x0d, 0x62, 0x69,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x18, 0x29, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x42, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74,
	0x75, 0x70, 0x52, 0x0c, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x75, 0x70,
	0x12, 0x5a, 0x0a, 0x0f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75, 0x64,
	0x67, 0x65, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x0e, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x12, 0x47, 0x0a, 0x08,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x52, 0x08, 0x63, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x12, 0x6d, 0x0a, 0x16, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x45, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x14,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x6a, 0x0a, 0x15, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x1a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x13, 0x63, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x12, 0x63, 0x0a, 0x12, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x63, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x6f, 0x6e, 0x52, 0x11, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x43, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x6f, 0x6e, 0x12, 0x82, 0x01, 0x0a, 0x1d, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x6f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x6f, 0x6e, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1b, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e,
	0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x0e, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x18, 0x31, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x44,
	0x72, 0x61, 0x66, 0x74, 0x52, 0x0d, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x44, 0x72,
	0x61, 0x66, 0x74, 0x12, 0x66, 0x0a, 0x13, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x54, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x79, 0x0a, 0x1a, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x71, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x18, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x54, 0x0a, 0x0d, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x18, 0x3f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x52, 0x0c,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x12, 0x57, 0x0a, 0x0e,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x6c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x0d, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x64, 0x0a, 0x13, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x1e, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x53, 0x65, 0x74, 0x52, 0x11, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x53, 0x65, 0x74, 0x12, 0x5d, 0x0a, 0x10, 0x63,
	0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x18,
	0x42, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x72, 0x72, 0x69, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x52, 0x0f, 0x63, 0x61, 0x72, 0x72, 0x69,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x12, 0x54, 0x0a, 0x0d, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x25, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x60, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x76, 0x69, 0x65, 0x77,
	0x18, 0x7a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x6c, 0x69, 0x63, 0x6b,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x5a, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65,
	0x73, 0x74, 0x18, 0x68, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x08, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x08, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x12, 0x6a, 0x0a, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x3d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x13, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x67, 0x0a, 0x14, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x3e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x5a, 0x0a, 0x0f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x18, 0x46, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x12, 0x79, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x18, 0x72, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x18, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x12, 0x54, 0x0a, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x66, 0x65, 0x65,
	0x64, 0x18, 0x40, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x52, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x12, 0x57, 0x0a, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x7c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x52, 0x0d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12,
	0x7c, 0x0a, 0x1b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x18, 0x58,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x6f, 0x6e, 0x52, 0x19, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4e, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a,
	0x15, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x76, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x13, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x67, 0x0a, 0x14, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x56, 0x69, 0x65, 0x77, 0x52, 0x12,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x56, 0x69,
	0x65, 0x77, 0x12, 0x55, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x18, 0x84, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x44,
	0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0c, 0x64, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x8e, 0x01, 0x0a, 0x23, 0x64, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x64, 0x73,
	0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x6a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x56, 0x69, 0x65, 0x77, 0x52, 0x1e, 0x64, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x73, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x56, 0x69, 0x65, 0x77, 0x12, 0x78, 0x0a, 0x1a, 0x65, 0x78,
	0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x80, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x61, 0x67, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x17, 0x65, 0x78, 0x70,
	0x61, 0x6e, 0x64, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x67, 0x65,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x64, 0x0a, 0x13, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x55, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46,
	0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x11, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x3b, 0x0a, 0x04, 0x66, 0x65,
	0x65, 0x64, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x65, 0x65,
	0x64, 0x52, 0x04, 0x66, 0x65, 0x65, 0x64, 0x12, 0x48, 0x0a, 0x09, 0x66, 0x65, 0x65, 0x64, 0x5f,
	0x69, 0x74, 0x65, 0x6d, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x46,
	0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x08, 0x66, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65,
	0x6d, 0x12, 0x5b, 0x0a, 0x10, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x74, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x0e,
	0x66, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x51,
	0x0a, 0x0c, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x3a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x66, 0x65, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x12, 0x6a, 0x0a, 0x15, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x61, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x52, 0x13, 0x66, 0x65, 0x65, 0x64, 0x50, 0x6c,
	0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x12, 0x4e, 0x0a,
	0x0b, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x28, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x56, 0x69, 0x65, 0x77, 0x12, 0x64, 0x0a,
	0x13, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x74, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x47,
	0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74,
	0x52, 0x11, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0f, 0x67, 0x65, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69,
	0x63, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x7d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x47, 0x65, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x0e, 0x67, 0x65, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x67, 0x0a, 0x14, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x77, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x12, 0x5b, 0x0a, 0x10, 0x68, 0x6f, 0x74, 0x65,
	0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x33, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0e, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x56, 0x69, 0x65, 0x77, 0x12, 0x6d, 0x0a, 0x16, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x70,
	0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x47, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x50,
	0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x14,
	0x68, 0x6f, 0x74, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x51, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f,
	0x76, 0x69, 0x65, 0x77, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0b, 0x6b, 0x65, 0x79, 0x77,
	0x6f, 0x72, 0x64, 0x56, 0x69, 0x65, 0x77, 0x12, 0x51, 0x0a, 0x0c, 0x6b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0b, 0x6b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x6a, 0x0a, 0x15, 0x6b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65,
	0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x52, 0x13, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x12, 0x80, 0x01, 0x0a, 0x1d, 0x6b, 0x65, 0x79, 0x77, 0x6f,
	0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4e, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x1a, 0x6b,
	0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x68, 0x0a, 0x15, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x12, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x64, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x67, 0x0a, 0x14, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x24, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6c, 0x61,
	0x6e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x12, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72,
	0x64, 0x50, 0x6c, 0x61, 0x6e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x3e, 0x0a, 0x05,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x5e, 0x0a, 0x11,
	0x6c, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x7e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4c, 0x61, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x61, 0x67, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0f, 0x6c, 0x61, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x50, 0x61, 0x67, 0x65, 0x56, 0x69, 0x65, 0x77, 0x12, 0x60, 0x0a, 0x11,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x18, 0x37, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x52, 0x10, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x12, 0x54,
	0x0a, 0x0d, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x7b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x6d, 0x0a, 0x16, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x35,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65, 0x77, 0x52, 0x14, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x4b, 0x0a, 0x0a, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x65, 0x64, 0x69,
	0x61, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x09, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x46, 0x69, 0x6c, 0x65,
	0x12, 0x7d, 0x0a, 0x1c, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74,
	0x18, 0x57, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x6f, 0x62, 0x69, 0x6c,
	0x65, 0x41, 0x70, 0x70, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x74, 0x52, 0x19, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x41, 0x70, 0x70, 0x43,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x12,
	0x6d, 0x0a, 0x16, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x18, 0x62, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x52, 0x14, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x12, 0x4b,
	0x0a, 0x0a, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x7f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62,
	0x52, 0x09, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x8c, 0x01, 0x0a, 0x21,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x18, 0x56, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x52, 0x1e, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x12, 0x7f, 0x0a, 0x1d, 0x70, 0x61,
	0x69, 0x64, 0x5f, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x81, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x50, 0x61, 0x69, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x63, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x19, 0x70, 0x61, 0x69, 0x64, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x56, 0x69, 0x65, 0x77, 0x12, 0x67, 0x0a, 0x14, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x50, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x56, 0x69, 0x65, 0x77, 0x12, 0x8c, 0x01, 0x0a, 0x21, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x18, 0x6d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x69, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x52, 0x1e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x69, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x12, 0x61, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x36, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x56, 0x69, 0x65, 0x77, 0x12, 0x59, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5b, 0x0a, 0x10, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65, 0x72, 0x6d,
	0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x44, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x56, 0x69, 0x65, 0x77, 0x52, 0x0e,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x56, 0x69, 0x65, 0x77, 0x12, 0x5d,
	0x0a, 0x10, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x6f, 0x6e, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x53, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a,
	0x0a, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x1b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x53, 0x65, 0x74, 0x52,
	0x09, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x53, 0x65, 0x74, 0x12, 0x76, 0x0a, 0x19, 0x73, 0x68,
	0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x75, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x69, 0x65, 0x77, 0x52, 0x17, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x69,
	0x65, 0x77, 0x12, 0x4b, 0x0a, 0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x76, 0x69, 0x65, 0x77,
	0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x56, 0x69, 0x65, 0x77, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x56, 0x69, 0x65, 0x77, 0x12,
	0x54, 0x0a, 0x0d, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74,
	0x18, 0x3b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x55, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x12,
	0x62, 0x0a, 0x12, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x87, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x65,
	0x77, 0x52, 0x10, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x63, 0x0a, 0x12, 0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69,
	0x6e, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x0e, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x74, 0x52, 0x0d, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x12, 0x3e, 0x0a, 0x05, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x52, 0x05, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x12, 0x41, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x44, 0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xf1, 0x01, 0x0a, 0x16, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x63, 0x0a, 0x11, 0x6d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xda,
	0x01, 0x0a, 0x17, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41,
	0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x15, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x13, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x77, 0x0a, 0x1a, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x52, 0x18, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x22, 0xfd, 0x24, 0x0a, 0x0f,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x79, 0x0a, 0x1b, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41,
	0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x17, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x15, 0x61, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x12, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x85, 0x01, 0x0a, 0x1f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x5f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x1b, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8e, 0x01,
	0x0a, 0x22, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1e,
	0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7e,
	0x0a, 0x1c, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x19, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x94,
	0x01, 0x0a, 0x24, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x20, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6f, 0x0a, 0x17, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x46, 0x65, 0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x14, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x65, 0x65, 0x64, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x18, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x15, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x12, 0x61, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x61, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6e,
	0x0a, 0x16, 0x61, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x41, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x61, 0x64, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b,
	0x0a, 0x0f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7a, 0x0a, 0x1a, 0x62,
	0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x5f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x18, 0x62,
	0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x87, 0x01, 0x0a, 0x1f, 0x63, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x69, 0x64,
	0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x1c, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x69, 0x64,
	0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x77, 0x0a, 0x19, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x17, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x80, 0x01, 0x0a, 0x1c, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f,
	0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x43, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x1a, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x74, 0x0a,
	0x18, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x44, 0x72, 0x61, 0x66, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x16, 0x63, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x44, 0x72, 0x61, 0x66, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x83, 0x01, 0x0a, 0x1d, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e,
	0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1b, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x96, 0x01, 0x0a, 0x24, 0x63, 0x61,
	0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x21, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x71, 0x0a, 0x17, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x66,
	0x65, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46,
	0x65, 0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x15,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x74, 0x0a, 0x18, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x16, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x12, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x81, 0x01, 0x0a, 0x1d, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x53, 0x65, 0x74, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1a, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x53, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7d, 0x0a, 0x1b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x19, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x96, 0x01, 0x0a, 0x24, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x21, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x65, 0x72, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x71, 0x0a,
	0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x74, 0x0a, 0x18, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x20, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x16,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x99, 0x01, 0x0a, 0x25, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x22,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x81, 0x01, 0x0a, 0x1d, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d,
	0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65,
	0x64, 0x49, 0x74, 0x65, 0x6d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x1a, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x49,
	0x74, 0x65, 0x6d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x65, 0x0a, 0x13,
	0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x65, 0x65,
	0x64, 0x49, 0x74, 0x65, 0x6d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x11, 0x66, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x78, 0x0a, 0x1a, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x49,
	0x74, 0x65, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x17, 0x66, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6e, 0x0a,
	0x16, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x46, 0x65, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x66, 0x65, 0x65, 0x64, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a,
	0x0e, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x66, 0x65, 0x65, 0x64, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x0f, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x68, 0x0a, 0x14, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x2a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x46, 0x69, 0x6c, 0x65, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x12, 0x6d, 0x65, 0x64, 0x69,
	0x61, 0x46, 0x69, 0x6c, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x80,
	0x01, 0x0a, 0x1c, 0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x52, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65,
	0x74, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x1a, 0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69,
	0x6e, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x7a, 0x0a, 0x1a, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x72, 0x69, 0x74,
	0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x43,
	0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x18, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x43, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x68, 0x0a,
	0x14, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x53, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x12, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x53, 0x65, 0x74, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x65, 0x0a, 0x13, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x6c, 0x69, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x75, 0x73, 0x65,
	0x72, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0b,
	0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x24, 0x0a, 0x17,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x76, 0x0a, 0x18, 0x61, 0x64, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x14, 0x61, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x41, 0x64, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x66, 0x0a, 0x12, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x61, 0x64, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41, 0x64, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x41,
	0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x1c, 0x61, 0x64, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42,
	0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x48, 0x00, 0x52, 0x18, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x69, 0x64, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x8b, 0x01, 0x0a,
	0x1f, 0x61, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72,
	0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x1b, 0x61,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7b, 0x0a, 0x19, 0x61, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72,
	0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52,
	0x16, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x91, 0x01, 0x0a, 0x21, 0x61, 0x64, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x41, 0x64, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x1d, 0x61, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x6c, 0x0a, 0x14, 0x61,
	0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x11, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x46,
	0x65, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x6f, 0x0a, 0x15, 0x61, 0x64, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x41, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x12, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5f, 0x0a, 0x0f, 0x61, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x41, 0x64, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x64,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x6b, 0x0a, 0x13, 0x61,
	0x64, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x41, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x11, 0x61, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x58, 0x0a, 0x0c, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x77, 0x0a, 0x17, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x42, 0x69, 0x64,
	0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x48, 0x00, 0x52, 0x15, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x84, 0x01, 0x0a, 0x1c,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62, 0x69, 0x64, 0x5f, 0x6d, 0x6f, 0x64,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x19, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x42, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x74, 0x0a, 0x16, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x62,
	0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x48, 0x00, 0x52, 0x14, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x42, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7d, 0x0a, 0x19, 0x63, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x43, 0x72, 0x69,
	0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x17,
	0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x71, 0x0a, 0x15, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x5f, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x44, 0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x13, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x44,
	0x72, 0x61, 0x66, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x80, 0x01, 0x0a, 0x1a, 0x63,
	0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x18, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x93, 0x01,
	0x0a, 0x21, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x1e, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x6e, 0x0a, 0x14, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x66, 0x65, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x1b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52,
	0x12, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x71, 0x0a, 0x15, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x1c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70,
	0x61, 0x69, 0x67, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48,
	0x00, 0x52, 0x13, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69,
	0x67, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x61, 0x6d, 0x70, 0x61,
	0x69, 0x67, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7e, 0x0a, 0x1a, 0x63, 0x61, 0x6d,
	0x70, 0x61, 0x69, 0x67, 0x6e, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00,
	0x52, 0x17, 0x63, 0x61, 0x6d, 0x70, 0x61, 0x69, 0x67, 0x6e, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64,
	0x53, 0x65, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7a, 0x0a, 0x18, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x16, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x93, 0x01, 0x0a, 0x21, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x1e, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x65, 0x72, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x6e, 0x0a, 0x14, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x46, 0x65, 0x65, 0x64, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x71, 0x0a, 0x15, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x13, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x95,
	0x01, 0x0a, 0x22, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x6e, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4e, 0x65, 0x67,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x1f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x4e,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x61, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7e, 0x0a, 0x1a, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00,
	0x52, 0x17, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x49,
	0x74, 0x65, 0x6d, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x62, 0x0a, 0x10, 0x66, 0x65, 0x65,
	0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x25, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65,
	0x64, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x66,
	0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x75, 0x0a,
	0x17, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x14,
	0x66, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x6b, 0x0a, 0x13, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x27, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x4d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x11,
	0x66, 0x65, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x55, 0x0a, 0x0b, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x66, 0x65,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x58, 0x0a, 0x0c, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x65, 0x0a, 0x11, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x46, 0x69, 0x6c, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x46,
	0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7d, 0x0a, 0x19, 0x72, 0x65, 0x6d,
	0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e,
	0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52,
	0x17, 0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x77, 0x0a, 0x17, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x15, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x43, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x65, 0x0a, 0x11, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x53,
	0x65, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x62, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x72,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x75, 0x73,
	0x65, 0x72, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x0a, 0x0a, 0x08,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xd9, 0x03, 0x0a, 0x10, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xcc, 0x01,
	0x0a, 0x06, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x33, 0x22, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x3d, 0x2a, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0xd8, 0x01, 0x0a,
	0x06, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74,
	0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x33, 0x22, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x3d, 0x2a, 0x7d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x6d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x1d, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x5f, 0x69, 0x64, 0x2c, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x1b, 0xca, 0x41, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x42, 0xfc, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x32, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x42, 0x15, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x2e, 0x56, 0x32,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x5c, 0x56, 0x32, 0x5c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0xea, 0x02, 0x24, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x32, 0x3a, 0x3a, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescData = file_google_ads_googleads_v2_services_google_ads_service_proto_rawDesc
)

func file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescData)
	})
	return file_google_ads_googleads_v2_services_google_ads_service_proto_rawDescData
}

var file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_ads_googleads_v2_services_google_ads_service_proto_goTypes = []interface{}{
	(*SearchGoogleAdsRequest)(nil),                   // 0: google.ads.googleads.v2.services.SearchGoogleAdsRequest
	(*SearchGoogleAdsResponse)(nil),                  // 1: google.ads.googleads.v2.services.SearchGoogleAdsResponse
	(*GoogleAdsRow)(nil),                             // 2: google.ads.googleads.v2.services.GoogleAdsRow
	(*MutateGoogleAdsRequest)(nil),                   // 3: google.ads.googleads.v2.services.MutateGoogleAdsRequest
	(*MutateGoogleAdsResponse)(nil),                  // 4: google.ads.googleads.v2.services.MutateGoogleAdsResponse
	(*MutateOperation)(nil),                          // 5: google.ads.googleads.v2.services.MutateOperation
	(*MutateOperationResponse)(nil),                  // 6: google.ads.googleads.v2.services.MutateOperationResponse
	(*fieldmaskpb.FieldMask)(nil),                    // 7: google.protobuf.FieldMask
	(*resources.AccountBudget)(nil),                  // 8: google.ads.googleads.v2.resources.AccountBudget
	(*resources.AccountBudgetProposal)(nil),          // 9: google.ads.googleads.v2.resources.AccountBudgetProposal
	(*resources.AdGroup)(nil),                        // 10: google.ads.googleads.v2.resources.AdGroup
	(*resources.AdGroupAd)(nil),                      // 11: google.ads.googleads.v2.resources.AdGroupAd
	(*resources.AdGroupAdAssetView)(nil),             // 12: google.ads.googleads.v2.resources.AdGroupAdAssetView
	(*resources.AdGroupAdLabel)(nil),                 // 13: google.ads.googleads.v2.resources.AdGroupAdLabel
	(*resources.AdGroupAudienceView)(nil),            // 14: google.ads.googleads.v2.resources.AdGroupAudienceView
	(*resources.AdGroupBidModifier)(nil),             // 15: google.ads.googleads.v2.resources.AdGroupBidModifier
	(*resources.AdGroupCriterion)(nil),               // 16: google.ads.googleads.v2.resources.AdGroupCriterion
	(*resources.AdGroupCriterionLabel)(nil),          // 17: google.ads.googleads.v2.resources.AdGroupCriterionLabel
	(*resources.AdGroupCriterionSimulation)(nil),     // 18: google.ads.googleads.v2.resources.AdGroupCriterionSimulation
	(*resources.AdGroupExtensionSetting)(nil),        // 19: google.ads.googleads.v2.resources.AdGroupExtensionSetting
	(*resources.AdGroupFeed)(nil),                    // 20: google.ads.googleads.v2.resources.AdGroupFeed
	(*resources.AdGroupLabel)(nil),                   // 21: google.ads.googleads.v2.resources.AdGroupLabel
	(*resources.AdGroupSimulation)(nil),              // 22: google.ads.googleads.v2.resources.AdGroupSimulation
	(*resources.AdParameter)(nil),                    // 23: google.ads.googleads.v2.resources.AdParameter
	(*resources.AgeRangeView)(nil),                   // 24: google.ads.googleads.v2.resources.AgeRangeView
	(*resources.AdScheduleView)(nil),                 // 25: google.ads.googleads.v2.resources.AdScheduleView
	(*resources.DomainCategory)(nil),                 // 26: google.ads.googleads.v2.resources.DomainCategory
	(*resources.Asset)(nil),                          // 27: google.ads.googleads.v2.resources.Asset
	(*resources.BiddingStrategy)(nil),                // 28: google.ads.googleads.v2.resources.BiddingStrategy
	(*resources.BillingSetup)(nil),                   // 29: google.ads.googleads.v2.resources.BillingSetup
	(*resources.CampaignBudget)(nil),                 // 30: google.ads.googleads.v2.resources.CampaignBudget
	(*resources.Campaign)(nil),                       // 31: google.ads.googleads.v2.resources.Campaign
	(*resources.CampaignAudienceView)(nil),           // 32: google.ads.googleads.v2.resources.CampaignAudienceView
	(*resources.CampaignBidModifier)(nil),            // 33: google.ads.googleads.v2.resources.CampaignBidModifier
	(*resources.CampaignCriterion)(nil),              // 34: google.ads.googleads.v2.resources.CampaignCriterion
	(*resources.CampaignCriterionSimulation)(nil),    // 35: google.ads.googleads.v2.resources.CampaignCriterionSimulation
	(*resources.CampaignDraft)(nil),                  // 36: google.ads.googleads.v2.resources.CampaignDraft
	(*resources.CampaignExperiment)(nil),             // 37: google.ads.googleads.v2.resources.CampaignExperiment
	(*resources.CampaignExtensionSetting)(nil),       // 38: google.ads.googleads.v2.resources.CampaignExtensionSetting
	(*resources.CampaignFeed)(nil),                   // 39: google.ads.googleads.v2.resources.CampaignFeed
	(*resources.CampaignLabel)(nil),                  // 40: google.ads.googleads.v2.resources.CampaignLabel
	(*resources.CampaignSharedSet)(nil),              // 41: google.ads.googleads.v2.resources.CampaignSharedSet
	(*resources.CarrierConstant)(nil),                // 42: google.ads.googleads.v2.resources.CarrierConstant
	(*resources.ChangeStatus)(nil),                   // 43: google.ads.googleads.v2.resources.ChangeStatus
	(*resources.ConversionAction)(nil),               // 44: google.ads.googleads.v2.resources.ConversionAction
	(*resources.ClickView)(nil),                      // 45: google.ads.googleads.v2.resources.ClickView
	(*resources.CustomInterest)(nil),                 // 46: google.ads.googleads.v2.resources.CustomInterest
	(*resources.Customer)(nil),                       // 47: google.ads.googleads.v2.resources.Customer
	(*resources.CustomerManagerLink)(nil),            // 48: google.ads.googleads.v2.resources.CustomerManagerLink
	(*resources.CustomerClientLink)(nil),             // 49: google.ads.googleads.v2.resources.CustomerClientLink
	(*resources.CustomerClient)(nil),                 // 50: google.ads.googleads.v2.resources.CustomerClient
	(*resources.CustomerExtensionSetting)(nil),       // 51: google.ads.googleads.v2.resources.CustomerExtensionSetting
	(*resources.CustomerFeed)(nil),                   // 52: google.ads.googleads.v2.resources.CustomerFeed
	(*resources.CustomerLabel)(nil),                  // 53: google.ads.googleads.v2.resources.CustomerLabel
	(*resources.CustomerNegativeCriterion)(nil),      // 54: google.ads.googleads.v2.resources.CustomerNegativeCriterion
	(*resources.DetailPlacementView)(nil),            // 55: google.ads.googleads.v2.resources.DetailPlacementView
	(*resources.DisplayKeywordView)(nil),             // 56: google.ads.googleads.v2.resources.DisplayKeywordView
	(*resources.DistanceView)(nil),                   // 57: google.ads.googleads.v2.resources.DistanceView
	(*resources.DynamicSearchAdsSearchTermView)(nil), // 58: google.ads.googleads.v2.resources.DynamicSearchAdsSearchTermView
	(*resources.ExpandedLandingPageView)(nil),        // 59: google.ads.googleads.v2.resources.ExpandedLandingPageView
	(*resources.ExtensionFeedItem)(nil),              // 60: google.ads.googleads.v2.resources.ExtensionFeedItem
	(*resources.Feed)(nil),                           // 61: google.ads.googleads.v2.resources.Feed
	(*resources.FeedItem)(nil),                       // 62: google.ads.googleads.v2.resources.FeedItem
	(*resources.FeedItemTarget)(nil),                 // 63: google.ads.googleads.v2.resources.FeedItemTarget
	(*resources.FeedMapping)(nil),                    // 64: google.ads.googleads.v2.resources.FeedMapping
	(*resources.FeedPlaceholderView)(nil),            // 65: google.ads.googleads.v2.resources.FeedPlaceholderView
	(*resources.GenderView)(nil),                     // 66: google.ads.googleads.v2.resources.GenderView
	(*resources.GeoTargetConstant)(nil),              // 67: google.ads.googleads.v2.resources.GeoTargetConstant
	(*resources.GeographicView)(nil),                 // 68: google.ads.googleads.v2.resources.GeographicView
	(*resources.GroupPlacementView)(nil),             // 69: google.ads.googleads.v2.resources.GroupPlacementView
	(*resources.HotelGroupView)(nil),                 // 70: google.ads.googleads.v2.resources.HotelGroupView
	(*resources.HotelPerformanceView)(nil),           // 71: google.ads.googleads.v2.resources.HotelPerformanceView
	(*resources.KeywordView)(nil),                    // 72: google.ads.googleads.v2.resources.KeywordView
	(*resources.KeywordPlan)(nil),                    // 73: google.ads.googleads.v2.resources.KeywordPlan
	(*resources.KeywordPlanCampaign)(nil),            // 74: google.ads.googleads.v2.resources.KeywordPlanCampaign
	(*resources.KeywordPlanNegativeKeyword)(nil),     // 75: google.ads.googleads.v2.resources.KeywordPlanNegativeKeyword
	(*resources.KeywordPlanAdGroup)(nil),             // 76: google.ads.googleads.v2.resources.KeywordPlanAdGroup
	(*resources.KeywordPlanKeyword)(nil),             // 77: google.ads.googleads.v2.resources.KeywordPlanKeyword
	(*resources.Label)(nil),                          // 78: google.ads.googleads.v2.resources.Label
	(*resources.LandingPageView)(nil),                // 79: google.ads.googleads.v2.resources.LandingPageView
	(*resources.LanguageConstant)(nil),               // 80: google.ads.googleads.v2.resources.LanguageConstant
	(*resources.LocationView)(nil),                   // 81: google.ads.googleads.v2.resources.LocationView
	(*resources.ManagedPlacementView)(nil),           // 82: google.ads.googleads.v2.resources.ManagedPlacementView
	(*resources.MediaFile)(nil),                      // 83: google.ads.googleads.v2.resources.MediaFile
	(*resources.MobileAppCategoryConstant)(nil),      // 84: google.ads.googleads.v2.resources.MobileAppCategoryConstant
	(*resources.MobileDeviceConstant)(nil),           // 85: google.ads.googleads.v2.resources.MobileDeviceConstant
	(*resources.MutateJob)(nil),                      // 86: google.ads.googleads.v2.resources.MutateJob
	(*resources.OperatingSystemVersionConstant)(nil), // 87: google.ads.googleads.v2.resources.OperatingSystemVersionConstant
	(*resources.PaidOrganicSearchTermView)(nil),      // 88: google.ads.googleads.v2.resources.PaidOrganicSearchTermView
	(*resources.ParentalStatusView)(nil),             // 89: google.ads.googleads.v2.resources.ParentalStatusView
	(*resources.ProductBiddingCategoryConstant)(nil), // 90: google.ads.googleads.v2.resources.ProductBiddingCategoryConstant
	(*resources.ProductGroupView)(nil),               // 91: google.ads.googleads.v2.resources.ProductGroupView
	(*resources.Recommendation)(nil),                 // 92: google.ads.googleads.v2.resources.Recommendation
	(*resources.SearchTermView)(nil),                 // 93: google.ads.googleads.v2.resources.SearchTermView
	(*resources.SharedCriterion)(nil),                // 94: google.ads.googleads.v2.resources.SharedCriterion
	(*resources.SharedSet)(nil),                      // 95: google.ads.googleads.v2.resources.SharedSet
	(*resources.ShoppingPerformanceView)(nil),        // 96: google.ads.googleads.v2.resources.ShoppingPerformanceView
	(*resources.TopicView)(nil),                      // 97: google.ads.googleads.v2.resources.TopicView
	(*resources.UserInterest)(nil),                   // 98: google.ads.googleads.v2.resources.UserInterest
	(*resources.UserList)(nil),                       // 99: google.ads.googleads.v2.resources.UserList
	(*resources.UserLocationView)(nil),               // 100: google.ads.googleads.v2.resources.UserLocationView
	(*resources.RemarketingAction)(nil),              // 101: google.ads.googleads.v2.resources.RemarketingAction
	(*resources.TopicConstant)(nil),                  // 102: google.ads.googleads.v2.resources.TopicConstant
	(*resources.Video)(nil),                          // 103: google.ads.googleads.v2.resources.Video
	(*common.Metrics)(nil),                           // 104: google.ads.googleads.v2.common.Metrics
	(*common.Segments)(nil),                          // 105: google.ads.googleads.v2.common.Segments
	(*status.Status)(nil),                            // 106: google.rpc.Status
	(*AdGroupAdLabelOperation)(nil),                  // 107: google.ads.googleads.v2.services.AdGroupAdLabelOperation
	(*AdGroupAdOperation)(nil),                       // 108: google.ads.googleads.v2.services.AdGroupAdOperation
	(*AdGroupBidModifierOperation)(nil),              // 109: google.ads.googleads.v2.services.AdGroupBidModifierOperation
	(*AdGroupCriterionLabelOperation)(nil),           // 110: google.ads.googleads.v2.services.AdGroupCriterionLabelOperation
	(*AdGroupCriterionOperation)(nil),                // 111: google.ads.googleads.v2.services.AdGroupCriterionOperation
	(*AdGroupExtensionSettingOperation)(nil),         // 112: google.ads.googleads.v2.services.AdGroupExtensionSettingOperation
	(*AdGroupFeedOperation)(nil),                     // 113: google.ads.googleads.v2.services.AdGroupFeedOperation
	(*AdGroupLabelOperation)(nil),                    // 114: google.ads.googleads.v2.services.AdGroupLabelOperation
	(*AdGroupOperation)(nil),                         // 115: google.ads.googleads.v2.services.AdGroupOperation
	(*AdParameterOperation)(nil),                     // 116: google.ads.googleads.v2.services.AdParameterOperation
	(*AssetOperation)(nil),                           // 117: google.ads.googleads.v2.services.AssetOperation
	(*BiddingStrategyOperation)(nil),                 // 118: google.ads.googleads.v2.services.BiddingStrategyOperation
	(*CampaignBidModifierOperation)(nil),             // 119: google.ads.googleads.v2.services.CampaignBidModifierOperation
	(*CampaignBudgetOperation)(nil),                  // 120: google.ads.googleads.v2.services.CampaignBudgetOperation
	(*CampaignCriterionOperation)(nil),               // 121: google.ads.googleads.v2.services.CampaignCriterionOperation
	(*CampaignDraftOperation)(nil),                   // 122: google.ads.googleads.v2.services.CampaignDraftOperation
	(*CampaignExperimentOperation)(nil),              // 123: google.ads.googleads.v2.services.CampaignExperimentOperation
	(*CampaignExtensionSettingOperation)(nil),        // 124: google.ads.googleads.v2.services.CampaignExtensionSettingOperation
	(*CampaignFeedOperation)(nil),                    // 125: google.ads.googleads.v2.services.CampaignFeedOperation
	(*CampaignLabelOperation)(nil),                   // 126: google.ads.googleads.v2.services.CampaignLabelOperation
	(*CampaignOperation)(nil),                        // 127: google.ads.googleads.v2.services.CampaignOperation
	(*CampaignSharedSetOperation)(nil),               // 128: google.ads.googleads.v2.services.CampaignSharedSetOperation
	(*ConversionActionOperation)(nil),                // 129: google.ads.googleads.v2.services.ConversionActionOperation
	(*CustomerExtensionSettingOperation)(nil),        // 130: google.ads.googleads.v2.services.CustomerExtensionSettingOperation
	(*CustomerFeedOperation)(nil),                    // 131: google.ads.googleads.v2.services.CustomerFeedOperation
	(*CustomerLabelOperation)(nil),                   // 132: google.ads.googleads.v2.services.CustomerLabelOperation
	(*CustomerNegativeCriterionOperation)(nil),       // 133: google.ads.googleads.v2.services.CustomerNegativeCriterionOperation
	(*CustomerOperation)(nil),                        // 134: google.ads.googleads.v2.services.CustomerOperation
	(*ExtensionFeedItemOperation)(nil),               // 135: google.ads.googleads.v2.services.ExtensionFeedItemOperation
	(*FeedItemOperation)(nil),                        // 136: google.ads.googleads.v2.services.FeedItemOperation
	(*FeedItemTargetOperation)(nil),                  // 137: google.ads.googleads.v2.services.FeedItemTargetOperation
	(*FeedMappingOperation)(nil),                     // 138: google.ads.googleads.v2.services.FeedMappingOperation
	(*FeedOperation)(nil),                            // 139: google.ads.googleads.v2.services.FeedOperation
	(*LabelOperation)(nil),                           // 140: google.ads.googleads.v2.services.LabelOperation
	(*MediaFileOperation)(nil),                       // 141: google.ads.googleads.v2.services.MediaFileOperation
	(*RemarketingActionOperation)(nil),               // 142: google.ads.googleads.v2.services.RemarketingActionOperation
	(*SharedCriterionOperation)(nil),                 // 143: google.ads.googleads.v2.services.SharedCriterionOperation
	(*SharedSetOperation)(nil),                       // 144: google.ads.googleads.v2.services.SharedSetOperation
	(*UserListOperation)(nil),                        // 145: google.ads.googleads.v2.services.UserListOperation
	(*MutateAdGroupAdLabelResult)(nil),               // 146: google.ads.googleads.v2.services.MutateAdGroupAdLabelResult
	(*MutateAdGroupAdResult)(nil),                    // 147: google.ads.googleads.v2.services.MutateAdGroupAdResult
	(*MutateAdGroupBidModifierResult)(nil),           // 148: google.ads.googleads.v2.services.MutateAdGroupBidModifierResult
	(*MutateAdGroupCriterionLabelResult)(nil),        // 149: google.ads.googleads.v2.services.MutateAdGroupCriterionLabelResult
	(*MutateAdGroupCriterionResult)(nil),             // 150: google.ads.googleads.v2.services.MutateAdGroupCriterionResult
	(*MutateAdGroupExtensionSettingResult)(nil),      // 151: google.ads.googleads.v2.services.MutateAdGroupExtensionSettingResult
	(*MutateAdGroupFeedResult)(nil),                  // 152: google.ads.googleads.v2.services.MutateAdGroupFeedResult
	(*MutateAdGroupLabelResult)(nil),                 // 153: google.ads.googleads.v2.services.MutateAdGroupLabelResult
	(*MutateAdGroupResult)(nil),                      // 154: google.ads.googleads.v2.services.MutateAdGroupResult
	(*MutateAdParameterResult)(nil),                  // 155: google.ads.googleads.v2.services.MutateAdParameterResult
	(*MutateAssetResult)(nil),                        // 156: google.ads.googleads.v2.services.MutateAssetResult
	(*MutateBiddingStrategyResult)(nil),              // 157: google.ads.googleads.v2.services.MutateBiddingStrategyResult
	(*MutateCampaignBidModifierResult)(nil),          // 158: google.ads.googleads.v2.services.MutateCampaignBidModifierResult
	(*MutateCampaignBudgetResult)(nil),               // 159: google.ads.googleads.v2.services.MutateCampaignBudgetResult
	(*MutateCampaignCriterionResult)(nil),            // 160: google.ads.googleads.v2.services.MutateCampaignCriterionResult
	(*MutateCampaignDraftResult)(nil),                // 161: google.ads.googleads.v2.services.MutateCampaignDraftResult
	(*MutateCampaignExperimentResult)(nil),           // 162: google.ads.googleads.v2.services.MutateCampaignExperimentResult
	(*MutateCampaignExtensionSettingResult)(nil),     // 163: google.ads.googleads.v2.services.MutateCampaignExtensionSettingResult
	(*MutateCampaignFeedResult)(nil),                 // 164: google.ads.googleads.v2.services.MutateCampaignFeedResult
	(*MutateCampaignLabelResult)(nil),                // 165: google.ads.googleads.v2.services.MutateCampaignLabelResult
	(*MutateCampaignResult)(nil),                     // 166: google.ads.googleads.v2.services.MutateCampaignResult
	(*MutateCampaignSharedSetResult)(nil),            // 167: google.ads.googleads.v2.services.MutateCampaignSharedSetResult
	(*MutateConversionActionResult)(nil),             // 168: google.ads.googleads.v2.services.MutateConversionActionResult
	(*MutateCustomerExtensionSettingResult)(nil),     // 169: google.ads.googleads.v2.services.MutateCustomerExtensionSettingResult
	(*MutateCustomerFeedResult)(nil),                 // 170: google.ads.googleads.v2.services.MutateCustomerFeedResult
	(*MutateCustomerLabelResult)(nil),                // 171: google.ads.googleads.v2.services.MutateCustomerLabelResult
	(*MutateCustomerNegativeCriteriaResult)(nil),     // 172: google.ads.googleads.v2.services.MutateCustomerNegativeCriteriaResult
	(*MutateCustomerResult)(nil),                     // 173: google.ads.googleads.v2.services.MutateCustomerResult
	(*MutateExtensionFeedItemResult)(nil),            // 174: google.ads.googleads.v2.services.MutateExtensionFeedItemResult
	(*MutateFeedItemResult)(nil),                     // 175: google.ads.googleads.v2.services.MutateFeedItemResult
	(*MutateFeedItemTargetResult)(nil),               // 176: google.ads.googleads.v2.services.MutateFeedItemTargetResult
	(*MutateFeedMappingResult)(nil),                  // 177: google.ads.googleads.v2.services.MutateFeedMappingResult
	(*MutateFeedResult)(nil),                         // 178: google.ads.googleads.v2.services.MutateFeedResult
	(*MutateLabelResult)(nil),                        // 179: google.ads.googleads.v2.services.MutateLabelResult
	(*MutateMediaFileResult)(nil),                    // 180: google.ads.googleads.v2.services.MutateMediaFileResult
	(*MutateRemarketingActionResult)(nil),            // 181: google.ads.googleads.v2.services.MutateRemarketingActionResult
	(*MutateSharedCriterionResult)(nil),              // 182: google.ads.googleads.v2.services.MutateSharedCriterionResult
	(*MutateSharedSetResult)(nil),                    // 183: google.ads.googleads.v2.services.MutateSharedSetResult
	(*MutateUserListResult)(nil),                     // 184: google.ads.googleads.v2.services.MutateUserListResult
}
var file_google_ads_googleads_v2_services_google_ads_service_proto_depIdxs = []int32{
	2,   // 0: google.ads.googleads.v2.services.SearchGoogleAdsResponse.results:type_name -> google.ads.googleads.v2.services.GoogleAdsRow
	7,   // 1: google.ads.googleads.v2.services.SearchGoogleAdsResponse.field_mask:type_name -> google.protobuf.FieldMask
	2,   // 2: google.ads.googleads.v2.services.SearchGoogleAdsResponse.summary_row:type_name -> google.ads.googleads.v2.services.GoogleAdsRow
	8,   // 3: google.ads.googleads.v2.services.GoogleAdsRow.account_budget:type_name -> google.ads.googleads.v2.resources.AccountBudget
	9,   // 4: google.ads.googleads.v2.services.GoogleAdsRow.account_budget_proposal:type_name -> google.ads.googleads.v2.resources.AccountBudgetProposal
	10,  // 5: google.ads.googleads.v2.services.GoogleAdsRow.ad_group:type_name -> google.ads.googleads.v2.resources.AdGroup
	11,  // 6: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_ad:type_name -> google.ads.googleads.v2.resources.AdGroupAd
	12,  // 7: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_ad_asset_view:type_name -> google.ads.googleads.v2.resources.AdGroupAdAssetView
	13,  // 8: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_ad_label:type_name -> google.ads.googleads.v2.resources.AdGroupAdLabel
	14,  // 9: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_audience_view:type_name -> google.ads.googleads.v2.resources.AdGroupAudienceView
	15,  // 10: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_bid_modifier:type_name -> google.ads.googleads.v2.resources.AdGroupBidModifier
	16,  // 11: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_criterion:type_name -> google.ads.googleads.v2.resources.AdGroupCriterion
	17,  // 12: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_criterion_label:type_name -> google.ads.googleads.v2.resources.AdGroupCriterionLabel
	18,  // 13: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_criterion_simulation:type_name -> google.ads.googleads.v2.resources.AdGroupCriterionSimulation
	19,  // 14: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_extension_setting:type_name -> google.ads.googleads.v2.resources.AdGroupExtensionSetting
	20,  // 15: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_feed:type_name -> google.ads.googleads.v2.resources.AdGroupFeed
	21,  // 16: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_label:type_name -> google.ads.googleads.v2.resources.AdGroupLabel
	22,  // 17: google.ads.googleads.v2.services.GoogleAdsRow.ad_group_simulation:type_name -> google.ads.googleads.v2.resources.AdGroupSimulation
	23,  // 18: google.ads.googleads.v2.services.GoogleAdsRow.ad_parameter:type_name -> google.ads.googleads.v2.resources.AdParameter
	24,  // 19: google.ads.googleads.v2.services.GoogleAdsRow.age_range_view:type_name -> google.ads.googleads.v2.resources.AgeRangeView
	25,  // 20: google.ads.googleads.v2.services.GoogleAdsRow.ad_schedule_view:type_name -> google.ads.googleads.v2.resources.AdScheduleView
	26,  // 21: google.ads.googleads.v2.services.GoogleAdsRow.domain_category:type_name -> google.ads.googleads.v2.resources.DomainCategory
	27,  // 22: google.ads.googleads.v2.services.GoogleAdsRow.asset:type_name -> google.ads.googleads.v2.resources.Asset
	28,  // 23: google.ads.googleads.v2.services.GoogleAdsRow.bidding_strategy:type_name -> google.ads.googleads.v2.resources.BiddingStrategy
	29,  // 24: google.ads.googleads.v2.services.GoogleAdsRow.billing_setup:type_name -> google.ads.googleads.v2.resources.BillingSetup
	30,  // 25: google.ads.googleads.v2.services.GoogleAdsRow.campaign_budget:type_name -> google.ads.googleads.v2.resources.CampaignBudget
	31,  // 26: google.ads.googleads.v2.services.GoogleAdsRow.campaign:type_name -> google.ads.googleads.v2.resources.Campaign
	32,  // 27: google.ads.googleads.v2.services.GoogleAdsRow.campaign_audience_view:type_name -> google.ads.googleads.v2.resources.CampaignAudienceView
	33,  // 28: google.ads.googleads.v2.services.GoogleAdsRow.campaign_bid_modifier:type_name -> google.ads.googleads.v2.resources.CampaignBidModifier
	34,  // 29: google.ads.googleads.v2.services.GoogleAdsRow.campaign_criterion:type_name -> google.ads.googleads.v2.resources.CampaignCriterion
	35,  // 30: google.ads.googleads.v2.services.GoogleAdsRow.campaign_criterion_simulation:type_name -> google.ads.googleads.v2.resources.CampaignCriterionSimulation
	36,  // 31: google.ads.googleads.v2.services.GoogleAdsRow.campaign_draft:type_name -> google.ads.googleads.v2.resources.CampaignDraft
	37,  // 32: google.ads.googleads.v2.services.GoogleAdsRow.campaign_experiment:type_name -> google.ads.googleads.v2.resources.CampaignExperiment
	38,  // 33: google.ads.googleads.v2.services.GoogleAdsRow.campaign_extension_setting:type_name -> google.ads.googleads.v2.resources.CampaignExtensionSetting
	39,  // 34: google.ads.googleads.v2.services.GoogleAdsRow.campaign_feed:type_name -> google.ads.googleads.v2.resources.CampaignFeed
	40,  // 35: google.ads.googleads.v2.services.GoogleAdsRow.campaign_label:type_name -> google.ads.googleads.v2.resources.CampaignLabel
	41,  // 36: google.ads.googleads.v2.services.GoogleAdsRow.campaign_shared_set:type_name -> google.ads.googleads.v2.resources.CampaignSharedSet
	42,  // 37: google.ads.googleads.v2.services.GoogleAdsRow.carrier_constant:type_name -> google.ads.googleads.v2.resources.CarrierConstant
	43,  // 38: google.ads.googleads.v2.services.GoogleAdsRow.change_status:type_name -> google.ads.googleads.v2.resources.ChangeStatus
	44,  // 39: google.ads.googleads.v2.services.GoogleAdsRow.conversion_action:type_name -> google.ads.googleads.v2.resources.ConversionAction
	45,  // 40: google.ads.googleads.v2.services.GoogleAdsRow.click_view:type_name -> google.ads.googleads.v2.resources.ClickView
	46,  // 41: google.ads.googleads.v2.services.GoogleAdsRow.custom_interest:type_name -> google.ads.googleads.v2.resources.CustomInterest
	47,  // 42: google.ads.googleads.v2.services.GoogleAdsRow.customer:type_name -> google.ads.googleads.v2.resources.Customer
	48,  // 43: google.ads.googleads.v2.services.GoogleAdsRow.customer_manager_link:type_name -> google.ads.googleads.v2.resources.CustomerManagerLink
	49,  // 44: google.ads.googleads.v2.services.GoogleAdsRow.customer_client_link:type_name -> google.ads.googleads.v2.resources.CustomerClientLink
	50,  // 45: google.ads.googleads.v2.services.GoogleAdsRow.customer_client:type_name -> google.ads.googleads.v2.resources.CustomerClient
	51,  // 46: google.ads.googleads.v2.services.GoogleAdsRow.customer_extension_setting:type_name -> google.ads.googleads.v2.resources.CustomerExtensionSetting
	52,  // 47: google.ads.googleads.v2.services.GoogleAdsRow.customer_feed:type_name -> google.ads.googleads.v2.resources.CustomerFeed
	53,  // 48: google.ads.googleads.v2.services.GoogleAdsRow.customer_label:type_name -> google.ads.googleads.v2.resources.CustomerLabel
	54,  // 49: google.ads.googleads.v2.services.GoogleAdsRow.customer_negative_criterion:type_name -> google.ads.googleads.v2.resources.CustomerNegativeCriterion
	55,  // 50: google.ads.googleads.v2.services.GoogleAdsRow.detail_placement_view:type_name -> google.ads.googleads.v2.resources.DetailPlacementView
	56,  // 51: google.ads.googleads.v2.services.GoogleAdsRow.display_keyword_view:type_name -> google.ads.googleads.v2.resources.DisplayKeywordView
	57,  // 52: google.ads.googleads.v2.services.GoogleAdsRow.distance_view:type_name -> google.ads.googleads.v2.resources.DistanceView
	58,  // 53: google.ads.googleads.v2.services.GoogleAdsRow.dynamic_search_ads_search_term_view:type_name -> google.ads.googleads.v2.resources.DynamicSearchAdsSearchTermView
	59,  // 54: google.ads.googleads.v2.services.GoogleAdsRow.expanded_landing_page_view:type_name -> google.ads.googleads.v2.resources.ExpandedLandingPageView
	60,  // 55: google.ads.googleads.v2.services.GoogleAdsRow.extension_feed_item:type_name -> google.ads.googleads.v2.resources.ExtensionFeedItem
	61,  // 56: google.ads.googleads.v2.services.GoogleAdsRow.feed:type_name -> google.ads.googleads.v2.resources.Feed
	62,  // 57: google.ads.googleads.v2.services.GoogleAdsRow.feed_item:type_name -> google.ads.googleads.v2.resources.FeedItem
	63,  // 58: google.ads.googleads.v2.services.GoogleAdsRow.feed_item_target:type_name -> google.ads.googleads.v2.resources.FeedItemTarget
	64,  // 59: google.ads.googleads.v2.services.GoogleAdsRow.feed_mapping:type_name -> google.ads.googleads.v2.resources.FeedMapping
	65,  // 60: google.ads.googleads.v2.services.GoogleAdsRow.feed_placeholder_view:type_name -> google.ads.googleads.v2.resources.FeedPlaceholderView
	66,  // 61: google.ads.googleads.v2.services.GoogleAdsRow.gender_view:type_name -> google.ads.googleads.v2.resources.GenderView
	67,  // 62: google.ads.googleads.v2.services.GoogleAdsRow.geo_target_constant:type_name -> google.ads.googleads.v2.resources.GeoTargetConstant
	68,  // 63: google.ads.googleads.v2.services.GoogleAdsRow.geographic_view:type_name -> google.ads.googleads.v2.resources.GeographicView
	69,  // 64: google.ads.googleads.v2.services.GoogleAdsRow.group_placement_view:type_name -> google.ads.googleads.v2.resources.GroupPlacementView
	70,  // 65: google.ads.googleads.v2.services.GoogleAdsRow.hotel_group_view:type_name -> google.ads.googleads.v2.resources.HotelGroupView
	71,  // 66: google.ads.googleads.v2.services.GoogleAdsRow.hotel_performance_view:type_name -> google.ads.googleads.v2.resources.HotelPerformanceView
	72,  // 67: google.ads.googleads.v2.services.GoogleAdsRow.keyword_view:type_name -> google.ads.googleads.v2.resources.KeywordView
	73,  // 68: google.ads.googleads.v2.services.GoogleAdsRow.keyword_plan:type_name -> google.ads.googleads.v2.resources.KeywordPlan
	74,  // 69: google.ads.googleads.v2.services.GoogleAdsRow.keyword_plan_campaign:type_name -> google.ads.googleads.v2.resources.KeywordPlanCampaign
	75,  // 70: google.ads.googleads.v2.services.GoogleAdsRow.keyword_plan_negative_keyword:type_name -> google.ads.googleads.v2.resources.KeywordPlanNegativeKeyword
	76,  // 71: google.ads.googleads.v2.services.GoogleAdsRow.keyword_plan_ad_group:type_name -> google.ads.googleads.v2.resources.KeywordPlanAdGroup
	77,  // 72: google.ads.googleads.v2.services.GoogleAdsRow.keyword_plan_keyword:type_name -> google.ads.googleads.v2.resources.KeywordPlanKeyword
	78,  // 73: google.ads.googleads.v2.services.GoogleAdsRow.label:type_name -> google.ads.googleads.v2.resources.Label
	79,  // 74: google.ads.googleads.v2.services.GoogleAdsRow.landing_page_view:type_name -> google.ads.googleads.v2.resources.LandingPageView
	80,  // 75: google.ads.googleads.v2.services.GoogleAdsRow.language_constant:type_name -> google.ads.googleads.v2.resources.LanguageConstant
	81,  // 76: google.ads.googleads.v2.services.GoogleAdsRow.location_view:type_name -> google.ads.googleads.v2.resources.LocationView
	82,  // 77: google.ads.googleads.v2.services.GoogleAdsRow.managed_placement_view:type_name -> google.ads.googleads.v2.resources.ManagedPlacementView
	83,  // 78: google.ads.googleads.v2.services.GoogleAdsRow.media_file:type_name -> google.ads.googleads.v2.resources.MediaFile
	84,  // 79: google.ads.googleads.v2.services.GoogleAdsRow.mobile_app_category_constant:type_name -> google.ads.googleads.v2.resources.MobileAppCategoryConstant
	85,  // 80: google.ads.googleads.v2.services.GoogleAdsRow.mobile_device_constant:type_name -> google.ads.googleads.v2.resources.MobileDeviceConstant
	86,  // 81: google.ads.googleads.v2.services.GoogleAdsRow.mutate_job:type_name -> google.ads.googleads.v2.resources.MutateJob
	87,  // 82: google.ads.googleads.v2.services.GoogleAdsRow.operating_system_version_constant:type_name -> google.ads.googleads.v2.resources.OperatingSystemVersionConstant
	88,  // 83: google.ads.googleads.v2.services.GoogleAdsRow.paid_organic_search_term_view:type_name -> google.ads.googleads.v2.resources.PaidOrganicSearchTermView
	89,  // 84: google.ads.googleads.v2.services.GoogleAdsRow.parental_status_view:type_name -> google.ads.googleads.v2.resources.ParentalStatusView
	90,  // 85: google.ads.googleads.v2.services.GoogleAdsRow.product_bidding_category_constant:type_name -> google.ads.googleads.v2.resources.ProductBiddingCategoryConstant
	91,  // 86: google.ads.googleads.v2.services.GoogleAdsRow.product_group_view:type_name -> google.ads.googleads.v2.resources.ProductGroupView
	92,  // 87: google.ads.googleads.v2.services.GoogleAdsRow.recommendation:type_name -> google.ads.googleads.v2.resources.Recommendation
	93,  // 88: google.ads.googleads.v2.services.GoogleAdsRow.search_term_view:type_name -> google.ads.googleads.v2.resources.SearchTermView
	94,  // 89: google.ads.googleads.v2.services.GoogleAdsRow.shared_criterion:type_name -> google.ads.googleads.v2.resources.SharedCriterion
	95,  // 90: google.ads.googleads.v2.services.GoogleAdsRow.shared_set:type_name -> google.ads.googleads.v2.resources.SharedSet
	96,  // 91: google.ads.googleads.v2.services.GoogleAdsRow.shopping_performance_view:type_name -> google.ads.googleads.v2.resources.ShoppingPerformanceView
	97,  // 92: google.ads.googleads.v2.services.GoogleAdsRow.topic_view:type_name -> google.ads.googleads.v2.resources.TopicView
	98,  // 93: google.ads.googleads.v2.services.GoogleAdsRow.user_interest:type_name -> google.ads.googleads.v2.resources.UserInterest
	99,  // 94: google.ads.googleads.v2.services.GoogleAdsRow.user_list:type_name -> google.ads.googleads.v2.resources.UserList
	100, // 95: google.ads.googleads.v2.services.GoogleAdsRow.user_location_view:type_name -> google.ads.googleads.v2.resources.UserLocationView
	101, // 96: google.ads.googleads.v2.services.GoogleAdsRow.remarketing_action:type_name -> google.ads.googleads.v2.resources.RemarketingAction
	102, // 97: google.ads.googleads.v2.services.GoogleAdsRow.topic_constant:type_name -> google.ads.googleads.v2.resources.TopicConstant
	103, // 98: google.ads.googleads.v2.services.GoogleAdsRow.video:type_name -> google.ads.googleads.v2.resources.Video
	104, // 99: google.ads.googleads.v2.services.GoogleAdsRow.metrics:type_name -> google.ads.googleads.v2.common.Metrics
	105, // 100: google.ads.googleads.v2.services.GoogleAdsRow.segments:type_name -> google.ads.googleads.v2.common.Segments
	5,   // 101: google.ads.googleads.v2.services.MutateGoogleAdsRequest.mutate_operations:type_name -> google.ads.googleads.v2.services.MutateOperation
	106, // 102: google.ads.googleads.v2.services.MutateGoogleAdsResponse.partial_failure_error:type_name -> google.rpc.Status
	6,   // 103: google.ads.googleads.v2.services.MutateGoogleAdsResponse.mutate_operation_responses:type_name -> google.ads.googleads.v2.services.MutateOperationResponse
	107, // 104: google.ads.googleads.v2.services.MutateOperation.ad_group_ad_label_operation:type_name -> google.ads.googleads.v2.services.AdGroupAdLabelOperation
	108, // 105: google.ads.googleads.v2.services.MutateOperation.ad_group_ad_operation:type_name -> google.ads.googleads.v2.services.AdGroupAdOperation
	109, // 106: google.ads.googleads.v2.services.MutateOperation.ad_group_bid_modifier_operation:type_name -> google.ads.googleads.v2.services.AdGroupBidModifierOperation
	110, // 107: google.ads.googleads.v2.services.MutateOperation.ad_group_criterion_label_operation:type_name -> google.ads.googleads.v2.services.AdGroupCriterionLabelOperation
	111, // 108: google.ads.googleads.v2.services.MutateOperation.ad_group_criterion_operation:type_name -> google.ads.googleads.v2.services.AdGroupCriterionOperation
	112, // 109: google.ads.googleads.v2.services.MutateOperation.ad_group_extension_setting_operation:type_name -> google.ads.googleads.v2.services.AdGroupExtensionSettingOperation
	113, // 110: google.ads.googleads.v2.services.MutateOperation.ad_group_feed_operation:type_name -> google.ads.googleads.v2.services.AdGroupFeedOperation
	114, // 111: google.ads.googleads.v2.services.MutateOperation.ad_group_label_operation:type_name -> google.ads.googleads.v2.services.AdGroupLabelOperation
	115, // 112: google.ads.googleads.v2.services.MutateOperation.ad_group_operation:type_name -> google.ads.googleads.v2.services.AdGroupOperation
	116, // 113: google.ads.googleads.v2.services.MutateOperation.ad_parameter_operation:type_name -> google.ads.googleads.v2.services.AdParameterOperation
	117, // 114: google.ads.googleads.v2.services.MutateOperation.asset_operation:type_name -> google.ads.googleads.v2.services.AssetOperation
	118, // 115: google.ads.googleads.v2.services.MutateOperation.bidding_strategy_operation:type_name -> google.ads.googleads.v2.services.BiddingStrategyOperation
	119, // 116: google.ads.googleads.v2.services.MutateOperation.campaign_bid_modifier_operation:type_name -> google.ads.googleads.v2.services.CampaignBidModifierOperation
	120, // 117: google.ads.googleads.v2.services.MutateOperation.campaign_budget_operation:type_name -> google.ads.googleads.v2.services.CampaignBudgetOperation
	121, // 118: google.ads.googleads.v2.services.MutateOperation.campaign_criterion_operation:type_name -> google.ads.googleads.v2.services.CampaignCriterionOperation
	122, // 119: google.ads.googleads.v2.services.MutateOperation.campaign_draft_operation:type_name -> google.ads.googleads.v2.services.CampaignDraftOperation
	123, // 120: google.ads.googleads.v2.services.MutateOperation.campaign_experiment_operation:type_name -> google.ads.googleads.v2.services.CampaignExperimentOperation
	124, // 121: google.ads.googleads.v2.services.MutateOperation.campaign_extension_setting_operation:type_name -> google.ads.googleads.v2.services.CampaignExtensionSettingOperation
	125, // 122: google.ads.googleads.v2.services.MutateOperation.campaign_feed_operation:type_name -> google.ads.googleads.v2.services.CampaignFeedOperation
	126, // 123: google.ads.googleads.v2.services.MutateOperation.campaign_label_operation:type_name -> google.ads.googleads.v2.services.CampaignLabelOperation
	127, // 124: google.ads.googleads.v2.services.MutateOperation.campaign_operation:type_name -> google.ads.googleads.v2.services.CampaignOperation
	128, // 125: google.ads.googleads.v2.services.MutateOperation.campaign_shared_set_operation:type_name -> google.ads.googleads.v2.services.CampaignSharedSetOperation
	129, // 126: google.ads.googleads.v2.services.MutateOperation.conversion_action_operation:type_name -> google.ads.googleads.v2.services.ConversionActionOperation
	130, // 127: google.ads.googleads.v2.services.MutateOperation.customer_extension_setting_operation:type_name -> google.ads.googleads.v2.services.CustomerExtensionSettingOperation
	131, // 128: google.ads.googleads.v2.services.MutateOperation.customer_feed_operation:type_name -> google.ads.googleads.v2.services.CustomerFeedOperation
	132, // 129: google.ads.googleads.v2.services.MutateOperation.customer_label_operation:type_name -> google.ads.googleads.v2.services.CustomerLabelOperation
	133, // 130: google.ads.googleads.v2.services.MutateOperation.customer_negative_criterion_operation:type_name -> google.ads.googleads.v2.services.CustomerNegativeCriterionOperation
	134, // 131: google.ads.googleads.v2.services.MutateOperation.customer_operation:type_name -> google.ads.googleads.v2.services.CustomerOperation
	135, // 132: google.ads.googleads.v2.services.MutateOperation.extension_feed_item_operation:type_name -> google.ads.googleads.v2.services.ExtensionFeedItemOperation
	136, // 133: google.ads.googleads.v2.services.MutateOperation.feed_item_operation:type_name -> google.ads.googleads.v2.services.FeedItemOperation
	137, // 134: google.ads.googleads.v2.services.MutateOperation.feed_item_target_operation:type_name -> google.ads.googleads.v2.services.FeedItemTargetOperation
	138, // 135: google.ads.googleads.v2.services.MutateOperation.feed_mapping_operation:type_name -> google.ads.googleads.v2.services.FeedMappingOperation
	139, // 136: google.ads.googleads.v2.services.MutateOperation.feed_operation:type_name -> google.ads.googleads.v2.services.FeedOperation
	140, // 137: google.ads.googleads.v2.services.MutateOperation.label_operation:type_name -> google.ads.googleads.v2.services.LabelOperation
	141, // 138: google.ads.googleads.v2.services.MutateOperation.media_file_operation:type_name -> google.ads.googleads.v2.services.MediaFileOperation
	142, // 139: google.ads.googleads.v2.services.MutateOperation.remarketing_action_operation:type_name -> google.ads.googleads.v2.services.RemarketingActionOperation
	143, // 140: google.ads.googleads.v2.services.MutateOperation.shared_criterion_operation:type_name -> google.ads.googleads.v2.services.SharedCriterionOperation
	144, // 141: google.ads.googleads.v2.services.MutateOperation.shared_set_operation:type_name -> google.ads.googleads.v2.services.SharedSetOperation
	145, // 142: google.ads.googleads.v2.services.MutateOperation.user_list_operation:type_name -> google.ads.googleads.v2.services.UserListOperation
	146, // 143: google.ads.googleads.v2.services.MutateOperationResponse.ad_group_ad_label_result:type_name -> google.ads.googleads.v2.services.MutateAdGroupAdLabelResult
	147, // 144: google.ads.googleads.v2.services.MutateOperationResponse.ad_group_ad_result:type_name -> google.ads.googleads.v2.services.MutateAdGroupAdResult
	148, // 145: google.ads.googleads.v2.services.MutateOperationResponse.ad_group_bid_modifier_result:type_name -> google.ads.googleads.v2.services.MutateAdGroupBidModifierResult
	149, // 146: google.ads.googleads.v2.services.MutateOperationResponse.ad_group_criterion_label_result:type_name -> google.ads.googleads.v2.services.MutateAdGroupCriterionLabelResult
	150, // 147: google.ads.googleads.v2.services.MutateOperationResponse.ad_group_criterion_result:type_name -> google.ads.googleads.v2.services.MutateAdGroupCriterionResult
	151, // 148: google.ads.googleads.v2.services.MutateOperationResponse.ad_group_extension_setting_result:type_name -> google.ads.googleads.v2.services.MutateAdGroupExtensionSettingResult
	152, // 149: google.ads.googleads.v2.services.MutateOperationResponse.ad_group_feed_result:type_name -> google.ads.googleads.v2.services.MutateAdGroupFeedResult
	153, // 150: google.ads.googleads.v2.services.MutateOperationResponse.ad_group_label_result:type_name -> google.ads.googleads.v2.services.MutateAdGroupLabelResult
	154, // 151: google.ads.googleads.v2.services.MutateOperationResponse.ad_group_result:type_name -> google.ads.googleads.v2.services.MutateAdGroupResult
	155, // 152: google.ads.googleads.v2.services.MutateOperationResponse.ad_parameter_result:type_name -> google.ads.googleads.v2.services.MutateAdParameterResult
	156, // 153: google.ads.googleads.v2.services.MutateOperationResponse.asset_result:type_name -> google.ads.googleads.v2.services.MutateAssetResult
	157, // 154: google.ads.googleads.v2.services.MutateOperationResponse.bidding_strategy_result:type_name -> google.ads.googleads.v2.services.MutateBiddingStrategyResult
	158, // 155: google.ads.googleads.v2.services.MutateOperationResponse.campaign_bid_modifier_result:type_name -> google.ads.googleads.v2.services.MutateCampaignBidModifierResult
	159, // 156: google.ads.googleads.v2.services.MutateOperationResponse.campaign_budget_result:type_name -> google.ads.googleads.v2.services.MutateCampaignBudgetResult
	160, // 157: google.ads.googleads.v2.services.MutateOperationResponse.campaign_criterion_result:type_name -> google.ads.googleads.v2.services.MutateCampaignCriterionResult
	161, // 158: google.ads.googleads.v2.services.MutateOperationResponse.campaign_draft_result:type_name -> google.ads.googleads.v2.services.MutateCampaignDraftResult
	162, // 159: google.ads.googleads.v2.services.MutateOperationResponse.campaign_experiment_result:type_name -> google.ads.googleads.v2.services.MutateCampaignExperimentResult
	163, // 160: google.ads.googleads.v2.services.MutateOperationResponse.campaign_extension_setting_result:type_name -> google.ads.googleads.v2.services.MutateCampaignExtensionSettingResult
	164, // 161: google.ads.googleads.v2.services.MutateOperationResponse.campaign_feed_result:type_name -> google.ads.googleads.v2.services.MutateCampaignFeedResult
	165, // 162: google.ads.googleads.v2.services.MutateOperationResponse.campaign_label_result:type_name -> google.ads.googleads.v2.services.MutateCampaignLabelResult
	166, // 163: google.ads.googleads.v2.services.MutateOperationResponse.campaign_result:type_name -> google.ads.googleads.v2.services.MutateCampaignResult
	167, // 164: google.ads.googleads.v2.services.MutateOperationResponse.campaign_shared_set_result:type_name -> google.ads.googleads.v2.services.MutateCampaignSharedSetResult
	168, // 165: google.ads.googleads.v2.services.MutateOperationResponse.conversion_action_result:type_name -> google.ads.googleads.v2.services.MutateConversionActionResult
	169, // 166: google.ads.googleads.v2.services.MutateOperationResponse.customer_extension_setting_result:type_name -> google.ads.googleads.v2.services.MutateCustomerExtensionSettingResult
	170, // 167: google.ads.googleads.v2.services.MutateOperationResponse.customer_feed_result:type_name -> google.ads.googleads.v2.services.MutateCustomerFeedResult
	171, // 168: google.ads.googleads.v2.services.MutateOperationResponse.customer_label_result:type_name -> google.ads.googleads.v2.services.MutateCustomerLabelResult
	172, // 169: google.ads.googleads.v2.services.MutateOperationResponse.customer_negative_criterion_result:type_name -> google.ads.googleads.v2.services.MutateCustomerNegativeCriteriaResult
	173, // 170: google.ads.googleads.v2.services.MutateOperationResponse.customer_result:type_name -> google.ads.googleads.v2.services.MutateCustomerResult
	174, // 171: google.ads.googleads.v2.services.MutateOperationResponse.extension_feed_item_result:type_name -> google.ads.googleads.v2.services.MutateExtensionFeedItemResult
	175, // 172: google.ads.googleads.v2.services.MutateOperationResponse.feed_item_result:type_name -> google.ads.googleads.v2.services.MutateFeedItemResult
	176, // 173: google.ads.googleads.v2.services.MutateOperationResponse.feed_item_target_result:type_name -> google.ads.googleads.v2.services.MutateFeedItemTargetResult
	177, // 174: google.ads.googleads.v2.services.MutateOperationResponse.feed_mapping_result:type_name -> google.ads.googleads.v2.services.MutateFeedMappingResult
	178, // 175: google.ads.googleads.v2.services.MutateOperationResponse.feed_result:type_name -> google.ads.googleads.v2.services.MutateFeedResult
	179, // 176: google.ads.googleads.v2.services.MutateOperationResponse.label_result:type_name -> google.ads.googleads.v2.services.MutateLabelResult
	180, // 177: google.ads.googleads.v2.services.MutateOperationResponse.media_file_result:type_name -> google.ads.googleads.v2.services.MutateMediaFileResult
	181, // 178: google.ads.googleads.v2.services.MutateOperationResponse.remarketing_action_result:type_name -> google.ads.googleads.v2.services.MutateRemarketingActionResult
	182, // 179: google.ads.googleads.v2.services.MutateOperationResponse.shared_criterion_result:type_name -> google.ads.googleads.v2.services.MutateSharedCriterionResult
	183, // 180: google.ads.googleads.v2.services.MutateOperationResponse.shared_set_result:type_name -> google.ads.googleads.v2.services.MutateSharedSetResult
	184, // 181: google.ads.googleads.v2.services.MutateOperationResponse.user_list_result:type_name -> google.ads.googleads.v2.services.MutateUserListResult
	0,   // 182: google.ads.googleads.v2.services.GoogleAdsService.Search:input_type -> google.ads.googleads.v2.services.SearchGoogleAdsRequest
	3,   // 183: google.ads.googleads.v2.services.GoogleAdsService.Mutate:input_type -> google.ads.googleads.v2.services.MutateGoogleAdsRequest
	1,   // 184: google.ads.googleads.v2.services.GoogleAdsService.Search:output_type -> google.ads.googleads.v2.services.SearchGoogleAdsResponse
	4,   // 185: google.ads.googleads.v2.services.GoogleAdsService.Mutate:output_type -> google.ads.googleads.v2.services.MutateGoogleAdsResponse
	184, // [184:186] is the sub-list for method output_type
	182, // [182:184] is the sub-list for method input_type
	182, // [182:182] is the sub-list for extension type_name
	182, // [182:182] is the sub-list for extension extendee
	0,   // [0:182] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v2_services_google_ads_service_proto_init() }
func file_google_ads_googleads_v2_services_google_ads_service_proto_init() {
	if File_google_ads_googleads_v2_services_google_ads_service_proto != nil {
		return
	}
	file_google_ads_googleads_v2_services_ad_group_ad_label_service_proto_init()
	file_google_ads_googleads_v2_services_ad_group_ad_service_proto_init()
	file_google_ads_googleads_v2_services_ad_group_bid_modifier_service_proto_init()
	file_google_ads_googleads_v2_services_ad_group_criterion_label_service_proto_init()
	file_google_ads_googleads_v2_services_ad_group_criterion_service_proto_init()
	file_google_ads_googleads_v2_services_ad_group_extension_setting_service_proto_init()
	file_google_ads_googleads_v2_services_ad_group_feed_service_proto_init()
	file_google_ads_googleads_v2_services_ad_group_label_service_proto_init()
	file_google_ads_googleads_v2_services_ad_group_service_proto_init()
	file_google_ads_googleads_v2_services_ad_parameter_service_proto_init()
	file_google_ads_googleads_v2_services_asset_service_proto_init()
	file_google_ads_googleads_v2_services_bidding_strategy_service_proto_init()
	file_google_ads_googleads_v2_services_campaign_bid_modifier_service_proto_init()
	file_google_ads_googleads_v2_services_campaign_budget_service_proto_init()
	file_google_ads_googleads_v2_services_campaign_criterion_service_proto_init()
	file_google_ads_googleads_v2_services_campaign_draft_service_proto_init()
	file_google_ads_googleads_v2_services_campaign_experiment_service_proto_init()
	file_google_ads_googleads_v2_services_campaign_extension_setting_service_proto_init()
	file_google_ads_googleads_v2_services_campaign_feed_service_proto_init()
	file_google_ads_googleads_v2_services_campaign_label_service_proto_init()
	file_google_ads_googleads_v2_services_campaign_service_proto_init()
	file_google_ads_googleads_v2_services_campaign_shared_set_service_proto_init()
	file_google_ads_googleads_v2_services_conversion_action_service_proto_init()
	file_google_ads_googleads_v2_services_customer_extension_setting_service_proto_init()
	file_google_ads_googleads_v2_services_customer_feed_service_proto_init()
	file_google_ads_googleads_v2_services_customer_label_service_proto_init()
	file_google_ads_googleads_v2_services_customer_negative_criterion_service_proto_init()
	file_google_ads_googleads_v2_services_customer_service_proto_init()
	file_google_ads_googleads_v2_services_extension_feed_item_service_proto_init()
	file_google_ads_googleads_v2_services_feed_item_service_proto_init()
	file_google_ads_googleads_v2_services_feed_item_target_service_proto_init()
	file_google_ads_googleads_v2_services_feed_mapping_service_proto_init()
	file_google_ads_googleads_v2_services_feed_service_proto_init()
	file_google_ads_googleads_v2_services_label_service_proto_init()
	file_google_ads_googleads_v2_services_media_file_service_proto_init()
	file_google_ads_googleads_v2_services_remarketing_action_service_proto_init()
	file_google_ads_googleads_v2_services_shared_criterion_service_proto_init()
	file_google_ads_googleads_v2_services_shared_set_service_proto_init()
	file_google_ads_googleads_v2_services_user_list_service_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchGoogleAdsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchGoogleAdsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleAdsRow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateGoogleAdsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateGoogleAdsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MutateOperationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*MutateOperation_AdGroupAdLabelOperation)(nil),
		(*MutateOperation_AdGroupAdOperation)(nil),
		(*MutateOperation_AdGroupBidModifierOperation)(nil),
		(*MutateOperation_AdGroupCriterionLabelOperation)(nil),
		(*MutateOperation_AdGroupCriterionOperation)(nil),
		(*MutateOperation_AdGroupExtensionSettingOperation)(nil),
		(*MutateOperation_AdGroupFeedOperation)(nil),
		(*MutateOperation_AdGroupLabelOperation)(nil),
		(*MutateOperation_AdGroupOperation)(nil),
		(*MutateOperation_AdParameterOperation)(nil),
		(*MutateOperation_AssetOperation)(nil),
		(*MutateOperation_BiddingStrategyOperation)(nil),
		(*MutateOperation_CampaignBidModifierOperation)(nil),
		(*MutateOperation_CampaignBudgetOperation)(nil),
		(*MutateOperation_CampaignCriterionOperation)(nil),
		(*MutateOperation_CampaignDraftOperation)(nil),
		(*MutateOperation_CampaignExperimentOperation)(nil),
		(*MutateOperation_CampaignExtensionSettingOperation)(nil),
		(*MutateOperation_CampaignFeedOperation)(nil),
		(*MutateOperation_CampaignLabelOperation)(nil),
		(*MutateOperation_CampaignOperation)(nil),
		(*MutateOperation_CampaignSharedSetOperation)(nil),
		(*MutateOperation_ConversionActionOperation)(nil),
		(*MutateOperation_CustomerExtensionSettingOperation)(nil),
		(*MutateOperation_CustomerFeedOperation)(nil),
		(*MutateOperation_CustomerLabelOperation)(nil),
		(*MutateOperation_CustomerNegativeCriterionOperation)(nil),
		(*MutateOperation_CustomerOperation)(nil),
		(*MutateOperation_ExtensionFeedItemOperation)(nil),
		(*MutateOperation_FeedItemOperation)(nil),
		(*MutateOperation_FeedItemTargetOperation)(nil),
		(*MutateOperation_FeedMappingOperation)(nil),
		(*MutateOperation_FeedOperation)(nil),
		(*MutateOperation_LabelOperation)(nil),
		(*MutateOperation_MediaFileOperation)(nil),
		(*MutateOperation_RemarketingActionOperation)(nil),
		(*MutateOperation_SharedCriterionOperation)(nil),
		(*MutateOperation_SharedSetOperation)(nil),
		(*MutateOperation_UserListOperation)(nil),
	}
	file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*MutateOperationResponse_AdGroupAdLabelResult)(nil),
		(*MutateOperationResponse_AdGroupAdResult)(nil),
		(*MutateOperationResponse_AdGroupBidModifierResult)(nil),
		(*MutateOperationResponse_AdGroupCriterionLabelResult)(nil),
		(*MutateOperationResponse_AdGroupCriterionResult)(nil),
		(*MutateOperationResponse_AdGroupExtensionSettingResult)(nil),
		(*MutateOperationResponse_AdGroupFeedResult)(nil),
		(*MutateOperationResponse_AdGroupLabelResult)(nil),
		(*MutateOperationResponse_AdGroupResult)(nil),
		(*MutateOperationResponse_AdParameterResult)(nil),
		(*MutateOperationResponse_AssetResult)(nil),
		(*MutateOperationResponse_BiddingStrategyResult)(nil),
		(*MutateOperationResponse_CampaignBidModifierResult)(nil),
		(*MutateOperationResponse_CampaignBudgetResult)(nil),
		(*MutateOperationResponse_CampaignCriterionResult)(nil),
		(*MutateOperationResponse_CampaignDraftResult)(nil),
		(*MutateOperationResponse_CampaignExperimentResult)(nil),
		(*MutateOperationResponse_CampaignExtensionSettingResult)(nil),
		(*MutateOperationResponse_CampaignFeedResult)(nil),
		(*MutateOperationResponse_CampaignLabelResult)(nil),
		(*MutateOperationResponse_CampaignResult)(nil),
		(*MutateOperationResponse_CampaignSharedSetResult)(nil),
		(*MutateOperationResponse_ConversionActionResult)(nil),
		(*MutateOperationResponse_CustomerExtensionSettingResult)(nil),
		(*MutateOperationResponse_CustomerFeedResult)(nil),
		(*MutateOperationResponse_CustomerLabelResult)(nil),
		(*MutateOperationResponse_CustomerNegativeCriterionResult)(nil),
		(*MutateOperationResponse_CustomerResult)(nil),
		(*MutateOperationResponse_ExtensionFeedItemResult)(nil),
		(*MutateOperationResponse_FeedItemResult)(nil),
		(*MutateOperationResponse_FeedItemTargetResult)(nil),
		(*MutateOperationResponse_FeedMappingResult)(nil),
		(*MutateOperationResponse_FeedResult)(nil),
		(*MutateOperationResponse_LabelResult)(nil),
		(*MutateOperationResponse_MediaFileResult)(nil),
		(*MutateOperationResponse_RemarketingActionResult)(nil),
		(*MutateOperationResponse_SharedCriterionResult)(nil),
		(*MutateOperationResponse_SharedSetResult)(nil),
		(*MutateOperationResponse_UserListResult)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v2_services_google_ads_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ads_googleads_v2_services_google_ads_service_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v2_services_google_ads_service_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v2_services_google_ads_service_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v2_services_google_ads_service_proto = out.File
	file_google_ads_googleads_v2_services_google_ads_service_proto_rawDesc = nil
	file_google_ads_googleads_v2_services_google_ads_service_proto_goTypes = nil
	file_google_ads_googleads_v2_services_google_ads_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GoogleAdsServiceClient is the client API for GoogleAdsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GoogleAdsServiceClient interface {
	// Returns all rows that match the search query.
	Search(ctx context.Context, in *SearchGoogleAdsRequest, opts ...grpc.CallOption) (*SearchGoogleAdsResponse, error)
	// Creates, updates, or removes resources. This method supports atomic
	// transactions with multiple types of resources. For example, you can
	// atomically create a campaign and a campaign budget, or perform up to
	// thousands of mutates atomically.
	//
	// This method is essentially a wrapper around a series of mutate methods. The
	// only features it offers over calling those methods directly are:
	//
	// - Atomic transactions
	// - Temp resource names (described below)
	// - Somewhat reduced latency over making a series of mutate calls
	//
	// Note: Only resources that support atomic transactions are included, so this
	// method can't replace all calls to individual services.
	//
	// ## Atomic Transaction Benefits
	//
	// Atomicity makes error handling much easier. If you're making a series of
	// changes and one fails, it can leave your account in an inconsistent state.
	// With atomicity, you either reach the desired state directly, or the request
	// fails and you can retry.
	//
	// ## Temp Resource Names
	//
	// Temp resource names are a special type of resource name used to create a
	// resource and reference that resource in the same request. For example, if a
	// campaign budget is created with `resource_name` equal to
	// `customers/123/campaignBudgets/-1`, that resource name can be reused in
	// the `Campaign.budget` field in the same request. That way, the two
	// resources are created and linked atomically.
	//
	// To create a temp resource name, put a negative number in the part of the
	// name that the server would normally allocate.
	//
	// Note:
	//
	// - Resources must be created with a temp name before the name can be reused.
	//   For example, the previous CampaignBudget+Campaign example would fail if
	//   the mutate order was reversed.
	// - Temp names are not remembered across requests.
	// - There's no limit to the number of temp names in a request.
	// - Each temp name must use a unique negative number, even if the resource
	//   types differ.
	//
	// ## Latency
	//
	// It's important to group mutates by resource type or the request may time
	// out and fail. Latency is roughly equal to a series of calls to individual
	// mutate methods, where each change in resource type is a new call. For
	// example, mutating 10 campaigns then 10 ad groups is like 2 calls, while
	// mutating 1 campaign, 1 ad group, 1 campaign, 1 ad group is like 4 calls.
	Mutate(ctx context.Context, in *MutateGoogleAdsRequest, opts ...grpc.CallOption) (*MutateGoogleAdsResponse, error)
}

type googleAdsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGoogleAdsServiceClient(cc grpc.ClientConnInterface) GoogleAdsServiceClient {
	return &googleAdsServiceClient{cc}
}

func (c *googleAdsServiceClient) Search(ctx context.Context, in *SearchGoogleAdsRequest, opts ...grpc.CallOption) (*SearchGoogleAdsResponse, error) {
	out := new(SearchGoogleAdsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.GoogleAdsService/Search", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *googleAdsServiceClient) Mutate(ctx context.Context, in *MutateGoogleAdsRequest, opts ...grpc.CallOption) (*MutateGoogleAdsResponse, error) {
	out := new(MutateGoogleAdsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v2.services.GoogleAdsService/Mutate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GoogleAdsServiceServer is the server API for GoogleAdsService service.
type GoogleAdsServiceServer interface {
	// Returns all rows that match the search query.
	Search(context.Context, *SearchGoogleAdsRequest) (*SearchGoogleAdsResponse, error)
	// Creates, updates, or removes resources. This method supports atomic
	// transactions with multiple types of resources. For example, you can
	// atomically create a campaign and a campaign budget, or perform up to
	// thousands of mutates atomically.
	//
	// This method is essentially a wrapper around a series of mutate methods. The
	// only features it offers over calling those methods directly are:
	//
	// - Atomic transactions
	// - Temp resource names (described below)
	// - Somewhat reduced latency over making a series of mutate calls
	//
	// Note: Only resources that support atomic transactions are included, so this
	// method can't replace all calls to individual services.
	//
	// ## Atomic Transaction Benefits
	//
	// Atomicity makes error handling much easier. If you're making a series of
	// changes and one fails, it can leave your account in an inconsistent state.
	// With atomicity, you either reach the desired state directly, or the request
	// fails and you can retry.
	//
	// ## Temp Resource Names
	//
	// Temp resource names are a special type of resource name used to create a
	// resource and reference that resource in the same request. For example, if a
	// campaign budget is created with `resource_name` equal to
	// `customers/123/campaignBudgets/-1`, that resource name can be reused in
	// the `Campaign.budget` field in the same request. That way, the two
	// resources are created and linked atomically.
	//
	// To create a temp resource name, put a negative number in the part of the
	// name that the server would normally allocate.
	//
	// Note:
	//
	// - Resources must be created with a temp name before the name can be reused.
	//   For example, the previous CampaignBudget+Campaign example would fail if
	//   the mutate order was reversed.
	// - Temp names are not remembered across requests.
	// - There's no limit to the number of temp names in a request.
	// - Each temp name must use a unique negative number, even if the resource
	//   types differ.
	//
	// ## Latency
	//
	// It's important to group mutates by resource type or the request may time
	// out and fail. Latency is roughly equal to a series of calls to individual
	// mutate methods, where each change in resource type is a new call. For
	// example, mutating 10 campaigns then 10 ad groups is like 2 calls, while
	// mutating 1 campaign, 1 ad group, 1 campaign, 1 ad group is like 4 calls.
	Mutate(context.Context, *MutateGoogleAdsRequest) (*MutateGoogleAdsResponse, error)
}

// UnimplementedGoogleAdsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedGoogleAdsServiceServer struct {
}

func (*UnimplementedGoogleAdsServiceServer) Search(context.Context, *SearchGoogleAdsRequest) (*SearchGoogleAdsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Search not implemented")
}
func (*UnimplementedGoogleAdsServiceServer) Mutate(context.Context, *MutateGoogleAdsRequest) (*MutateGoogleAdsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method Mutate not implemented")
}

func RegisterGoogleAdsServiceServer(s *grpc.Server, srv GoogleAdsServiceServer) {
	s.RegisterService(&_GoogleAdsService_serviceDesc, srv)
}

func _GoogleAdsService_Search_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchGoogleAdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GoogleAdsServiceServer).Search(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.GoogleAdsService/Search",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GoogleAdsServiceServer).Search(ctx, req.(*SearchGoogleAdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GoogleAdsService_Mutate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateGoogleAdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GoogleAdsServiceServer).Mutate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v2.services.GoogleAdsService/Mutate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GoogleAdsServiceServer).Mutate(ctx, req.(*MutateGoogleAdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GoogleAdsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v2.services.GoogleAdsService",
	HandlerType: (*GoogleAdsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Search",
			Handler:    _GoogleAdsService_Search_Handler,
		},
		{
			MethodName: "Mutate",
			Handler:    _GoogleAdsService_Mutate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v2/services/google_ads_service.proto",
}
