#!/bin/bash
#
# This script will install or remove SaraB (Schedule and Rotate Automatic Backups)
#

sarab_version="1.0.0"

# Define functions to be used by the script.

# Install function
install()
{
# check for dar in the path
DAR_BINARY=`which dar`
if [ ! -x "$DAR_BINARY" ]
then
    echo "Dar not found on the path (SaraB requires http://dar.linux.free.fr)"
    echo
    echo -n "Please provide absolute path to dar executable:" 
    read DAR_BINARY
    echo
    if [ ! -x "$DAR_BINARY" ]
    then
        echo "Dar not found at $DAR_BINARY. Terminating."
        exit 1
    fi
fi

if [ -d /etc/sarab ]
then
    echo
    echo "***WARNING*** Files in the following directories will be overwritten:"
    echo "/etc/sarab/"
    echo "/etc/sarab/examples/"
    echo "/usr/local/sarab/"
    echo
    echo "This will overwrite all SaraB related files including:"
    echo "SaraB configuration files"
    echo "SaraB rotation schedules"
    echo "SaraB executable files"
    echo "SaraB documentation files"
    echo
    echo "This script will NOT overwrite your backups."
fi
echo 
echo -n "Are you sure you want to install SaraB? (y/n): "
read answer
if [ "$answer" != "y" ] && [ "$answer" != "Y" ]; then
   echo
   echo "You must choose the letter 'y' if you want to install SaraB.  Cancelling install."
   echo
   exit 0
fi 
echo 
echo "Installing SaraB version $sarab_version ..."
mkdir -p /etc/sarab/
cp -r ./etc/* /etc/sarab/
mkdir -p /usr/local/sarab/
cp * /usr/local/sarab/ > /dev/null 2>&1

# add configuration changes
echo "#">>/etc/sarab/sarab.conf
echo "# Settings added by install.sh:">>/etc/sarab/sarab.conf
echo "#">>/etc/sarab/sarab.conf
echo >>/etc/sarab/sarab.conf
echo "# The location of the dar executable file">>/etc/sarab/sarab.conf
echo "DAR_BINARY=$DAR_BINARY">>/etc/sarab/sarab.conf
echo >>/etc/sarab/sarab.conf
echo "# The complete command to run DAR. Does NOT include the reference archive. SaraB will add">>/etc/sarab/sarab.conf
echo "# that option if needed at run-time, according to the rotation.schedule.">>/etc/sarab/sarab.conf
echo 'DAR_COMMAND="$DAR_BINARY --batch $SECURITY_CONFIG --batch $SARAB_ETC/$SARAB_DCF -c $DAR_CREATE --noconf -Q"'>>/etc/sarab/sarab.conf

#create log file
touch /var/log/sarab.log
chown root.root /var/log/sarab.log
chmod 600 /var/log/sarab.log

echo
echo "If there are no error messages listed above, SaraB was successfully installed." 
echo
}

# Uninstall function
remove()
{
echo
echo "***WARNING*** Any files in the following directories will be deleted:"
echo "/etc/sarab/"
echo "/etc/sarab/examples/"
echo "/usr/local/sarab/"
echo
echo "This will delete all SaraB related files including:"
echo "SaraB configuration files"
echo "SaraB rotation schedules"
echo "SaraB executable files"
echo "SaraB documentation files"
echo
echo "This script will NOT delete the following:"
echo "Your backups"
echo "Any cron jobs you have manually created"
echo 
echo -n "Are you sure you want to uninstall SaraB? (y/n): "
read answer
if [ "$answer" != "y" ] && [ "$answer" != "Y" ]; then
   echo
   echo "You must choose the letter 'y' if you want to uninstall SaraB.  Cancelling uninstall."
   echo
   exit 0
fi 
echo
echo "Removing files..."
rm -f /etc/sarab/examples/*
if [ "$?" != "0" ]; then
   error="yes"
fi
rmdir /etc/sarab/examples/
if [ "$?" != "0" ]; then
   error="yes"
fi
rm -f /etc/sarab/*
if [ "$?" != "0" ]; then
   error="yes"
fi
rmdir /etc/sarab/
if [ "$?" != "0" ]; then
   error="yes"
fi
rm -f /usr/local/sarab/*
if [ "$?" != "0" ]; then
   error="yes"
fi
rmdir /usr/local/sarab/
if [ "$?" != "0" ]; then
   error="yes"
fi
if [ "$error" = "yes" ]; then
   echo
   echo "An error occurred when trying to delete one of the directories listed above."
   echo "This could mean that the directories don't exist, or that they have subdirectories in them."
   echo "This script will not delete a directory if it has subdirectories."
fi
echo
echo "SaraB was successfully removed from your system."
echo
}

#### Begin processing script here. ####

echo
echo "SaraB (Schedule and Rotate Automatic Backups) version $sarab_version "
echo
if [ "$UID" != "0" ]; then
   echo "You must have root permissions to run this script. Exiting."
   echo
   exit 1;
fi
echo "If you want to exit without doing anything, hit Enter."
echo 
echo -n "Do you want to (i)nstall or (r)emove SaraB? (i/r): "
read answer
case "$answer" in
  "i" | "I" )  # Accept upper or lowercase input.
   install  ;;
  "r" | "R" )
   remove  ;;
          * )  # Default option.
   echo
   echo "You must choose the letter 'i' or 'r' before this script will do anything."
   echo  ;;
esac

