// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opensearchserverless

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetCollection = "BatchGetCollection"

// BatchGetCollectionRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetCollection for more information on using the BatchGetCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetCollectionRequest method.
//	req, resp := client.BatchGetCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetCollection
func (c *OpenSearchServerless) BatchGetCollectionRequest(input *BatchGetCollectionInput) (req *request.Request, output *BatchGetCollectionOutput) {
	op := &request.Operation{
		Name:       opBatchGetCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetCollectionInput{}
	}

	output = &BatchGetCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetCollection API operation for OpenSearch Service Serverless.
//
// Returns attributes for one or more collections, including the collection
// endpoint and the OpenSearch Dashboards endpoint. For more information, see
// Creating and managing Amazon OpenSearch Serverless collections (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation BatchGetCollection for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetCollection
func (c *OpenSearchServerless) BatchGetCollection(input *BatchGetCollectionInput) (*BatchGetCollectionOutput, error) {
	req, out := c.BatchGetCollectionRequest(input)
	return out, req.Send()
}

// BatchGetCollectionWithContext is the same as BatchGetCollection with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) BatchGetCollectionWithContext(ctx aws.Context, input *BatchGetCollectionInput, opts ...request.Option) (*BatchGetCollectionOutput, error) {
	req, out := c.BatchGetCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetVpcEndpoint = "BatchGetVpcEndpoint"

// BatchGetVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetVpcEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetVpcEndpoint for more information on using the BatchGetVpcEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetVpcEndpointRequest method.
//	req, resp := client.BatchGetVpcEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetVpcEndpoint
func (c *OpenSearchServerless) BatchGetVpcEndpointRequest(input *BatchGetVpcEndpointInput) (req *request.Request, output *BatchGetVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opBatchGetVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetVpcEndpointInput{}
	}

	output = &BatchGetVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetVpcEndpoint API operation for OpenSearch Service Serverless.
//
// Returns attributes for one or more VPC endpoints associated with the current
// account. For more information, see Access Amazon OpenSearch Serverless using
// an interface endpoint (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation BatchGetVpcEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetVpcEndpoint
func (c *OpenSearchServerless) BatchGetVpcEndpoint(input *BatchGetVpcEndpointInput) (*BatchGetVpcEndpointOutput, error) {
	req, out := c.BatchGetVpcEndpointRequest(input)
	return out, req.Send()
}

// BatchGetVpcEndpointWithContext is the same as BatchGetVpcEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetVpcEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) BatchGetVpcEndpointWithContext(ctx aws.Context, input *BatchGetVpcEndpointInput, opts ...request.Option) (*BatchGetVpcEndpointOutput, error) {
	req, out := c.BatchGetVpcEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessPolicy = "CreateAccessPolicy"

// CreateAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessPolicy for more information on using the CreateAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccessPolicyRequest method.
//	req, resp := client.CreateAccessPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateAccessPolicy
func (c *OpenSearchServerless) CreateAccessPolicyRequest(input *CreateAccessPolicyInput) (req *request.Request, output *CreateAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateAccessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccessPolicyInput{}
	}

	output = &CreateAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccessPolicy API operation for OpenSearch Service Serverless.
//
// Creates a data access policy for OpenSearch Serverless. Access policies limit
// access to collections and the resources within them, and allow a user to
// access that data irrespective of the access mechanism or network source.
// For more information, see Data access control for Amazon OpenSearch Serverless
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation CreateAccessPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
//   - ServiceQuotaExceededException
//     Thrown when you attempt to create more resources than the service allows
//     based on service quotas.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateAccessPolicy
func (c *OpenSearchServerless) CreateAccessPolicy(input *CreateAccessPolicyInput) (*CreateAccessPolicyOutput, error) {
	req, out := c.CreateAccessPolicyRequest(input)
	return out, req.Send()
}

// CreateAccessPolicyWithContext is the same as CreateAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) CreateAccessPolicyWithContext(ctx aws.Context, input *CreateAccessPolicyInput, opts ...request.Option) (*CreateAccessPolicyOutput, error) {
	req, out := c.CreateAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCollection = "CreateCollection"

// CreateCollectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCollection for more information on using the CreateCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCollectionRequest method.
//	req, resp := client.CreateCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateCollection
func (c *OpenSearchServerless) CreateCollectionRequest(input *CreateCollectionInput) (req *request.Request, output *CreateCollectionOutput) {
	op := &request.Operation{
		Name:       opCreateCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCollectionInput{}
	}

	output = &CreateCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCollection API operation for OpenSearch Service Serverless.
//
// Creates a new OpenSearch Serverless collection. For more information, see
// Creating and managing Amazon OpenSearch Serverless collections (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation CreateCollection for usage and error information.
//
// Returned Error Types:
//
//   - OcuLimitExceededException
//     OCU Limit Exceeded for service limits
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
//   - ServiceQuotaExceededException
//     Thrown when you attempt to create more resources than the service allows
//     based on service quotas.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateCollection
func (c *OpenSearchServerless) CreateCollection(input *CreateCollectionInput) (*CreateCollectionOutput, error) {
	req, out := c.CreateCollectionRequest(input)
	return out, req.Send()
}

// CreateCollectionWithContext is the same as CreateCollection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) CreateCollectionWithContext(ctx aws.Context, input *CreateCollectionInput, opts ...request.Option) (*CreateCollectionOutput, error) {
	req, out := c.CreateCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecurityConfig = "CreateSecurityConfig"

// CreateSecurityConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecurityConfig for more information on using the CreateSecurityConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSecurityConfigRequest method.
//	req, resp := client.CreateSecurityConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityConfig
func (c *OpenSearchServerless) CreateSecurityConfigRequest(input *CreateSecurityConfigInput) (req *request.Request, output *CreateSecurityConfigOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityConfigInput{}
	}

	output = &CreateSecurityConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecurityConfig API operation for OpenSearch Service Serverless.
//
// Specifies a security configuration for OpenSearch Serverless. For more information,
// see SAML authentication for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation CreateSecurityConfig for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
//   - ServiceQuotaExceededException
//     Thrown when you attempt to create more resources than the service allows
//     based on service quotas.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityConfig
func (c *OpenSearchServerless) CreateSecurityConfig(input *CreateSecurityConfigInput) (*CreateSecurityConfigOutput, error) {
	req, out := c.CreateSecurityConfigRequest(input)
	return out, req.Send()
}

// CreateSecurityConfigWithContext is the same as CreateSecurityConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) CreateSecurityConfigWithContext(ctx aws.Context, input *CreateSecurityConfigInput, opts ...request.Option) (*CreateSecurityConfigOutput, error) {
	req, out := c.CreateSecurityConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecurityPolicy = "CreateSecurityPolicy"

// CreateSecurityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecurityPolicy for more information on using the CreateSecurityPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSecurityPolicyRequest method.
//	req, resp := client.CreateSecurityPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityPolicy
func (c *OpenSearchServerless) CreateSecurityPolicyRequest(input *CreateSecurityPolicyInput) (req *request.Request, output *CreateSecurityPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecurityPolicyInput{}
	}

	output = &CreateSecurityPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecurityPolicy API operation for OpenSearch Service Serverless.
//
// Creates a security policy to be used by one or more OpenSearch Serverless
// collections. Security policies provide access to a collection and its OpenSearch
// Dashboards endpoint from public networks or specific VPC endpoints. They
// also allow you to secure a collection with a KMS encryption key. For more
// information, see Network access for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html)
// and Encryption at rest for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation CreateSecurityPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
//   - ServiceQuotaExceededException
//     Thrown when you attempt to create more resources than the service allows
//     based on service quotas.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityPolicy
func (c *OpenSearchServerless) CreateSecurityPolicy(input *CreateSecurityPolicyInput) (*CreateSecurityPolicyOutput, error) {
	req, out := c.CreateSecurityPolicyRequest(input)
	return out, req.Send()
}

// CreateSecurityPolicyWithContext is the same as CreateSecurityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) CreateSecurityPolicyWithContext(ctx aws.Context, input *CreateSecurityPolicyInput, opts ...request.Option) (*CreateSecurityPolicyOutput, error) {
	req, out := c.CreateSecurityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcEndpoint = "CreateVpcEndpoint"

// CreateVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcEndpoint for more information on using the CreateVpcEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVpcEndpointRequest method.
//	req, resp := client.CreateVpcEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateVpcEndpoint
func (c *OpenSearchServerless) CreateVpcEndpointRequest(input *CreateVpcEndpointInput) (req *request.Request, output *CreateVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVpcEndpointInput{}
	}

	output = &CreateVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcEndpoint API operation for OpenSearch Service Serverless.
//
// Creates an OpenSearch Serverless-managed interface VPC endpoint. For more
// information, see Access Amazon OpenSearch Serverless using an interface endpoint
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation CreateVpcEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
//   - ServiceQuotaExceededException
//     Thrown when you attempt to create more resources than the service allows
//     based on service quotas.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateVpcEndpoint
func (c *OpenSearchServerless) CreateVpcEndpoint(input *CreateVpcEndpointInput) (*CreateVpcEndpointOutput, error) {
	req, out := c.CreateVpcEndpointRequest(input)
	return out, req.Send()
}

// CreateVpcEndpointWithContext is the same as CreateVpcEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) CreateVpcEndpointWithContext(ctx aws.Context, input *CreateVpcEndpointInput, opts ...request.Option) (*CreateVpcEndpointOutput, error) {
	req, out := c.CreateVpcEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPolicy = "DeleteAccessPolicy"

// DeleteAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPolicy for more information on using the DeleteAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessPolicyRequest method.
//	req, resp := client.DeleteAccessPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteAccessPolicy
func (c *OpenSearchServerless) DeleteAccessPolicyRequest(input *DeleteAccessPolicyInput) (req *request.Request, output *DeleteAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccessPolicyInput{}
	}

	output = &DeleteAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccessPolicy API operation for OpenSearch Service Serverless.
//
// Deletes an OpenSearch Serverless access policy. For more information, see
// Data access control for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation DeleteAccessPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteAccessPolicy
func (c *OpenSearchServerless) DeleteAccessPolicy(input *DeleteAccessPolicyInput) (*DeleteAccessPolicyOutput, error) {
	req, out := c.DeleteAccessPolicyRequest(input)
	return out, req.Send()
}

// DeleteAccessPolicyWithContext is the same as DeleteAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) DeleteAccessPolicyWithContext(ctx aws.Context, input *DeleteAccessPolicyInput, opts ...request.Option) (*DeleteAccessPolicyOutput, error) {
	req, out := c.DeleteAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCollection = "DeleteCollection"

// DeleteCollectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCollection for more information on using the DeleteCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCollectionRequest method.
//	req, resp := client.DeleteCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteCollection
func (c *OpenSearchServerless) DeleteCollectionRequest(input *DeleteCollectionInput) (req *request.Request, output *DeleteCollectionOutput) {
	op := &request.Operation{
		Name:       opDeleteCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCollectionInput{}
	}

	output = &DeleteCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCollection API operation for OpenSearch Service Serverless.
//
// Deletes an OpenSearch Serverless collection. For more information, see Creating
// and managing Amazon OpenSearch Serverless collections (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation DeleteCollection for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteCollection
func (c *OpenSearchServerless) DeleteCollection(input *DeleteCollectionInput) (*DeleteCollectionOutput, error) {
	req, out := c.DeleteCollectionRequest(input)
	return out, req.Send()
}

// DeleteCollectionWithContext is the same as DeleteCollection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) DeleteCollectionWithContext(ctx aws.Context, input *DeleteCollectionInput, opts ...request.Option) (*DeleteCollectionOutput, error) {
	req, out := c.DeleteCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecurityConfig = "DeleteSecurityConfig"

// DeleteSecurityConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecurityConfig for more information on using the DeleteSecurityConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSecurityConfigRequest method.
//	req, resp := client.DeleteSecurityConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityConfig
func (c *OpenSearchServerless) DeleteSecurityConfigRequest(input *DeleteSecurityConfigInput) (req *request.Request, output *DeleteSecurityConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecurityConfigInput{}
	}

	output = &DeleteSecurityConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSecurityConfig API operation for OpenSearch Service Serverless.
//
// Deletes a security configuration for OpenSearch Serverless. For more information,
// see SAML authentication for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation DeleteSecurityConfig for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityConfig
func (c *OpenSearchServerless) DeleteSecurityConfig(input *DeleteSecurityConfigInput) (*DeleteSecurityConfigOutput, error) {
	req, out := c.DeleteSecurityConfigRequest(input)
	return out, req.Send()
}

// DeleteSecurityConfigWithContext is the same as DeleteSecurityConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecurityConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) DeleteSecurityConfigWithContext(ctx aws.Context, input *DeleteSecurityConfigInput, opts ...request.Option) (*DeleteSecurityConfigOutput, error) {
	req, out := c.DeleteSecurityConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecurityPolicy = "DeleteSecurityPolicy"

// DeleteSecurityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecurityPolicy for more information on using the DeleteSecurityPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSecurityPolicyRequest method.
//	req, resp := client.DeleteSecurityPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityPolicy
func (c *OpenSearchServerless) DeleteSecurityPolicyRequest(input *DeleteSecurityPolicyInput) (req *request.Request, output *DeleteSecurityPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSecurityPolicyInput{}
	}

	output = &DeleteSecurityPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSecurityPolicy API operation for OpenSearch Service Serverless.
//
// Deletes an OpenSearch Serverless security policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation DeleteSecurityPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityPolicy
func (c *OpenSearchServerless) DeleteSecurityPolicy(input *DeleteSecurityPolicyInput) (*DeleteSecurityPolicyOutput, error) {
	req, out := c.DeleteSecurityPolicyRequest(input)
	return out, req.Send()
}

// DeleteSecurityPolicyWithContext is the same as DeleteSecurityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecurityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) DeleteSecurityPolicyWithContext(ctx aws.Context, input *DeleteSecurityPolicyInput, opts ...request.Option) (*DeleteSecurityPolicyOutput, error) {
	req, out := c.DeleteSecurityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcEndpoint = "DeleteVpcEndpoint"

// DeleteVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcEndpoint for more information on using the DeleteVpcEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVpcEndpointRequest method.
//	req, resp := client.DeleteVpcEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteVpcEndpoint
func (c *OpenSearchServerless) DeleteVpcEndpointRequest(input *DeleteVpcEndpointInput) (req *request.Request, output *DeleteVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVpcEndpointInput{}
	}

	output = &DeleteVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVpcEndpoint API operation for OpenSearch Service Serverless.
//
// Deletes an OpenSearch Serverless-managed interface endpoint. For more information,
// see Access Amazon OpenSearch Serverless using an interface endpoint (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation DeleteVpcEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteVpcEndpoint
func (c *OpenSearchServerless) DeleteVpcEndpoint(input *DeleteVpcEndpointInput) (*DeleteVpcEndpointOutput, error) {
	req, out := c.DeleteVpcEndpointRequest(input)
	return out, req.Send()
}

// DeleteVpcEndpointWithContext is the same as DeleteVpcEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) DeleteVpcEndpointWithContext(ctx aws.Context, input *DeleteVpcEndpointInput, opts ...request.Option) (*DeleteVpcEndpointOutput, error) {
	req, out := c.DeleteVpcEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccessPolicy = "GetAccessPolicy"

// GetAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccessPolicy for more information on using the GetAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccessPolicyRequest method.
//	req, resp := client.GetAccessPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccessPolicy
func (c *OpenSearchServerless) GetAccessPolicyRequest(input *GetAccessPolicyInput) (req *request.Request, output *GetAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opGetAccessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccessPolicyInput{}
	}

	output = &GetAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccessPolicy API operation for OpenSearch Service Serverless.
//
// Returns an OpenSearch Serverless access policy. For more information, see
// Data access control for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation GetAccessPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccessPolicy
func (c *OpenSearchServerless) GetAccessPolicy(input *GetAccessPolicyInput) (*GetAccessPolicyOutput, error) {
	req, out := c.GetAccessPolicyRequest(input)
	return out, req.Send()
}

// GetAccessPolicyWithContext is the same as GetAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) GetAccessPolicyWithContext(ctx aws.Context, input *GetAccessPolicyInput, opts ...request.Option) (*GetAccessPolicyOutput, error) {
	req, out := c.GetAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountSettings for more information on using the GetAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountSettingsRequest method.
//	req, resp := client.GetAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccountSettings
func (c *OpenSearchServerless) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for OpenSearch Service Serverless.
//
// Returns account-level settings related to OpenSearch Serverless.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccountSettings
func (c *OpenSearchServerless) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	return out, req.Send()
}

// GetAccountSettingsWithContext is the same as GetAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) GetAccountSettingsWithContext(ctx aws.Context, input *GetAccountSettingsInput, opts ...request.Option) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPoliciesStats = "GetPoliciesStats"

// GetPoliciesStatsRequest generates a "aws/request.Request" representing the
// client's request for the GetPoliciesStats operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPoliciesStats for more information on using the GetPoliciesStats
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPoliciesStatsRequest method.
//	req, resp := client.GetPoliciesStatsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetPoliciesStats
func (c *OpenSearchServerless) GetPoliciesStatsRequest(input *GetPoliciesStatsInput) (req *request.Request, output *GetPoliciesStatsOutput) {
	op := &request.Operation{
		Name:       opGetPoliciesStats,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPoliciesStatsInput{}
	}

	output = &GetPoliciesStatsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPoliciesStats API operation for OpenSearch Service Serverless.
//
// Returns statistical information about your OpenSearch Serverless access policies,
// security configurations, and security policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation GetPoliciesStats for usage and error information.
//
// Returned Error Types:
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetPoliciesStats
func (c *OpenSearchServerless) GetPoliciesStats(input *GetPoliciesStatsInput) (*GetPoliciesStatsOutput, error) {
	req, out := c.GetPoliciesStatsRequest(input)
	return out, req.Send()
}

// GetPoliciesStatsWithContext is the same as GetPoliciesStats with the addition of
// the ability to pass a context and additional request options.
//
// See GetPoliciesStats for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) GetPoliciesStatsWithContext(ctx aws.Context, input *GetPoliciesStatsInput, opts ...request.Option) (*GetPoliciesStatsOutput, error) {
	req, out := c.GetPoliciesStatsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSecurityConfig = "GetSecurityConfig"

// GetSecurityConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetSecurityConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSecurityConfig for more information on using the GetSecurityConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSecurityConfigRequest method.
//	req, resp := client.GetSecurityConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityConfig
func (c *OpenSearchServerless) GetSecurityConfigRequest(input *GetSecurityConfigInput) (req *request.Request, output *GetSecurityConfigOutput) {
	op := &request.Operation{
		Name:       opGetSecurityConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSecurityConfigInput{}
	}

	output = &GetSecurityConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSecurityConfig API operation for OpenSearch Service Serverless.
//
// Returns information about an OpenSearch Serverless security configuration.
// For more information, see SAML authentication for Amazon OpenSearch Serverless
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation GetSecurityConfig for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityConfig
func (c *OpenSearchServerless) GetSecurityConfig(input *GetSecurityConfigInput) (*GetSecurityConfigOutput, error) {
	req, out := c.GetSecurityConfigRequest(input)
	return out, req.Send()
}

// GetSecurityConfigWithContext is the same as GetSecurityConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetSecurityConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) GetSecurityConfigWithContext(ctx aws.Context, input *GetSecurityConfigInput, opts ...request.Option) (*GetSecurityConfigOutput, error) {
	req, out := c.GetSecurityConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSecurityPolicy = "GetSecurityPolicy"

// GetSecurityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetSecurityPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSecurityPolicy for more information on using the GetSecurityPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSecurityPolicyRequest method.
//	req, resp := client.GetSecurityPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityPolicy
func (c *OpenSearchServerless) GetSecurityPolicyRequest(input *GetSecurityPolicyInput) (req *request.Request, output *GetSecurityPolicyOutput) {
	op := &request.Operation{
		Name:       opGetSecurityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSecurityPolicyInput{}
	}

	output = &GetSecurityPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSecurityPolicy API operation for OpenSearch Service Serverless.
//
// Returns information about a configured OpenSearch Serverless security policy.
// For more information, see Network access for Amazon OpenSearch Serverless
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html)
// and Encryption at rest for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation GetSecurityPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityPolicy
func (c *OpenSearchServerless) GetSecurityPolicy(input *GetSecurityPolicyInput) (*GetSecurityPolicyOutput, error) {
	req, out := c.GetSecurityPolicyRequest(input)
	return out, req.Send()
}

// GetSecurityPolicyWithContext is the same as GetSecurityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetSecurityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) GetSecurityPolicyWithContext(ctx aws.Context, input *GetSecurityPolicyInput, opts ...request.Option) (*GetSecurityPolicyOutput, error) {
	req, out := c.GetSecurityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccessPolicies = "ListAccessPolicies"

// ListAccessPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessPolicies for more information on using the ListAccessPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccessPoliciesRequest method.
//	req, resp := client.ListAccessPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListAccessPolicies
func (c *OpenSearchServerless) ListAccessPoliciesRequest(input *ListAccessPoliciesInput) (req *request.Request, output *ListAccessPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAccessPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPoliciesInput{}
	}

	output = &ListAccessPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccessPolicies API operation for OpenSearch Service Serverless.
//
// Returns information about a list of OpenSearch Serverless access policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation ListAccessPolicies for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListAccessPolicies
func (c *OpenSearchServerless) ListAccessPolicies(input *ListAccessPoliciesInput) (*ListAccessPoliciesOutput, error) {
	req, out := c.ListAccessPoliciesRequest(input)
	return out, req.Send()
}

// ListAccessPoliciesWithContext is the same as ListAccessPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListAccessPoliciesWithContext(ctx aws.Context, input *ListAccessPoliciesInput, opts ...request.Option) (*ListAccessPoliciesOutput, error) {
	req, out := c.ListAccessPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessPoliciesPages iterates over the pages of a ListAccessPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccessPolicies operation.
//	pageNum := 0
//	err := client.ListAccessPoliciesPages(params,
//	    func(page *opensearchserverless.ListAccessPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchServerless) ListAccessPoliciesPages(input *ListAccessPoliciesInput, fn func(*ListAccessPoliciesOutput, bool) bool) error {
	return c.ListAccessPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessPoliciesPagesWithContext same as ListAccessPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListAccessPoliciesPagesWithContext(ctx aws.Context, input *ListAccessPoliciesInput, fn func(*ListAccessPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCollections = "ListCollections"

// ListCollectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCollections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCollections for more information on using the ListCollections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCollectionsRequest method.
//	req, resp := client.ListCollectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListCollections
func (c *OpenSearchServerless) ListCollectionsRequest(input *ListCollectionsInput) (req *request.Request, output *ListCollectionsOutput) {
	op := &request.Operation{
		Name:       opListCollections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCollectionsInput{}
	}

	output = &ListCollectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCollections API operation for OpenSearch Service Serverless.
//
// Lists all OpenSearch Serverless collections. For more information, see Creating
// and managing Amazon OpenSearch Serverless collections (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html).
//
// Make sure to include an empty request body {} if you don't include any collection
// filters in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation ListCollections for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListCollections
func (c *OpenSearchServerless) ListCollections(input *ListCollectionsInput) (*ListCollectionsOutput, error) {
	req, out := c.ListCollectionsRequest(input)
	return out, req.Send()
}

// ListCollectionsWithContext is the same as ListCollections with the addition of
// the ability to pass a context and additional request options.
//
// See ListCollections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListCollectionsWithContext(ctx aws.Context, input *ListCollectionsInput, opts ...request.Option) (*ListCollectionsOutput, error) {
	req, out := c.ListCollectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCollectionsPages iterates over the pages of a ListCollections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCollections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCollections operation.
//	pageNum := 0
//	err := client.ListCollectionsPages(params,
//	    func(page *opensearchserverless.ListCollectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchServerless) ListCollectionsPages(input *ListCollectionsInput, fn func(*ListCollectionsOutput, bool) bool) error {
	return c.ListCollectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCollectionsPagesWithContext same as ListCollectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListCollectionsPagesWithContext(ctx aws.Context, input *ListCollectionsInput, fn func(*ListCollectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCollectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCollectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCollectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecurityConfigs = "ListSecurityConfigs"

// ListSecurityConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityConfigs for more information on using the ListSecurityConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSecurityConfigsRequest method.
//	req, resp := client.ListSecurityConfigsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityConfigs
func (c *OpenSearchServerless) ListSecurityConfigsRequest(input *ListSecurityConfigsInput) (req *request.Request, output *ListSecurityConfigsOutput) {
	op := &request.Operation{
		Name:       opListSecurityConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecurityConfigsInput{}
	}

	output = &ListSecurityConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityConfigs API operation for OpenSearch Service Serverless.
//
// Returns information about configured OpenSearch Serverless security configurations.
// For more information, see SAML authentication for Amazon OpenSearch Serverless
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation ListSecurityConfigs for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityConfigs
func (c *OpenSearchServerless) ListSecurityConfigs(input *ListSecurityConfigsInput) (*ListSecurityConfigsOutput, error) {
	req, out := c.ListSecurityConfigsRequest(input)
	return out, req.Send()
}

// ListSecurityConfigsWithContext is the same as ListSecurityConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListSecurityConfigsWithContext(ctx aws.Context, input *ListSecurityConfigsInput, opts ...request.Option) (*ListSecurityConfigsOutput, error) {
	req, out := c.ListSecurityConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecurityConfigsPages iterates over the pages of a ListSecurityConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecurityConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSecurityConfigs operation.
//	pageNum := 0
//	err := client.ListSecurityConfigsPages(params,
//	    func(page *opensearchserverless.ListSecurityConfigsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchServerless) ListSecurityConfigsPages(input *ListSecurityConfigsInput, fn func(*ListSecurityConfigsOutput, bool) bool) error {
	return c.ListSecurityConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecurityConfigsPagesWithContext same as ListSecurityConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListSecurityConfigsPagesWithContext(ctx aws.Context, input *ListSecurityConfigsInput, fn func(*ListSecurityConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecurityConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecurityConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecurityConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecurityPolicies = "ListSecurityPolicies"

// ListSecurityPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityPolicies for more information on using the ListSecurityPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSecurityPoliciesRequest method.
//	req, resp := client.ListSecurityPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityPolicies
func (c *OpenSearchServerless) ListSecurityPoliciesRequest(input *ListSecurityPoliciesInput) (req *request.Request, output *ListSecurityPoliciesOutput) {
	op := &request.Operation{
		Name:       opListSecurityPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecurityPoliciesInput{}
	}

	output = &ListSecurityPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityPolicies API operation for OpenSearch Service Serverless.
//
// Returns information about configured OpenSearch Serverless security policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation ListSecurityPolicies for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityPolicies
func (c *OpenSearchServerless) ListSecurityPolicies(input *ListSecurityPoliciesInput) (*ListSecurityPoliciesOutput, error) {
	req, out := c.ListSecurityPoliciesRequest(input)
	return out, req.Send()
}

// ListSecurityPoliciesWithContext is the same as ListSecurityPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListSecurityPoliciesWithContext(ctx aws.Context, input *ListSecurityPoliciesInput, opts ...request.Option) (*ListSecurityPoliciesOutput, error) {
	req, out := c.ListSecurityPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecurityPoliciesPages iterates over the pages of a ListSecurityPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecurityPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSecurityPolicies operation.
//	pageNum := 0
//	err := client.ListSecurityPoliciesPages(params,
//	    func(page *opensearchserverless.ListSecurityPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchServerless) ListSecurityPoliciesPages(input *ListSecurityPoliciesInput, fn func(*ListSecurityPoliciesOutput, bool) bool) error {
	return c.ListSecurityPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecurityPoliciesPagesWithContext same as ListSecurityPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListSecurityPoliciesPagesWithContext(ctx aws.Context, input *ListSecurityPoliciesInput, fn func(*ListSecurityPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecurityPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecurityPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecurityPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListTagsForResource
func (c *OpenSearchServerless) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for OpenSearch Service Serverless.
//
// Returns the tags for an OpenSearch Serverless resource. For more information,
// see Tagging Amazon OpenSearch Serverless collections (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListTagsForResource
func (c *OpenSearchServerless) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVpcEndpoints = "ListVpcEndpoints"

// ListVpcEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListVpcEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVpcEndpoints for more information on using the ListVpcEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVpcEndpointsRequest method.
//	req, resp := client.ListVpcEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListVpcEndpoints
func (c *OpenSearchServerless) ListVpcEndpointsRequest(input *ListVpcEndpointsInput) (req *request.Request, output *ListVpcEndpointsOutput) {
	op := &request.Operation{
		Name:       opListVpcEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVpcEndpointsInput{}
	}

	output = &ListVpcEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVpcEndpoints API operation for OpenSearch Service Serverless.
//
// Returns the OpenSearch Serverless-managed interface VPC endpoints associated
// with the current account. For more information, see Access Amazon OpenSearch
// Serverless using an interface endpoint (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation ListVpcEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListVpcEndpoints
func (c *OpenSearchServerless) ListVpcEndpoints(input *ListVpcEndpointsInput) (*ListVpcEndpointsOutput, error) {
	req, out := c.ListVpcEndpointsRequest(input)
	return out, req.Send()
}

// ListVpcEndpointsWithContext is the same as ListVpcEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListVpcEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListVpcEndpointsWithContext(ctx aws.Context, input *ListVpcEndpointsInput, opts ...request.Option) (*ListVpcEndpointsOutput, error) {
	req, out := c.ListVpcEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVpcEndpointsPages iterates over the pages of a ListVpcEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVpcEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVpcEndpoints operation.
//	pageNum := 0
//	err := client.ListVpcEndpointsPages(params,
//	    func(page *opensearchserverless.ListVpcEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *OpenSearchServerless) ListVpcEndpointsPages(input *ListVpcEndpointsInput, fn func(*ListVpcEndpointsOutput, bool) bool) error {
	return c.ListVpcEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVpcEndpointsPagesWithContext same as ListVpcEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) ListVpcEndpointsPagesWithContext(ctx aws.Context, input *ListVpcEndpointsInput, fn func(*ListVpcEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVpcEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVpcEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVpcEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/TagResource
func (c *OpenSearchServerless) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for OpenSearch Service Serverless.
//
// Associates tags with an OpenSearch Serverless resource. For more information,
// see Tagging Amazon OpenSearch Serverless collections (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
//   - ServiceQuotaExceededException
//     Thrown when you attempt to create more resources than the service allows
//     based on service quotas.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/TagResource
func (c *OpenSearchServerless) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UntagResource
func (c *OpenSearchServerless) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for OpenSearch Service Serverless.
//
// Removes a tag or set of tags from an OpenSearch Serverless resource. For
// more information, see Tagging Amazon OpenSearch Serverless collections (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UntagResource
func (c *OpenSearchServerless) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccessPolicy = "UpdateAccessPolicy"

// UpdateAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccessPolicy for more information on using the UpdateAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccessPolicyRequest method.
//	req, resp := client.UpdateAccessPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccessPolicy
func (c *OpenSearchServerless) UpdateAccessPolicyRequest(input *UpdateAccessPolicyInput) (req *request.Request, output *UpdateAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateAccessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAccessPolicyInput{}
	}

	output = &UpdateAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccessPolicy API operation for OpenSearch Service Serverless.
//
// Updates an OpenSearch Serverless access policy. For more information, see
// Data access control for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation UpdateAccessPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccessPolicy
func (c *OpenSearchServerless) UpdateAccessPolicy(input *UpdateAccessPolicyInput) (*UpdateAccessPolicyOutput, error) {
	req, out := c.UpdateAccessPolicyRequest(input)
	return out, req.Send()
}

// UpdateAccessPolicyWithContext is the same as UpdateAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) UpdateAccessPolicyWithContext(ctx aws.Context, input *UpdateAccessPolicyInput, opts ...request.Option) (*UpdateAccessPolicyOutput, error) {
	req, out := c.UpdateAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountSettings = "UpdateAccountSettings"

// UpdateAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountSettings for more information on using the UpdateAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountSettingsRequest method.
//	req, resp := client.UpdateAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccountSettings
func (c *OpenSearchServerless) UpdateAccountSettingsRequest(input *UpdateAccountSettingsInput) (req *request.Request, output *UpdateAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAccountSettingsInput{}
	}

	output = &UpdateAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountSettings API operation for OpenSearch Service Serverless.
//
// Update the OpenSearch Serverless settings for the current Amazon Web Services
// account. For more information, see Managing capacity limits for Amazon OpenSearch
// Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation UpdateAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccountSettings
func (c *OpenSearchServerless) UpdateAccountSettings(input *UpdateAccountSettingsInput) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	return out, req.Send()
}

// UpdateAccountSettingsWithContext is the same as UpdateAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) UpdateAccountSettingsWithContext(ctx aws.Context, input *UpdateAccountSettingsInput, opts ...request.Option) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCollection = "UpdateCollection"

// UpdateCollectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCollection for more information on using the UpdateCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCollectionRequest method.
//	req, resp := client.UpdateCollectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateCollection
func (c *OpenSearchServerless) UpdateCollectionRequest(input *UpdateCollectionInput) (req *request.Request, output *UpdateCollectionOutput) {
	op := &request.Operation{
		Name:       opUpdateCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCollectionInput{}
	}

	output = &UpdateCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCollection API operation for OpenSearch Service Serverless.
//
// Updates an OpenSearch Serverless collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation UpdateCollection for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateCollection
func (c *OpenSearchServerless) UpdateCollection(input *UpdateCollectionInput) (*UpdateCollectionOutput, error) {
	req, out := c.UpdateCollectionRequest(input)
	return out, req.Send()
}

// UpdateCollectionWithContext is the same as UpdateCollection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) UpdateCollectionWithContext(ctx aws.Context, input *UpdateCollectionInput, opts ...request.Option) (*UpdateCollectionOutput, error) {
	req, out := c.UpdateCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecurityConfig = "UpdateSecurityConfig"

// UpdateSecurityConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecurityConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecurityConfig for more information on using the UpdateSecurityConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSecurityConfigRequest method.
//	req, resp := client.UpdateSecurityConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityConfig
func (c *OpenSearchServerless) UpdateSecurityConfigRequest(input *UpdateSecurityConfigInput) (req *request.Request, output *UpdateSecurityConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateSecurityConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSecurityConfigInput{}
	}

	output = &UpdateSecurityConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSecurityConfig API operation for OpenSearch Service Serverless.
//
// Updates a security configuration for OpenSearch Serverless. For more information,
// see SAML authentication for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation UpdateSecurityConfig for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityConfig
func (c *OpenSearchServerless) UpdateSecurityConfig(input *UpdateSecurityConfigInput) (*UpdateSecurityConfigOutput, error) {
	req, out := c.UpdateSecurityConfigRequest(input)
	return out, req.Send()
}

// UpdateSecurityConfigWithContext is the same as UpdateSecurityConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecurityConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) UpdateSecurityConfigWithContext(ctx aws.Context, input *UpdateSecurityConfigInput, opts ...request.Option) (*UpdateSecurityConfigOutput, error) {
	req, out := c.UpdateSecurityConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecurityPolicy = "UpdateSecurityPolicy"

// UpdateSecurityPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecurityPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecurityPolicy for more information on using the UpdateSecurityPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSecurityPolicyRequest method.
//	req, resp := client.UpdateSecurityPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityPolicy
func (c *OpenSearchServerless) UpdateSecurityPolicyRequest(input *UpdateSecurityPolicyInput) (req *request.Request, output *UpdateSecurityPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateSecurityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSecurityPolicyInput{}
	}

	output = &UpdateSecurityPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSecurityPolicy API operation for OpenSearch Service Serverless.
//
// Updates an OpenSearch Serverless security policy. For more information, see
// Network access for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html)
// and Encryption at rest for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation UpdateSecurityPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ResourceNotFoundException
//     Thrown when accessing or deleting a resource that does not exist.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
//   - ServiceQuotaExceededException
//     Thrown when you attempt to create more resources than the service allows
//     based on service quotas.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityPolicy
func (c *OpenSearchServerless) UpdateSecurityPolicy(input *UpdateSecurityPolicyInput) (*UpdateSecurityPolicyOutput, error) {
	req, out := c.UpdateSecurityPolicyRequest(input)
	return out, req.Send()
}

// UpdateSecurityPolicyWithContext is the same as UpdateSecurityPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecurityPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) UpdateSecurityPolicyWithContext(ctx aws.Context, input *UpdateSecurityPolicyInput, opts ...request.Option) (*UpdateSecurityPolicyOutput, error) {
	req, out := c.UpdateSecurityPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVpcEndpoint = "UpdateVpcEndpoint"

// UpdateVpcEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVpcEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVpcEndpoint for more information on using the UpdateVpcEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVpcEndpointRequest method.
//	req, resp := client.UpdateVpcEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateVpcEndpoint
func (c *OpenSearchServerless) UpdateVpcEndpointRequest(input *UpdateVpcEndpointInput) (req *request.Request, output *UpdateVpcEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateVpcEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVpcEndpointInput{}
	}

	output = &UpdateVpcEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVpcEndpoint API operation for OpenSearch Service Serverless.
//
// Updates an OpenSearch Serverless-managed interface endpoint. For more information,
// see Access Amazon OpenSearch Serverless using an interface endpoint (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for OpenSearch Service Serverless's
// API operation UpdateVpcEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     Thrown when an error internal to the service occurs while processing a request.
//
//   - ConflictException
//     When creating a resource, thrown when a resource with the same name already
//     exists or is being created. When deleting a resource, thrown when the resource
//     is not in the ACTIVE or FAILED state.
//
//   - ValidationException
//     Thrown when the HTTP request contains invalid input or is missing required
//     input.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateVpcEndpoint
func (c *OpenSearchServerless) UpdateVpcEndpoint(input *UpdateVpcEndpointInput) (*UpdateVpcEndpointOutput, error) {
	req, out := c.UpdateVpcEndpointRequest(input)
	return out, req.Send()
}

// UpdateVpcEndpointWithContext is the same as UpdateVpcEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVpcEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpenSearchServerless) UpdateVpcEndpointWithContext(ctx aws.Context, input *UpdateVpcEndpointInput, opts ...request.Option) (*UpdateVpcEndpointOutput, error) {
	req, out := c.UpdateVpcEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Details about an OpenSearch Serverless access policy.
type AccessPolicyDetail struct {
	_ struct{} `type:"structure"`

	// The date the policy was created.
	CreatedDate *int64 `locationName:"createdDate" type:"long"`

	// The description of the policy.
	Description *string `locationName:"description" type:"string"`

	// The timestamp of when the policy was last modified.
	LastModifiedDate *int64 `locationName:"lastModifiedDate" type:"long"`

	// The name of the policy.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The version of the policy.
	PolicyVersion *string `locationName:"policyVersion" min:"20" type:"string"`

	// The type of access policy.
	Type *string `locationName:"type" type:"string" enum:"AccessPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPolicyDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPolicyDetail) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AccessPolicyDetail) SetCreatedDate(v int64) *AccessPolicyDetail {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AccessPolicyDetail) SetDescription(v string) *AccessPolicyDetail {
	s.Description = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *AccessPolicyDetail) SetLastModifiedDate(v int64) *AccessPolicyDetail {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *AccessPolicyDetail) SetName(v string) *AccessPolicyDetail {
	s.Name = &v
	return s
}

// SetPolicyVersion sets the PolicyVersion field's value.
func (s *AccessPolicyDetail) SetPolicyVersion(v string) *AccessPolicyDetail {
	s.PolicyVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *AccessPolicyDetail) SetType(v string) *AccessPolicyDetail {
	s.Type = &v
	return s
}

// Statistics for an OpenSearch Serverless access policy.
type AccessPolicyStats struct {
	_ struct{} `type:"structure"`

	// The number of data access policies in the current account.
	DataPolicyCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPolicyStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPolicyStats) GoString() string {
	return s.String()
}

// SetDataPolicyCount sets the DataPolicyCount field's value.
func (s *AccessPolicyStats) SetDataPolicyCount(v int64) *AccessPolicyStats {
	s.DataPolicyCount = &v
	return s
}

// A summary of the data access policy.
type AccessPolicySummary struct {
	_ struct{} `type:"structure"`

	// The Epoch time when the access policy was created.
	CreatedDate *int64 `locationName:"createdDate" type:"long"`

	// The description of the access policy.
	Description *string `locationName:"description" type:"string"`

	// The date and time when the collection was last modified.
	LastModifiedDate *int64 `locationName:"lastModifiedDate" type:"long"`

	// The name of the access policy.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The version of the policy.
	PolicyVersion *string `locationName:"policyVersion" min:"20" type:"string"`

	// The type of access policy. Currently the only available type is data.
	Type *string `locationName:"type" type:"string" enum:"AccessPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPolicySummary) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AccessPolicySummary) SetCreatedDate(v int64) *AccessPolicySummary {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AccessPolicySummary) SetDescription(v string) *AccessPolicySummary {
	s.Description = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *AccessPolicySummary) SetLastModifiedDate(v int64) *AccessPolicySummary {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *AccessPolicySummary) SetName(v string) *AccessPolicySummary {
	s.Name = &v
	return s
}

// SetPolicyVersion sets the PolicyVersion field's value.
func (s *AccessPolicySummary) SetPolicyVersion(v string) *AccessPolicySummary {
	s.PolicyVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *AccessPolicySummary) SetType(v string) *AccessPolicySummary {
	s.Type = &v
	return s
}

// OpenSearch Serverless-related information for the current account.
type AccountSettingsDetail struct {
	_ struct{} `type:"structure"`

	// The maximum capacity limits for all OpenSearch Serverless collections, in
	// OpenSearch Compute Units (OCUs). These limits are used to scale your collections
	// based on the current workload. For more information, see Managing capacity
	// limits for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html).
	CapacityLimits *CapacityLimits `locationName:"capacityLimits" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettingsDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettingsDetail) GoString() string {
	return s.String()
}

// SetCapacityLimits sets the CapacityLimits field's value.
func (s *AccountSettingsDetail) SetCapacityLimits(v *CapacityLimits) *AccountSettingsDetail {
	s.CapacityLimits = v
	return s
}

type BatchGetCollectionInput struct {
	_ struct{} `type:"structure"`

	// A list of collection IDs. You can't provide names and IDs in the same request.
	// The ID is part of the collection endpoint. You can also retrieve it using
	// the ListCollections (https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_ListCollections.html)
	// API.
	Ids []*string `locationName:"ids" min:"1" type:"list"`

	// A list of collection names. You can't provide names and IDs in the same request.
	Names []*string `locationName:"names" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetCollectionInput"}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIds sets the Ids field's value.
func (s *BatchGetCollectionInput) SetIds(v []*string) *BatchGetCollectionInput {
	s.Ids = v
	return s
}

// SetNames sets the Names field's value.
func (s *BatchGetCollectionInput) SetNames(v []*string) *BatchGetCollectionInput {
	s.Names = v
	return s
}

type BatchGetCollectionOutput struct {
	_ struct{} `type:"structure"`

	// Details about each collection.
	CollectionDetails []*CollectionDetail `locationName:"collectionDetails" type:"list"`

	// Error information for the request.
	CollectionErrorDetails []*CollectionErrorDetail `locationName:"collectionErrorDetails" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetCollectionOutput) GoString() string {
	return s.String()
}

// SetCollectionDetails sets the CollectionDetails field's value.
func (s *BatchGetCollectionOutput) SetCollectionDetails(v []*CollectionDetail) *BatchGetCollectionOutput {
	s.CollectionDetails = v
	return s
}

// SetCollectionErrorDetails sets the CollectionErrorDetails field's value.
func (s *BatchGetCollectionOutput) SetCollectionErrorDetails(v []*CollectionErrorDetail) *BatchGetCollectionOutput {
	s.CollectionErrorDetails = v
	return s
}

type BatchGetVpcEndpointInput struct {
	_ struct{} `type:"structure"`

	// A list of VPC endpoint identifiers.
	//
	// Ids is a required field
	Ids []*string `locationName:"ids" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetVpcEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetVpcEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetVpcEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetVpcEndpointInput"}
	if s.Ids == nil {
		invalidParams.Add(request.NewErrParamRequired("Ids"))
	}
	if s.Ids != nil && len(s.Ids) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Ids", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIds sets the Ids field's value.
func (s *BatchGetVpcEndpointInput) SetIds(v []*string) *BatchGetVpcEndpointInput {
	s.Ids = v
	return s
}

type BatchGetVpcEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Details about the specified VPC endpoint.
	VpcEndpointDetails []*VpcEndpointDetail `locationName:"vpcEndpointDetails" type:"list"`

	// Error information for a failed request.
	VpcEndpointErrorDetails []*VpcEndpointErrorDetail `locationName:"vpcEndpointErrorDetails" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetVpcEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetVpcEndpointOutput) GoString() string {
	return s.String()
}

// SetVpcEndpointDetails sets the VpcEndpointDetails field's value.
func (s *BatchGetVpcEndpointOutput) SetVpcEndpointDetails(v []*VpcEndpointDetail) *BatchGetVpcEndpointOutput {
	s.VpcEndpointDetails = v
	return s
}

// SetVpcEndpointErrorDetails sets the VpcEndpointErrorDetails field's value.
func (s *BatchGetVpcEndpointOutput) SetVpcEndpointErrorDetails(v []*VpcEndpointErrorDetail) *BatchGetVpcEndpointOutput {
	s.VpcEndpointErrorDetails = v
	return s
}

// The maximum capacity limits for all OpenSearch Serverless collections, in
// OpenSearch Compute Units (OCUs). These limits are used to scale your collections
// based on the current workload. For more information, see Managing capacity
// limits for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html).
type CapacityLimits struct {
	_ struct{} `type:"structure"`

	// The maximum indexing capacity for collections.
	MaxIndexingCapacityInOCU *int64 `locationName:"maxIndexingCapacityInOCU" min:"2" type:"integer"`

	// The maximum search capacity for collections.
	MaxSearchCapacityInOCU *int64 `locationName:"maxSearchCapacityInOCU" min:"2" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityLimits) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityLimits) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapacityLimits"}
	if s.MaxIndexingCapacityInOCU != nil && *s.MaxIndexingCapacityInOCU < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxIndexingCapacityInOCU", 2))
	}
	if s.MaxSearchCapacityInOCU != nil && *s.MaxSearchCapacityInOCU < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSearchCapacityInOCU", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxIndexingCapacityInOCU sets the MaxIndexingCapacityInOCU field's value.
func (s *CapacityLimits) SetMaxIndexingCapacityInOCU(v int64) *CapacityLimits {
	s.MaxIndexingCapacityInOCU = &v
	return s
}

// SetMaxSearchCapacityInOCU sets the MaxSearchCapacityInOCU field's value.
func (s *CapacityLimits) SetMaxSearchCapacityInOCU(v int64) *CapacityLimits {
	s.MaxSearchCapacityInOCU = &v
	return s
}

// Details about each OpenSearch Serverless collection, including the collection
// endpoint and the OpenSearch Dashboards endpoint.
type CollectionDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the collection.
	Arn *string `locationName:"arn" type:"string"`

	// Collection-specific endpoint used to submit index, search, and data upload
	// requests to an OpenSearch Serverless collection.
	CollectionEndpoint *string `locationName:"collectionEndpoint" type:"string"`

	// The Epoch time when the collection was created.
	CreatedDate *int64 `locationName:"createdDate" type:"long"`

	// Collection-specific endpoint used to access OpenSearch Dashboards.
	DashboardEndpoint *string `locationName:"dashboardEndpoint" type:"string"`

	// A description of the collection.
	Description *string `locationName:"description" type:"string"`

	// A unique identifier for the collection.
	Id *string `locationName:"id" min:"3" type:"string"`

	// The ARN of the Amazon Web Services KMS key used to encrypt the collection.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The date and time when the collection was last modified.
	LastModifiedDate *int64 `locationName:"lastModifiedDate" type:"long"`

	// The name of the collection.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The current status of the collection.
	Status *string `locationName:"status" type:"string" enum:"CollectionStatus"`

	// The type of collection.
	Type *string `locationName:"type" type:"string" enum:"CollectionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectionDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CollectionDetail) SetArn(v string) *CollectionDetail {
	s.Arn = &v
	return s
}

// SetCollectionEndpoint sets the CollectionEndpoint field's value.
func (s *CollectionDetail) SetCollectionEndpoint(v string) *CollectionDetail {
	s.CollectionEndpoint = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CollectionDetail) SetCreatedDate(v int64) *CollectionDetail {
	s.CreatedDate = &v
	return s
}

// SetDashboardEndpoint sets the DashboardEndpoint field's value.
func (s *CollectionDetail) SetDashboardEndpoint(v string) *CollectionDetail {
	s.DashboardEndpoint = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CollectionDetail) SetDescription(v string) *CollectionDetail {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollectionDetail) SetId(v string) *CollectionDetail {
	s.Id = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CollectionDetail) SetKmsKeyArn(v string) *CollectionDetail {
	s.KmsKeyArn = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CollectionDetail) SetLastModifiedDate(v int64) *CollectionDetail {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *CollectionDetail) SetName(v string) *CollectionDetail {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CollectionDetail) SetStatus(v string) *CollectionDetail {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *CollectionDetail) SetType(v string) *CollectionDetail {
	s.Type = &v
	return s
}

// Error information for an OpenSearch Serverless request.
type CollectionErrorDetail struct {
	_ struct{} `type:"structure"`

	// The error code for the request. For example, NOT_FOUND.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// A description of the error. For example, The specified Collection is not
	// found.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// If the request contains collection IDs, the response includes the IDs provided
	// in the request.
	Id *string `locationName:"id" min:"3" type:"string"`

	// If the request contains collection names, the response includes the names
	// provided in the request.
	Name *string `locationName:"name" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectionErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectionErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *CollectionErrorDetail) SetErrorCode(v string) *CollectionErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *CollectionErrorDetail) SetErrorMessage(v string) *CollectionErrorDetail {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollectionErrorDetail) SetId(v string) *CollectionErrorDetail {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CollectionErrorDetail) SetName(v string) *CollectionErrorDetail {
	s.Name = &v
	return s
}

// List of filter keys that you can use for LIST, UPDATE, and DELETE requests
// to OpenSearch Serverless collections.
type CollectionFilters struct {
	_ struct{} `type:"structure"`

	// The name of the collection.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The current status of the collection.
	Status *string `locationName:"status" type:"string" enum:"CollectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectionFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectionFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CollectionFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CollectionFilters"}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CollectionFilters) SetName(v string) *CollectionFilters {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CollectionFilters) SetStatus(v string) *CollectionFilters {
	s.Status = &v
	return s
}

// Details about each OpenSearch Serverless collection.
type CollectionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the collection.
	Arn *string `locationName:"arn" type:"string"`

	// The unique identifier of the collection.
	Id *string `locationName:"id" min:"3" type:"string"`

	// The name of the collection.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The current status of the collection.
	Status *string `locationName:"status" type:"string" enum:"CollectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CollectionSummary) SetArn(v string) *CollectionSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CollectionSummary) SetId(v string) *CollectionSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CollectionSummary) SetName(v string) *CollectionSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CollectionSummary) SetStatus(v string) *CollectionSummary {
	s.Status = &v
	return s
}

// When creating a resource, thrown when a resource with the same name already
// exists or is being created. When deleting a resource, thrown when the resource
// is not in the ACTIVE or FAILED state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the policy. Typically used to store information about the
	// permissions defined in the policy.
	Description *string `locationName:"description" type:"string"`

	// The name of the policy.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The JSON policy document to use as the content for the policy.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`

	// The type of policy.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AccessPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessPolicyInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAccessPolicyInput) SetClientToken(v string) *CreateAccessPolicyInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAccessPolicyInput) SetDescription(v string) *CreateAccessPolicyInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAccessPolicyInput) SetName(v string) *CreateAccessPolicyInput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CreateAccessPolicyInput) SetPolicy(v string) *CreateAccessPolicyInput {
	s.Policy = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateAccessPolicyInput) SetType(v string) *CreateAccessPolicyInput {
	s.Type = &v
	return s
}

type CreateAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Details about the created access policy.
	AccessPolicyDetail *AccessPolicyDetail `locationName:"accessPolicyDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPolicyOutput) GoString() string {
	return s.String()
}

// SetAccessPolicyDetail sets the AccessPolicyDetail field's value.
func (s *CreateAccessPolicyOutput) SetAccessPolicyDetail(v *AccessPolicyDetail) *CreateAccessPolicyOutput {
	s.AccessPolicyDetail = v
	return s
}

// Details about the created OpenSearch Serverless collection.
type CreateCollectionDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the collection.
	Arn *string `locationName:"arn" type:"string"`

	// The Epoch time when the collection was created.
	CreatedDate *int64 `locationName:"createdDate" type:"long"`

	// A description of the collection.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the collection.
	Id *string `locationName:"id" min:"3" type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key with which to encrypt the collection.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The date and time when the collection was last modified.
	LastModifiedDate *int64 `locationName:"lastModifiedDate" type:"long"`

	// The name of the collection.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The current status of the collection.
	Status *string `locationName:"status" type:"string" enum:"CollectionStatus"`

	// The type of collection.
	Type *string `locationName:"type" type:"string" enum:"CollectionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollectionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollectionDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateCollectionDetail) SetArn(v string) *CreateCollectionDetail {
	s.Arn = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CreateCollectionDetail) SetCreatedDate(v int64) *CreateCollectionDetail {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCollectionDetail) SetDescription(v string) *CreateCollectionDetail {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateCollectionDetail) SetId(v string) *CreateCollectionDetail {
	s.Id = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateCollectionDetail) SetKmsKeyArn(v string) *CreateCollectionDetail {
	s.KmsKeyArn = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *CreateCollectionDetail) SetLastModifiedDate(v int64) *CreateCollectionDetail {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCollectionDetail) SetName(v string) *CreateCollectionDetail {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateCollectionDetail) SetStatus(v string) *CreateCollectionDetail {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateCollectionDetail) SetType(v string) *CreateCollectionDetail {
	s.Type = &v
	return s
}

type CreateCollectionInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Description of the collection.
	Description *string `locationName:"description" type:"string"`

	// Name of the collection.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// An arbitrary set of tags (key–value pairs) to associate with the OpenSearch
	// Serverless collection.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The type of collection.
	Type *string `locationName:"type" type:"string" enum:"CollectionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCollectionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateCollectionInput) SetClientToken(v string) *CreateCollectionInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCollectionInput) SetDescription(v string) *CreateCollectionInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCollectionInput) SetName(v string) *CreateCollectionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCollectionInput) SetTags(v []*Tag) *CreateCollectionInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateCollectionInput) SetType(v string) *CreateCollectionInput {
	s.Type = &v
	return s
}

type CreateCollectionOutput struct {
	_ struct{} `type:"structure"`

	// Details about the collection.
	CreateCollectionDetail *CreateCollectionDetail `locationName:"createCollectionDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollectionOutput) GoString() string {
	return s.String()
}

// SetCreateCollectionDetail sets the CreateCollectionDetail field's value.
func (s *CreateCollectionOutput) SetCreateCollectionDetail(v *CreateCollectionDetail) *CreateCollectionOutput {
	s.CreateCollectionDetail = v
	return s
}

type CreateSecurityConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the security configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the security configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// Describes SAML options in in the form of a key-value map. This field is required
	// if you specify saml for the type parameter.
	SamlOptions *SamlConfigOptions `locationName:"samlOptions" type:"structure"`

	// The type of security configuration.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SecurityConfigType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecurityConfigInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.SamlOptions != nil {
		if err := s.SamlOptions.Validate(); err != nil {
			invalidParams.AddNested("SamlOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSecurityConfigInput) SetClientToken(v string) *CreateSecurityConfigInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSecurityConfigInput) SetDescription(v string) *CreateSecurityConfigInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSecurityConfigInput) SetName(v string) *CreateSecurityConfigInput {
	s.Name = &v
	return s
}

// SetSamlOptions sets the SamlOptions field's value.
func (s *CreateSecurityConfigInput) SetSamlOptions(v *SamlConfigOptions) *CreateSecurityConfigInput {
	s.SamlOptions = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateSecurityConfigInput) SetType(v string) *CreateSecurityConfigInput {
	s.Type = &v
	return s
}

type CreateSecurityConfigOutput struct {
	_ struct{} `type:"structure"`

	// Details about the created security configuration.
	SecurityConfigDetail *SecurityConfigDetail `locationName:"securityConfigDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityConfigOutput) GoString() string {
	return s.String()
}

// SetSecurityConfigDetail sets the SecurityConfigDetail field's value.
func (s *CreateSecurityConfigOutput) SetSecurityConfigDetail(v *SecurityConfigDetail) *CreateSecurityConfigOutput {
	s.SecurityConfigDetail = v
	return s
}

type CreateSecurityPolicyInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the policy. Typically used to store information about the
	// permissions defined in the policy.
	Description *string `locationName:"description" type:"string"`

	// The name of the policy.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The JSON policy document to use as the content for the new policy.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`

	// The type of security policy.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SecurityPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecurityPolicyInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateSecurityPolicyInput) SetClientToken(v string) *CreateSecurityPolicyInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSecurityPolicyInput) SetDescription(v string) *CreateSecurityPolicyInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSecurityPolicyInput) SetName(v string) *CreateSecurityPolicyInput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CreateSecurityPolicyInput) SetPolicy(v string) *CreateSecurityPolicyInput {
	s.Policy = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateSecurityPolicyInput) SetType(v string) *CreateSecurityPolicyInput {
	s.Type = &v
	return s
}

type CreateSecurityPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Details about the created security policy.
	SecurityPolicyDetail *SecurityPolicyDetail `locationName:"securityPolicyDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityPolicyOutput) GoString() string {
	return s.String()
}

// SetSecurityPolicyDetail sets the SecurityPolicyDetail field's value.
func (s *CreateSecurityPolicyOutput) SetSecurityPolicyDetail(v *SecurityPolicyDetail) *CreateSecurityPolicyOutput {
	s.SecurityPolicyDetail = v
	return s
}

// Creation details for an OpenSearch Serverless-managed interface endpoint.
// For more information, see Access Amazon OpenSearch Serverless using an interface
// endpoint (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html).
type CreateVpcEndpointDetail struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the endpoint.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the endpoint.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The current status in the endpoint creation process.
	Status *string `locationName:"status" type:"string" enum:"VpcEndpointStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcEndpointDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcEndpointDetail) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateVpcEndpointDetail) SetId(v string) *CreateVpcEndpointDetail {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVpcEndpointDetail) SetName(v string) *CreateVpcEndpointDetail {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateVpcEndpointDetail) SetStatus(v string) *CreateVpcEndpointDetail {
	s.Status = &v
	return s
}

type CreateVpcEndpointInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the interface endpoint.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The unique identifiers of the security groups that define the ports, protocols,
	// and sources for inbound traffic that you are authorizing into your endpoint.
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list"`

	// The ID of one or more subnets from which you'll access OpenSearch Serverless.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" min:"1" type:"list" required:"true"`

	// The ID of the VPC from which you'll access OpenSearch Serverless.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcEndpointInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVpcEndpointInput) SetClientToken(v string) *CreateVpcEndpointInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVpcEndpointInput) SetName(v string) *CreateVpcEndpointInput {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateVpcEndpointInput) SetSecurityGroupIds(v []*string) *CreateVpcEndpointInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateVpcEndpointInput) SetSubnetIds(v []*string) *CreateVpcEndpointInput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateVpcEndpointInput) SetVpcId(v string) *CreateVpcEndpointInput {
	s.VpcId = &v
	return s
}

type CreateVpcEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Details about the created interface VPC endpoint.
	CreateVpcEndpointDetail *CreateVpcEndpointDetail `locationName:"createVpcEndpointDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcEndpointOutput) GoString() string {
	return s.String()
}

// SetCreateVpcEndpointDetail sets the CreateVpcEndpointDetail field's value.
func (s *CreateVpcEndpointOutput) SetCreateVpcEndpointDetail(v *CreateVpcEndpointDetail) *CreateVpcEndpointOutput {
	s.CreateVpcEndpointDetail = v
	return s
}

type DeleteAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the policy to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The type of policy.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AccessPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPolicyInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteAccessPolicyInput) SetClientToken(v string) *DeleteAccessPolicyInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAccessPolicyInput) SetName(v string) *DeleteAccessPolicyInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *DeleteAccessPolicyInput) SetType(v string) *DeleteAccessPolicyInput {
	s.Type = &v
	return s
}

type DeleteAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPolicyOutput) GoString() string {
	return s.String()
}

// Details about a deleted OpenSearch Serverless collection.
type DeleteCollectionDetail struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the collection.
	Id *string `locationName:"id" min:"3" type:"string"`

	// The name of the collection.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The current status of the collection.
	Status *string `locationName:"status" type:"string" enum:"CollectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollectionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollectionDetail) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DeleteCollectionDetail) SetId(v string) *DeleteCollectionDetail {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteCollectionDetail) SetName(v string) *DeleteCollectionDetail {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteCollectionDetail) SetStatus(v string) *DeleteCollectionDetail {
	s.Status = &v
	return s
}

type DeleteCollectionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The unique identifier of the collection. For example, 1iu5usc406kd. The ID
	// is part of the collection endpoint. You can also retrieve it using the ListCollections
	// (https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_ListCollections.html)
	// API.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCollectionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteCollectionInput) SetClientToken(v string) *DeleteCollectionInput {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteCollectionInput) SetId(v string) *DeleteCollectionInput {
	s.Id = &v
	return s
}

type DeleteCollectionOutput struct {
	_ struct{} `type:"structure"`

	// Details of the deleted collection.
	DeleteCollectionDetail *DeleteCollectionDetail `locationName:"deleteCollectionDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollectionOutput) GoString() string {
	return s.String()
}

// SetDeleteCollectionDetail sets the DeleteCollectionDetail field's value.
func (s *DeleteCollectionOutput) SetDeleteCollectionDetail(v *DeleteCollectionDetail) *DeleteCollectionOutput {
	s.DeleteCollectionDetail = v
	return s
}

type DeleteSecurityConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The security configuration identifier. For SAML the ID will be saml/<accountId>/<idpProviderName>.
	// For example, saml/123456789123/OKTADev.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecurityConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecurityConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSecurityConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSecurityConfigInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteSecurityConfigInput) SetClientToken(v string) *DeleteSecurityConfigInput {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteSecurityConfigInput) SetId(v string) *DeleteSecurityConfigInput {
	s.Id = &v
	return s
}

type DeleteSecurityConfigOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecurityConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecurityConfigOutput) GoString() string {
	return s.String()
}

type DeleteSecurityPolicyInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The name of the policy to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The type of policy.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SecurityPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecurityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecurityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSecurityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSecurityPolicyInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteSecurityPolicyInput) SetClientToken(v string) *DeleteSecurityPolicyInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteSecurityPolicyInput) SetName(v string) *DeleteSecurityPolicyInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *DeleteSecurityPolicyInput) SetType(v string) *DeleteSecurityPolicyInput {
	s.Type = &v
	return s
}

type DeleteSecurityPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecurityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSecurityPolicyOutput) GoString() string {
	return s.String()
}

// Deletion details for an OpenSearch Serverless-managed interface endpoint.
type DeleteVpcEndpointDetail struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the endpoint.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the endpoint.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The current status of the endpoint deletion process.
	Status *string `locationName:"status" type:"string" enum:"VpcEndpointStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcEndpointDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcEndpointDetail) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DeleteVpcEndpointDetail) SetId(v string) *DeleteVpcEndpointDetail {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteVpcEndpointDetail) SetName(v string) *DeleteVpcEndpointDetail {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteVpcEndpointDetail) SetStatus(v string) *DeleteVpcEndpointDetail {
	s.Status = &v
	return s
}

type DeleteVpcEndpointInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The VPC endpoint identifier.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcEndpointInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteVpcEndpointInput) SetClientToken(v string) *DeleteVpcEndpointInput {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteVpcEndpointInput) SetId(v string) *DeleteVpcEndpointInput {
	s.Id = &v
	return s
}

type DeleteVpcEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Details about the deleted endpoint.
	DeleteVpcEndpointDetail *DeleteVpcEndpointDetail `locationName:"deleteVpcEndpointDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcEndpointOutput) GoString() string {
	return s.String()
}

// SetDeleteVpcEndpointDetail sets the DeleteVpcEndpointDetail field's value.
func (s *DeleteVpcEndpointOutput) SetDeleteVpcEndpointDetail(v *DeleteVpcEndpointDetail) *DeleteVpcEndpointOutput {
	s.DeleteVpcEndpointDetail = v
	return s
}

type GetAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the access policy.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// Tye type of policy. Currently the only supported value is data.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AccessPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessPolicyInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetAccessPolicyInput) SetName(v string) *GetAccessPolicyInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetAccessPolicyInput) SetType(v string) *GetAccessPolicyInput {
	s.Type = &v
	return s
}

type GetAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Details about the requested access policy.
	AccessPolicyDetail *AccessPolicyDetail `locationName:"accessPolicyDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccessPolicyOutput) GoString() string {
	return s.String()
}

// SetAccessPolicyDetail sets the AccessPolicyDetail field's value.
func (s *GetAccessPolicyOutput) SetAccessPolicyDetail(v *AccessPolicyDetail) *GetAccessPolicyOutput {
	s.AccessPolicyDetail = v
	return s
}

type GetAccountSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// OpenSearch Serverless-related details for the current account.
	AccountSettingsDetail *AccountSettingsDetail `locationName:"accountSettingsDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettingsDetail sets the AccountSettingsDetail field's value.
func (s *GetAccountSettingsOutput) SetAccountSettingsDetail(v *AccountSettingsDetail) *GetAccountSettingsOutput {
	s.AccountSettingsDetail = v
	return s
}

type GetPoliciesStatsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPoliciesStatsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPoliciesStatsInput) GoString() string {
	return s.String()
}

type GetPoliciesStatsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the data access policies in your account.
	AccessPolicyStats *AccessPolicyStats `type:"structure"`

	// Information about the security configurations in your account.
	SecurityConfigStats *SecurityConfigStats `type:"structure"`

	// Information about the security policies in your account.
	SecurityPolicyStats *SecurityPolicyStats `type:"structure"`

	// The total number of OpenSearch Serverless security policies and configurations
	// in your account.
	TotalPolicyCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPoliciesStatsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPoliciesStatsOutput) GoString() string {
	return s.String()
}

// SetAccessPolicyStats sets the AccessPolicyStats field's value.
func (s *GetPoliciesStatsOutput) SetAccessPolicyStats(v *AccessPolicyStats) *GetPoliciesStatsOutput {
	s.AccessPolicyStats = v
	return s
}

// SetSecurityConfigStats sets the SecurityConfigStats field's value.
func (s *GetPoliciesStatsOutput) SetSecurityConfigStats(v *SecurityConfigStats) *GetPoliciesStatsOutput {
	s.SecurityConfigStats = v
	return s
}

// SetSecurityPolicyStats sets the SecurityPolicyStats field's value.
func (s *GetPoliciesStatsOutput) SetSecurityPolicyStats(v *SecurityPolicyStats) *GetPoliciesStatsOutput {
	s.SecurityPolicyStats = v
	return s
}

// SetTotalPolicyCount sets the TotalPolicyCount field's value.
func (s *GetPoliciesStatsOutput) SetTotalPolicyCount(v int64) *GetPoliciesStatsOutput {
	s.TotalPolicyCount = &v
	return s
}

type GetSecurityConfigInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the security configuration.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecurityConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecurityConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSecurityConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSecurityConfigInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetSecurityConfigInput) SetId(v string) *GetSecurityConfigInput {
	s.Id = &v
	return s
}

type GetSecurityConfigOutput struct {
	_ struct{} `type:"structure"`

	// Details of the requested security configuration.
	SecurityConfigDetail *SecurityConfigDetail `locationName:"securityConfigDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecurityConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecurityConfigOutput) GoString() string {
	return s.String()
}

// SetSecurityConfigDetail sets the SecurityConfigDetail field's value.
func (s *GetSecurityConfigOutput) SetSecurityConfigDetail(v *SecurityConfigDetail) *GetSecurityConfigOutput {
	s.SecurityConfigDetail = v
	return s
}

type GetSecurityPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the security policy.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The type of security policy.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SecurityPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecurityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecurityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSecurityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSecurityPolicyInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetSecurityPolicyInput) SetName(v string) *GetSecurityPolicyInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetSecurityPolicyInput) SetType(v string) *GetSecurityPolicyInput {
	s.Type = &v
	return s
}

type GetSecurityPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Details about the requested security policy.
	SecurityPolicyDetail *SecurityPolicyDetail `locationName:"securityPolicyDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecurityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSecurityPolicyOutput) GoString() string {
	return s.String()
}

// SetSecurityPolicyDetail sets the SecurityPolicyDetail field's value.
func (s *GetSecurityPolicyOutput) SetSecurityPolicyDetail(v *SecurityPolicyDetail) *GetSecurityPolicyOutput {
	s.SecurityPolicyDetail = v
	return s
}

// Thrown when an error internal to the service occurs while processing a request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAccessPoliciesInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results. The default is 20.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If your initial ListAccessPolicies operation returns a nextToken, you can
	// include the returned nextToken in subsequent ListAccessPolicies operations,
	// which returns results in the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Resource filters (can be collections or indexes) that policies can apply
	// to.
	Resource []*string `locationName:"resource" min:"1" type:"list"`

	// The type of access policy.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AccessPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessPoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Resource != nil && len(s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessPoliciesInput) SetMaxResults(v int64) *ListAccessPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPoliciesInput) SetNextToken(v string) *ListAccessPoliciesInput {
	s.NextToken = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *ListAccessPoliciesInput) SetResource(v []*string) *ListAccessPoliciesInput {
	s.Resource = v
	return s
}

// SetType sets the Type field's value.
func (s *ListAccessPoliciesInput) SetType(v string) *ListAccessPoliciesInput {
	s.Type = &v
	return s
}

type ListAccessPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// Details about the requested access policies.
	AccessPolicySummaries []*AccessPolicySummary `locationName:"accessPolicySummaries" type:"list"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesOutput) GoString() string {
	return s.String()
}

// SetAccessPolicySummaries sets the AccessPolicySummaries field's value.
func (s *ListAccessPoliciesOutput) SetAccessPolicySummaries(v []*AccessPolicySummary) *ListAccessPoliciesOutput {
	s.AccessPolicySummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPoliciesOutput) SetNextToken(v string) *ListAccessPoliciesOutput {
	s.NextToken = &v
	return s
}

type ListCollectionsInput struct {
	_ struct{} `type:"structure"`

	// List of filter names and values that you can use for requests.
	CollectionFilters *CollectionFilters `locationName:"collectionFilters" type:"structure"`

	// The maximum number of results to return. Default is 20. You can use nextToken
	// to get the next page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If your initial ListCollections operation returns a nextToken, you can include
	// the returned nextToken in subsequent ListCollections operations, which returns
	// results in the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCollectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCollectionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.CollectionFilters != nil {
		if err := s.CollectionFilters.Validate(); err != nil {
			invalidParams.AddNested("CollectionFilters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionFilters sets the CollectionFilters field's value.
func (s *ListCollectionsInput) SetCollectionFilters(v *CollectionFilters) *ListCollectionsInput {
	s.CollectionFilters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCollectionsInput) SetMaxResults(v int64) *ListCollectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollectionsInput) SetNextToken(v string) *ListCollectionsInput {
	s.NextToken = &v
	return s
}

type ListCollectionsOutput struct {
	_ struct{} `type:"structure"`

	// Details about each collection.
	CollectionSummaries []*CollectionSummary `locationName:"collectionSummaries" type:"list"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectionsOutput) GoString() string {
	return s.String()
}

// SetCollectionSummaries sets the CollectionSummaries field's value.
func (s *ListCollectionsOutput) SetCollectionSummaries(v []*CollectionSummary) *ListCollectionsOutput {
	s.CollectionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollectionsOutput) SetNextToken(v string) *ListCollectionsOutput {
	s.NextToken = &v
	return s
}

type ListSecurityConfigsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results. The default is 20.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If your initial ListSecurityConfigs operation returns a nextToken, you can
	// include the returned nextToken in subsequent ListSecurityConfigs operations,
	// which returns results in the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The type of security configuration.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SecurityConfigType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecurityConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecurityConfigsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecurityConfigsInput) SetMaxResults(v int64) *ListSecurityConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityConfigsInput) SetNextToken(v string) *ListSecurityConfigsInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListSecurityConfigsInput) SetType(v string) *ListSecurityConfigsInput {
	s.Type = &v
	return s
}

type ListSecurityConfigsOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Details about the security configurations in your account.
	SecurityConfigSummaries []*SecurityConfigSummary `locationName:"securityConfigSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityConfigsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityConfigsOutput) SetNextToken(v string) *ListSecurityConfigsOutput {
	s.NextToken = &v
	return s
}

// SetSecurityConfigSummaries sets the SecurityConfigSummaries field's value.
func (s *ListSecurityConfigsOutput) SetSecurityConfigSummaries(v []*SecurityConfigSummary) *ListSecurityConfigsOutput {
	s.SecurityConfigSummaries = v
	return s
}

type ListSecurityPoliciesInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results. The default is 20.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If your initial ListSecurityPolicies operation returns a nextToken, you can
	// include the returned nextToken in subsequent ListSecurityPolicies operations,
	// which returns results in the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Resource filters (can be collection or indexes) that policies can apply to.
	Resource []*string `locationName:"resource" min:"1" type:"list"`

	// The type of policy.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SecurityPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSecurityPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSecurityPoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Resource != nil && len(s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSecurityPoliciesInput) SetMaxResults(v int64) *ListSecurityPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityPoliciesInput) SetNextToken(v string) *ListSecurityPoliciesInput {
	s.NextToken = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *ListSecurityPoliciesInput) SetResource(v []*string) *ListSecurityPoliciesInput {
	s.Resource = v
	return s
}

// SetType sets the Type field's value.
func (s *ListSecurityPoliciesInput) SetType(v string) *ListSecurityPoliciesInput {
	s.Type = &v
	return s
}

type ListSecurityPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Details about the security policies in your account.
	SecurityPolicySummaries []*SecurityPolicySummary `locationName:"securityPolicySummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSecurityPoliciesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSecurityPoliciesOutput) SetNextToken(v string) *ListSecurityPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetSecurityPolicySummaries sets the SecurityPolicySummaries field's value.
func (s *ListSecurityPoliciesOutput) SetSecurityPolicySummaries(v []*SecurityPolicySummary) *ListSecurityPoliciesOutput {
	s.SecurityPolicySummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. The resource must be active
	// (not in the DELETING state), and must be owned by the account ID included
	// in the request.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags associated with the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListVpcEndpointsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results. The default is 20.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If your initial ListVpcEndpoints operation returns a nextToken, you can include
	// the returned nextToken in subsequent ListVpcEndpoints operations, which returns
	// results in the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Filter the results according to the current status of the VPC endpoint. Possible
	// statuses are CREATING, DELETING, UPDATING, ACTIVE, and FAILED.
	VpcEndpointFilters *VpcEndpointFilters `locationName:"vpcEndpointFilters" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVpcEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVpcEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVpcEndpointsInput) SetMaxResults(v int64) *ListVpcEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVpcEndpointsInput) SetNextToken(v string) *ListVpcEndpointsInput {
	s.NextToken = &v
	return s
}

// SetVpcEndpointFilters sets the VpcEndpointFilters field's value.
func (s *ListVpcEndpointsInput) SetVpcEndpointFilters(v *VpcEndpointFilters) *ListVpcEndpointsInput {
	s.VpcEndpointFilters = v
	return s
}

type ListVpcEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Details about each VPC endpoint, including the name and current status.
	VpcEndpointSummaries []*VpcEndpointSummary `locationName:"vpcEndpointSummaries" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVpcEndpointsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVpcEndpointsOutput) SetNextToken(v string) *ListVpcEndpointsOutput {
	s.NextToken = &v
	return s
}

// SetVpcEndpointSummaries sets the VpcEndpointSummaries field's value.
func (s *ListVpcEndpointsOutput) SetVpcEndpointSummaries(v []*VpcEndpointSummary) *ListVpcEndpointsOutput {
	s.VpcEndpointSummaries = v
	return s
}

// OCU Limit Exceeded for service limits
type OcuLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OcuLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OcuLimitExceededException) GoString() string {
	return s.String()
}

func newErrorOcuLimitExceededException(v protocol.ResponseMetadata) error {
	return &OcuLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OcuLimitExceededException) Code() string {
	return "OcuLimitExceededException"
}

// Message returns the exception's message.
func (s *OcuLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OcuLimitExceededException) OrigErr() error {
	return nil
}

func (s *OcuLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OcuLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OcuLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Thrown when accessing or deleting a resource that does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes SAML options for an OpenSearch Serverless security configuration
// in the form of a key-value map.
type SamlConfigOptions struct {
	_ struct{} `type:"structure"`

	// The group attribute for this SAML integration.
	GroupAttribute *string `locationName:"groupAttribute" min:"1" type:"string"`

	// The XML IdP metadata file generated from your identity provider.
	//
	// Metadata is a required field
	Metadata *string `locationName:"metadata" min:"1" type:"string" required:"true"`

	// The session timeout, in minutes. Default is 60 minutes (12 hours).
	SessionTimeout *int64 `locationName:"sessionTimeout" min:"5" type:"integer"`

	// A user attribute for this SAML integration.
	UserAttribute *string `locationName:"userAttribute" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SamlConfigOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SamlConfigOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SamlConfigOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SamlConfigOptions"}
	if s.GroupAttribute != nil && len(*s.GroupAttribute) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupAttribute", 1))
	}
	if s.Metadata == nil {
		invalidParams.Add(request.NewErrParamRequired("Metadata"))
	}
	if s.Metadata != nil && len(*s.Metadata) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Metadata", 1))
	}
	if s.SessionTimeout != nil && *s.SessionTimeout < 5 {
		invalidParams.Add(request.NewErrParamMinValue("SessionTimeout", 5))
	}
	if s.UserAttribute != nil && len(*s.UserAttribute) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserAttribute", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupAttribute sets the GroupAttribute field's value.
func (s *SamlConfigOptions) SetGroupAttribute(v string) *SamlConfigOptions {
	s.GroupAttribute = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *SamlConfigOptions) SetMetadata(v string) *SamlConfigOptions {
	s.Metadata = &v
	return s
}

// SetSessionTimeout sets the SessionTimeout field's value.
func (s *SamlConfigOptions) SetSessionTimeout(v int64) *SamlConfigOptions {
	s.SessionTimeout = &v
	return s
}

// SetUserAttribute sets the UserAttribute field's value.
func (s *SamlConfigOptions) SetUserAttribute(v string) *SamlConfigOptions {
	s.UserAttribute = &v
	return s
}

// Details about a security configuration for OpenSearch Serverless.
type SecurityConfigDetail struct {
	_ struct{} `type:"structure"`

	// The version of the security configuration.
	ConfigVersion *string `locationName:"configVersion" min:"20" type:"string"`

	// The date the configuration was created.
	CreatedDate *int64 `locationName:"createdDate" type:"long"`

	// The description of the security configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the security configuration.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The timestamp of when the configuration was last modified.
	LastModifiedDate *int64 `locationName:"lastModifiedDate" type:"long"`

	// SAML options for the security configuration in the form of a key-value map.
	SamlOptions *SamlConfigOptions `locationName:"samlOptions" type:"structure"`

	// The type of security configuration.
	Type *string `locationName:"type" type:"string" enum:"SecurityConfigType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityConfigDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityConfigDetail) GoString() string {
	return s.String()
}

// SetConfigVersion sets the ConfigVersion field's value.
func (s *SecurityConfigDetail) SetConfigVersion(v string) *SecurityConfigDetail {
	s.ConfigVersion = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SecurityConfigDetail) SetCreatedDate(v int64) *SecurityConfigDetail {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SecurityConfigDetail) SetDescription(v string) *SecurityConfigDetail {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *SecurityConfigDetail) SetId(v string) *SecurityConfigDetail {
	s.Id = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SecurityConfigDetail) SetLastModifiedDate(v int64) *SecurityConfigDetail {
	s.LastModifiedDate = &v
	return s
}

// SetSamlOptions sets the SamlOptions field's value.
func (s *SecurityConfigDetail) SetSamlOptions(v *SamlConfigOptions) *SecurityConfigDetail {
	s.SamlOptions = v
	return s
}

// SetType sets the Type field's value.
func (s *SecurityConfigDetail) SetType(v string) *SecurityConfigDetail {
	s.Type = &v
	return s
}

// Statistics for an OpenSearch Serverless security configuration.
type SecurityConfigStats struct {
	_ struct{} `type:"structure"`

	// The number of security configurations in the current account.
	SamlConfigCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityConfigStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityConfigStats) GoString() string {
	return s.String()
}

// SetSamlConfigCount sets the SamlConfigCount field's value.
func (s *SecurityConfigStats) SetSamlConfigCount(v int64) *SecurityConfigStats {
	s.SamlConfigCount = &v
	return s
}

// A summary of a security configuration for OpenSearch Serverless.
type SecurityConfigSummary struct {
	_ struct{} `type:"structure"`

	// The version of the security configuration.
	ConfigVersion *string `locationName:"configVersion" min:"20" type:"string"`

	// The Epoch time when the security configuration was created.
	CreatedDate *int64 `locationName:"createdDate" type:"long"`

	// The description of the security configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the security configuration.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The timestamp of when the configuration was last modified.
	LastModifiedDate *int64 `locationName:"lastModifiedDate" type:"long"`

	// The type of security configuration.
	Type *string `locationName:"type" type:"string" enum:"SecurityConfigType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityConfigSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityConfigSummary) GoString() string {
	return s.String()
}

// SetConfigVersion sets the ConfigVersion field's value.
func (s *SecurityConfigSummary) SetConfigVersion(v string) *SecurityConfigSummary {
	s.ConfigVersion = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SecurityConfigSummary) SetCreatedDate(v int64) *SecurityConfigSummary {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SecurityConfigSummary) SetDescription(v string) *SecurityConfigSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *SecurityConfigSummary) SetId(v string) *SecurityConfigSummary {
	s.Id = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SecurityConfigSummary) SetLastModifiedDate(v int64) *SecurityConfigSummary {
	s.LastModifiedDate = &v
	return s
}

// SetType sets the Type field's value.
func (s *SecurityConfigSummary) SetType(v string) *SecurityConfigSummary {
	s.Type = &v
	return s
}

// Details about an OpenSearch Serverless security policy.
type SecurityPolicyDetail struct {
	_ struct{} `type:"structure"`

	// The date the policy was created.
	CreatedDate *int64 `locationName:"createdDate" type:"long"`

	// The description of the security policy.
	Description *string `locationName:"description" type:"string"`

	// The timestamp of when the policy was last modified.
	LastModifiedDate *int64 `locationName:"lastModifiedDate" type:"long"`

	// The name of the policy.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The version of the policy.
	PolicyVersion *string `locationName:"policyVersion" min:"20" type:"string"`

	// The type of security policy.
	Type *string `locationName:"type" type:"string" enum:"SecurityPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityPolicyDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityPolicyDetail) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SecurityPolicyDetail) SetCreatedDate(v int64) *SecurityPolicyDetail {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SecurityPolicyDetail) SetDescription(v string) *SecurityPolicyDetail {
	s.Description = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SecurityPolicyDetail) SetLastModifiedDate(v int64) *SecurityPolicyDetail {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *SecurityPolicyDetail) SetName(v string) *SecurityPolicyDetail {
	s.Name = &v
	return s
}

// SetPolicyVersion sets the PolicyVersion field's value.
func (s *SecurityPolicyDetail) SetPolicyVersion(v string) *SecurityPolicyDetail {
	s.PolicyVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *SecurityPolicyDetail) SetType(v string) *SecurityPolicyDetail {
	s.Type = &v
	return s
}

// Statistics for an OpenSearch Serverless security policy.
type SecurityPolicyStats struct {
	_ struct{} `type:"structure"`

	// The number of encryption policies in the current account.
	EncryptionPolicyCount *int64 `type:"long"`

	// The number of network policies in the current account.
	NetworkPolicyCount *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityPolicyStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityPolicyStats) GoString() string {
	return s.String()
}

// SetEncryptionPolicyCount sets the EncryptionPolicyCount field's value.
func (s *SecurityPolicyStats) SetEncryptionPolicyCount(v int64) *SecurityPolicyStats {
	s.EncryptionPolicyCount = &v
	return s
}

// SetNetworkPolicyCount sets the NetworkPolicyCount field's value.
func (s *SecurityPolicyStats) SetNetworkPolicyCount(v int64) *SecurityPolicyStats {
	s.NetworkPolicyCount = &v
	return s
}

// A summary of a security policy for OpenSearch Serverless.
type SecurityPolicySummary struct {
	_ struct{} `type:"structure"`

	// The date the policy was created.
	CreatedDate *int64 `locationName:"createdDate" type:"long"`

	// The description of the security policy.
	Description *string `locationName:"description" type:"string"`

	// The timestamp of when the policy was last modified.
	LastModifiedDate *int64 `locationName:"lastModifiedDate" type:"long"`

	// The name of the policy.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The version of the policy.
	PolicyVersion *string `locationName:"policyVersion" min:"20" type:"string"`

	// The type of security policy.
	Type *string `locationName:"type" type:"string" enum:"SecurityPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityPolicySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityPolicySummary) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *SecurityPolicySummary) SetCreatedDate(v int64) *SecurityPolicySummary {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SecurityPolicySummary) SetDescription(v string) *SecurityPolicySummary {
	s.Description = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *SecurityPolicySummary) SetLastModifiedDate(v int64) *SecurityPolicySummary {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *SecurityPolicySummary) SetName(v string) *SecurityPolicySummary {
	s.Name = &v
	return s
}

// SetPolicyVersion sets the PolicyVersion field's value.
func (s *SecurityPolicySummary) SetPolicyVersion(v string) *SecurityPolicySummary {
	s.PolicyVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *SecurityPolicySummary) SetType(v string) *SecurityPolicySummary {
	s.Type = &v
	return s
}

// Thrown when you attempt to create more resources than the service allows
// based on service quotas.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Service Quotas requirement to identify originating quota.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Identifier of the resource affected.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// Type of the resource affected.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// Service Quotas requirement to identify originating service.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A map of key-value pairs associated to an OpenSearch Serverless resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key to use in the tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource. The resource must be active
	// (not in the DELETING state), and must be owned by the account ID included
	// in the request.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of tags (key-value pairs) to add to the resource. All tag keys in
	// the request must be unique.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to remove tags from. The resource
	// must be active (not in the DELETING state), and must be owned by the account
	// ID included in the request.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tag or set of tags to remove from the resource. All tag keys in the request
	// must be unique.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the policy. Typically used to store information about the
	// permissions defined in the policy.
	Description *string `locationName:"description" type:"string"`

	// The name of the policy.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The JSON policy document to use as the content for the policy.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// The version of the policy being updated.
	//
	// PolicyVersion is a required field
	PolicyVersion *string `locationName:"policyVersion" min:"20" type:"string" required:"true"`

	// The type of policy.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AccessPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccessPolicyInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.PolicyVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyVersion"))
	}
	if s.PolicyVersion != nil && len(*s.PolicyVersion) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyVersion", 20))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateAccessPolicyInput) SetClientToken(v string) *UpdateAccessPolicyInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAccessPolicyInput) SetDescription(v string) *UpdateAccessPolicyInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAccessPolicyInput) SetName(v string) *UpdateAccessPolicyInput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *UpdateAccessPolicyInput) SetPolicy(v string) *UpdateAccessPolicyInput {
	s.Policy = &v
	return s
}

// SetPolicyVersion sets the PolicyVersion field's value.
func (s *UpdateAccessPolicyInput) SetPolicyVersion(v string) *UpdateAccessPolicyInput {
	s.PolicyVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateAccessPolicyInput) SetType(v string) *UpdateAccessPolicyInput {
	s.Type = &v
	return s
}

type UpdateAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Details about the updated access policy.
	AccessPolicyDetail *AccessPolicyDetail `locationName:"accessPolicyDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessPolicyOutput) GoString() string {
	return s.String()
}

// SetAccessPolicyDetail sets the AccessPolicyDetail field's value.
func (s *UpdateAccessPolicyOutput) SetAccessPolicyDetail(v *AccessPolicyDetail) *UpdateAccessPolicyOutput {
	s.AccessPolicyDetail = v
	return s
}

type UpdateAccountSettingsInput struct {
	_ struct{} `type:"structure"`

	// The maximum capacity limits for all OpenSearch Serverless collections, in
	// OpenSearch Compute Units (OCUs). These limits are used to scale your collections
	// based on the current workload. For more information, see Managing capacity
	// limits for Amazon OpenSearch Serverless (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html).
	CapacityLimits *CapacityLimits `locationName:"capacityLimits" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccountSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccountSettingsInput"}
	if s.CapacityLimits != nil {
		if err := s.CapacityLimits.Validate(); err != nil {
			invalidParams.AddNested("CapacityLimits", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityLimits sets the CapacityLimits field's value.
func (s *UpdateAccountSettingsInput) SetCapacityLimits(v *CapacityLimits) *UpdateAccountSettingsInput {
	s.CapacityLimits = v
	return s
}

type UpdateAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// OpenSearch Serverless-related settings for the current Amazon Web Services
	// account.
	AccountSettingsDetail *AccountSettingsDetail `locationName:"accountSettingsDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettingsDetail sets the AccountSettingsDetail field's value.
func (s *UpdateAccountSettingsOutput) SetAccountSettingsDetail(v *AccountSettingsDetail) *UpdateAccountSettingsOutput {
	s.AccountSettingsDetail = v
	return s
}

// Details about an updated OpenSearch Serverless collection.
type UpdateCollectionDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the collection.
	Arn *string `locationName:"arn" type:"string"`

	// The date and time when the collection was created.
	CreatedDate *int64 `locationName:"createdDate" type:"long"`

	// The description of the collection.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the collection.
	Id *string `locationName:"id" min:"3" type:"string"`

	// The date and time when the collection was last modified.
	LastModifiedDate *int64 `locationName:"lastModifiedDate" type:"long"`

	// The name of the collection.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The current status of the collection.
	Status *string `locationName:"status" type:"string" enum:"CollectionStatus"`

	// The collection type.
	Type *string `locationName:"type" type:"string" enum:"CollectionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCollectionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCollectionDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateCollectionDetail) SetArn(v string) *UpdateCollectionDetail {
	s.Arn = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *UpdateCollectionDetail) SetCreatedDate(v int64) *UpdateCollectionDetail {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateCollectionDetail) SetDescription(v string) *UpdateCollectionDetail {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateCollectionDetail) SetId(v string) *UpdateCollectionDetail {
	s.Id = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *UpdateCollectionDetail) SetLastModifiedDate(v int64) *UpdateCollectionDetail {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCollectionDetail) SetName(v string) *UpdateCollectionDetail {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateCollectionDetail) SetStatus(v string) *UpdateCollectionDetail {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateCollectionDetail) SetType(v string) *UpdateCollectionDetail {
	s.Type = &v
	return s
}

type UpdateCollectionInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the collection.
	Description *string `locationName:"description" type:"string"`

	// The unique identifier of the collection.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCollectionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateCollectionInput) SetClientToken(v string) *UpdateCollectionInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateCollectionInput) SetDescription(v string) *UpdateCollectionInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateCollectionInput) SetId(v string) *UpdateCollectionInput {
	s.Id = &v
	return s
}

type UpdateCollectionOutput struct {
	_ struct{} `type:"structure"`

	// Details about the updated collection.
	UpdateCollectionDetail *UpdateCollectionDetail `locationName:"updateCollectionDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCollectionOutput) GoString() string {
	return s.String()
}

// SetUpdateCollectionDetail sets the UpdateCollectionDetail field's value.
func (s *UpdateCollectionOutput) SetUpdateCollectionDetail(v *UpdateCollectionDetail) *UpdateCollectionOutput {
	s.UpdateCollectionDetail = v
	return s
}

type UpdateSecurityConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The version of the security configuration to be updated. You can find the
	// most recent version of a security configuration using the GetSecurityPolicy
	// command.
	//
	// ConfigVersion is a required field
	ConfigVersion *string `locationName:"configVersion" min:"20" type:"string" required:"true"`

	// A description of the security configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The security configuration identifier. For SAML the ID will be saml/<accountId>/<idpProviderName>.
	// For example, saml/123456789123/OKTADev.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// SAML options in in the form of a key-value map.
	SamlOptions *SamlConfigOptions `locationName:"samlOptions" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSecurityConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSecurityConfigInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ConfigVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigVersion"))
	}
	if s.ConfigVersion != nil && len(*s.ConfigVersion) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigVersion", 20))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.SamlOptions != nil {
		if err := s.SamlOptions.Validate(); err != nil {
			invalidParams.AddNested("SamlOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateSecurityConfigInput) SetClientToken(v string) *UpdateSecurityConfigInput {
	s.ClientToken = &v
	return s
}

// SetConfigVersion sets the ConfigVersion field's value.
func (s *UpdateSecurityConfigInput) SetConfigVersion(v string) *UpdateSecurityConfigInput {
	s.ConfigVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateSecurityConfigInput) SetDescription(v string) *UpdateSecurityConfigInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateSecurityConfigInput) SetId(v string) *UpdateSecurityConfigInput {
	s.Id = &v
	return s
}

// SetSamlOptions sets the SamlOptions field's value.
func (s *UpdateSecurityConfigInput) SetSamlOptions(v *SamlConfigOptions) *UpdateSecurityConfigInput {
	s.SamlOptions = v
	return s
}

type UpdateSecurityConfigOutput struct {
	_ struct{} `type:"structure"`

	// Details about the updated security configuration.
	SecurityConfigDetail *SecurityConfigDetail `locationName:"securityConfigDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityConfigOutput) GoString() string {
	return s.String()
}

// SetSecurityConfigDetail sets the SecurityConfigDetail field's value.
func (s *UpdateSecurityConfigOutput) SetSecurityConfigDetail(v *SecurityConfigDetail) *UpdateSecurityConfigOutput {
	s.SecurityConfigDetail = v
	return s
}

type UpdateSecurityPolicyInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// A description of the policy. Typically used to store information about the
	// permissions defined in the policy.
	Description *string `locationName:"description" type:"string"`

	// The name of the policy.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"3" type:"string" required:"true"`

	// The JSON policy document to use as the content for the new policy.
	Policy *string `locationName:"policy" min:"1" type:"string"`

	// The version of the policy being updated.
	//
	// PolicyVersion is a required field
	PolicyVersion *string `locationName:"policyVersion" min:"20" type:"string" required:"true"`

	// The type of access policy.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"SecurityPolicyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSecurityPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSecurityPolicyInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 3))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.PolicyVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyVersion"))
	}
	if s.PolicyVersion != nil && len(*s.PolicyVersion) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyVersion", 20))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateSecurityPolicyInput) SetClientToken(v string) *UpdateSecurityPolicyInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateSecurityPolicyInput) SetDescription(v string) *UpdateSecurityPolicyInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSecurityPolicyInput) SetName(v string) *UpdateSecurityPolicyInput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *UpdateSecurityPolicyInput) SetPolicy(v string) *UpdateSecurityPolicyInput {
	s.Policy = &v
	return s
}

// SetPolicyVersion sets the PolicyVersion field's value.
func (s *UpdateSecurityPolicyInput) SetPolicyVersion(v string) *UpdateSecurityPolicyInput {
	s.PolicyVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateSecurityPolicyInput) SetType(v string) *UpdateSecurityPolicyInput {
	s.Type = &v
	return s
}

type UpdateSecurityPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Details about the updated security policy.
	SecurityPolicyDetail *SecurityPolicyDetail `locationName:"securityPolicyDetail" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSecurityPolicyOutput) GoString() string {
	return s.String()
}

// SetSecurityPolicyDetail sets the SecurityPolicyDetail field's value.
func (s *UpdateSecurityPolicyOutput) SetSecurityPolicyDetail(v *SecurityPolicyDetail) *UpdateSecurityPolicyOutput {
	s.SecurityPolicyDetail = v
	return s
}

// Update details for an OpenSearch Serverless-managed interface endpoint.
type UpdateVpcEndpointDetail struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the endpoint.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The timestamp of when the endpoint was last modified.
	LastModifiedDate *int64 `locationName:"lastModifiedDate" type:"long"`

	// The name of the endpoint.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The unique identifiers of the security groups that define the ports, protocols,
	// and sources for inbound traffic that you are authorizing into your endpoint.
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list"`

	// The current status of the endpoint update process.
	Status *string `locationName:"status" type:"string" enum:"VpcEndpointStatus"`

	// The ID of the subnets from which you access OpenSearch Serverless.
	SubnetIds []*string `locationName:"subnetIds" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVpcEndpointDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVpcEndpointDetail) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *UpdateVpcEndpointDetail) SetId(v string) *UpdateVpcEndpointDetail {
	s.Id = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *UpdateVpcEndpointDetail) SetLastModifiedDate(v int64) *UpdateVpcEndpointDetail {
	s.LastModifiedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateVpcEndpointDetail) SetName(v string) *UpdateVpcEndpointDetail {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateVpcEndpointDetail) SetSecurityGroupIds(v []*string) *UpdateVpcEndpointDetail {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateVpcEndpointDetail) SetStatus(v string) *UpdateVpcEndpointDetail {
	s.Status = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *UpdateVpcEndpointDetail) SetSubnetIds(v []*string) *UpdateVpcEndpointDetail {
	s.SubnetIds = v
	return s
}

type UpdateVpcEndpointInput struct {
	_ struct{} `type:"structure"`

	// The unique identifiers of the security groups to add to the endpoint. Security
	// groups define the ports, protocols, and sources for inbound traffic that
	// you are authorizing into your endpoint.
	AddSecurityGroupIds []*string `locationName:"addSecurityGroupIds" min:"1" type:"list"`

	// The ID of one or more subnets to add to the endpoint.
	AddSubnetIds []*string `locationName:"addSubnetIds" min:"1" type:"list"`

	// Unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The unique identifier of the interface endpoint to update.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The unique identifiers of the security groups to remove from the endpoint.
	RemoveSecurityGroupIds []*string `locationName:"removeSecurityGroupIds" min:"1" type:"list"`

	// The unique identifiers of the subnets to remove from the endpoint.
	RemoveSubnetIds []*string `locationName:"removeSubnetIds" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVpcEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVpcEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVpcEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVpcEndpointInput"}
	if s.AddSecurityGroupIds != nil && len(s.AddSecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddSecurityGroupIds", 1))
	}
	if s.AddSubnetIds != nil && len(s.AddSubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddSubnetIds", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.RemoveSecurityGroupIds != nil && len(s.RemoveSecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RemoveSecurityGroupIds", 1))
	}
	if s.RemoveSubnetIds != nil && len(s.RemoveSubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RemoveSubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddSecurityGroupIds sets the AddSecurityGroupIds field's value.
func (s *UpdateVpcEndpointInput) SetAddSecurityGroupIds(v []*string) *UpdateVpcEndpointInput {
	s.AddSecurityGroupIds = v
	return s
}

// SetAddSubnetIds sets the AddSubnetIds field's value.
func (s *UpdateVpcEndpointInput) SetAddSubnetIds(v []*string) *UpdateVpcEndpointInput {
	s.AddSubnetIds = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateVpcEndpointInput) SetClientToken(v string) *UpdateVpcEndpointInput {
	s.ClientToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateVpcEndpointInput) SetId(v string) *UpdateVpcEndpointInput {
	s.Id = &v
	return s
}

// SetRemoveSecurityGroupIds sets the RemoveSecurityGroupIds field's value.
func (s *UpdateVpcEndpointInput) SetRemoveSecurityGroupIds(v []*string) *UpdateVpcEndpointInput {
	s.RemoveSecurityGroupIds = v
	return s
}

// SetRemoveSubnetIds sets the RemoveSubnetIds field's value.
func (s *UpdateVpcEndpointInput) SetRemoveSubnetIds(v []*string) *UpdateVpcEndpointInput {
	s.RemoveSubnetIds = v
	return s
}

type UpdateVpcEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Details about the updated VPC endpoint.
	UpdateVpcEndpointDetail *UpdateVpcEndpointDetail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVpcEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVpcEndpointOutput) GoString() string {
	return s.String()
}

// SetUpdateVpcEndpointDetail sets the UpdateVpcEndpointDetail field's value.
func (s *UpdateVpcEndpointOutput) SetUpdateVpcEndpointDetail(v *UpdateVpcEndpointDetail) *UpdateVpcEndpointOutput {
	s.UpdateVpcEndpointDetail = v
	return s
}

// Thrown when the HTTP request contains invalid input or is missing required
// input.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about an OpenSearch Serverless-managed interface endpoint.
type VpcEndpointDetail struct {
	_ struct{} `type:"structure"`

	// The date the endpoint was created.
	CreatedDate *int64 `locationName:"createdDate" type:"long"`

	// The unique identifier of the endpoint.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the endpoint.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The unique identifiers of the security groups that define the ports, protocols,
	// and sources for inbound traffic that you are authorizing into your endpoint.
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list"`

	// The current status of the endpoint.
	Status *string `locationName:"status" type:"string" enum:"VpcEndpointStatus"`

	// The ID of the subnets from which you access OpenSearch Serverless.
	SubnetIds []*string `locationName:"subnetIds" min:"1" type:"list"`

	// The ID of the VPC from which you access OpenSearch Serverless.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointDetail) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *VpcEndpointDetail) SetCreatedDate(v int64) *VpcEndpointDetail {
	s.CreatedDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *VpcEndpointDetail) SetId(v string) *VpcEndpointDetail {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *VpcEndpointDetail) SetName(v string) *VpcEndpointDetail {
	s.Name = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcEndpointDetail) SetSecurityGroupIds(v []*string) *VpcEndpointDetail {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *VpcEndpointDetail) SetStatus(v string) *VpcEndpointDetail {
	s.Status = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcEndpointDetail) SetSubnetIds(v []*string) *VpcEndpointDetail {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcEndpointDetail) SetVpcId(v string) *VpcEndpointDetail {
	s.VpcId = &v
	return s
}

// Error information for a failed BatchGetVpcEndpoint request.
type VpcEndpointErrorDetail struct {
	_ struct{} `type:"structure"`

	// The error code for the failed request.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// An error message describing the reason for the failure.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The unique identifier of the VPC endpoint.
	Id *string `locationName:"id" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *VpcEndpointErrorDetail) SetErrorCode(v string) *VpcEndpointErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *VpcEndpointErrorDetail) SetErrorMessage(v string) *VpcEndpointErrorDetail {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *VpcEndpointErrorDetail) SetId(v string) *VpcEndpointErrorDetail {
	s.Id = &v
	return s
}

// Filter the results of a ListVpcEndpoints request.
type VpcEndpointFilters struct {
	_ struct{} `type:"structure"`

	// The current status of the endpoint.
	Status *string `locationName:"status" type:"string" enum:"VpcEndpointStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointFilters) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VpcEndpointFilters) SetStatus(v string) *VpcEndpointFilters {
	s.Status = &v
	return s
}

// The VPC endpoint object.
type VpcEndpointSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the endpoint.
	Id *string `locationName:"id" min:"1" type:"string"`

	// The name of the endpoint.
	Name *string `locationName:"name" min:"3" type:"string"`

	// The current status of the endpoint.
	Status *string `locationName:"status" type:"string" enum:"VpcEndpointStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpointSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *VpcEndpointSummary) SetId(v string) *VpcEndpointSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *VpcEndpointSummary) SetName(v string) *VpcEndpointSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VpcEndpointSummary) SetStatus(v string) *VpcEndpointSummary {
	s.Status = &v
	return s
}

const (
	// AccessPolicyTypeData is a AccessPolicyType enum value
	AccessPolicyTypeData = "data"
)

// AccessPolicyType_Values returns all elements of the AccessPolicyType enum
func AccessPolicyType_Values() []string {
	return []string{
		AccessPolicyTypeData,
	}
}

const (
	// CollectionStatusCreating is a CollectionStatus enum value
	CollectionStatusCreating = "CREATING"

	// CollectionStatusDeleting is a CollectionStatus enum value
	CollectionStatusDeleting = "DELETING"

	// CollectionStatusActive is a CollectionStatus enum value
	CollectionStatusActive = "ACTIVE"

	// CollectionStatusFailed is a CollectionStatus enum value
	CollectionStatusFailed = "FAILED"
)

// CollectionStatus_Values returns all elements of the CollectionStatus enum
func CollectionStatus_Values() []string {
	return []string{
		CollectionStatusCreating,
		CollectionStatusDeleting,
		CollectionStatusActive,
		CollectionStatusFailed,
	}
}

const (
	// CollectionTypeSearch is a CollectionType enum value
	CollectionTypeSearch = "SEARCH"

	// CollectionTypeTimeseries is a CollectionType enum value
	CollectionTypeTimeseries = "TIMESERIES"
)

// CollectionType_Values returns all elements of the CollectionType enum
func CollectionType_Values() []string {
	return []string{
		CollectionTypeSearch,
		CollectionTypeTimeseries,
	}
}

const (
	// SecurityConfigTypeSaml is a SecurityConfigType enum value
	SecurityConfigTypeSaml = "saml"
)

// SecurityConfigType_Values returns all elements of the SecurityConfigType enum
func SecurityConfigType_Values() []string {
	return []string{
		SecurityConfigTypeSaml,
	}
}

const (
	// SecurityPolicyTypeEncryption is a SecurityPolicyType enum value
	SecurityPolicyTypeEncryption = "encryption"

	// SecurityPolicyTypeNetwork is a SecurityPolicyType enum value
	SecurityPolicyTypeNetwork = "network"
)

// SecurityPolicyType_Values returns all elements of the SecurityPolicyType enum
func SecurityPolicyType_Values() []string {
	return []string{
		SecurityPolicyTypeEncryption,
		SecurityPolicyTypeNetwork,
	}
}

const (
	// VpcEndpointStatusPending is a VpcEndpointStatus enum value
	VpcEndpointStatusPending = "PENDING"

	// VpcEndpointStatusDeleting is a VpcEndpointStatus enum value
	VpcEndpointStatusDeleting = "DELETING"

	// VpcEndpointStatusActive is a VpcEndpointStatus enum value
	VpcEndpointStatusActive = "ACTIVE"

	// VpcEndpointStatusFailed is a VpcEndpointStatus enum value
	VpcEndpointStatusFailed = "FAILED"
)

// VpcEndpointStatus_Values returns all elements of the VpcEndpointStatus enum
func VpcEndpointStatus_Values() []string {
	return []string{
		VpcEndpointStatusPending,
		VpcEndpointStatusDeleting,
		VpcEndpointStatusActive,
		VpcEndpointStatusFailed,
	}
}
