<!--
  - SPDX-FileCopyrightText: 2017 Nextcloud GmbH and Nextcloud contributors
  - SPDX-FileCopyrightText: 2013 Nextcloud GmbH and Nextcloud contributors
  - SPDX-License-Identifier: GPL-2.0-or-later
-->
## Contributing by reporting issues

* **Always report bugs via Github**: that is the most reliable way to contacts us since we do not follow any process to check the forum and social media. 
* **For questions about the Nextcloud Desktop Client**, use the [📋 Forum](https://help.nextcloud.com) and the [:speech_balloon: Desktop public Talk chat room](https://cloud.nextcloud.com/call/d8k2r6p6).
* Alternativately, we also have [🐣 Twitter](https://twitter.com/Nextclouders) and [🐘 Mastodon](https://mastodon.xyz/@nextcloud) accounts. 

### Bug Reporting Guidelines

* __Important__: [Complete the bug report form](https://github.com/nextcloud/desktop/issues/new/choose). If you fill it correctly, it should give us enough information to start working on the issue.
* __SECURITY__: **Please do _not_ report security vulnerabilities through public GitHub issues.** 
If you have discovered a security matter with Nextcloud, please first read our [responsible disclosure guidelines](https://nextcloud.com/security/) and our [security policy](https://github.com/nextcloud/server/blob/9459724e72d647bb21d0bc36c6dc56b751771130/SECURITY.md). Then contact us at [hackerone.com/nextcloud](https://hackerone.com/nextcloud).
* This repository is *only* for issues within the Nextcloud desktop client. 
  Issues in other components should be reported in their own repositores: 
  - [Nextcloud server](https://github.com/nextcloud/server/issues)
  - [Android client](https://github.com/nextcloud/android/issues)
  - [iOS client](https://github.com/nextcloud/ios/issues)
* Search the existing issues first, it's likely that your issue was already
  reported.
* If your issue appears to be a bug and hasn't been reported, open a new issue.
  Help us to maximize the effort we can spend fixing issues and adding new features, by not reporting duplicate issues.

## Contributing to Source Code

Thanks for wanting to contribute source code to Nextcloud. That's great!

We ask that you follow our [Code of Conduct](https://nextcloud.com/code-of-conduct/).

Please read the [Contribution Guide](https://nextcloud.com/contribute/) to get 
started and follow the [Coding Style](https://github.com/nextcloud/desktop/wiki/Coding-Style)
when writing new code.

### Sign your work

We use the Developer Certificate of Origin (DCO) as an additional safeguard
for the Nextcloud project. This is a well established and widely used
mechanism to assure contributors have confirmed their right to license
their contribution under the project's license.
Please read [contribute/developer-certificate-of-origin](https://github.com/nextcloud/server/blob/master/contribute/developer-certificate-of-origin).
If you can certify it, then just add a line to every git commit message:

```
Signed-off-by: Random J Developer <random@developer.example.org>
```

If you set your `user.name` and `user.email` git configs, you can sign your
commit automatically with `git commit -s`. You can also use git [aliases](https://git-scm.com/book/tr/v2/Git-Basics-Git-Aliases)
like `git config --global alias.ci 'commit -s'`. Now you can commit with
`git ci` and the commit will be signed.


## Translations

Please submit translations via [Transifex](https://www.transifex.com/nextcloud/nextcloud/).
