/*********************************************************************
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ===================================================================
 * Revision History ::
 * YYYY.MM.DD   Change ID       Developer
 *              Description
 * -------------------------------------------------------------------
 * 2002.04.25                   Vlad Skarzhevskyy
 *              Initial implementation.
 *
 * ===================================================================
 *
 * This file define map between Windows/DOS and Unix functions.
 * As well missing in Windows/DOS functions defined in platform.c
 *
 ********************************************************************/


#ifndef pure_sfv_platform_h_defined
#define pure_sfv_platform_h_defined


#define DIR_SEP_UNIX '/'
#define DIR_SEP_DOS  '\\'

#ifdef __unix

/* Define new name for common functions just in case */

#include <dirent.h>
#include <unistd.h>
/* #include <libgen.h> */

#define DIR_SEP_PLATFORM DIR_SEP_UNIX
#define DOS_LINE_END     "\r\n"

#define O_BINARY      0

/* End on Unix */
#else

#ifdef _MSC_VER

/* MS VC++ Solution for this commmon functions */

#include <io.h>
#include <direct.h>

#define DIR_SEP_PLATFORM DIR_SEP_DOS
#define DOS_LINE_END     "\n"

#define open  _open
#define read  _read
#define close _close
#define stat  _stat
#define S_ISDIR(mode)   (((mode)&_S_IFDIR))

#define strcasecmp        _stricmp

#ifndef O_RDONLY
#define O_RDONLY          _O_RDONLY
#endif

#ifndef O_BINARY
#define O_BINARY           _O_BINARY
#endif

#define PATH_MAX          _MAX_PATH


extern char*  optarg;
extern int    optind;
extern int getopt(int argc, char** argv, const char* pszValidOpts);

extern int chdir(const char *path);
extern char *getcwd(char *buf, int size);

typedef struct
{
    char          name[PATH_MAX];
	long          dirp;
} DIR;

extern DIR *opendir(const char *dirname);
extern int closedir(DIR *dirp);

struct dirent
{
	char            d_name[PATH_MAX];
};

extern struct dirent *readdir(DIR *dirp);

/* ifdef _MSC_VER */
#endif

/* ifdef __unix */
#endif

#endif
/* EOF */
