// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/asset/v1/asset_service.proto

package asset

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	expr "google.golang.org/genproto/googleapis/type/expr"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Asset content type.
type ContentType int32

const (
	// Unspecified content type.
	ContentType_CONTENT_TYPE_UNSPECIFIED ContentType = 0
	// Resource metadata.
	ContentType_RESOURCE ContentType = 1
	// The actual IAM policy set on a resource.
	ContentType_IAM_POLICY ContentType = 2
	// The Cloud Organization Policy set on an asset.
	ContentType_ORG_POLICY ContentType = 4
	// The Cloud Access context manager Policy set on an asset.
	ContentType_ACCESS_POLICY ContentType = 5
	// The runtime OS Inventory information.
	ContentType_OS_INVENTORY ContentType = 6
	// The related resources.
	ContentType_RELATIONSHIP ContentType = 7
)

// Enum value maps for ContentType.
var (
	ContentType_name = map[int32]string{
		0: "CONTENT_TYPE_UNSPECIFIED",
		1: "RESOURCE",
		2: "IAM_POLICY",
		4: "ORG_POLICY",
		5: "ACCESS_POLICY",
		6: "OS_INVENTORY",
		7: "RELATIONSHIP",
	}
	ContentType_value = map[string]int32{
		"CONTENT_TYPE_UNSPECIFIED": 0,
		"RESOURCE":                 1,
		"IAM_POLICY":               2,
		"ORG_POLICY":               4,
		"ACCESS_POLICY":            5,
		"OS_INVENTORY":             6,
		"RELATIONSHIP":             7,
	}
)

func (x ContentType) Enum() *ContentType {
	p := new(ContentType)
	*p = x
	return p
}

func (x ContentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[0].Descriptor()
}

func (ContentType) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[0]
}

func (x ContentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContentType.Descriptor instead.
func (ContentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{0}
}

// This enum is used to determine the partition key column when exporting
// assets to BigQuery partitioned table(s). Note that, if the partition key is
// a timestamp column, the actual partition is based on its date value
// (expressed in UTC. see details in
// https://cloud.google.com/bigquery/docs/partitioned-tables#date_timestamp_partitioned_tables).
type PartitionSpec_PartitionKey int32

const (
	// Unspecified partition key. If used, it means using non-partitioned table.
	PartitionSpec_PARTITION_KEY_UNSPECIFIED PartitionSpec_PartitionKey = 0
	// The time when the snapshot is taken. If specified as partition key, the
	// result table(s) is partitoned by the additional timestamp column,
	// readTime. If [read_time] in ExportAssetsRequest is specified, the
	// readTime column's value will be the same as it. Otherwise, its value will
	// be the current time that is used to take the snapshot.
	PartitionSpec_READ_TIME PartitionSpec_PartitionKey = 1
	// The time when the request is received and started to be processed. If
	// specified as partition key, the result table(s) is partitoned by the
	// requestTime column, an additional timestamp column representing when the
	// request was received.
	PartitionSpec_REQUEST_TIME PartitionSpec_PartitionKey = 2
)

// Enum value maps for PartitionSpec_PartitionKey.
var (
	PartitionSpec_PartitionKey_name = map[int32]string{
		0: "PARTITION_KEY_UNSPECIFIED",
		1: "READ_TIME",
		2: "REQUEST_TIME",
	}
	PartitionSpec_PartitionKey_value = map[string]int32{
		"PARTITION_KEY_UNSPECIFIED": 0,
		"READ_TIME":                 1,
		"REQUEST_TIME":              2,
	}
)

func (x PartitionSpec_PartitionKey) Enum() *PartitionSpec_PartitionKey {
	p := new(PartitionSpec_PartitionKey)
	*p = x
	return p
}

func (x PartitionSpec_PartitionKey) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartitionSpec_PartitionKey) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[1].Descriptor()
}

func (PartitionSpec_PartitionKey) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[1]
}

func (x PartitionSpec_PartitionKey) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartitionSpec_PartitionKey.Descriptor instead.
func (PartitionSpec_PartitionKey) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{18, 0}
}

// This enum determines the partition key column for the bigquery tables.
// Partitioning can improve query performance and reduce query cost by
// filtering partitions. Refer to
// https://cloud.google.com/bigquery/docs/partitioned-tables for details.
type IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey int32

const (
	// Unspecified partition key. Tables won't be partitioned using this
	// option.
	IamPolicyAnalysisOutputConfig_BigQueryDestination_PARTITION_KEY_UNSPECIFIED IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey = 0
	// The time when the request is received. If specified as partition key,
	// the result table(s) is partitoned by the RequestTime column, an
	// additional timestamp column representing when the request was received.
	IamPolicyAnalysisOutputConfig_BigQueryDestination_REQUEST_TIME IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey = 1
)

// Enum value maps for IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey.
var (
	IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey_name = map[int32]string{
		0: "PARTITION_KEY_UNSPECIFIED",
		1: "REQUEST_TIME",
	}
	IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey_value = map[string]int32{
		"PARTITION_KEY_UNSPECIFIED": 0,
		"REQUEST_TIME":              1,
	}
)

func (x IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) Enum() *IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey {
	p := new(IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey)
	*p = x
	return p
}

func (x IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[2].Descriptor()
}

func (IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[2]
}

func (x IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey.Descriptor instead.
func (IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{29, 1, 0}
}

// View enum for supporting partial analysis responses.
type AnalyzeMoveRequest_AnalysisView int32

const (
	// The default/unset value.
	// The API will default to the FULL view.
	AnalyzeMoveRequest_ANALYSIS_VIEW_UNSPECIFIED AnalyzeMoveRequest_AnalysisView = 0
	// Full analysis including all level of impacts of the specified resource
	// move.
	AnalyzeMoveRequest_FULL AnalyzeMoveRequest_AnalysisView = 1
	// Basic analysis only including blockers which will prevent the specified
	// resource move at runtime.
	AnalyzeMoveRequest_BASIC AnalyzeMoveRequest_AnalysisView = 2
)

// Enum value maps for AnalyzeMoveRequest_AnalysisView.
var (
	AnalyzeMoveRequest_AnalysisView_name = map[int32]string{
		0: "ANALYSIS_VIEW_UNSPECIFIED",
		1: "FULL",
		2: "BASIC",
	}
	AnalyzeMoveRequest_AnalysisView_value = map[string]int32{
		"ANALYSIS_VIEW_UNSPECIFIED": 0,
		"FULL":                      1,
		"BASIC":                     2,
	}
)

func (x AnalyzeMoveRequest_AnalysisView) Enum() *AnalyzeMoveRequest_AnalysisView {
	p := new(AnalyzeMoveRequest_AnalysisView)
	*p = x
	return p
}

func (x AnalyzeMoveRequest_AnalysisView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnalyzeMoveRequest_AnalysisView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[3].Descriptor()
}

func (AnalyzeMoveRequest_AnalysisView) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[3]
}

func (x AnalyzeMoveRequest_AnalysisView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnalyzeMoveRequest_AnalysisView.Descriptor instead.
func (AnalyzeMoveRequest_AnalysisView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{39, 0}
}

// Represents the metadata of the longrunning operation for the
// AnalyzeIamPolicyLongrunning rpc.
type AnalyzeIamPolicyLongrunningMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *AnalyzeIamPolicyLongrunningMetadata) Reset() {
	*x = AnalyzeIamPolicyLongrunningMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyLongrunningMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyLongrunningMetadata) ProtoMessage() {}

func (x *AnalyzeIamPolicyLongrunningMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyLongrunningMetadata.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyLongrunningMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{0}
}

func (x *AnalyzeIamPolicyLongrunningMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Export asset request.
type ExportAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. This can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345"),
	// or a folder number (such as "folders/123").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Timestamp to take an asset snapshot. This can only be set to a timestamp
	// between the current time and the current time minus 35 days (inclusive).
	// If not specified, the current time will be used. Due to delays in resource
	// data collection and indexing, there is a volatile window during which
	// running the same query may get different results.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// A list of asset types to take a snapshot for. For example:
	// "compute.googleapis.com/Disk".
	//
	// Regular expressions are also supported. For example:
	//
	// * "compute.googleapis.com.*" snapshots resources whose asset type starts
	// with "compute.googleapis.com".
	// * ".*Instance" snapshots resources whose asset type ends with "Instance".
	// * ".*Instance.*" snapshots resources whose asset type contains "Instance".
	//
	// See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
	// regular expression syntax. If the regular expression does not match any
	// supported asset type, an INVALID_ARGUMENT error will be returned.
	//
	// If specified, only matching assets will be returned, otherwise, it will
	// snapshot all asset types. See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name will be
	// returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Required. Output configuration indicating where the results will be output
	// to.
	OutputConfig *OutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// A list of relationship types to export, for example:
	// `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
	// content_type=RELATIONSHIP.
	// * If specified:
	// it snapshots specified relationships. It returns an error if
	// any of the [relationship_types] doesn't belong to the supported
	// relationship types of the [asset_types] or if any of the [asset_types]
	// doesn't belong to the source types of the [relationship_types].
	// * Otherwise:
	// it snapshots the supported relationships for all [asset_types] or returns
	// an error if any of the [asset_types] has no relationship support.
	// An unspecified asset types field means all supported asset_types.
	// See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
	// supported asset types and relationship types.
	RelationshipTypes []string `protobuf:"bytes,6,rep,name=relationship_types,json=relationshipTypes,proto3" json:"relationship_types,omitempty"`
}

func (x *ExportAssetsRequest) Reset() {
	*x = ExportAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAssetsRequest) ProtoMessage() {}

func (x *ExportAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAssetsRequest.ProtoReflect.Descriptor instead.
func (*ExportAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{1}
}

func (x *ExportAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportAssetsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ExportAssetsRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *ExportAssetsRequest) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *ExportAssetsRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ExportAssetsRequest) GetRelationshipTypes() []string {
	if x != nil {
		return x.RelationshipTypes
	}
	return nil
}

// The export asset response. This message is returned by the
// [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation]
// method in the returned
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// field.
type ExportAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time the snapshot was taken.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Output configuration indicating where the results were output to.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Output result indicating where the assets were exported to. For example, a
	// set of actual Google Cloud Storage object uris where the assets are
	// exported to. The uris can be different from what [output_config] has
	// specified, as the service will split the output object into multiple ones
	// once it exceeds a single Google Cloud Storage object limit.
	OutputResult *OutputResult `protobuf:"bytes,3,opt,name=output_result,json=outputResult,proto3" json:"output_result,omitempty"`
}

func (x *ExportAssetsResponse) Reset() {
	*x = ExportAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAssetsResponse) ProtoMessage() {}

func (x *ExportAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAssetsResponse.ProtoReflect.Descriptor instead.
func (*ExportAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{2}
}

func (x *ExportAssetsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ExportAssetsResponse) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ExportAssetsResponse) GetOutputResult() *OutputResult {
	if x != nil {
		return x.OutputResult
	}
	return nil
}

// ListAssets request.
type ListAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the organization, folder, or project the assets belong
	// to. Format: "organizations/[organization-number]" (such as
	// "organizations/123"), "projects/[project-id]" (such as
	// "projects/my-project-id"), "projects/[project-number]" (such as
	// "projects/12345"), or "folders/[folder-number]" (such as "folders/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Timestamp to take an asset snapshot. This can only be set to a timestamp
	// between the current time and the current time minus 35 days (inclusive).
	// If not specified, the current time will be used. Due to delays in resource
	// data collection and indexing, there is a volatile window during which
	// running the same query may get different results.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// A list of asset types to take a snapshot for. For example:
	// "compute.googleapis.com/Disk".
	//
	// Regular expression is also supported. For example:
	//
	// * "compute.googleapis.com.*" snapshots resources whose asset type starts
	// with "compute.googleapis.com".
	// * ".*Instance" snapshots resources whose asset type ends with "Instance".
	// * ".*Instance.*" snapshots resources whose asset type contains "Instance".
	//
	// See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
	// regular expression syntax. If the regular expression does not match any
	// supported asset type, an INVALID_ARGUMENT error will be returned.
	//
	// If specified, only matching assets will be returned, otherwise, it will
	// snapshot all asset types. See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name will
	// be returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// The maximum number of assets to be returned in a single response. Default
	// is 100, minimum is 1, and maximum is 1000.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `next_page_token` returned from the previous `ListAssetsResponse`, or
	// unspecified for the first `ListAssetsRequest`. It is a continuation of a
	// prior `ListAssets` call, and the API should return the next page of assets.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A list of relationship types to output, for example:
	// `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
	// content_type=RELATIONSHIP.
	// * If specified:
	// it snapshots specified relationships. It returns an error if
	// any of the [relationship_types] doesn't belong to the supported
	// relationship types of the [asset_types] or if any of the [asset_types]
	// doesn't belong to the source types of the [relationship_types].
	// * Otherwise:
	// it snapshots the supported relationships for all [asset_types] or returns
	// an error if any of the [asset_types] has no relationship support.
	// An unspecified asset types field means all supported asset_types.
	// See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types and relationship types.
	RelationshipTypes []string `protobuf:"bytes,7,rep,name=relationship_types,json=relationshipTypes,proto3" json:"relationship_types,omitempty"`
}

func (x *ListAssetsRequest) Reset() {
	*x = ListAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsRequest) ProtoMessage() {}

func (x *ListAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsRequest.ProtoReflect.Descriptor instead.
func (*ListAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAssetsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListAssetsRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *ListAssetsRequest) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *ListAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAssetsRequest) GetRelationshipTypes() []string {
	if x != nil {
		return x.RelationshipTypes
	}
	return nil
}

// ListAssets response.
type ListAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time the snapshot was taken.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Assets.
	Assets []*Asset `protobuf:"bytes,2,rep,name=assets,proto3" json:"assets,omitempty"`
	// Token to retrieve the next page of results. It expires 72 hours after the
	// page token for the first page is generated. Set to empty if there are no
	// remaining results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAssetsResponse) Reset() {
	*x = ListAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsResponse) ProtoMessage() {}

func (x *ListAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsResponse.ProtoReflect.Descriptor instead.
func (*ListAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListAssetsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListAssetsResponse) GetAssets() []*Asset {
	if x != nil {
		return x.Assets
	}
	return nil
}

func (x *ListAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Batch get assets history request.
type BatchGetAssetsHistoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. It can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id")", or a project number (such as "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A list of the full names of the assets.
	// See: https://cloud.google.com/asset-inventory/docs/resource-name-format
	// Example:
	//
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	//
	// The request becomes a no-op if the asset name list is empty, and the max
	// size of the asset name list is 100 in one request.
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// Optional. The content type.
	ContentType ContentType `protobuf:"varint,3,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Optional. The time window for the asset history. Both start_time and
	// end_time are optional and if set, it must be after the current time minus
	// 35 days. If end_time is not set, it is default to current timestamp.
	// If start_time is not set, the snapshot of the assets at end_time will be
	// returned. The returned results contain all temporal assets whose time
	// window overlap with read_time_window.
	ReadTimeWindow *TimeWindow `protobuf:"bytes,4,opt,name=read_time_window,json=readTimeWindow,proto3" json:"read_time_window,omitempty"`
	// Optional. A list of relationship types to output, for example:
	// `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
	// content_type=RELATIONSHIP.
	// * If specified:
	// it outputs specified relationships' history on the [asset_names]. It
	// returns an error if any of the [relationship_types] doesn't belong to the
	// supported relationship types of the [asset_names] or if any of the
	// [asset_names]'s types doesn't belong to the source types of the
	// [relationship_types].
	// * Otherwise:
	// it outputs the supported relationships' history on the [asset_names] or
	// returns an error if any of the [asset_names]'s types has no relationship
	// support.
	// See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
	// supported asset types and relationship types.
	RelationshipTypes []string `protobuf:"bytes,5,rep,name=relationship_types,json=relationshipTypes,proto3" json:"relationship_types,omitempty"`
}

func (x *BatchGetAssetsHistoryRequest) Reset() {
	*x = BatchGetAssetsHistoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetAssetsHistoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetAssetsHistoryRequest) ProtoMessage() {}

func (x *BatchGetAssetsHistoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetAssetsHistoryRequest.ProtoReflect.Descriptor instead.
func (*BatchGetAssetsHistoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{5}
}

func (x *BatchGetAssetsHistoryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchGetAssetsHistoryRequest) GetAssetNames() []string {
	if x != nil {
		return x.AssetNames
	}
	return nil
}

func (x *BatchGetAssetsHistoryRequest) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *BatchGetAssetsHistoryRequest) GetReadTimeWindow() *TimeWindow {
	if x != nil {
		return x.ReadTimeWindow
	}
	return nil
}

func (x *BatchGetAssetsHistoryRequest) GetRelationshipTypes() []string {
	if x != nil {
		return x.RelationshipTypes
	}
	return nil
}

// Batch get assets history response.
type BatchGetAssetsHistoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of assets with valid time windows.
	Assets []*TemporalAsset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
}

func (x *BatchGetAssetsHistoryResponse) Reset() {
	*x = BatchGetAssetsHistoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetAssetsHistoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetAssetsHistoryResponse) ProtoMessage() {}

func (x *BatchGetAssetsHistoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetAssetsHistoryResponse.ProtoReflect.Descriptor instead.
func (*BatchGetAssetsHistoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{6}
}

func (x *BatchGetAssetsHistoryResponse) GetAssets() []*TemporalAsset {
	if x != nil {
		return x.Assets
	}
	return nil
}

// Create asset feed request.
type CreateFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project/folder/organization where this feed
	// should be created in. It can only be an organization number (such as
	// "organizations/123"), a folder number (such as "folders/123"), a project ID
	// (such as "projects/my-project-id")", or a project number (such as
	// "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. This is the client-assigned asset feed identifier and it needs to
	// be unique under a specific parent project/folder/organization.
	FeedId string `protobuf:"bytes,2,opt,name=feed_id,json=feedId,proto3" json:"feed_id,omitempty"`
	// Required. The feed details. The field `name` must be empty and it will be
	// generated in the format of: projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Feed *Feed `protobuf:"bytes,3,opt,name=feed,proto3" json:"feed,omitempty"`
}

func (x *CreateFeedRequest) Reset() {
	*x = CreateFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeedRequest) ProtoMessage() {}

func (x *CreateFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeedRequest.ProtoReflect.Descriptor instead.
func (*CreateFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{7}
}

func (x *CreateFeedRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFeedRequest) GetFeedId() string {
	if x != nil {
		return x.FeedId
	}
	return ""
}

func (x *CreateFeedRequest) GetFeed() *Feed {
	if x != nil {
		return x.Feed
	}
	return nil
}

// Get asset feed request.
type GetFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFeedRequest) Reset() {
	*x = GetFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFeedRequest) ProtoMessage() {}

func (x *GetFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFeedRequest.ProtoReflect.Descriptor instead.
func (*GetFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetFeedRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// List asset feeds request.
type ListFeedsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent project/folder/organization whose feeds are to be
	// listed. It can only be using project/folder/organization number (such as
	// "folders/12345")", or a project ID (such as "projects/my-project-id").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListFeedsRequest) Reset() {
	*x = ListFeedsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFeedsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeedsRequest) ProtoMessage() {}

func (x *ListFeedsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeedsRequest.ProtoReflect.Descriptor instead.
func (*ListFeedsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListFeedsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

type ListFeedsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of feeds.
	Feeds []*Feed `protobuf:"bytes,1,rep,name=feeds,proto3" json:"feeds,omitempty"`
}

func (x *ListFeedsResponse) Reset() {
	*x = ListFeedsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFeedsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeedsResponse) ProtoMessage() {}

func (x *ListFeedsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeedsResponse.ProtoReflect.Descriptor instead.
func (*ListFeedsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListFeedsResponse) GetFeeds() []*Feed {
	if x != nil {
		return x.Feeds
	}
	return nil
}

// Update asset feed request.
type UpdateFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values of feed details. It must match an existing feed
	// and the field `name` must be in the format of:
	// projects/project_number/feeds/feed_id or
	// folders/folder_number/feeds/feed_id or
	// organizations/organization_number/feeds/feed_id.
	Feed *Feed `protobuf:"bytes,1,opt,name=feed,proto3" json:"feed,omitempty"`
	// Required. Only updates the `feed` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFeedRequest) Reset() {
	*x = UpdateFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeedRequest) ProtoMessage() {}

func (x *UpdateFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeedRequest.ProtoReflect.Descriptor instead.
func (*UpdateFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateFeedRequest) GetFeed() *Feed {
	if x != nil {
		return x.Feed
	}
	return nil
}

func (x *UpdateFeedRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

type DeleteFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFeedRequest) Reset() {
	*x = DeleteFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeedRequest) ProtoMessage() {}

func (x *DeleteFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeedRequest.ProtoReflect.Descriptor instead.
func (*DeleteFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteFeedRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Output configuration for export assets destination.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset export destination.
	//
	// Types that are assignable to Destination:
	//	*OutputConfig_GcsDestination
	//	*OutputConfig_BigqueryDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{13}
}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *OutputConfig) GetBigqueryDestination() *BigQueryDestination {
	if x, ok := x.GetDestination().(*OutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	// Destination on Cloud Storage.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_BigqueryDestination struct {
	// Destination on BigQuery. The output table stores the fields in asset
	// Protobuf as columns in BigQuery.
	BigqueryDestination *BigQueryDestination `protobuf:"bytes,2,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (*OutputConfig_BigqueryDestination) isOutputConfig_Destination() {}

// Output result of export assets.
type OutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset export result.
	//
	// Types that are assignable to Result:
	//	*OutputResult_GcsResult
	Result isOutputResult_Result `protobuf_oneof:"result"`
}

func (x *OutputResult) Reset() {
	*x = OutputResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputResult) ProtoMessage() {}

func (x *OutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputResult.ProtoReflect.Descriptor instead.
func (*OutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{14}
}

func (m *OutputResult) GetResult() isOutputResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *OutputResult) GetGcsResult() *GcsOutputResult {
	if x, ok := x.GetResult().(*OutputResult_GcsResult); ok {
		return x.GcsResult
	}
	return nil
}

type isOutputResult_Result interface {
	isOutputResult_Result()
}

type OutputResult_GcsResult struct {
	// Export result on Cloud Storage.
	GcsResult *GcsOutputResult `protobuf:"bytes,1,opt,name=gcs_result,json=gcsResult,proto3,oneof"`
}

func (*OutputResult_GcsResult) isOutputResult_Result() {}

// A Cloud Storage output result.
type GcsOutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of uris of the Cloud Storage objects. Example:
	// "gs://bucket_name/object_name".
	Uris []string `protobuf:"bytes,1,rep,name=uris,proto3" json:"uris,omitempty"`
}

func (x *GcsOutputResult) Reset() {
	*x = GcsOutputResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsOutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsOutputResult) ProtoMessage() {}

func (x *GcsOutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsOutputResult.ProtoReflect.Descriptor instead.
func (*GcsOutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{15}
}

func (x *GcsOutputResult) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

// A Cloud Storage location.
type GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to ObjectUri:
	//	*GcsDestination_Uri
	//	*GcsDestination_UriPrefix
	ObjectUri isGcsDestination_ObjectUri `protobuf_oneof:"object_uri"`
}

func (x *GcsDestination) Reset() {
	*x = GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestination) ProtoMessage() {}

func (x *GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestination.ProtoReflect.Descriptor instead.
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{16}
}

func (m *GcsDestination) GetObjectUri() isGcsDestination_ObjectUri {
	if m != nil {
		return m.ObjectUri
	}
	return nil
}

func (x *GcsDestination) GetUri() string {
	if x, ok := x.GetObjectUri().(*GcsDestination_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *GcsDestination) GetUriPrefix() string {
	if x, ok := x.GetObjectUri().(*GcsDestination_UriPrefix); ok {
		return x.UriPrefix
	}
	return ""
}

type isGcsDestination_ObjectUri interface {
	isGcsDestination_ObjectUri()
}

type GcsDestination_Uri struct {
	// The uri of the Cloud Storage object. It's the same uri that is used by
	// gsutil. Example: "gs://bucket_name/object_name". See [Viewing and
	// Editing Object
	// Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
	// for more information.
	//
	// If the specified Cloud Storage object already exists and there is no
	// [hold](https://cloud.google.com/storage/docs/object-holds), it will be
	// overwritten with the exported result.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type GcsDestination_UriPrefix struct {
	// The uri prefix of all generated Cloud Storage objects. Example:
	// "gs://bucket_name/object_name_prefix". Each object uri is in format:
	// "gs://bucket_name/object_name_prefix/<asset type>/<shard number> and only
	// contains assets for that type. <shard number> starts from 0. Example:
	// "gs://bucket_name/object_name_prefix/compute.googleapis.com/Disk/0" is
	// the first shard of output objects containing all
	// compute.googleapis.com/Disk assets. An INVALID_ARGUMENT error will be
	// returned if file with the same name "gs://bucket_name/object_name_prefix"
	// already exists.
	UriPrefix string `protobuf:"bytes,2,opt,name=uri_prefix,json=uriPrefix,proto3,oneof"`
}

func (*GcsDestination_Uri) isGcsDestination_ObjectUri() {}

func (*GcsDestination_UriPrefix) isGcsDestination_ObjectUri() {}

// A BigQuery destination for exporting assets to.
type BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery dataset in format
	// "projects/projectId/datasets/datasetId", to which the snapshot result
	// should be exported. If this dataset does not exist, the export call returns
	// an INVALID_ARGUMENT error. Setting the `contentType` for `exportAssets`
	// determines the
	// [schema](/asset-inventory/docs/exporting-to-bigquery#bigquery-schema)
	// of the BigQuery table. Setting `separateTablesPerAssetType` to `TRUE` also
	// influences the schema.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The BigQuery table to which the snapshot result should be
	// written. If this table does not exist, a new table with the given name
	// will be created.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
	// If the destination table already exists and this flag is `TRUE`, the
	// table will be overwritten by the contents of assets snapshot. If the flag
	// is `FALSE` or unset and the destination table already exists, the export
	// call returns an INVALID_ARGUMEMT error.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// [partition_spec] determines whether to export to partitioned table(s) and
	// how to partition the data.
	//
	// If [partition_spec] is unset or [partition_spec.partition_key] is unset or
	// `PARTITION_KEY_UNSPECIFIED`, the snapshot results will be exported to
	// non-partitioned table(s). [force] will decide whether to overwrite existing
	// table(s).
	//
	// If [partition_spec] is specified. First, the snapshot results will be
	// written to partitioned table(s) with two additional timestamp columns,
	// readTime and requestTime, one of which will be the partition key. Secondly,
	// in the case when any destination table already exists, it will first try to
	// update existing table's schema as necessary by appending additional
	// columns. Then, if [force] is `TRUE`, the corresponding partition will be
	// overwritten by the snapshot results (data in different partitions will
	// remain intact); if [force] is unset or `FALSE`, it will append the data. An
	// error will be returned if the schema update or data appension fails.
	PartitionSpec *PartitionSpec `protobuf:"bytes,4,opt,name=partition_spec,json=partitionSpec,proto3" json:"partition_spec,omitempty"`
	// If this flag is `TRUE`, the snapshot results will be written to one or
	// multiple tables, each of which contains results of one asset type. The
	// [force] and [partition_spec] fields will apply to each of them.
	//
	// Field [table] will be concatenated with "_" and the asset type names (see
	// https://cloud.google.com/asset-inventory/docs/supported-asset-types for
	// supported asset types) to construct per-asset-type table names, in which
	// all non-alphanumeric characters like "." and "/" will be substituted by
	// "_". Example: if field [table] is "mytable" and snapshot results
	// contain "storage.googleapis.com/Bucket" assets, the corresponding table
	// name will be "mytable_storage_googleapis_com_Bucket". If any of these
	// tables does not exist, a new table with the concatenated name will be
	// created.
	//
	// When [content_type] in the ExportAssetsRequest is `RESOURCE`, the schema of
	// each table will include RECORD-type columns mapped to the nested fields in
	// the Asset.resource.data field of that asset type (up to the 15 nested level
	// BigQuery supports
	// (https://cloud.google.com/bigquery/docs/nested-repeated#limitations)). The
	// fields in >15 nested levels will be stored in JSON format string as a child
	// column of its parent RECORD column.
	//
	// If error occurs when exporting to any table, the whole export call will
	// return an error but the export results that already succeed will persist.
	// Example: if exporting to table_type_A succeeds when exporting to
	// table_type_B fails during one export call, the results in table_type_A will
	// persist and there will not be partial results persisting in a table.
	SeparateTablesPerAssetType bool `protobuf:"varint,5,opt,name=separate_tables_per_asset_type,json=separateTablesPerAssetType,proto3" json:"separate_tables_per_asset_type,omitempty"`
}

func (x *BigQueryDestination) Reset() {
	*x = BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDestination) ProtoMessage() {}

func (x *BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDestination.ProtoReflect.Descriptor instead.
func (*BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{17}
}

func (x *BigQueryDestination) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *BigQueryDestination) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *BigQueryDestination) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *BigQueryDestination) GetPartitionSpec() *PartitionSpec {
	if x != nil {
		return x.PartitionSpec
	}
	return nil
}

func (x *BigQueryDestination) GetSeparateTablesPerAssetType() bool {
	if x != nil {
		return x.SeparateTablesPerAssetType
	}
	return false
}

// Specifications of BigQuery partitioned table as export destination.
type PartitionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The partition key for BigQuery partitioned table.
	PartitionKey PartitionSpec_PartitionKey `protobuf:"varint,1,opt,name=partition_key,json=partitionKey,proto3,enum=google.cloud.asset.v1.PartitionSpec_PartitionKey" json:"partition_key,omitempty"`
}

func (x *PartitionSpec) Reset() {
	*x = PartitionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionSpec) ProtoMessage() {}

func (x *PartitionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionSpec.ProtoReflect.Descriptor instead.
func (*PartitionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{18}
}

func (x *PartitionSpec) GetPartitionKey() PartitionSpec_PartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return PartitionSpec_PARTITION_KEY_UNSPECIFIED
}

// A Pub/Sub destination.
type PubsubDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Pub/Sub topic to publish to.
	// Example: `projects/PROJECT_ID/topics/TOPIC_ID`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *PubsubDestination) Reset() {
	*x = PubsubDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubsubDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubsubDestination) ProtoMessage() {}

func (x *PubsubDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubsubDestination.ProtoReflect.Descriptor instead.
func (*PubsubDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{19}
}

func (x *PubsubDestination) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Output configuration for asset feed destination.
type FeedOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset feed destination.
	//
	// Types that are assignable to Destination:
	//	*FeedOutputConfig_PubsubDestination
	Destination isFeedOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *FeedOutputConfig) Reset() {
	*x = FeedOutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeedOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeedOutputConfig) ProtoMessage() {}

func (x *FeedOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeedOutputConfig.ProtoReflect.Descriptor instead.
func (*FeedOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{20}
}

func (m *FeedOutputConfig) GetDestination() isFeedOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *FeedOutputConfig) GetPubsubDestination() *PubsubDestination {
	if x, ok := x.GetDestination().(*FeedOutputConfig_PubsubDestination); ok {
		return x.PubsubDestination
	}
	return nil
}

type isFeedOutputConfig_Destination interface {
	isFeedOutputConfig_Destination()
}

type FeedOutputConfig_PubsubDestination struct {
	// Destination on Pub/Sub.
	PubsubDestination *PubsubDestination `protobuf:"bytes,1,opt,name=pubsub_destination,json=pubsubDestination,proto3,oneof"`
}

func (*FeedOutputConfig_PubsubDestination) isFeedOutputConfig_Destination() {}

// An asset feed used to export asset updates to a destinations.
// An asset feed filter controls what updates are exported.
// The asset feed must be created within a project, organization, or
// folder. Supported destinations are:
// Pub/Sub topics.
type Feed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The format will be
	// projects/{project_number}/feeds/{client-assigned_feed_identifier} or
	// folders/{folder_number}/feeds/{client-assigned_feed_identifier} or
	// organizations/{organization_number}/feeds/{client-assigned_feed_identifier}
	//
	// The client-assigned feed identifier must be unique within the parent
	// project/folder/organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of the full names of the assets to receive updates. You must specify
	// either or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names or asset_types are exported to the feed.
	// Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// For a list of the full names for supported asset types, see [Resource
	// name format](/asset-inventory/docs/resource-name-format).
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// A list of types of the assets to receive updates. You must specify either
	// or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names or asset_types are exported to the feed.
	// Example: `"compute.googleapis.com/Disk"`
	//
	// For a list of all supported asset types, see
	// [Supported asset types](/asset-inventory/docs/supported-asset-types).
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name and
	// type will be returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Required. Feed output configuration defining where the asset updates are
	// published to.
	FeedOutputConfig *FeedOutputConfig `protobuf:"bytes,5,opt,name=feed_output_config,json=feedOutputConfig,proto3" json:"feed_output_config,omitempty"`
	// A condition which determines whether an asset update should be published.
	// If specified, an asset will be returned only when the expression evaluates
	// to true.
	// When set, `expression` field in the `Expr` must be a valid [CEL expression]
	// (https://github.com/google/cel-spec) on a TemporalAsset with name
	// `temporal_asset`. Example: a Feed with expression ("temporal_asset.deleted
	// == true") will only publish Asset deletions. Other fields of `Expr` are
	// optional.
	//
	// See our [user
	// guide](https://cloud.google.com/asset-inventory/docs/monitoring-asset-changes-with-condition)
	// for detailed instructions.
	Condition *expr.Expr `protobuf:"bytes,6,opt,name=condition,proto3" json:"condition,omitempty"`
	// A list of relationship types to output, for example:
	// `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
	// content_type=RELATIONSHIP.
	// * If specified:
	// it outputs specified relationship updates on the [asset_names] or the
	// [asset_types]. It returns an error if any of the [relationship_types]
	// doesn't belong to the supported relationship types of the [asset_names] or
	// [asset_types], or any of the [asset_names] or the [asset_types] doesn't
	// belong to the source types of the [relationship_types].
	// * Otherwise:
	// it outputs the supported relationships of the types of [asset_names] and
	// [asset_types] or returns an error if any of the [asset_names] or the
	// [asset_types] has no replationship support.
	// See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types and relationship types.
	RelationshipTypes []string `protobuf:"bytes,7,rep,name=relationship_types,json=relationshipTypes,proto3" json:"relationship_types,omitempty"`
}

func (x *Feed) Reset() {
	*x = Feed{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Feed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Feed) ProtoMessage() {}

func (x *Feed) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Feed.ProtoReflect.Descriptor instead.
func (*Feed) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{21}
}

func (x *Feed) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Feed) GetAssetNames() []string {
	if x != nil {
		return x.AssetNames
	}
	return nil
}

func (x *Feed) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *Feed) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *Feed) GetFeedOutputConfig() *FeedOutputConfig {
	if x != nil {
		return x.FeedOutputConfig
	}
	return nil
}

func (x *Feed) GetCondition() *expr.Expr {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *Feed) GetRelationshipTypes() []string {
	if x != nil {
		return x.RelationshipTypes
	}
	return nil
}

// Search all resources request.
type SearchAllResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A scope can be a project, a folder, or an organization. The
	// search is limited to the resources within the `scope`. The caller must be
	// granted the
	// [`cloudasset.assets.searchAllResources`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
	// permission on the desired scope.
	//
	// The allowed values are:
	//
	// * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
	// * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
	// * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
	// * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query statement. See [how to construct a
	// query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
	// for more information. If not specified or empty, it will search all the
	// resources within the specified `scope`.
	//
	// Examples:
	//
	// * `name:Important` to find Cloud resources whose name contains
	//   "Important" as a word.
	// * `name=Important` to find the Cloud resource whose name is exactly
	//   "Important".
	// * `displayName:Impor*` to find Cloud resources whose display name
	//   contains "Impor" as a prefix of any word in the field.
	// * `location:us-west*` to find Cloud resources whose location contains both
	//   "us" and "west" as prefixes.
	// * `labels:prod` to find Cloud resources whose labels contain "prod" as
	//   a key or value.
	// * `labels.env:prod` to find Cloud resources that have a label "env"
	//   and its value is "prod".
	// * `labels.env:*` to find Cloud resources that have a label "env".
	// * `kmsKey:key` to find Cloud resources encrypted with a customer-managed
	//   encryption key whose name contains the word "key".
	// * `state:ACTIVE` to find Cloud resources whose state contains "ACTIVE" as a
	//   word.
	// * `NOT state:ACTIVE` to find Cloud resources whose state doesn't contain
	//   "ACTIVE" as a word.
	// * `createTime<1609459200` to find Cloud resources that were created before
	//   "2021-01-01 00:00:00 UTC". 1609459200 is the epoch timestamp of
	//   "2021-01-01 00:00:00 UTC" in seconds.
	// * `updateTime>1609459200` to find Cloud resources that were updated after
	//   "2021-01-01 00:00:00 UTC". 1609459200 is the epoch timestamp of
	//   "2021-01-01 00:00:00 UTC" in seconds.
	// * `Important` to find Cloud resources that contain "Important" as a word
	//   in any of the searchable fields.
	// * `Impor*` to find Cloud resources that contain "Impor" as a prefix of any
	//   word in any of the searchable fields.
	// * `Important location:(us-west1 OR global)` to find Cloud
	//   resources that contain "Important" as a word in any of the searchable
	//   fields and are also located in the "us-west1" region or the "global"
	//   location.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. A list of asset types that this request searches for. If empty,
	// it will search all the [searchable asset
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
	//
	// Regular expressions are also supported. For example:
	//
	// * "compute.googleapis.com.*" snapshots resources whose asset type starts
	// with "compute.googleapis.com".
	// * ".*Instance" snapshots resources whose asset type ends with "Instance".
	// * ".*Instance.*" snapshots resources whose asset type contains "Instance".
	//
	// See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
	// regular expression syntax. If the regular expression does not match any
	// supported asset type, an INVALID_ARGUMENT error will be returned.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Optional. The page size for search result pagination. Page size is capped
	// at 500 even if a larger value is given. If set to zero, server will pick an
	// appropriate default. Returned results may be fewer than requested. When
	// this happens, there could be more results as long as `next_page_token` is
	// returned.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method. `page_token` must be the value of
	// `next_page_token` from the previous response. The values of all other
	// method parameters, must be identical to those in the previous call.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A comma-separated list of fields specifying the sorting order of
	// the results. The default order is ascending. Add " DESC" after the field
	// name to indicate descending order. Redundant space characters are ignored.
	// Example: "location DESC, name".
	// Only singular primitive fields in the response are sortable:
	//
	//   * name
	//   * assetType
	//   * project
	//   * displayName
	//   * description
	//   * location
	//   * kmsKey
	//   * createTime
	//   * updateTime
	//   * state
	//   * parentFullResourceName
	//   * parentAssetType
	//
	// All the other fields such as repeated fields (e.g., `networkTags`), map
	// fields (e.g., `labels`) and struct fields (e.g., `additionalAttributes`)
	// are not supported.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. A comma-separated list of fields specifying which fields to be
	// returned in ResourceSearchResult. Only '*' or combination of top level
	// fields can be specified. Field names of both snake_case and camelCase are
	// supported. Examples: `"*"`, `"name,location"`, `"name,versionedResources"`.
	//
	// The read_mask paths must be valid field paths listed but not limited to
	// (both snake_case and camelCase are supported):
	//
	//   * name
	//   * assetType
	//   * project
	//   * displayName
	//   * description
	//   * location
	//   * tagKeys
	//   * tagValues
	//   * tagValueIds
	//   * labels
	//   * networkTags
	//   * kmsKey
	//   * createTime
	//   * updateTime
	//   * state
	//   * additionalAttributes
	//   * versionedResources
	//
	// If read_mask is not specified, all fields except versionedResources will
	// be returned.
	// If only '*' is specified, all fields including versionedResources will be
	// returned.
	// Any invalid field path will trigger INVALID_ARGUMENT error.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,8,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *SearchAllResourcesRequest) Reset() {
	*x = SearchAllResourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllResourcesRequest) ProtoMessage() {}

func (x *SearchAllResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllResourcesRequest.ProtoReflect.Descriptor instead.
func (*SearchAllResourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{22}
}

func (x *SearchAllResourcesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *SearchAllResourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAllResourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Search all resources response.
type SearchAllResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Resources that match the search query. It contains the resource
	// standard metadata information.
	Results []*ResourceSearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// If there are more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAllResourcesResponse) Reset() {
	*x = SearchAllResourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllResourcesResponse) ProtoMessage() {}

func (x *SearchAllResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllResourcesResponse.ProtoReflect.Descriptor instead.
func (*SearchAllResourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{23}
}

func (x *SearchAllResourcesResponse) GetResults() []*ResourceSearchResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchAllResourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Search all IAM policies request.
type SearchAllIamPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A scope can be a project, a folder, or an organization. The
	// search is limited to the IAM policies within the `scope`. The caller must
	// be granted the
	// [`cloudasset.assets.searchAllIamPolicies`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
	// permission on the desired scope.
	//
	// The allowed values are:
	//
	// * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
	// * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
	// * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
	// * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query statement. See [how to construct a
	// query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
	// for more information. If not specified or empty, it will search all the
	// IAM policies within the specified `scope`. Note that the query string is
	// compared against each Cloud IAM policy binding, including its principals,
	// roles, and Cloud IAM conditions. The returned Cloud IAM policies will only
	// contain the bindings that match your query. To learn more about the IAM
	// policy structure, see [IAM policy
	// doc](https://cloud.google.com/iam/docs/policies#structure).
	//
	// Examples:
	//
	// * `policy:amy@gmail.com` to find IAM policy bindings that specify user
	//   "amy@gmail.com".
	// * `policy:roles/compute.admin` to find IAM policy bindings that specify
	//   the Compute Admin role.
	// * `policy:comp*` to find IAM policy bindings that contain "comp" as a
	//   prefix of any word in the binding.
	// * `policy.role.permissions:storage.buckets.update` to find IAM policy
	//   bindings that specify a role containing "storage.buckets.update"
	//   permission. Note that if callers don't have `iam.roles.get` access to a
	//   role's included permissions, policy bindings that specify this role will
	//   be dropped from the search results.
	// * `policy.role.permissions:upd*` to find IAM policy bindings that specify a
	//   role containing "upd" as a prefix of any word in the role permission.
	//   Note that if callers don't have `iam.roles.get` access to a role's
	//   included permissions, policy bindings that specify this role will be
	//   dropped from the search results.
	// * `resource:organizations/123456` to find IAM policy bindings
	//   that are set on "organizations/123456".
	// * `resource=//cloudresourcemanager.googleapis.com/projects/myproject` to
	//   find IAM policy bindings that are set on the project named "myproject".
	// * `Important` to find IAM policy bindings that contain "Important" as a
	//   word in any of the searchable fields (except for the included
	//   permissions).
	// * `resource:(instance1 OR instance2) policy:amy` to find
	//   IAM policy bindings that are set on resources "instance1" or
	//   "instance2" and also specify user "amy".
	// * `roles:roles/compute.admin` to find IAM policy bindings that specify the
	//   Compute Admin role.
	// * `memberTypes:user` to find IAM policy bindings that contain the
	//   principal type "user".
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The page size for search result pagination. Page size is capped
	// at 500 even if a larger value is given. If set to zero, server will pick an
	// appropriate default. Returned results may be fewer than requested. When
	// this happens, there could be more results as long as `next_page_token` is
	// returned.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, retrieve the next batch of results from the preceding
	// call to this method. `page_token` must be the value of `next_page_token`
	// from the previous response. The values of all other method parameters must
	// be identical to those in the previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A list of asset types that the IAM policies are attached to. If
	// empty, it will search the IAM policies that are attached to all the
	// [searchable asset
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
	//
	// Regular expressions are also supported. For example:
	//
	// * "compute.googleapis.com.*" snapshots IAM policies attached to asset type
	// starts with "compute.googleapis.com".
	// * ".*Instance" snapshots IAM policies attached to asset type ends with
	// "Instance".
	// * ".*Instance.*" snapshots IAM policies attached to asset type contains
	// "Instance".
	//
	// See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
	// regular expression syntax. If the regular expression does not match any
	// supported asset type, an INVALID_ARGUMENT error will be returned.
	AssetTypes []string `protobuf:"bytes,5,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Optional. A comma-separated list of fields specifying the sorting order of
	// the results. The default order is ascending. Add " DESC" after the field
	// name to indicate descending order. Redundant space characters are ignored.
	// Example: "assetType DESC, resource".
	// Only singular primitive fields in the response are sortable:
	//   * resource
	//   * assetType
	//   * project
	// All the other fields such as repeated fields (e.g., `folders`) and
	// non-primitive fields (e.g., `policy`) are not supported.
	OrderBy string `protobuf:"bytes,7,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *SearchAllIamPoliciesRequest) Reset() {
	*x = SearchAllIamPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllIamPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllIamPoliciesRequest) ProtoMessage() {}

func (x *SearchAllIamPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllIamPoliciesRequest.ProtoReflect.Descriptor instead.
func (*SearchAllIamPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{24}
}

func (x *SearchAllIamPoliciesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *SearchAllIamPoliciesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchAllIamPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAllIamPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchAllIamPoliciesRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *SearchAllIamPoliciesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Search all IAM policies response.
type SearchAllIamPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of IamPolicy that match the search query. Related information such
	// as the associated resource is returned along with the policy.
	Results []*IamPolicySearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Set if there are more results than those appearing in this response; to get
	// the next set of results, call this method again, using this value as the
	// `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAllIamPoliciesResponse) Reset() {
	*x = SearchAllIamPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllIamPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllIamPoliciesResponse) ProtoMessage() {}

func (x *SearchAllIamPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllIamPoliciesResponse.ProtoReflect.Descriptor instead.
func (*SearchAllIamPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{25}
}

func (x *SearchAllIamPoliciesResponse) GetResults() []*IamPolicySearchResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchAllIamPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// IAM policy analysis query message.
type IamPolicyAnalysisQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. Only resources and IAM
	// policies within the scope will be analyzed.
	//
	// This can only be an organization number (such as "organizations/123"), a
	// folder number (such as "folders/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345").
	//
	// To know how to get organization id, visit [here
	// ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
	//
	// To know how to get folder or project id, visit [here
	// ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. Specifies a resource for analysis.
	ResourceSelector *IamPolicyAnalysisQuery_ResourceSelector `protobuf:"bytes,2,opt,name=resource_selector,json=resourceSelector,proto3" json:"resource_selector,omitempty"`
	// Optional. Specifies an identity for analysis.
	IdentitySelector *IamPolicyAnalysisQuery_IdentitySelector `protobuf:"bytes,3,opt,name=identity_selector,json=identitySelector,proto3" json:"identity_selector,omitempty"`
	// Optional. Specifies roles or permissions for analysis. This is optional.
	AccessSelector *IamPolicyAnalysisQuery_AccessSelector `protobuf:"bytes,4,opt,name=access_selector,json=accessSelector,proto3" json:"access_selector,omitempty"`
	// Optional. The query options.
	Options *IamPolicyAnalysisQuery_Options `protobuf:"bytes,5,opt,name=options,proto3" json:"options,omitempty"`
	// Optional. The hypothetical context for IAM conditions evaluation.
	ConditionContext *IamPolicyAnalysisQuery_ConditionContext `protobuf:"bytes,6,opt,name=condition_context,json=conditionContext,proto3" json:"condition_context,omitempty"`
}

func (x *IamPolicyAnalysisQuery) Reset() {
	*x = IamPolicyAnalysisQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26}
}

func (x *IamPolicyAnalysisQuery) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *IamPolicyAnalysisQuery) GetResourceSelector() *IamPolicyAnalysisQuery_ResourceSelector {
	if x != nil {
		return x.ResourceSelector
	}
	return nil
}

func (x *IamPolicyAnalysisQuery) GetIdentitySelector() *IamPolicyAnalysisQuery_IdentitySelector {
	if x != nil {
		return x.IdentitySelector
	}
	return nil
}

func (x *IamPolicyAnalysisQuery) GetAccessSelector() *IamPolicyAnalysisQuery_AccessSelector {
	if x != nil {
		return x.AccessSelector
	}
	return nil
}

func (x *IamPolicyAnalysisQuery) GetOptions() *IamPolicyAnalysisQuery_Options {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *IamPolicyAnalysisQuery) GetConditionContext() *IamPolicyAnalysisQuery_ConditionContext {
	if x != nil {
		return x.ConditionContext
	}
	return nil
}

// A request message for
// [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1.AssetService.AnalyzeIamPolicy].
type AnalyzeIamPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// Optional. The name of a saved query, which must be in the format of:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	//
	// If both `analysis_query` and `saved_analysis_query` are provided, they
	// will be merged together with the `saved_analysis_query` as base and
	// the `analysis_query` as overrides. For more details of the merge behavior,
	// please refer to the
	// [MergeFrom](https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.details)
	// page.
	//
	// Note that you cannot override primitive fields with default value, such as
	// 0 or empty string, etc., because we use proto3, which doesn't support field
	// presence yet.
	SavedAnalysisQuery string `protobuf:"bytes,3,opt,name=saved_analysis_query,json=savedAnalysisQuery,proto3" json:"saved_analysis_query,omitempty"`
	// Optional. Amount of time executable has to complete.  See JSON
	// representation of
	// [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json).
	//
	// If this field is set with a value less than the RPC deadline, and the
	// execution of your query hasn't finished in the specified
	// execution timeout,  you will get a response with partial result.
	// Otherwise, your query's execution will continue until the RPC deadline.
	// If it's not finished until then, you will get a  DEADLINE_EXCEEDED error.
	//
	// Default is empty.
	ExecutionTimeout *durationpb.Duration `protobuf:"bytes,2,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
}

func (x *AnalyzeIamPolicyRequest) Reset() {
	*x = AnalyzeIamPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyRequest) ProtoMessage() {}

func (x *AnalyzeIamPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{27}
}

func (x *AnalyzeIamPolicyRequest) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if x != nil {
		return x.AnalysisQuery
	}
	return nil
}

func (x *AnalyzeIamPolicyRequest) GetSavedAnalysisQuery() string {
	if x != nil {
		return x.SavedAnalysisQuery
	}
	return ""
}

func (x *AnalyzeIamPolicyRequest) GetExecutionTimeout() *durationpb.Duration {
	if x != nil {
		return x.ExecutionTimeout
	}
	return nil
}

// A response message for
// [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1.AssetService.AnalyzeIamPolicy].
type AnalyzeIamPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The main analysis that matches the original request.
	MainAnalysis *AnalyzeIamPolicyResponse_IamPolicyAnalysis `protobuf:"bytes,1,opt,name=main_analysis,json=mainAnalysis,proto3" json:"main_analysis,omitempty"`
	// The service account impersonation analysis if
	// [AnalyzeIamPolicyRequest.analyze_service_account_impersonation][] is
	// enabled.
	ServiceAccountImpersonationAnalysis []*AnalyzeIamPolicyResponse_IamPolicyAnalysis `protobuf:"bytes,2,rep,name=service_account_impersonation_analysis,json=serviceAccountImpersonationAnalysis,proto3" json:"service_account_impersonation_analysis,omitempty"`
	// Represents whether all entries in the
	// [main_analysis][google.cloud.asset.v1.AnalyzeIamPolicyResponse.main_analysis]
	// and
	// [service_account_impersonation_analysis][google.cloud.asset.v1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis]
	// have been fully explored to answer the query in the request.
	FullyExplored bool `protobuf:"varint,3,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
}

func (x *AnalyzeIamPolicyResponse) Reset() {
	*x = AnalyzeIamPolicyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyResponse) ProtoMessage() {}

func (x *AnalyzeIamPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{28}
}

func (x *AnalyzeIamPolicyResponse) GetMainAnalysis() *AnalyzeIamPolicyResponse_IamPolicyAnalysis {
	if x != nil {
		return x.MainAnalysis
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse) GetServiceAccountImpersonationAnalysis() []*AnalyzeIamPolicyResponse_IamPolicyAnalysis {
	if x != nil {
		return x.ServiceAccountImpersonationAnalysis
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse) GetFullyExplored() bool {
	if x != nil {
		return x.FullyExplored
	}
	return false
}

// Output configuration for export IAM policy analysis destination.
type IamPolicyAnalysisOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IAM policy analysis export destination.
	//
	// Types that are assignable to Destination:
	//	*IamPolicyAnalysisOutputConfig_GcsDestination_
	//	*IamPolicyAnalysisOutputConfig_BigqueryDestination
	Destination isIamPolicyAnalysisOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *IamPolicyAnalysisOutputConfig) Reset() {
	*x = IamPolicyAnalysisOutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisOutputConfig) ProtoMessage() {}

func (x *IamPolicyAnalysisOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisOutputConfig.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{29}
}

func (m *IamPolicyAnalysisOutputConfig) GetDestination() isIamPolicyAnalysisOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *IamPolicyAnalysisOutputConfig) GetGcsDestination() *IamPolicyAnalysisOutputConfig_GcsDestination {
	if x, ok := x.GetDestination().(*IamPolicyAnalysisOutputConfig_GcsDestination_); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *IamPolicyAnalysisOutputConfig) GetBigqueryDestination() *IamPolicyAnalysisOutputConfig_BigQueryDestination {
	if x, ok := x.GetDestination().(*IamPolicyAnalysisOutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

type isIamPolicyAnalysisOutputConfig_Destination interface {
	isIamPolicyAnalysisOutputConfig_Destination()
}

type IamPolicyAnalysisOutputConfig_GcsDestination_ struct {
	// Destination on Cloud Storage.
	GcsDestination *IamPolicyAnalysisOutputConfig_GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type IamPolicyAnalysisOutputConfig_BigqueryDestination struct {
	// Destination on BigQuery.
	BigqueryDestination *IamPolicyAnalysisOutputConfig_BigQueryDestination `protobuf:"bytes,2,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*IamPolicyAnalysisOutputConfig_GcsDestination_) isIamPolicyAnalysisOutputConfig_Destination() {}

func (*IamPolicyAnalysisOutputConfig_BigqueryDestination) isIamPolicyAnalysisOutputConfig_Destination() {
}

// A request message for
// [AssetService.AnalyzeIamPolicyLongrunning][google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning].
type AnalyzeIamPolicyLongrunningRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// Optional. The name of a saved query, which must be in the format of:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	//
	// If both `analysis_query` and `saved_analysis_query` are provided, they
	// will be merged together with the `saved_analysis_query` as base and
	// the `analysis_query` as overrides. For more details of the merge behavior,
	// please refer to the
	// [MergeFrom](https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.details)
	// doc.
	//
	// Note that you cannot override primitive fields with default value, such as
	// 0 or empty string, etc., because we use proto3, which doesn't support field
	// presence yet.
	SavedAnalysisQuery string `protobuf:"bytes,3,opt,name=saved_analysis_query,json=savedAnalysisQuery,proto3" json:"saved_analysis_query,omitempty"`
	// Required. Output configuration indicating where the results will be output
	// to.
	OutputConfig *IamPolicyAnalysisOutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *AnalyzeIamPolicyLongrunningRequest) Reset() {
	*x = AnalyzeIamPolicyLongrunningRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyLongrunningRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyLongrunningRequest) ProtoMessage() {}

func (x *AnalyzeIamPolicyLongrunningRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyLongrunningRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyLongrunningRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{30}
}

func (x *AnalyzeIamPolicyLongrunningRequest) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if x != nil {
		return x.AnalysisQuery
	}
	return nil
}

func (x *AnalyzeIamPolicyLongrunningRequest) GetSavedAnalysisQuery() string {
	if x != nil {
		return x.SavedAnalysisQuery
	}
	return ""
}

func (x *AnalyzeIamPolicyLongrunningRequest) GetOutputConfig() *IamPolicyAnalysisOutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// A response message for
// [AssetService.AnalyzeIamPolicyLongrunning][google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning].
type AnalyzeIamPolicyLongrunningResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AnalyzeIamPolicyLongrunningResponse) Reset() {
	*x = AnalyzeIamPolicyLongrunningResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyLongrunningResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyLongrunningResponse) ProtoMessage() {}

func (x *AnalyzeIamPolicyLongrunningResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyLongrunningResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyLongrunningResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{31}
}

// A saved query which can be shared with others or used later.
type SavedQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the saved query. The format must be:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The description of this saved query. This value should be fewer than 255
	// characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The create time of this saved query.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The account's email address who has created this saved query.
	Creator string `protobuf:"bytes,4,opt,name=creator,proto3" json:"creator,omitempty"`
	// Output only. The last update time of this saved query.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// Output only. The account's email address who has updated this saved query
	// most recently.
	LastUpdater string `protobuf:"bytes,6,opt,name=last_updater,json=lastUpdater,proto3" json:"last_updater,omitempty"`
	// Labels applied on the resource.
	// This value should not contain more than 10 entries. The key and value of
	// each entry must be non-empty and fewer than 64 characters.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The query content.
	Content *SavedQuery_QueryContent `protobuf:"bytes,8,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *SavedQuery) Reset() {
	*x = SavedQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SavedQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SavedQuery) ProtoMessage() {}

func (x *SavedQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SavedQuery.ProtoReflect.Descriptor instead.
func (*SavedQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{32}
}

func (x *SavedQuery) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SavedQuery) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SavedQuery) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *SavedQuery) GetCreator() string {
	if x != nil {
		return x.Creator
	}
	return ""
}

func (x *SavedQuery) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

func (x *SavedQuery) GetLastUpdater() string {
	if x != nil {
		return x.LastUpdater
	}
	return ""
}

func (x *SavedQuery) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *SavedQuery) GetContent() *SavedQuery_QueryContent {
	if x != nil {
		return x.Content
	}
	return nil
}

// Request to create a saved query.
type CreateSavedQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project/folder/organization where this
	// saved_query should be created in. It can only be an organization number
	// (such as "organizations/123"), a folder number (such as "folders/123"), a
	// project ID (such as "projects/my-project-id")", or a project number (such
	// as "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The saved_query details. The `name` field must be empty as it
	// will be generated based on the parent and saved_query_id.
	SavedQuery *SavedQuery `protobuf:"bytes,2,opt,name=saved_query,json=savedQuery,proto3" json:"saved_query,omitempty"`
	// Required. The ID to use for the saved query, which must be unique in the
	// specified parent. It will become the final component of the saved query's
	// resource name.
	//
	// This value should be 4-63 characters, and valid characters
	// are /[a-z][0-9]-/.
	//
	// Notice that this field is required in the saved query creation, and the
	// `name` field of the `saved_query` will be ignored.
	SavedQueryId string `protobuf:"bytes,3,opt,name=saved_query_id,json=savedQueryId,proto3" json:"saved_query_id,omitempty"`
}

func (x *CreateSavedQueryRequest) Reset() {
	*x = CreateSavedQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSavedQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSavedQueryRequest) ProtoMessage() {}

func (x *CreateSavedQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSavedQueryRequest.ProtoReflect.Descriptor instead.
func (*CreateSavedQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{33}
}

func (x *CreateSavedQueryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSavedQueryRequest) GetSavedQuery() *SavedQuery {
	if x != nil {
		return x.SavedQuery
	}
	return nil
}

func (x *CreateSavedQueryRequest) GetSavedQueryId() string {
	if x != nil {
		return x.SavedQueryId
	}
	return ""
}

// Request to get a saved query.
type GetSavedQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the saved query and it must be in the format of:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSavedQueryRequest) Reset() {
	*x = GetSavedQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSavedQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSavedQueryRequest) ProtoMessage() {}

func (x *GetSavedQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSavedQueryRequest.ProtoReflect.Descriptor instead.
func (*GetSavedQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{34}
}

func (x *GetSavedQueryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list saved queries.
type ListSavedQueriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent project/folder/organization whose savedQueries are to
	// be listed. It can only be using project/folder/organization number (such as
	// "folders/12345")", or a project ID (such as "projects/my-project-id").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The expression to filter resources.
	// The expression is a list of zero or more restrictions combined via logical
	// operators `AND` and `OR`. When `AND` and `OR` are both used in the
	// expression, parentheses must be appropriately used to group the
	// combinations. The expression may also contain regular expressions.
	//
	// See https://google.aip.dev/160 for more information on the grammar.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of saved queries to return per page. The
	// service may return fewer than this value. If unspecified, at most 50 will
	// be returned.
	//  The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListSavedQueries` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListSavedQueries` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSavedQueriesRequest) Reset() {
	*x = ListSavedQueriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSavedQueriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSavedQueriesRequest) ProtoMessage() {}

func (x *ListSavedQueriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSavedQueriesRequest.ProtoReflect.Descriptor instead.
func (*ListSavedQueriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{35}
}

func (x *ListSavedQueriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSavedQueriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSavedQueriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSavedQueriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response of listing saved queries.
type ListSavedQueriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of savedQueries.
	SavedQueries []*SavedQuery `protobuf:"bytes,1,rep,name=saved_queries,json=savedQueries,proto3" json:"saved_queries,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSavedQueriesResponse) Reset() {
	*x = ListSavedQueriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSavedQueriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSavedQueriesResponse) ProtoMessage() {}

func (x *ListSavedQueriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSavedQueriesResponse.ProtoReflect.Descriptor instead.
func (*ListSavedQueriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{36}
}

func (x *ListSavedQueriesResponse) GetSavedQueries() []*SavedQuery {
	if x != nil {
		return x.SavedQueries
	}
	return nil
}

func (x *ListSavedQueriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to update a saved query.
type UpdateSavedQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The saved query to update.
	//
	// The saved query's `name` field is used to identify the one to update,
	// which has format as below:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	SavedQuery *SavedQuery `protobuf:"bytes,1,opt,name=saved_query,json=savedQuery,proto3" json:"saved_query,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSavedQueryRequest) Reset() {
	*x = UpdateSavedQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSavedQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSavedQueryRequest) ProtoMessage() {}

func (x *UpdateSavedQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSavedQueryRequest.ProtoReflect.Descriptor instead.
func (*UpdateSavedQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{37}
}

func (x *UpdateSavedQueryRequest) GetSavedQuery() *SavedQuery {
	if x != nil {
		return x.SavedQuery
	}
	return nil
}

func (x *UpdateSavedQueryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to delete a saved query.
type DeleteSavedQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the saved query to delete. It must be in the format
	// of:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSavedQueryRequest) Reset() {
	*x = DeleteSavedQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSavedQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSavedQueryRequest) ProtoMessage() {}

func (x *DeleteSavedQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSavedQueryRequest.ProtoReflect.Descriptor instead.
func (*DeleteSavedQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{38}
}

func (x *DeleteSavedQueryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for performing resource move analysis.
type AnalyzeMoveRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource to perform the analysis against.
	// Only GCP Project are supported as of today. Hence, this can only be Project
	// ID (such as "projects/my-project-id") or a Project Number (such as
	// "projects/12345").
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// Required. Name of the GCP Folder or Organization to reparent the target
	// resource. The analysis will be performed against hypothetically moving the
	// resource to this specified desitination parent. This can only be a Folder
	// number (such as "folders/123") or an Organization number (such as
	// "organizations/123").
	DestinationParent string `protobuf:"bytes,2,opt,name=destination_parent,json=destinationParent,proto3" json:"destination_parent,omitempty"`
	// Analysis view indicating what information should be included in the
	// analysis response. If unspecified, the default view is FULL.
	View AnalyzeMoveRequest_AnalysisView `protobuf:"varint,3,opt,name=view,proto3,enum=google.cloud.asset.v1.AnalyzeMoveRequest_AnalysisView" json:"view,omitempty"`
}

func (x *AnalyzeMoveRequest) Reset() {
	*x = AnalyzeMoveRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeMoveRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeMoveRequest) ProtoMessage() {}

func (x *AnalyzeMoveRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeMoveRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeMoveRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{39}
}

func (x *AnalyzeMoveRequest) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *AnalyzeMoveRequest) GetDestinationParent() string {
	if x != nil {
		return x.DestinationParent
	}
	return ""
}

func (x *AnalyzeMoveRequest) GetView() AnalyzeMoveRequest_AnalysisView {
	if x != nil {
		return x.View
	}
	return AnalyzeMoveRequest_ANALYSIS_VIEW_UNSPECIFIED
}

// The response message for resource move analysis.
type AnalyzeMoveResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of analyses returned from performing the intended resource move
	// analysis. The analysis is grouped by different Cloud services.
	MoveAnalysis []*MoveAnalysis `protobuf:"bytes,1,rep,name=move_analysis,json=moveAnalysis,proto3" json:"move_analysis,omitempty"`
}

func (x *AnalyzeMoveResponse) Reset() {
	*x = AnalyzeMoveResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeMoveResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeMoveResponse) ProtoMessage() {}

func (x *AnalyzeMoveResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeMoveResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeMoveResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{40}
}

func (x *AnalyzeMoveResponse) GetMoveAnalysis() []*MoveAnalysis {
	if x != nil {
		return x.MoveAnalysis
	}
	return nil
}

// A message to group the analysis information.
type MoveAnalysis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user friendly display name of the analysis. E.g. IAM, Organization
	// Policy etc.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Types that are assignable to Result:
	//	*MoveAnalysis_Analysis
	//	*MoveAnalysis_Error
	Result isMoveAnalysis_Result `protobuf_oneof:"result"`
}

func (x *MoveAnalysis) Reset() {
	*x = MoveAnalysis{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveAnalysis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveAnalysis) ProtoMessage() {}

func (x *MoveAnalysis) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveAnalysis.ProtoReflect.Descriptor instead.
func (*MoveAnalysis) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{41}
}

func (x *MoveAnalysis) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *MoveAnalysis) GetResult() isMoveAnalysis_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *MoveAnalysis) GetAnalysis() *MoveAnalysisResult {
	if x, ok := x.GetResult().(*MoveAnalysis_Analysis); ok {
		return x.Analysis
	}
	return nil
}

func (x *MoveAnalysis) GetError() *status.Status {
	if x, ok := x.GetResult().(*MoveAnalysis_Error); ok {
		return x.Error
	}
	return nil
}

type isMoveAnalysis_Result interface {
	isMoveAnalysis_Result()
}

type MoveAnalysis_Analysis struct {
	// Analysis result of moving the target resource.
	Analysis *MoveAnalysisResult `protobuf:"bytes,2,opt,name=analysis,proto3,oneof"`
}

type MoveAnalysis_Error struct {
	// Description of error encountered when performing the analysis.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

func (*MoveAnalysis_Analysis) isMoveAnalysis_Result() {}

func (*MoveAnalysis_Error) isMoveAnalysis_Result() {}

// An analysis result including blockers and warnings.
type MoveAnalysisResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Blocking information that would prevent the target resource from moving
	// to the specified destination at runtime.
	Blockers []*MoveImpact `protobuf:"bytes,1,rep,name=blockers,proto3" json:"blockers,omitempty"`
	// Warning information indicating that moving the target resource to the
	// specified destination might be unsafe. This can include important policy
	// information and configuration changes, but will not block moves at runtime.
	Warnings []*MoveImpact `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (x *MoveAnalysisResult) Reset() {
	*x = MoveAnalysisResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveAnalysisResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveAnalysisResult) ProtoMessage() {}

func (x *MoveAnalysisResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveAnalysisResult.ProtoReflect.Descriptor instead.
func (*MoveAnalysisResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{42}
}

func (x *MoveAnalysisResult) GetBlockers() []*MoveImpact {
	if x != nil {
		return x.Blockers
	}
	return nil
}

func (x *MoveAnalysisResult) GetWarnings() []*MoveImpact {
	if x != nil {
		return x.Warnings
	}
	return nil
}

// A message to group impacts of moving the target resource.
type MoveImpact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User friendly impact detail in a free form message.
	Detail string `protobuf:"bytes,1,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *MoveImpact) Reset() {
	*x = MoveImpact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveImpact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveImpact) ProtoMessage() {}

func (x *MoveImpact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveImpact.ProtoReflect.Descriptor instead.
func (*MoveImpact) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{43}
}

func (x *MoveImpact) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

// A request message for
// [AssetService.BatchGetEffectiveIamPolicies][google.cloud.asset.v1.AssetService.BatchGetEffectiveIamPolicies].
type BatchGetEffectiveIamPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Only IAM policies on or below the scope will be returned.
	//
	// This can only be an organization number (such as "organizations/123"), a
	// folder number (such as "folders/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345").
	//
	// To know how to get organization id, visit [here
	// ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
	//
	// To know how to get folder or project id, visit [here
	// ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The names refer to the [full_resource_names]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// of [searchable asset
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
	// A maximum of 20 resources' effective policies can be retrieved in a batch.
	Names []string `protobuf:"bytes,3,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchGetEffectiveIamPoliciesRequest) Reset() {
	*x = BatchGetEffectiveIamPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetEffectiveIamPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetEffectiveIamPoliciesRequest) ProtoMessage() {}

func (x *BatchGetEffectiveIamPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetEffectiveIamPoliciesRequest.ProtoReflect.Descriptor instead.
func (*BatchGetEffectiveIamPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{44}
}

func (x *BatchGetEffectiveIamPoliciesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *BatchGetEffectiveIamPoliciesRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// A response message for
// [AssetService.BatchGetEffectiveIamPolicies][google.cloud.asset.v1.AssetService.BatchGetEffectiveIamPolicies].
type BatchGetEffectiveIamPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The effective policies for a batch of resources. Note that the results
	// order is the same as the order of
	// [BatchGetEffectiveIamPoliciesRequest.names][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest.names].
	// When a resource does not have any effective IAM policies, its corresponding
	// policy_result will contain empty
	// [EffectiveIamPolicy.policies][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.policies].
	PolicyResults []*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy `protobuf:"bytes,2,rep,name=policy_results,json=policyResults,proto3" json:"policy_results,omitempty"`
}

func (x *BatchGetEffectiveIamPoliciesResponse) Reset() {
	*x = BatchGetEffectiveIamPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetEffectiveIamPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetEffectiveIamPoliciesResponse) ProtoMessage() {}

func (x *BatchGetEffectiveIamPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetEffectiveIamPoliciesResponse.ProtoReflect.Descriptor instead.
func (*BatchGetEffectiveIamPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{45}
}

func (x *BatchGetEffectiveIamPoliciesResponse) GetPolicyResults() []*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy {
	if x != nil {
		return x.PolicyResults
	}
	return nil
}

// Specifies the resource to analyze for access policies, which may be set
// directly on the resource, or on ancestors such as organizations, folders or
// projects.
type IamPolicyAnalysisQuery_ResourceSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [full resource name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// of a resource of [supported resource
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#analyzable_asset_types).
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
}

func (x *IamPolicyAnalysisQuery_ResourceSelector) Reset() {
	*x = IamPolicyAnalysisQuery_ResourceSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_ResourceSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_ResourceSelector) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_ResourceSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_ResourceSelector.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_ResourceSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26, 0}
}

func (x *IamPolicyAnalysisQuery_ResourceSelector) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

// Specifies an identity for which to determine resource access, based on
// roles assigned either directly to them or to the groups they belong to,
// directly or indirectly.
type IamPolicyAnalysisQuery_IdentitySelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The identity appear in the form of principals in
	// [IAM policy
	// binding](https://cloud.google.com/iam/reference/rest/v1/Binding).
	//
	// The examples of supported forms are:
	// "user:mike@example.com",
	// "group:admins@example.com",
	// "domain:google.com",
	// "serviceAccount:my-project-id@appspot.gserviceaccount.com".
	//
	// Notice that wildcard characters (such as * and ?) are not supported.
	// You must give a specific identity.
	Identity string `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (x *IamPolicyAnalysisQuery_IdentitySelector) Reset() {
	*x = IamPolicyAnalysisQuery_IdentitySelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_IdentitySelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_IdentitySelector) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_IdentitySelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_IdentitySelector.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_IdentitySelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26, 1}
}

func (x *IamPolicyAnalysisQuery_IdentitySelector) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

// Specifies roles and/or permissions to analyze, to determine both the
// identities possessing them and the resources they control. If multiple
// values are specified, results will include roles or permissions matching
// any of them. The total number of roles and permissions should be equal or
// less than 10.
type IamPolicyAnalysisQuery_AccessSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The roles to appear in result.
	Roles []string `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	// Optional. The permissions to appear in result.
	Permissions []string `protobuf:"bytes,2,rep,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *IamPolicyAnalysisQuery_AccessSelector) Reset() {
	*x = IamPolicyAnalysisQuery_AccessSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_AccessSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_AccessSelector) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_AccessSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_AccessSelector.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_AccessSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26, 2}
}

func (x *IamPolicyAnalysisQuery_AccessSelector) GetRoles() []string {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *IamPolicyAnalysisQuery_AccessSelector) GetPermissions() []string {
	if x != nil {
		return x.Permissions
	}
	return nil
}

// Contains query options.
type IamPolicyAnalysisQuery_Options struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If true, the identities section of the result will expand any
	// Google groups appearing in an IAM policy binding.
	//
	// If
	// [IamPolicyAnalysisQuery.identity_selector][google.cloud.asset.v1.IamPolicyAnalysisQuery.identity_selector]
	// is specified, the identity in the result will be determined by the
	// selector, and this flag is not allowed to set.
	//
	// If true, the default max expansion per group is 1000 for
	// AssetService.AnalyzeIamPolicy][].
	//
	// Default is false.
	ExpandGroups bool `protobuf:"varint,1,opt,name=expand_groups,json=expandGroups,proto3" json:"expand_groups,omitempty"`
	// Optional. If true, the access section of result will expand any roles
	// appearing in IAM policy bindings to include their permissions.
	//
	// If
	// [IamPolicyAnalysisQuery.access_selector][google.cloud.asset.v1.IamPolicyAnalysisQuery.access_selector]
	// is specified, the access section of the result will be determined by the
	// selector, and this flag is not allowed to set.
	//
	// Default is false.
	ExpandRoles bool `protobuf:"varint,2,opt,name=expand_roles,json=expandRoles,proto3" json:"expand_roles,omitempty"`
	// Optional. If true and
	// [IamPolicyAnalysisQuery.resource_selector][google.cloud.asset.v1.IamPolicyAnalysisQuery.resource_selector]
	// is not specified, the resource section of the result will expand any
	// resource attached to an IAM policy to include resources lower in the
	// resource hierarchy.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and the results include an IAM policy with P on a GCP
	// folder, the results will also include resources in that folder with
	// permission P.
	//
	// If true and
	// [IamPolicyAnalysisQuery.resource_selector][google.cloud.asset.v1.IamPolicyAnalysisQuery.resource_selector]
	// is specified, the resource section of the result will expand the
	// specified resource to include resources lower in the resource hierarchy.
	// Only project or lower resources are supported. Folder and organization
	// resource cannot be used together with this option.
	//
	// For example, if the request analyzes for which users have permission P on
	// a GCP project with this option enabled, the results will include all
	// users who have permission P on that project or any lower resource.
	//
	// If true, the default max expansion per resource is 1000 for
	// AssetService.AnalyzeIamPolicy][] and 100000 for
	// AssetService.AnalyzeIamPolicyLongrunning][].
	//
	// Default is false.
	ExpandResources bool `protobuf:"varint,3,opt,name=expand_resources,json=expandResources,proto3" json:"expand_resources,omitempty"`
	// Optional. If true, the result will output the relevant parent/child
	// relationships between resources. Default is false.
	OutputResourceEdges bool `protobuf:"varint,4,opt,name=output_resource_edges,json=outputResourceEdges,proto3" json:"output_resource_edges,omitempty"`
	// Optional. If true, the result will output the relevant membership
	// relationships between groups and other groups, and between groups and
	// principals. Default is false.
	OutputGroupEdges bool `protobuf:"varint,5,opt,name=output_group_edges,json=outputGroupEdges,proto3" json:"output_group_edges,omitempty"`
	// Optional. If true, the response will include access analysis from
	// identities to resources via service account impersonation. This is a very
	// expensive operation, because many derived queries will be executed. We
	// highly recommend you use
	// [AssetService.AnalyzeIamPolicyLongrunning][google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning]
	// rpc instead.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and there's an IAM policy states user A has
	// iam.serviceAccounts.getAccessToken permission to a service account SA,
	// and there's another IAM policy states service account SA has permission P
	// to a GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Another example, if the request analyzes for who has
	// permission P to a GCP folder F, and there's an IAM policy states user A
	// has iam.serviceAccounts.actAs permission to a service account SA, and
	// there's another IAM policy states service account SA has permission P to
	// the GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Only the following permissions are considered in this analysis:
	//
	// * `iam.serviceAccounts.actAs`
	// * `iam.serviceAccounts.signBlob`
	// * `iam.serviceAccounts.signJwt`
	// * `iam.serviceAccounts.getAccessToken`
	// * `iam.serviceAccounts.getOpenIdToken`
	// * `iam.serviceAccounts.implicitDelegation`
	//
	// Default is false.
	AnalyzeServiceAccountImpersonation bool `protobuf:"varint,6,opt,name=analyze_service_account_impersonation,json=analyzeServiceAccountImpersonation,proto3" json:"analyze_service_account_impersonation,omitempty"`
}

func (x *IamPolicyAnalysisQuery_Options) Reset() {
	*x = IamPolicyAnalysisQuery_Options{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_Options) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_Options) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_Options) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_Options.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_Options) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26, 3}
}

func (x *IamPolicyAnalysisQuery_Options) GetExpandGroups() bool {
	if x != nil {
		return x.ExpandGroups
	}
	return false
}

func (x *IamPolicyAnalysisQuery_Options) GetExpandRoles() bool {
	if x != nil {
		return x.ExpandRoles
	}
	return false
}

func (x *IamPolicyAnalysisQuery_Options) GetExpandResources() bool {
	if x != nil {
		return x.ExpandResources
	}
	return false
}

func (x *IamPolicyAnalysisQuery_Options) GetOutputResourceEdges() bool {
	if x != nil {
		return x.OutputResourceEdges
	}
	return false
}

func (x *IamPolicyAnalysisQuery_Options) GetOutputGroupEdges() bool {
	if x != nil {
		return x.OutputGroupEdges
	}
	return false
}

func (x *IamPolicyAnalysisQuery_Options) GetAnalyzeServiceAccountImpersonation() bool {
	if x != nil {
		return x.AnalyzeServiceAccountImpersonation
	}
	return false
}

// The IAM conditions context.
type IamPolicyAnalysisQuery_ConditionContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IAM conditions time context.
	//
	// Types that are assignable to TimeContext:
	//	*IamPolicyAnalysisQuery_ConditionContext_AccessTime
	TimeContext isIamPolicyAnalysisQuery_ConditionContext_TimeContext `protobuf_oneof:"TimeContext"`
}

func (x *IamPolicyAnalysisQuery_ConditionContext) Reset() {
	*x = IamPolicyAnalysisQuery_ConditionContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_ConditionContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_ConditionContext) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_ConditionContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_ConditionContext.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_ConditionContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26, 4}
}

func (m *IamPolicyAnalysisQuery_ConditionContext) GetTimeContext() isIamPolicyAnalysisQuery_ConditionContext_TimeContext {
	if m != nil {
		return m.TimeContext
	}
	return nil
}

func (x *IamPolicyAnalysisQuery_ConditionContext) GetAccessTime() *timestamppb.Timestamp {
	if x, ok := x.GetTimeContext().(*IamPolicyAnalysisQuery_ConditionContext_AccessTime); ok {
		return x.AccessTime
	}
	return nil
}

type isIamPolicyAnalysisQuery_ConditionContext_TimeContext interface {
	isIamPolicyAnalysisQuery_ConditionContext_TimeContext()
}

type IamPolicyAnalysisQuery_ConditionContext_AccessTime struct {
	// The hypothetical access timestamp to evaluate IAM conditions. Note that
	// this value must not be earlier than the current time; otherwise, an
	// INVALID_ARGUMENT error will be returned.
	AccessTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=access_time,json=accessTime,proto3,oneof"`
}

func (*IamPolicyAnalysisQuery_ConditionContext_AccessTime) isIamPolicyAnalysisQuery_ConditionContext_TimeContext() {
}

// An analysis message to group the query and results.
type AnalyzeIamPolicyResponse_IamPolicyAnalysis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The analysis query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// A list of
	// [IamPolicyAnalysisResult][google.cloud.asset.v1.IamPolicyAnalysisResult]
	// that matches the analysis query, or empty if no result is found.
	AnalysisResults []*IamPolicyAnalysisResult `protobuf:"bytes,2,rep,name=analysis_results,json=analysisResults,proto3" json:"analysis_results,omitempty"`
	// Represents whether all entries in the
	// [analysis_results][google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_results]
	// have been fully explored to answer the query.
	FullyExplored bool `protobuf:"varint,3,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
	// A list of non-critical errors happened during the query handling.
	NonCriticalErrors []*IamPolicyAnalysisState `protobuf:"bytes,5,rep,name=non_critical_errors,json=nonCriticalErrors,proto3" json:"non_critical_errors,omitempty"`
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) Reset() {
	*x = AnalyzeIamPolicyResponse_IamPolicyAnalysis{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyResponse_IamPolicyAnalysis) ProtoMessage() {}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyResponse_IamPolicyAnalysis.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyResponse_IamPolicyAnalysis) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{28, 0}
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if x != nil {
		return x.AnalysisQuery
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetAnalysisResults() []*IamPolicyAnalysisResult {
	if x != nil {
		return x.AnalysisResults
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetFullyExplored() bool {
	if x != nil {
		return x.FullyExplored
	}
	return false
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetNonCriticalErrors() []*IamPolicyAnalysisState {
	if x != nil {
		return x.NonCriticalErrors
	}
	return nil
}

// A Cloud Storage location.
type IamPolicyAnalysisOutputConfig_GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The uri of the Cloud Storage object. It's the same uri that is
	// used by gsutil. Example: "gs://bucket_name/object_name". See [Viewing and
	// Editing Object
	// Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
	// for more information.
	//
	// If the specified Cloud Storage object already exists and there is no
	// [hold](https://cloud.google.com/storage/docs/object-holds), it will be
	// overwritten with the analysis result.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) Reset() {
	*x = IamPolicyAnalysisOutputConfig_GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisOutputConfig_GcsDestination) ProtoMessage() {}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisOutputConfig_GcsDestination.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisOutputConfig_GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{29, 0}
}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// A BigQuery destination.
type IamPolicyAnalysisOutputConfig_BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery dataset in format
	// "projects/projectId/datasets/datasetId", to which the analysis results
	// should be exported. If this dataset does not exist, the export call will
	// return an INVALID_ARGUMENT error.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The prefix of the BigQuery tables to which the analysis results
	// will be written. Tables will be created based on this table_prefix if not
	// exist:
	// * <table_prefix>_analysis table will contain export operation's metadata.
	// * <table_prefix>_analysis_result will contain all the
	//   [IamPolicyAnalysisResult][google.cloud.asset.v1.IamPolicyAnalysisResult].
	// When [partition_key] is specified, both tables will be partitioned based
	// on the [partition_key].
	TablePrefix string `protobuf:"bytes,2,opt,name=table_prefix,json=tablePrefix,proto3" json:"table_prefix,omitempty"`
	// The partition key for BigQuery partitioned table.
	PartitionKey IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey `protobuf:"varint,3,opt,name=partition_key,json=partitionKey,proto3,enum=google.cloud.asset.v1.IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey" json:"partition_key,omitempty"`
	// Optional. Specifies the action that occurs if the destination table or
	// partition already exists. The following values are supported:
	//
	// * WRITE_TRUNCATE: If the table or partition already exists, BigQuery
	// overwrites the entire table or all the partitions data.
	// * WRITE_APPEND: If the table or partition already exists, BigQuery
	// appends the data to the table or the latest partition.
	// * WRITE_EMPTY: If the table already exists and contains data, an error is
	// returned.
	//
	// The default value is WRITE_APPEND. Each action is atomic and only occurs
	// if BigQuery is able to complete the job successfully. Details are at
	// https://cloud.google.com/bigquery/docs/loading-data-local#appending_to_or_overwriting_a_table_using_a_local_file.
	WriteDisposition string `protobuf:"bytes,4,opt,name=write_disposition,json=writeDisposition,proto3" json:"write_disposition,omitempty"`
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) Reset() {
	*x = IamPolicyAnalysisOutputConfig_BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisOutputConfig_BigQueryDestination) ProtoMessage() {}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisOutputConfig_BigQueryDestination.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisOutputConfig_BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{29, 1}
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) GetTablePrefix() string {
	if x != nil {
		return x.TablePrefix
	}
	return ""
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) GetPartitionKey() IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return IamPolicyAnalysisOutputConfig_BigQueryDestination_PARTITION_KEY_UNSPECIFIED
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) GetWriteDisposition() string {
	if x != nil {
		return x.WriteDisposition
	}
	return ""
}

// The query content.
type SavedQuery_QueryContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to QueryContent:
	//	*SavedQuery_QueryContent_IamPolicyAnalysisQuery
	QueryContent isSavedQuery_QueryContent_QueryContent `protobuf_oneof:"query_content"`
}

func (x *SavedQuery_QueryContent) Reset() {
	*x = SavedQuery_QueryContent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SavedQuery_QueryContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SavedQuery_QueryContent) ProtoMessage() {}

func (x *SavedQuery_QueryContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SavedQuery_QueryContent.ProtoReflect.Descriptor instead.
func (*SavedQuery_QueryContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{32, 0}
}

func (m *SavedQuery_QueryContent) GetQueryContent() isSavedQuery_QueryContent_QueryContent {
	if m != nil {
		return m.QueryContent
	}
	return nil
}

func (x *SavedQuery_QueryContent) GetIamPolicyAnalysisQuery() *IamPolicyAnalysisQuery {
	if x, ok := x.GetQueryContent().(*SavedQuery_QueryContent_IamPolicyAnalysisQuery); ok {
		return x.IamPolicyAnalysisQuery
	}
	return nil
}

type isSavedQuery_QueryContent_QueryContent interface {
	isSavedQuery_QueryContent_QueryContent()
}

type SavedQuery_QueryContent_IamPolicyAnalysisQuery struct {
	// An IAM Policy Analysis query, which could be used in
	// the
	// [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1.AssetService.AnalyzeIamPolicy]
	// rpc or the
	// [AssetService.AnalyzeIamPolicyLongrunning][google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning]
	// rpc.
	IamPolicyAnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=iam_policy_analysis_query,json=iamPolicyAnalysisQuery,proto3,oneof"`
}

func (*SavedQuery_QueryContent_IamPolicyAnalysisQuery) isSavedQuery_QueryContent_QueryContent() {}

// The effective IAM policies on one resource.
type BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [full_resource_name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for which the
	// [policies][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.policies]
	// are computed. This is one of the
	// [BatchGetEffectiveIamPoliciesRequest.names][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest.names]
	// the caller provides in the request.
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// The effective policies for the
	// [full_resource_name][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.full_resource_name].
	//
	// These policies include the policy set on the
	// [full_resource_name][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.full_resource_name]
	// and those set on its parents and ancestors up to the
	// [BatchGetEffectiveIamPoliciesRequest.scope][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest.scope].
	// Note that these policies are not filtered according to the resource type
	// of the
	// [full_resource_name][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.full_resource_name].
	//
	// These policies are hierarchically ordered by
	// [PolicyInfo.attached_resource][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.attached_resource]
	// starting from
	// [full_resource_name][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.full_resource_name]
	// itself to its parents and ancestors, such that policies[i]'s
	// [PolicyInfo.attached_resource][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.attached_resource]
	// is the child of policies[i+1]'s
	// [PolicyInfo.attached_resource][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.attached_resource],
	// if policies[i+1] exists.
	Policies []*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo `protobuf:"bytes,2,rep,name=policies,proto3" json:"policies,omitempty"`
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) Reset() {
	*x = BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) ProtoMessage() {}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy.ProtoReflect.Descriptor instead.
func (*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{45, 0}
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) GetPolicies() []*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo {
	if x != nil {
		return x.Policies
	}
	return nil
}

// The IAM policy and its attached resource.
type BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name the
	// [policy][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.policy]
	// is directly attached to.
	AttachedResource string `protobuf:"bytes,1,opt,name=attached_resource,json=attachedResource,proto3" json:"attached_resource,omitempty"`
	// The IAM policy that's directly attached to the
	// [attached_resource][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.attached_resource].
	Policy *v1.Policy `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) Reset() {
	*x = BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) ProtoMessage() {}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo.ProtoReflect.Descriptor instead.
func (*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{45, 0, 0}
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) GetAttachedResource() string {
	if x != nil {
		return x.AttachedResource
	}
	return ""
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) GetPolicy() *v1.Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

var File_google_cloud_asset_v1_asset_service_proto protoreflect.FileDescriptor

var file_google_cloud_asset_v1_asset_service_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x2f, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x67, 0x0a, 0x23, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0xf5, 0x02, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a,
	0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65,
	0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4d,
	0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a,
	0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xe3, 0x01, 0x0a,
	0x14, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48,
	0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x48, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x22, 0xe0, 0x02, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x12, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xab, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x09,
	0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0xd2, 0x02, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x50, 0x0a, 0x10, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x12, 0x32, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x68, 0x69, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x5d, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x06, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52,
	0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x22, 0x84, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x07, 0x66, 0x65,
	0x65, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x66, 0x65, 0x65, 0x64, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x04, 0x66, 0x65, 0x65, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x65, 0x65, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x66, 0x65, 0x65, 0x64, 0x22, 0x4c,
	0x0a, 0x0e, 0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2f, 0x0a, 0x10,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x46, 0x0a,
	0x11, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x31, 0x0a, 0x05, 0x66, 0x65, 0x65, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x52, 0x05,
	0x66, 0x65, 0x65, 0x64, 0x73, 0x22, 0x8b, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x04, 0x66,
	0x65, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x66, 0x65, 0x65,
	0x64, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x4f, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x65,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x14, 0x62, 0x69, 0x67, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69,
	0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x48, 0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x61, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x47, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x25, 0x0a, 0x0f, 0x47, 0x63,
	0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x75, 0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x69,
	0x73, 0x22, 0x53, 0x0a, 0x0e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x0a, 0x75, 0x72, 0x69, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x75,
	0x72, 0x69, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x42, 0x0c, 0x0a, 0x0a, 0x6f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x22, 0xf6, 0x01, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d,
	0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x19, 0x0a,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x4b,
	0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0d, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x42, 0x0a, 0x1e, 0x73,
	0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x1a, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x50, 0x65, 0x72, 0x41, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22,
	0xb7, 0x01, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x56, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0x4e, 0x0a, 0x0c, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x41, 0x52,
	0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x44,
	0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x51, 0x55, 0x45,
	0x53, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x02, 0x22, 0x29, 0x0a, 0x11, 0x50, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x22, 0x7c, 0x0a, 0x10, 0x46, 0x65, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x12, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62,
	0x73, 0x75, 0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00,
	0x52, 0x11, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xf8, 0x03, 0x0a, 0x04, 0x46, 0x65, 0x65, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a,
	0x12, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x66, 0x65, 0x65, 0x64, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x52,
	0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x73, 0x3a, 0x91, 0x01, 0xea, 0x41, 0x8d, 0x01,
	0x0a, 0x1e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64,
	0x12, 0x1f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64,
	0x7d, 0x12, 0x1d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64, 0x7d,
	0x12, 0x29, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66,
	0x65, 0x65, 0x64, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64, 0x7d, 0x20, 0x01, 0x22, 0x9b, 0x02,
	0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x3c, 0x0a,
	0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x8b, 0x01, 0x0a, 0x1a,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x07, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdf, 0x01, 0x0a, 0x1b, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x8e, 0x01, 0x0a, 0x1c,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x07,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcf, 0x09, 0x0a,
	0x16, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x12, 0x70, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x12, 0x70, 0x0a, 0x11, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x6a, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x12, 0x54, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x70, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x1a, 0x45, 0x0a, 0x10, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x31,
	0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x1a, 0x33, 0x0a, 0x10, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x1a, 0x52, 0x0a, 0x0e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x19, 0x0a, 0x05, 0x72, 0x6f, 0x6c, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x72, 0x6f,
	0x6c, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xcf, 0x02, 0x0a, 0x07, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x12, 0x26, 0x0a, 0x0c, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x78, 0x70,
	0x61, 0x6e, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x61,
	0x6e, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x64, 0x67, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x64, 0x67, 0x65,
	0x73, 0x12, 0x31, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x65, 0x64, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45,
	0x64, 0x67, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x69, 0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x22, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49,
	0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x60, 0x0a, 0x10,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x3d, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x42,
	0x0d, 0x0a, 0x0b, 0x54, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xf8,
	0x01, 0x0a, 0x17, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x61, 0x76, 0x65, 0x64, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x4b, 0x0a, 0x11,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0x8f, 0x05, 0x0a, 0x18, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x0d, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x52, 0x0c, 0x6d, 0x61, 0x69, 0x6e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x96,
	0x01, 0x0a, 0x26, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x52, 0x23, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x49, 0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6c, 0x6c, 0x79,
	0x5f, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0d, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x1a, 0xca,
	0x02, 0x0a, 0x11, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x12, 0x54, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x0d, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x59, 0x0a, 0x10, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x0f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x65,
	0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x66,
	0x75, 0x6c, 0x6c, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x12, 0x5d, 0x0a, 0x13,
	0x6e, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x11, 0x6e, 0x6f, 0x6e, 0x43, 0x72, 0x69,
	0x74, 0x69, 0x63, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x94, 0x05, 0x0a, 0x1d,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6e, 0x0a,
	0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x63, 0x73,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67,
	0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7d, 0x0a,
	0x14, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x27, 0x0a, 0x0e,
	0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15,
	0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x1a, 0xcb, 0x02, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a,
	0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x26, 0x0a, 0x0c,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x12, 0x7a, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x30, 0x0a, 0x11, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x10, 0x77, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x3f, 0x0a, 0x0c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x4b, 0x45, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x54, 0x49, 0x4d,
	0x45, 0x10, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x96, 0x02, 0x0a, 0x22, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x61, 0x76, 0x65, 0x64, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x5e, 0x0a, 0x0d, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x25, 0x0a, 0x23, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0xb2, 0x06, 0x0a, 0x0a, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x49, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x72, 0x12, 0x45, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x48, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65,
	0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x1a, 0x8b, 0x01, 0x0a,
	0x0c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x6a, 0x0a,
	0x19, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x48,
	0x00, 0x52, 0x16, 0x69, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x0f, 0x0a, 0x0d, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xbf, 0x01, 0xea, 0x41, 0xbb, 0x01, 0x0a, 0x24, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x2d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x7d, 0x12, 0x2b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x7d, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x7b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x7d, 0x12, 0x37,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x61, 0x76,
	0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x61, 0x76, 0x65, 0x64,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x7d, 0x22, 0xd3, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x0b, 0x73, 0x61, 0x76,
	0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x29, 0x0a, 0x0e, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x64, 0x22, 0x58, 0x0a,
	0x14, 0x47, 0x65, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc2, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0d, 0x73, 0x61, 0x76,
	0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x0c, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x17, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0x5b, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76,
	0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf9, 0x01,
	0x0a, 0x12, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x32, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x42, 0x0a, 0x0c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x4e, 0x41, 0x4c, 0x59, 0x53, 0x49,
	0x53, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x09,
	0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x02, 0x22, 0x5f, 0x0a, 0x13, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x48, 0x0a, 0x0d, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x6f, 0x76, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x0c, 0x6d, 0x6f,
	0x76, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0xb0, 0x01, 0x0a, 0x0c, 0x4d,
	0x6f, 0x76, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x47,
	0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x08, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x92, 0x01,
	0x0a, 0x12, 0x4d, 0x6f, 0x76, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x3d, 0x0a, 0x08, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x76, 0x65, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52, 0x08, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x65, 0x72, 0x73, 0x12, 0x3d, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f,
	0x76, 0x65, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x73, 0x22, 0x24, 0x0a, 0x0a, 0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x67, 0x0a, 0x23, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1f, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x12, 0x01, 0x2a, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x12, 0x1f, 0x0a, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a, 0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x22, 0xc3, 0x03, 0x0a, 0x24, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x45, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x75, 0x0a, 0x0e, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x0d, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x1a, 0xa3, 0x02, 0x0a, 0x12, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x75, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x1a, 0x68, 0x0a,
	0x0a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2b, 0x0a, 0x11, 0x61,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2d, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2a, 0x90, 0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x4f, 0x4e, 0x54, 0x45,
	0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x41, 0x4d, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x10, 0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x4f, 0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f,
	0x4c, 0x49, 0x43, 0x59, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x4f, 0x53, 0x5f, 0x49, 0x4e, 0x56,
	0x45, 0x4e, 0x54, 0x4f, 0x52, 0x59, 0x10, 0x06, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x4c, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x53, 0x48, 0x49, 0x50, 0x10, 0x07, 0x32, 0x8b, 0x1a, 0x0a, 0x0c, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xde, 0x01, 0x0a, 0x0c,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22,
	0x22, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f,
	0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a,
	0x01, 0x2a, 0xca, 0x41, 0x57, 0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x8b, 0x01, 0x0a,
	0x0a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x28, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x19, 0x12, 0x17, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb2, 0x01, 0x0a, 0x15, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73,
	0x74, 0x6f, 0x72, 0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47,
	0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12,
	0x7f, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x12, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x65, 0x65, 0x64, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x22, 0x16, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x66,
	0x65, 0x65, 0x64, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x74, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x12, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x22,
	0x25, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x12, 0x16, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x46,
	0x65, 0x65, 0x64, 0x73, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x46, 0x65, 0x65, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x27, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x12,
	0x16, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a,
	0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x82, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x12,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65,
	0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x22, 0x2d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x32, 0x1b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a,
	0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41,
	0x04, 0x66, 0x65, 0x65, 0x64, 0x12, 0x75, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46,
	0x65, 0x65, 0x64, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x25, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x2a, 0x16, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x65,
	0x64, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbf, 0x01, 0x0a,
	0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24,
	0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a,
	0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0xda, 0x41, 0x17, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x2c, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0xbb,
	0x01, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0xda, 0x41,
	0x0b, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0xac, 0x01, 0x0a,
	0x10, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xb8, 0x02, 0x0a, 0x1b,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x4c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x4c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbe, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x22, 0x3a,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x76,
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x4c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x8c, 0x01, 0x0a, 0x0b, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x4d, 0x6f, 0x76, 0x65, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x4d, 0x6f, 0x76, 0x65, 0x12, 0xbd, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0x56, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x22, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x3a, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x61, 0x76, 0x65, 0x64,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x69, 0x64, 0x12, 0x8d, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x53, 0x61, 0x76,
	0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76,
	0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0x2c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x12,
	0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73,
	0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xa3, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61,
	0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1f, 0x12, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69,
	0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xbf, 0x01, 0x0a, 0x10,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x22, 0x58, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x32, 0x29, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0xda, 0x41, 0x17, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x88, 0x01,
	0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2c, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x1f, 0x2a, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f,
	0x2a, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xce, 0x01, 0x0a, 0x1c, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x9c, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x76,
	0x31, 0x3b, 0x61, 0x73, 0x73, 0x65, 0x74, 0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_asset_v1_asset_service_proto_rawDescOnce sync.Once
	file_google_cloud_asset_v1_asset_service_proto_rawDescData = file_google_cloud_asset_v1_asset_service_proto_rawDesc
)

func file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP() []byte {
	file_google_cloud_asset_v1_asset_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_asset_v1_asset_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_asset_v1_asset_service_proto_rawDescData)
	})
	return file_google_cloud_asset_v1_asset_service_proto_rawDescData
}

var file_google_cloud_asset_v1_asset_service_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_asset_v1_asset_service_proto_msgTypes = make([]protoimpl.MessageInfo, 58)
var file_google_cloud_asset_v1_asset_service_proto_goTypes = []interface{}{
	(ContentType)(0),                // 0: google.cloud.asset.v1.ContentType
	(PartitionSpec_PartitionKey)(0), // 1: google.cloud.asset.v1.PartitionSpec.PartitionKey
	(IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey)(0),        // 2: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.BigQueryDestination.PartitionKey
	(AnalyzeMoveRequest_AnalysisView)(0),                                       // 3: google.cloud.asset.v1.AnalyzeMoveRequest.AnalysisView
	(*AnalyzeIamPolicyLongrunningMetadata)(nil),                                // 4: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningMetadata
	(*ExportAssetsRequest)(nil),                                                // 5: google.cloud.asset.v1.ExportAssetsRequest
	(*ExportAssetsResponse)(nil),                                               // 6: google.cloud.asset.v1.ExportAssetsResponse
	(*ListAssetsRequest)(nil),                                                  // 7: google.cloud.asset.v1.ListAssetsRequest
	(*ListAssetsResponse)(nil),                                                 // 8: google.cloud.asset.v1.ListAssetsResponse
	(*BatchGetAssetsHistoryRequest)(nil),                                       // 9: google.cloud.asset.v1.BatchGetAssetsHistoryRequest
	(*BatchGetAssetsHistoryResponse)(nil),                                      // 10: google.cloud.asset.v1.BatchGetAssetsHistoryResponse
	(*CreateFeedRequest)(nil),                                                  // 11: google.cloud.asset.v1.CreateFeedRequest
	(*GetFeedRequest)(nil),                                                     // 12: google.cloud.asset.v1.GetFeedRequest
	(*ListFeedsRequest)(nil),                                                   // 13: google.cloud.asset.v1.ListFeedsRequest
	(*ListFeedsResponse)(nil),                                                  // 14: google.cloud.asset.v1.ListFeedsResponse
	(*UpdateFeedRequest)(nil),                                                  // 15: google.cloud.asset.v1.UpdateFeedRequest
	(*DeleteFeedRequest)(nil),                                                  // 16: google.cloud.asset.v1.DeleteFeedRequest
	(*OutputConfig)(nil),                                                       // 17: google.cloud.asset.v1.OutputConfig
	(*OutputResult)(nil),                                                       // 18: google.cloud.asset.v1.OutputResult
	(*GcsOutputResult)(nil),                                                    // 19: google.cloud.asset.v1.GcsOutputResult
	(*GcsDestination)(nil),                                                     // 20: google.cloud.asset.v1.GcsDestination
	(*BigQueryDestination)(nil),                                                // 21: google.cloud.asset.v1.BigQueryDestination
	(*PartitionSpec)(nil),                                                      // 22: google.cloud.asset.v1.PartitionSpec
	(*PubsubDestination)(nil),                                                  // 23: google.cloud.asset.v1.PubsubDestination
	(*FeedOutputConfig)(nil),                                                   // 24: google.cloud.asset.v1.FeedOutputConfig
	(*Feed)(nil),                                                               // 25: google.cloud.asset.v1.Feed
	(*SearchAllResourcesRequest)(nil),                                          // 26: google.cloud.asset.v1.SearchAllResourcesRequest
	(*SearchAllResourcesResponse)(nil),                                         // 27: google.cloud.asset.v1.SearchAllResourcesResponse
	(*SearchAllIamPoliciesRequest)(nil),                                        // 28: google.cloud.asset.v1.SearchAllIamPoliciesRequest
	(*SearchAllIamPoliciesResponse)(nil),                                       // 29: google.cloud.asset.v1.SearchAllIamPoliciesResponse
	(*IamPolicyAnalysisQuery)(nil),                                             // 30: google.cloud.asset.v1.IamPolicyAnalysisQuery
	(*AnalyzeIamPolicyRequest)(nil),                                            // 31: google.cloud.asset.v1.AnalyzeIamPolicyRequest
	(*AnalyzeIamPolicyResponse)(nil),                                           // 32: google.cloud.asset.v1.AnalyzeIamPolicyResponse
	(*IamPolicyAnalysisOutputConfig)(nil),                                      // 33: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig
	(*AnalyzeIamPolicyLongrunningRequest)(nil),                                 // 34: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest
	(*AnalyzeIamPolicyLongrunningResponse)(nil),                                // 35: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningResponse
	(*SavedQuery)(nil),                                                         // 36: google.cloud.asset.v1.SavedQuery
	(*CreateSavedQueryRequest)(nil),                                            // 37: google.cloud.asset.v1.CreateSavedQueryRequest
	(*GetSavedQueryRequest)(nil),                                               // 38: google.cloud.asset.v1.GetSavedQueryRequest
	(*ListSavedQueriesRequest)(nil),                                            // 39: google.cloud.asset.v1.ListSavedQueriesRequest
	(*ListSavedQueriesResponse)(nil),                                           // 40: google.cloud.asset.v1.ListSavedQueriesResponse
	(*UpdateSavedQueryRequest)(nil),                                            // 41: google.cloud.asset.v1.UpdateSavedQueryRequest
	(*DeleteSavedQueryRequest)(nil),                                            // 42: google.cloud.asset.v1.DeleteSavedQueryRequest
	(*AnalyzeMoveRequest)(nil),                                                 // 43: google.cloud.asset.v1.AnalyzeMoveRequest
	(*AnalyzeMoveResponse)(nil),                                                // 44: google.cloud.asset.v1.AnalyzeMoveResponse
	(*MoveAnalysis)(nil),                                                       // 45: google.cloud.asset.v1.MoveAnalysis
	(*MoveAnalysisResult)(nil),                                                 // 46: google.cloud.asset.v1.MoveAnalysisResult
	(*MoveImpact)(nil),                                                         // 47: google.cloud.asset.v1.MoveImpact
	(*BatchGetEffectiveIamPoliciesRequest)(nil),                                // 48: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest
	(*BatchGetEffectiveIamPoliciesResponse)(nil),                               // 49: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse
	(*IamPolicyAnalysisQuery_ResourceSelector)(nil),                            // 50: google.cloud.asset.v1.IamPolicyAnalysisQuery.ResourceSelector
	(*IamPolicyAnalysisQuery_IdentitySelector)(nil),                            // 51: google.cloud.asset.v1.IamPolicyAnalysisQuery.IdentitySelector
	(*IamPolicyAnalysisQuery_AccessSelector)(nil),                              // 52: google.cloud.asset.v1.IamPolicyAnalysisQuery.AccessSelector
	(*IamPolicyAnalysisQuery_Options)(nil),                                     // 53: google.cloud.asset.v1.IamPolicyAnalysisQuery.Options
	(*IamPolicyAnalysisQuery_ConditionContext)(nil),                            // 54: google.cloud.asset.v1.IamPolicyAnalysisQuery.ConditionContext
	(*AnalyzeIamPolicyResponse_IamPolicyAnalysis)(nil),                         // 55: google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis
	(*IamPolicyAnalysisOutputConfig_GcsDestination)(nil),                       // 56: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.GcsDestination
	(*IamPolicyAnalysisOutputConfig_BigQueryDestination)(nil),                  // 57: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.BigQueryDestination
	(*SavedQuery_QueryContent)(nil),                                            // 58: google.cloud.asset.v1.SavedQuery.QueryContent
	nil,                                                                        // 59: google.cloud.asset.v1.SavedQuery.LabelsEntry
	(*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy)(nil),            // 60: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy
	(*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo)(nil), // 61: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo
	(*timestamppb.Timestamp)(nil),                                              // 62: google.protobuf.Timestamp
	(*Asset)(nil),                                                              // 63: google.cloud.asset.v1.Asset
	(*TimeWindow)(nil),                                                         // 64: google.cloud.asset.v1.TimeWindow
	(*TemporalAsset)(nil),                                                      // 65: google.cloud.asset.v1.TemporalAsset
	(*fieldmaskpb.FieldMask)(nil),                                              // 66: google.protobuf.FieldMask
	(*expr.Expr)(nil),                                                          // 67: google.type.Expr
	(*ResourceSearchResult)(nil),                                               // 68: google.cloud.asset.v1.ResourceSearchResult
	(*IamPolicySearchResult)(nil),                                              // 69: google.cloud.asset.v1.IamPolicySearchResult
	(*durationpb.Duration)(nil),                                                // 70: google.protobuf.Duration
	(*status.Status)(nil),                                                      // 71: google.rpc.Status
	(*IamPolicyAnalysisResult)(nil),                                            // 72: google.cloud.asset.v1.IamPolicyAnalysisResult
	(*IamPolicyAnalysisState)(nil),                                             // 73: google.cloud.asset.v1.IamPolicyAnalysisState
	(*v1.Policy)(nil),                                                          // 74: google.iam.v1.Policy
	(*longrunning.Operation)(nil),                                              // 75: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                                      // 76: google.protobuf.Empty
}
var file_google_cloud_asset_v1_asset_service_proto_depIdxs = []int32{
	62, // 0: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningMetadata.create_time:type_name -> google.protobuf.Timestamp
	62, // 1: google.cloud.asset.v1.ExportAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.cloud.asset.v1.ExportAssetsRequest.content_type:type_name -> google.cloud.asset.v1.ContentType
	17, // 3: google.cloud.asset.v1.ExportAssetsRequest.output_config:type_name -> google.cloud.asset.v1.OutputConfig
	62, // 4: google.cloud.asset.v1.ExportAssetsResponse.read_time:type_name -> google.protobuf.Timestamp
	17, // 5: google.cloud.asset.v1.ExportAssetsResponse.output_config:type_name -> google.cloud.asset.v1.OutputConfig
	18, // 6: google.cloud.asset.v1.ExportAssetsResponse.output_result:type_name -> google.cloud.asset.v1.OutputResult
	62, // 7: google.cloud.asset.v1.ListAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	0,  // 8: google.cloud.asset.v1.ListAssetsRequest.content_type:type_name -> google.cloud.asset.v1.ContentType
	62, // 9: google.cloud.asset.v1.ListAssetsResponse.read_time:type_name -> google.protobuf.Timestamp
	63, // 10: google.cloud.asset.v1.ListAssetsResponse.assets:type_name -> google.cloud.asset.v1.Asset
	0,  // 11: google.cloud.asset.v1.BatchGetAssetsHistoryRequest.content_type:type_name -> google.cloud.asset.v1.ContentType
	64, // 12: google.cloud.asset.v1.BatchGetAssetsHistoryRequest.read_time_window:type_name -> google.cloud.asset.v1.TimeWindow
	65, // 13: google.cloud.asset.v1.BatchGetAssetsHistoryResponse.assets:type_name -> google.cloud.asset.v1.TemporalAsset
	25, // 14: google.cloud.asset.v1.CreateFeedRequest.feed:type_name -> google.cloud.asset.v1.Feed
	25, // 15: google.cloud.asset.v1.ListFeedsResponse.feeds:type_name -> google.cloud.asset.v1.Feed
	25, // 16: google.cloud.asset.v1.UpdateFeedRequest.feed:type_name -> google.cloud.asset.v1.Feed
	66, // 17: google.cloud.asset.v1.UpdateFeedRequest.update_mask:type_name -> google.protobuf.FieldMask
	20, // 18: google.cloud.asset.v1.OutputConfig.gcs_destination:type_name -> google.cloud.asset.v1.GcsDestination
	21, // 19: google.cloud.asset.v1.OutputConfig.bigquery_destination:type_name -> google.cloud.asset.v1.BigQueryDestination
	19, // 20: google.cloud.asset.v1.OutputResult.gcs_result:type_name -> google.cloud.asset.v1.GcsOutputResult
	22, // 21: google.cloud.asset.v1.BigQueryDestination.partition_spec:type_name -> google.cloud.asset.v1.PartitionSpec
	1,  // 22: google.cloud.asset.v1.PartitionSpec.partition_key:type_name -> google.cloud.asset.v1.PartitionSpec.PartitionKey
	23, // 23: google.cloud.asset.v1.FeedOutputConfig.pubsub_destination:type_name -> google.cloud.asset.v1.PubsubDestination
	0,  // 24: google.cloud.asset.v1.Feed.content_type:type_name -> google.cloud.asset.v1.ContentType
	24, // 25: google.cloud.asset.v1.Feed.feed_output_config:type_name -> google.cloud.asset.v1.FeedOutputConfig
	67, // 26: google.cloud.asset.v1.Feed.condition:type_name -> google.type.Expr
	66, // 27: google.cloud.asset.v1.SearchAllResourcesRequest.read_mask:type_name -> google.protobuf.FieldMask
	68, // 28: google.cloud.asset.v1.SearchAllResourcesResponse.results:type_name -> google.cloud.asset.v1.ResourceSearchResult
	69, // 29: google.cloud.asset.v1.SearchAllIamPoliciesResponse.results:type_name -> google.cloud.asset.v1.IamPolicySearchResult
	50, // 30: google.cloud.asset.v1.IamPolicyAnalysisQuery.resource_selector:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery.ResourceSelector
	51, // 31: google.cloud.asset.v1.IamPolicyAnalysisQuery.identity_selector:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery.IdentitySelector
	52, // 32: google.cloud.asset.v1.IamPolicyAnalysisQuery.access_selector:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery.AccessSelector
	53, // 33: google.cloud.asset.v1.IamPolicyAnalysisQuery.options:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery.Options
	54, // 34: google.cloud.asset.v1.IamPolicyAnalysisQuery.condition_context:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery.ConditionContext
	30, // 35: google.cloud.asset.v1.AnalyzeIamPolicyRequest.analysis_query:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery
	70, // 36: google.cloud.asset.v1.AnalyzeIamPolicyRequest.execution_timeout:type_name -> google.protobuf.Duration
	55, // 37: google.cloud.asset.v1.AnalyzeIamPolicyResponse.main_analysis:type_name -> google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis
	55, // 38: google.cloud.asset.v1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis:type_name -> google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis
	56, // 39: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.gcs_destination:type_name -> google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.GcsDestination
	57, // 40: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.bigquery_destination:type_name -> google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.BigQueryDestination
	30, // 41: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest.analysis_query:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery
	33, // 42: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest.output_config:type_name -> google.cloud.asset.v1.IamPolicyAnalysisOutputConfig
	62, // 43: google.cloud.asset.v1.SavedQuery.create_time:type_name -> google.protobuf.Timestamp
	62, // 44: google.cloud.asset.v1.SavedQuery.last_update_time:type_name -> google.protobuf.Timestamp
	59, // 45: google.cloud.asset.v1.SavedQuery.labels:type_name -> google.cloud.asset.v1.SavedQuery.LabelsEntry
	58, // 46: google.cloud.asset.v1.SavedQuery.content:type_name -> google.cloud.asset.v1.SavedQuery.QueryContent
	36, // 47: google.cloud.asset.v1.CreateSavedQueryRequest.saved_query:type_name -> google.cloud.asset.v1.SavedQuery
	36, // 48: google.cloud.asset.v1.ListSavedQueriesResponse.saved_queries:type_name -> google.cloud.asset.v1.SavedQuery
	36, // 49: google.cloud.asset.v1.UpdateSavedQueryRequest.saved_query:type_name -> google.cloud.asset.v1.SavedQuery
	66, // 50: google.cloud.asset.v1.UpdateSavedQueryRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 51: google.cloud.asset.v1.AnalyzeMoveRequest.view:type_name -> google.cloud.asset.v1.AnalyzeMoveRequest.AnalysisView
	45, // 52: google.cloud.asset.v1.AnalyzeMoveResponse.move_analysis:type_name -> google.cloud.asset.v1.MoveAnalysis
	46, // 53: google.cloud.asset.v1.MoveAnalysis.analysis:type_name -> google.cloud.asset.v1.MoveAnalysisResult
	71, // 54: google.cloud.asset.v1.MoveAnalysis.error:type_name -> google.rpc.Status
	47, // 55: google.cloud.asset.v1.MoveAnalysisResult.blockers:type_name -> google.cloud.asset.v1.MoveImpact
	47, // 56: google.cloud.asset.v1.MoveAnalysisResult.warnings:type_name -> google.cloud.asset.v1.MoveImpact
	60, // 57: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.policy_results:type_name -> google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy
	62, // 58: google.cloud.asset.v1.IamPolicyAnalysisQuery.ConditionContext.access_time:type_name -> google.protobuf.Timestamp
	30, // 59: google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_query:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery
	72, // 60: google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_results:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult
	73, // 61: google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.non_critical_errors:type_name -> google.cloud.asset.v1.IamPolicyAnalysisState
	2,  // 62: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.BigQueryDestination.partition_key:type_name -> google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.BigQueryDestination.PartitionKey
	30, // 63: google.cloud.asset.v1.SavedQuery.QueryContent.iam_policy_analysis_query:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery
	61, // 64: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.policies:type_name -> google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo
	74, // 65: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.policy:type_name -> google.iam.v1.Policy
	5,  // 66: google.cloud.asset.v1.AssetService.ExportAssets:input_type -> google.cloud.asset.v1.ExportAssetsRequest
	7,  // 67: google.cloud.asset.v1.AssetService.ListAssets:input_type -> google.cloud.asset.v1.ListAssetsRequest
	9,  // 68: google.cloud.asset.v1.AssetService.BatchGetAssetsHistory:input_type -> google.cloud.asset.v1.BatchGetAssetsHistoryRequest
	11, // 69: google.cloud.asset.v1.AssetService.CreateFeed:input_type -> google.cloud.asset.v1.CreateFeedRequest
	12, // 70: google.cloud.asset.v1.AssetService.GetFeed:input_type -> google.cloud.asset.v1.GetFeedRequest
	13, // 71: google.cloud.asset.v1.AssetService.ListFeeds:input_type -> google.cloud.asset.v1.ListFeedsRequest
	15, // 72: google.cloud.asset.v1.AssetService.UpdateFeed:input_type -> google.cloud.asset.v1.UpdateFeedRequest
	16, // 73: google.cloud.asset.v1.AssetService.DeleteFeed:input_type -> google.cloud.asset.v1.DeleteFeedRequest
	26, // 74: google.cloud.asset.v1.AssetService.SearchAllResources:input_type -> google.cloud.asset.v1.SearchAllResourcesRequest
	28, // 75: google.cloud.asset.v1.AssetService.SearchAllIamPolicies:input_type -> google.cloud.asset.v1.SearchAllIamPoliciesRequest
	31, // 76: google.cloud.asset.v1.AssetService.AnalyzeIamPolicy:input_type -> google.cloud.asset.v1.AnalyzeIamPolicyRequest
	34, // 77: google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning:input_type -> google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest
	43, // 78: google.cloud.asset.v1.AssetService.AnalyzeMove:input_type -> google.cloud.asset.v1.AnalyzeMoveRequest
	37, // 79: google.cloud.asset.v1.AssetService.CreateSavedQuery:input_type -> google.cloud.asset.v1.CreateSavedQueryRequest
	38, // 80: google.cloud.asset.v1.AssetService.GetSavedQuery:input_type -> google.cloud.asset.v1.GetSavedQueryRequest
	39, // 81: google.cloud.asset.v1.AssetService.ListSavedQueries:input_type -> google.cloud.asset.v1.ListSavedQueriesRequest
	41, // 82: google.cloud.asset.v1.AssetService.UpdateSavedQuery:input_type -> google.cloud.asset.v1.UpdateSavedQueryRequest
	42, // 83: google.cloud.asset.v1.AssetService.DeleteSavedQuery:input_type -> google.cloud.asset.v1.DeleteSavedQueryRequest
	48, // 84: google.cloud.asset.v1.AssetService.BatchGetEffectiveIamPolicies:input_type -> google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest
	75, // 85: google.cloud.asset.v1.AssetService.ExportAssets:output_type -> google.longrunning.Operation
	8,  // 86: google.cloud.asset.v1.AssetService.ListAssets:output_type -> google.cloud.asset.v1.ListAssetsResponse
	10, // 87: google.cloud.asset.v1.AssetService.BatchGetAssetsHistory:output_type -> google.cloud.asset.v1.BatchGetAssetsHistoryResponse
	25, // 88: google.cloud.asset.v1.AssetService.CreateFeed:output_type -> google.cloud.asset.v1.Feed
	25, // 89: google.cloud.asset.v1.AssetService.GetFeed:output_type -> google.cloud.asset.v1.Feed
	14, // 90: google.cloud.asset.v1.AssetService.ListFeeds:output_type -> google.cloud.asset.v1.ListFeedsResponse
	25, // 91: google.cloud.asset.v1.AssetService.UpdateFeed:output_type -> google.cloud.asset.v1.Feed
	76, // 92: google.cloud.asset.v1.AssetService.DeleteFeed:output_type -> google.protobuf.Empty
	27, // 93: google.cloud.asset.v1.AssetService.SearchAllResources:output_type -> google.cloud.asset.v1.SearchAllResourcesResponse
	29, // 94: google.cloud.asset.v1.AssetService.SearchAllIamPolicies:output_type -> google.cloud.asset.v1.SearchAllIamPoliciesResponse
	32, // 95: google.cloud.asset.v1.AssetService.AnalyzeIamPolicy:output_type -> google.cloud.asset.v1.AnalyzeIamPolicyResponse
	75, // 96: google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning:output_type -> google.longrunning.Operation
	44, // 97: google.cloud.asset.v1.AssetService.AnalyzeMove:output_type -> google.cloud.asset.v1.AnalyzeMoveResponse
	36, // 98: google.cloud.asset.v1.AssetService.CreateSavedQuery:output_type -> google.cloud.asset.v1.SavedQuery
	36, // 99: google.cloud.asset.v1.AssetService.GetSavedQuery:output_type -> google.cloud.asset.v1.SavedQuery
	40, // 100: google.cloud.asset.v1.AssetService.ListSavedQueries:output_type -> google.cloud.asset.v1.ListSavedQueriesResponse
	36, // 101: google.cloud.asset.v1.AssetService.UpdateSavedQuery:output_type -> google.cloud.asset.v1.SavedQuery
	76, // 102: google.cloud.asset.v1.AssetService.DeleteSavedQuery:output_type -> google.protobuf.Empty
	49, // 103: google.cloud.asset.v1.AssetService.BatchGetEffectiveIamPolicies:output_type -> google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse
	85, // [85:104] is the sub-list for method output_type
	66, // [66:85] is the sub-list for method input_type
	66, // [66:66] is the sub-list for extension type_name
	66, // [66:66] is the sub-list for extension extendee
	0,  // [0:66] is the sub-list for field type_name
}

func init() { file_google_cloud_asset_v1_asset_service_proto_init() }
func file_google_cloud_asset_v1_asset_service_proto_init() {
	if File_google_cloud_asset_v1_asset_service_proto != nil {
		return
	}
	file_google_cloud_asset_v1_assets_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeIamPolicyLongrunningMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetAssetsHistoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetAssetsHistoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFeedsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFeedsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsOutputResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubsubDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeedOutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Feed); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAllResourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAllResourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAllIamPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAllIamPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeIamPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeIamPolicyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisOutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeIamPolicyLongrunningRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeIamPolicyLongrunningResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SavedQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSavedQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSavedQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSavedQueriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSavedQueriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSavedQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSavedQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeMoveRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeMoveResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveAnalysis); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveAnalysisResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MoveImpact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetEffectiveIamPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetEffectiveIamPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisQuery_ResourceSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisQuery_IdentitySelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisQuery_AccessSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisQuery_Options); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisQuery_ConditionContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeIamPolicyResponse_IamPolicyAnalysis); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisOutputConfig_GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisOutputConfig_BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SavedQuery_QueryContent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*OutputConfig_GcsDestination)(nil),
		(*OutputConfig_BigqueryDestination)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*OutputResult_GcsResult)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*GcsDestination_Uri)(nil),
		(*GcsDestination_UriPrefix)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[20].OneofWrappers = []interface{}{
		(*FeedOutputConfig_PubsubDestination)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[29].OneofWrappers = []interface{}{
		(*IamPolicyAnalysisOutputConfig_GcsDestination_)(nil),
		(*IamPolicyAnalysisOutputConfig_BigqueryDestination)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[41].OneofWrappers = []interface{}{
		(*MoveAnalysis_Analysis)(nil),
		(*MoveAnalysis_Error)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[50].OneofWrappers = []interface{}{
		(*IamPolicyAnalysisQuery_ConditionContext_AccessTime)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[54].OneofWrappers = []interface{}{
		(*SavedQuery_QueryContent_IamPolicyAnalysisQuery)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_asset_v1_asset_service_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   58,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_asset_v1_asset_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_asset_v1_asset_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_asset_v1_asset_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_asset_v1_asset_service_proto_msgTypes,
	}.Build()
	File_google_cloud_asset_v1_asset_service_proto = out.File
	file_google_cloud_asset_v1_asset_service_proto_rawDesc = nil
	file_google_cloud_asset_v1_asset_service_proto_goTypes = nil
	file_google_cloud_asset_v1_asset_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location/BigQuery table. For Cloud Storage location destinations, the
	// output format is newline-delimited JSON. Each line represents a
	// [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
	// format; for BigQuery table destinations, the output table stores the fields
	// in asset Protobuf as columns. This API implements the
	// [google.longrunning.Operation][google.longrunning.Operation] API, which
	// allows you to keep track of the export. We recommend intervals of at least
	// 2 seconds with exponential retry to poll the export operation result. For
	// regular-size resource parent, the export operation usually finishes within
	// 5 minutes.
	ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists assets with time and resource types and returns paged results in
	// response.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Batch gets the update history of assets that overlap a time window.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	// Otherwise, this API outputs history with asset in both non-delete or
	// deleted status.
	// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
	// error.
	BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Searches all Cloud resources within the specified scope, such as a project,
	// folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllResources` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllResources(ctx context.Context, in *SearchAllResourcesRequest, opts ...grpc.CallOption) (*SearchAllResourcesResponse, error)
	// Searches all IAM policies within the specified scope, such as a project,
	// folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllIamPolicies(ctx context.Context, in *SearchAllIamPoliciesRequest, opts ...grpc.CallOption) (*SearchAllIamPoliciesResponse, error)
	// Analyzes IAM policies to answer which identities have what accesses on
	// which resources.
	AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error)
	// Analyzes IAM policies asynchronously to answer which identities have what
	// accesses on which resources, and writes the analysis results to a Google
	// Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
	// output format is the JSON format that represents a
	// [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
	// This method implements the
	// [google.longrunning.Operation][google.longrunning.Operation], which allows
	// you to track the operation status. We recommend intervals of at least 2
	// seconds with exponential backoff retry to poll the operation result. The
	// metadata contains the metadata for the long-running operation.
	AnalyzeIamPolicyLongrunning(ctx context.Context, in *AnalyzeIamPolicyLongrunningRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Analyze moving a resource to a specified destination without kicking off
	// the actual move. The analysis is best effort depending on the user's
	// permissions of viewing different hierarchical policies and configurations.
	// The policies and configuration are subject to change before the actual
	// resource migration takes place.
	AnalyzeMove(ctx context.Context, in *AnalyzeMoveRequest, opts ...grpc.CallOption) (*AnalyzeMoveResponse, error)
	// Creates a saved query in a parent project/folder/organization.
	CreateSavedQuery(ctx context.Context, in *CreateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error)
	// Gets details about a saved query.
	GetSavedQuery(ctx context.Context, in *GetSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error)
	// Lists all saved queries in a parent project/folder/organization.
	ListSavedQueries(ctx context.Context, in *ListSavedQueriesRequest, opts ...grpc.CallOption) (*ListSavedQueriesResponse, error)
	// Updates a saved query.
	UpdateSavedQuery(ctx context.Context, in *UpdateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error)
	// Deletes a saved query.
	DeleteSavedQuery(ctx context.Context, in *DeleteSavedQueryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets effective IAM policies for a batch of resources.
	BatchGetEffectiveIamPolicies(ctx context.Context, in *BatchGetEffectiveIamPoliciesRequest, opts ...grpc.CallOption) (*BatchGetEffectiveIamPoliciesResponse, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ExportAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ListAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error) {
	out := new(BatchGetAssetsHistoryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/BatchGetAssetsHistory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/CreateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/GetFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error) {
	out := new(ListFeedsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ListFeeds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/UpdateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/DeleteFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchAllResources(ctx context.Context, in *SearchAllResourcesRequest, opts ...grpc.CallOption) (*SearchAllResourcesResponse, error) {
	out := new(SearchAllResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/SearchAllResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchAllIamPolicies(ctx context.Context, in *SearchAllIamPoliciesRequest, opts ...grpc.CallOption) (*SearchAllIamPoliciesResponse, error) {
	out := new(SearchAllIamPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/SearchAllIamPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error) {
	out := new(AnalyzeIamPolicyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/AnalyzeIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeIamPolicyLongrunning(ctx context.Context, in *AnalyzeIamPolicyLongrunningRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/AnalyzeIamPolicyLongrunning", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeMove(ctx context.Context, in *AnalyzeMoveRequest, opts ...grpc.CallOption) (*AnalyzeMoveResponse, error) {
	out := new(AnalyzeMoveResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/AnalyzeMove", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) CreateSavedQuery(ctx context.Context, in *CreateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error) {
	out := new(SavedQuery)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/CreateSavedQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) GetSavedQuery(ctx context.Context, in *GetSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error) {
	out := new(SavedQuery)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/GetSavedQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListSavedQueries(ctx context.Context, in *ListSavedQueriesRequest, opts ...grpc.CallOption) (*ListSavedQueriesResponse, error) {
	out := new(ListSavedQueriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ListSavedQueries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) UpdateSavedQuery(ctx context.Context, in *UpdateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error) {
	out := new(SavedQuery)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/UpdateSavedQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) DeleteSavedQuery(ctx context.Context, in *DeleteSavedQueryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/DeleteSavedQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) BatchGetEffectiveIamPolicies(ctx context.Context, in *BatchGetEffectiveIamPoliciesRequest, opts ...grpc.CallOption) (*BatchGetEffectiveIamPoliciesResponse, error) {
	out := new(BatchGetEffectiveIamPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/BatchGetEffectiveIamPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location/BigQuery table. For Cloud Storage location destinations, the
	// output format is newline-delimited JSON. Each line represents a
	// [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
	// format; for BigQuery table destinations, the output table stores the fields
	// in asset Protobuf as columns. This API implements the
	// [google.longrunning.Operation][google.longrunning.Operation] API, which
	// allows you to keep track of the export. We recommend intervals of at least
	// 2 seconds with exponential retry to poll the export operation result. For
	// regular-size resource parent, the export operation usually finishes within
	// 5 minutes.
	ExportAssets(context.Context, *ExportAssetsRequest) (*longrunning.Operation, error)
	// Lists assets with time and resource types and returns paged results in
	// response.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Batch gets the update history of assets that overlap a time window.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	// Otherwise, this API outputs history with asset in both non-delete or
	// deleted status.
	// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
	// error.
	BatchGetAssetsHistory(context.Context, *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(context.Context, *GetFeedRequest) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(context.Context, *DeleteFeedRequest) (*emptypb.Empty, error)
	// Searches all Cloud resources within the specified scope, such as a project,
	// folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllResources` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllResources(context.Context, *SearchAllResourcesRequest) (*SearchAllResourcesResponse, error)
	// Searches all IAM policies within the specified scope, such as a project,
	// folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllIamPolicies(context.Context, *SearchAllIamPoliciesRequest) (*SearchAllIamPoliciesResponse, error)
	// Analyzes IAM policies to answer which identities have what accesses on
	// which resources.
	AnalyzeIamPolicy(context.Context, *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error)
	// Analyzes IAM policies asynchronously to answer which identities have what
	// accesses on which resources, and writes the analysis results to a Google
	// Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
	// output format is the JSON format that represents a
	// [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
	// This method implements the
	// [google.longrunning.Operation][google.longrunning.Operation], which allows
	// you to track the operation status. We recommend intervals of at least 2
	// seconds with exponential backoff retry to poll the operation result. The
	// metadata contains the metadata for the long-running operation.
	AnalyzeIamPolicyLongrunning(context.Context, *AnalyzeIamPolicyLongrunningRequest) (*longrunning.Operation, error)
	// Analyze moving a resource to a specified destination without kicking off
	// the actual move. The analysis is best effort depending on the user's
	// permissions of viewing different hierarchical policies and configurations.
	// The policies and configuration are subject to change before the actual
	// resource migration takes place.
	AnalyzeMove(context.Context, *AnalyzeMoveRequest) (*AnalyzeMoveResponse, error)
	// Creates a saved query in a parent project/folder/organization.
	CreateSavedQuery(context.Context, *CreateSavedQueryRequest) (*SavedQuery, error)
	// Gets details about a saved query.
	GetSavedQuery(context.Context, *GetSavedQueryRequest) (*SavedQuery, error)
	// Lists all saved queries in a parent project/folder/organization.
	ListSavedQueries(context.Context, *ListSavedQueriesRequest) (*ListSavedQueriesResponse, error)
	// Updates a saved query.
	UpdateSavedQuery(context.Context, *UpdateSavedQueryRequest) (*SavedQuery, error)
	// Deletes a saved query.
	DeleteSavedQuery(context.Context, *DeleteSavedQueryRequest) (*emptypb.Empty, error)
	// Gets effective IAM policies for a batch of resources.
	BatchGetEffectiveIamPolicies(context.Context, *BatchGetEffectiveIamPoliciesRequest) (*BatchGetEffectiveIamPoliciesResponse, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) ExportAssets(context.Context, *ExportAssetsRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExportAssets not implemented")
}
func (*UnimplementedAssetServiceServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (*UnimplementedAssetServiceServer) BatchGetAssetsHistory(context.Context, *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchGetAssetsHistory not implemented")
}
func (*UnimplementedAssetServiceServer) CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateFeed not implemented")
}
func (*UnimplementedAssetServiceServer) GetFeed(context.Context, *GetFeedRequest) (*Feed, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetFeed not implemented")
}
func (*UnimplementedAssetServiceServer) ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListFeeds not implemented")
}
func (*UnimplementedAssetServiceServer) UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateFeed not implemented")
}
func (*UnimplementedAssetServiceServer) DeleteFeed(context.Context, *DeleteFeedRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteFeed not implemented")
}
func (*UnimplementedAssetServiceServer) SearchAllResources(context.Context, *SearchAllResourcesRequest) (*SearchAllResourcesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAllResources not implemented")
}
func (*UnimplementedAssetServiceServer) SearchAllIamPolicies(context.Context, *SearchAllIamPoliciesRequest) (*SearchAllIamPoliciesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAllIamPolicies not implemented")
}
func (*UnimplementedAssetServiceServer) AnalyzeIamPolicy(context.Context, *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeIamPolicy not implemented")
}
func (*UnimplementedAssetServiceServer) AnalyzeIamPolicyLongrunning(context.Context, *AnalyzeIamPolicyLongrunningRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeIamPolicyLongrunning not implemented")
}
func (*UnimplementedAssetServiceServer) AnalyzeMove(context.Context, *AnalyzeMoveRequest) (*AnalyzeMoveResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeMove not implemented")
}
func (*UnimplementedAssetServiceServer) CreateSavedQuery(context.Context, *CreateSavedQueryRequest) (*SavedQuery, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSavedQuery not implemented")
}
func (*UnimplementedAssetServiceServer) GetSavedQuery(context.Context, *GetSavedQueryRequest) (*SavedQuery, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSavedQuery not implemented")
}
func (*UnimplementedAssetServiceServer) ListSavedQueries(context.Context, *ListSavedQueriesRequest) (*ListSavedQueriesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSavedQueries not implemented")
}
func (*UnimplementedAssetServiceServer) UpdateSavedQuery(context.Context, *UpdateSavedQueryRequest) (*SavedQuery, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSavedQuery not implemented")
}
func (*UnimplementedAssetServiceServer) DeleteSavedQuery(context.Context, *DeleteSavedQueryRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteSavedQuery not implemented")
}
func (*UnimplementedAssetServiceServer) BatchGetEffectiveIamPolicies(context.Context, *BatchGetEffectiveIamPoliciesRequest) (*BatchGetEffectiveIamPoliciesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchGetEffectiveIamPolicies not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_ExportAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ExportAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ExportAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ExportAssets(ctx, req.(*ExportAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ListAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_BatchGetAssetsHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetAssetsHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/BatchGetAssetsHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, req.(*BatchGetAssetsHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_CreateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).CreateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/CreateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).CreateFeed(ctx, req.(*CreateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_GetFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/GetFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetFeed(ctx, req.(*GetFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ListFeeds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListFeeds(ctx, req.(*ListFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_UpdateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).UpdateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/UpdateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).UpdateFeed(ctx, req.(*UpdateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_DeleteFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).DeleteFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/DeleteFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).DeleteFeed(ctx, req.(*DeleteFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchAllResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchAllResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/SearchAllResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchAllResources(ctx, req.(*SearchAllResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchAllIamPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllIamPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchAllIamPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/SearchAllIamPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchAllIamPolicies(ctx, req.(*SearchAllIamPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/AnalyzeIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, req.(*AnalyzeIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeIamPolicyLongrunning_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeIamPolicyLongrunningRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeIamPolicyLongrunning(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/AnalyzeIamPolicyLongrunning",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeIamPolicyLongrunning(ctx, req.(*AnalyzeIamPolicyLongrunningRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeMove_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeMoveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeMove(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/AnalyzeMove",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeMove(ctx, req.(*AnalyzeMoveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_CreateSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).CreateSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/CreateSavedQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).CreateSavedQuery(ctx, req.(*CreateSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_GetSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/GetSavedQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetSavedQuery(ctx, req.(*GetSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListSavedQueries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSavedQueriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListSavedQueries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ListSavedQueries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListSavedQueries(ctx, req.(*ListSavedQueriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_UpdateSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).UpdateSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/UpdateSavedQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).UpdateSavedQuery(ctx, req.(*UpdateSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_DeleteSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).DeleteSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/DeleteSavedQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).DeleteSavedQuery(ctx, req.(*DeleteSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_BatchGetEffectiveIamPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetEffectiveIamPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).BatchGetEffectiveIamPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/BatchGetEffectiveIamPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).BatchGetEffectiveIamPolicies(ctx, req.(*BatchGetEffectiveIamPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportAssets",
			Handler:    _AssetService_ExportAssets_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _AssetService_ListAssets_Handler,
		},
		{
			MethodName: "BatchGetAssetsHistory",
			Handler:    _AssetService_BatchGetAssetsHistory_Handler,
		},
		{
			MethodName: "CreateFeed",
			Handler:    _AssetService_CreateFeed_Handler,
		},
		{
			MethodName: "GetFeed",
			Handler:    _AssetService_GetFeed_Handler,
		},
		{
			MethodName: "ListFeeds",
			Handler:    _AssetService_ListFeeds_Handler,
		},
		{
			MethodName: "UpdateFeed",
			Handler:    _AssetService_UpdateFeed_Handler,
		},
		{
			MethodName: "DeleteFeed",
			Handler:    _AssetService_DeleteFeed_Handler,
		},
		{
			MethodName: "SearchAllResources",
			Handler:    _AssetService_SearchAllResources_Handler,
		},
		{
			MethodName: "SearchAllIamPolicies",
			Handler:    _AssetService_SearchAllIamPolicies_Handler,
		},
		{
			MethodName: "AnalyzeIamPolicy",
			Handler:    _AssetService_AnalyzeIamPolicy_Handler,
		},
		{
			MethodName: "AnalyzeIamPolicyLongrunning",
			Handler:    _AssetService_AnalyzeIamPolicyLongrunning_Handler,
		},
		{
			MethodName: "AnalyzeMove",
			Handler:    _AssetService_AnalyzeMove_Handler,
		},
		{
			MethodName: "CreateSavedQuery",
			Handler:    _AssetService_CreateSavedQuery_Handler,
		},
		{
			MethodName: "GetSavedQuery",
			Handler:    _AssetService_GetSavedQuery_Handler,
		},
		{
			MethodName: "ListSavedQueries",
			Handler:    _AssetService_ListSavedQueries_Handler,
		},
		{
			MethodName: "UpdateSavedQuery",
			Handler:    _AssetService_UpdateSavedQuery_Handler,
		},
		{
			MethodName: "DeleteSavedQuery",
			Handler:    _AssetService_DeleteSavedQuery_Handler,
		},
		{
			MethodName: "BatchGetEffectiveIamPolicies",
			Handler:    _AssetService_BatchGetEffectiveIamPolicies_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1/asset_service.proto",
}
