// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/dialogflow/v2/session.proto

package dialogflow

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of the response message.
type StreamingRecognitionResult_MessageType int32

const (
	// Not specified. Should never be used.
	StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED StreamingRecognitionResult_MessageType = 0
	// Message contains a (possibly partial) transcript.
	StreamingRecognitionResult_TRANSCRIPT StreamingRecognitionResult_MessageType = 1
	// Event indicates that the server has detected the end of the user's speech
	// utterance and expects no additional inputs.
	// Therefore, the server will not process additional audio (although it may subsequently return additional results). The
	// client should stop sending additional audio data, half-close the gRPC
	// connection, and wait for any additional results until the server closes
	// the gRPC connection. This message is only sent if `single_utterance` was
	// set to `true`, and is not used otherwise.
	StreamingRecognitionResult_END_OF_SINGLE_UTTERANCE StreamingRecognitionResult_MessageType = 2
)

// Enum value maps for StreamingRecognitionResult_MessageType.
var (
	StreamingRecognitionResult_MessageType_name = map[int32]string{
		0: "MESSAGE_TYPE_UNSPECIFIED",
		1: "TRANSCRIPT",
		2: "END_OF_SINGLE_UTTERANCE",
	}
	StreamingRecognitionResult_MessageType_value = map[string]int32{
		"MESSAGE_TYPE_UNSPECIFIED": 0,
		"TRANSCRIPT":               1,
		"END_OF_SINGLE_UTTERANCE":  2,
	}
)

func (x StreamingRecognitionResult_MessageType) Enum() *StreamingRecognitionResult_MessageType {
	p := new(StreamingRecognitionResult_MessageType)
	*p = x
	return p
}

func (x StreamingRecognitionResult_MessageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StreamingRecognitionResult_MessageType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_session_proto_enumTypes[0].Descriptor()
}

func (StreamingRecognitionResult_MessageType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_session_proto_enumTypes[0]
}

func (x StreamingRecognitionResult_MessageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StreamingRecognitionResult_MessageType.Descriptor instead.
func (StreamingRecognitionResult_MessageType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{7, 0}
}

// The request to detect user's intent.
type DetectIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session this query is sent to. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>`, or
	// `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>`. If `Environment ID` is not specified, we assume
	// default 'draft' environment (`Environment ID` might be referred to as
	// environment name at some places). If `User ID` is not specified, we are
	// using "-". It's up to the API caller to choose an appropriate `Session ID`
	// and `User Id`. They can be a random number or some type of user and session
	// identifiers (preferably hashed). The length of the `Session ID` and
	// `User ID` must not exceed 36 characters.
	//
	// For more information, see the [API interactions
	// guide](https://cloud.google.com/dialogflow/docs/api-overview).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config
	//     which instructs the speech recognizer how to process the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Instructs the speech synthesizer how to generate the output
	// audio. If this field is not set and agent-level speech synthesizer is not
	// configured, no output audio is generated.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Mask for [output_audio_config][google.cloud.dialogflow.v2.DetectIntentRequest.output_audio_config] indicating which settings in this
	// request-level config should override speech synthesizer settings defined at
	// agent-level.
	//
	// If unspecified or empty, [output_audio_config][google.cloud.dialogflow.v2.DetectIntentRequest.output_audio_config] replaces the agent-level
	// config in its entirety.
	OutputAudioConfigMask *fieldmaskpb.FieldMask `protobuf:"bytes,7,opt,name=output_audio_config_mask,json=outputAudioConfigMask,proto3" json:"output_audio_config_mask,omitempty"`
	// The natural language speech audio to be processed. This field
	// should be populated iff `query_input` is set to an input audio config.
	// A single request can contain up to 1 minute of speech audio data.
	InputAudio []byte `protobuf:"bytes,5,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
}

func (x *DetectIntentRequest) Reset() {
	*x = DetectIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectIntentRequest) ProtoMessage() {}

func (x *DetectIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectIntentRequest.ProtoReflect.Descriptor instead.
func (*DetectIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{0}
}

func (x *DetectIntentRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *DetectIntentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *DetectIntentRequest) GetQueryInput() *QueryInput {
	if x != nil {
		return x.QueryInput
	}
	return nil
}

func (x *DetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

func (x *DetectIntentRequest) GetOutputAudioConfigMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.OutputAudioConfigMask
	}
	return nil
}

func (x *DetectIntentRequest) GetInputAudio() []byte {
	if x != nil {
		return x.InputAudio
	}
	return nil
}

// The message returned from the DetectIntent method.
type DetectIntentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The selected results of the conversational query or event processing.
	// See `alternative_query_results` for additional potential results.
	QueryResult *QueryResult `protobuf:"bytes,2,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// Specifies the status of the webhook request.
	WebhookStatus *status.Status `protobuf:"bytes,3,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the `query_result.fulfillment_messages` field. If
	// multiple default text responses exist, they will be concatenated when
	// generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	//
	// In some scenarios, multiple output audio fields may be present in the
	// response structure. In these cases, only the top-most-level audio output
	// has content.
	OutputAudio []byte `protobuf:"bytes,4,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,6,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
}

func (x *DetectIntentResponse) Reset() {
	*x = DetectIntentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DetectIntentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DetectIntentResponse) ProtoMessage() {}

func (x *DetectIntentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DetectIntentResponse.ProtoReflect.Descriptor instead.
func (*DetectIntentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{1}
}

func (x *DetectIntentResponse) GetResponseId() string {
	if x != nil {
		return x.ResponseId
	}
	return ""
}

func (x *DetectIntentResponse) GetQueryResult() *QueryResult {
	if x != nil {
		return x.QueryResult
	}
	return nil
}

func (x *DetectIntentResponse) GetWebhookStatus() *status.Status {
	if x != nil {
		return x.WebhookStatus
	}
	return nil
}

func (x *DetectIntentResponse) GetOutputAudio() []byte {
	if x != nil {
		return x.OutputAudio
	}
	return nil
}

func (x *DetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

// Represents the parameters of the conversational query.
type QueryParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time zone of this conversational query from the
	// [time zone database](https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris. If not provided, the time zone specified in
	// agent settings is used.
	TimeZone string `protobuf:"bytes,1,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// The geo location of this conversational query.
	GeoLocation *latlng.LatLng `protobuf:"bytes,2,opt,name=geo_location,json=geoLocation,proto3" json:"geo_location,omitempty"`
	// The collection of contexts to be activated before this query is
	// executed.
	Contexts []*Context `protobuf:"bytes,3,rep,name=contexts,proto3" json:"contexts,omitempty"`
	// Specifies whether to delete all contexts in the current session
	// before the new ones are activated.
	ResetContexts bool `protobuf:"varint,4,opt,name=reset_contexts,json=resetContexts,proto3" json:"reset_contexts,omitempty"`
	// Additional session entity types to replace or extend developer
	// entity types with. The entity synonyms apply to all languages and persist
	// for the session of this query.
	SessionEntityTypes []*SessionEntityType `protobuf:"bytes,5,rep,name=session_entity_types,json=sessionEntityTypes,proto3" json:"session_entity_types,omitempty"`
	// This field can be used to pass custom data to your webhook.
	// Arbitrary JSON objects are supported.
	// If supplied, the value is used to populate the
	// `WebhookRequest.original_detect_intent_request.payload`
	// field sent to your webhook.
	Payload *structpb.Struct `protobuf:"bytes,6,opt,name=payload,proto3" json:"payload,omitempty"`
	// Configures the type of sentiment analysis to perform. If not
	// provided, sentiment analysis is not performed.
	SentimentAnalysisRequestConfig *SentimentAnalysisRequestConfig `protobuf:"bytes,10,opt,name=sentiment_analysis_request_config,json=sentimentAnalysisRequestConfig,proto3" json:"sentiment_analysis_request_config,omitempty"`
	// This field can be used to pass HTTP headers for a webhook
	// call. These headers will be sent to webhook along with the headers that
	// have been configured through the Dialogflow web console. The headers
	// defined within this field will overwrite the headers configured through the
	// Dialogflow console if there is a conflict. Header names are
	// case-insensitive. Google's specified headers are not allowed. Including:
	// "Host", "Content-Length", "Connection", "From", "User-Agent",
	// "Accept-Encoding", "If-Modified-Since", "If-None-Match", "X-Forwarded-For",
	// etc.
	WebhookHeaders map[string]string `protobuf:"bytes,14,rep,name=webhook_headers,json=webhookHeaders,proto3" json:"webhook_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *QueryParameters) Reset() {
	*x = QueryParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryParameters) ProtoMessage() {}

func (x *QueryParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryParameters.ProtoReflect.Descriptor instead.
func (*QueryParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{2}
}

func (x *QueryParameters) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *QueryParameters) GetGeoLocation() *latlng.LatLng {
	if x != nil {
		return x.GeoLocation
	}
	return nil
}

func (x *QueryParameters) GetContexts() []*Context {
	if x != nil {
		return x.Contexts
	}
	return nil
}

func (x *QueryParameters) GetResetContexts() bool {
	if x != nil {
		return x.ResetContexts
	}
	return false
}

func (x *QueryParameters) GetSessionEntityTypes() []*SessionEntityType {
	if x != nil {
		return x.SessionEntityTypes
	}
	return nil
}

func (x *QueryParameters) GetPayload() *structpb.Struct {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *QueryParameters) GetSentimentAnalysisRequestConfig() *SentimentAnalysisRequestConfig {
	if x != nil {
		return x.SentimentAnalysisRequestConfig
	}
	return nil
}

func (x *QueryParameters) GetWebhookHeaders() map[string]string {
	if x != nil {
		return x.WebhookHeaders
	}
	return nil
}

// Represents the query input. It can contain either:
//
// 1.  An audio config which
//     instructs the speech recognizer how to process the speech audio.
//
// 2.  A conversational query in the form of text,.
//
// 3.  An event that specifies which intent to trigger.
type QueryInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The input specification.
	//
	// Types that are assignable to Input:
	//	*QueryInput_AudioConfig
	//	*QueryInput_Text
	//	*QueryInput_Event
	Input isQueryInput_Input `protobuf_oneof:"input"`
}

func (x *QueryInput) Reset() {
	*x = QueryInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryInput) ProtoMessage() {}

func (x *QueryInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryInput.ProtoReflect.Descriptor instead.
func (*QueryInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{3}
}

func (m *QueryInput) GetInput() isQueryInput_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *QueryInput) GetAudioConfig() *InputAudioConfig {
	if x, ok := x.GetInput().(*QueryInput_AudioConfig); ok {
		return x.AudioConfig
	}
	return nil
}

func (x *QueryInput) GetText() *TextInput {
	if x, ok := x.GetInput().(*QueryInput_Text); ok {
		return x.Text
	}
	return nil
}

func (x *QueryInput) GetEvent() *EventInput {
	if x, ok := x.GetInput().(*QueryInput_Event); ok {
		return x.Event
	}
	return nil
}

type isQueryInput_Input interface {
	isQueryInput_Input()
}

type QueryInput_AudioConfig struct {
	// Instructs the speech recognizer how to process the speech audio.
	AudioConfig *InputAudioConfig `protobuf:"bytes,1,opt,name=audio_config,json=audioConfig,proto3,oneof"`
}

type QueryInput_Text struct {
	// The natural language text to be processed.
	Text *TextInput `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}

type QueryInput_Event struct {
	// The event to be processed.
	Event *EventInput `protobuf:"bytes,3,opt,name=event,proto3,oneof"`
}

func (*QueryInput_AudioConfig) isQueryInput_Input() {}

func (*QueryInput_Text) isQueryInput_Input() {}

func (*QueryInput_Event) isQueryInput_Input() {}

// Represents the result of conversational query or event processing.
type QueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The original conversational query text:
	//
	// - If natural language text was provided as input, `query_text` contains
	//   a copy of the input.
	// - If natural language speech audio was provided as input, `query_text`
	//   contains the speech recognition result. If speech recognizer produced
	//   multiple alternatives, a particular one is picked.
	// - If automatic spell correction is enabled, `query_text` will contain the
	//   corrected user input.
	QueryText string `protobuf:"bytes,1,opt,name=query_text,json=queryText,proto3" json:"query_text,omitempty"`
	// The language that was triggered during intent detection.
	// See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,15,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Speech recognition confidence between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. The default of 0.0 is a sentinel value indicating that confidence
	// was not set.
	//
	// This field is not guaranteed to be accurate or set. In particular this
	// field isn't set for StreamingDetectIntent since the streaming endpoint has
	// separate confidence estimates per portion of the audio in
	// StreamingRecognitionResult.
	SpeechRecognitionConfidence float32 `protobuf:"fixed32,2,opt,name=speech_recognition_confidence,json=speechRecognitionConfidence,proto3" json:"speech_recognition_confidence,omitempty"`
	// The action name from the matched intent.
	Action string `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// The collection of extracted parameters.
	//
	// Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object
	// composed of a collection of (MapKey, MapValue) pairs:
	//
	// -   MapKey type: string
	// -   MapKey value: parameter name
	// -   MapValue type:
	//     -   If parameter's entity type is a composite entity: map
	//     -   Else: depending on parameter value type, could be one of string,
	//         number, boolean, null, list or map
	// -   MapValue value:
	//     -   If parameter's entity type is a composite entity:
	//         map from composite entity property names to property values
	//     -   Else: parameter value
	Parameters *structpb.Struct `protobuf:"bytes,4,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// This field is set to:
	//
	// - `false` if the matched intent has required parameters and not all of
	//    the required parameter values have been collected.
	// - `true` if all required parameter values have been collected, or if the
	//    matched intent doesn't contain any required parameters.
	AllRequiredParamsPresent bool `protobuf:"varint,5,opt,name=all_required_params_present,json=allRequiredParamsPresent,proto3" json:"all_required_params_present,omitempty"`
	// Indicates whether the conversational query triggers a cancellation for slot
	// filling.
	CancelsSlotFilling bool `protobuf:"varint,21,opt,name=cancels_slot_filling,json=cancelsSlotFilling,proto3" json:"cancels_slot_filling,omitempty"`
	// The text to be pronounced to the user or shown on the screen.
	// Note: This is a legacy field, `fulfillment_messages` should be preferred.
	FulfillmentText string `protobuf:"bytes,6,opt,name=fulfillment_text,json=fulfillmentText,proto3" json:"fulfillment_text,omitempty"`
	// The collection of rich messages to present to the user.
	FulfillmentMessages []*Intent_Message `protobuf:"bytes,7,rep,name=fulfillment_messages,json=fulfillmentMessages,proto3" json:"fulfillment_messages,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `source` field returned in the webhook response.
	WebhookSource string `protobuf:"bytes,8,opt,name=webhook_source,json=webhookSource,proto3" json:"webhook_source,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `payload` field returned in the webhook response.
	WebhookPayload *structpb.Struct `protobuf:"bytes,9,opt,name=webhook_payload,json=webhookPayload,proto3" json:"webhook_payload,omitempty"`
	// The collection of output contexts. If applicable,
	// `output_contexts.parameters` contains entries with name
	// `<parameter name>.original` containing the original parameter values
	// before the query.
	OutputContexts []*Context `protobuf:"bytes,10,rep,name=output_contexts,json=outputContexts,proto3" json:"output_contexts,omitempty"`
	// The intent that matched the conversational query. Some, not
	// all fields are filled in this message, including but not limited to:
	// `name`, `display_name`, `end_interaction` and `is_fallback`.
	Intent *Intent `protobuf:"bytes,11,opt,name=intent,proto3" json:"intent,omitempty"`
	// The intent detection confidence. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to
	// help match the best intent within the classification threshold.
	// This value may change for the same end-user expression at any time due to a
	// model retraining or change in implementation.
	// If there are `multiple knowledge_answers` messages, this value is set to
	// the greatest `knowledgeAnswers.match_confidence` value in the list.
	IntentDetectionConfidence float32 `protobuf:"fixed32,12,opt,name=intent_detection_confidence,json=intentDetectionConfidence,proto3" json:"intent_detection_confidence,omitempty"`
	// Free-form diagnostic information for the associated detect intent request.
	// The fields of this data can change without notice, so you should not write
	// code that depends on its structure.
	// The data may contain:
	//
	// - webhook call latency
	// - webhook errors
	DiagnosticInfo *structpb.Struct `protobuf:"bytes,14,opt,name=diagnostic_info,json=diagnosticInfo,proto3" json:"diagnostic_info,omitempty"`
	// The sentiment analysis result, which depends on the
	// `sentiment_analysis_request_config` specified in the request.
	SentimentAnalysisResult *SentimentAnalysisResult `protobuf:"bytes,17,opt,name=sentiment_analysis_result,json=sentimentAnalysisResult,proto3" json:"sentiment_analysis_result,omitempty"`
}

func (x *QueryResult) Reset() {
	*x = QueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResult) ProtoMessage() {}

func (x *QueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResult.ProtoReflect.Descriptor instead.
func (*QueryResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{4}
}

func (x *QueryResult) GetQueryText() string {
	if x != nil {
		return x.QueryText
	}
	return ""
}

func (x *QueryResult) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *QueryResult) GetSpeechRecognitionConfidence() float32 {
	if x != nil {
		return x.SpeechRecognitionConfidence
	}
	return 0
}

func (x *QueryResult) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *QueryResult) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *QueryResult) GetAllRequiredParamsPresent() bool {
	if x != nil {
		return x.AllRequiredParamsPresent
	}
	return false
}

func (x *QueryResult) GetCancelsSlotFilling() bool {
	if x != nil {
		return x.CancelsSlotFilling
	}
	return false
}

func (x *QueryResult) GetFulfillmentText() string {
	if x != nil {
		return x.FulfillmentText
	}
	return ""
}

func (x *QueryResult) GetFulfillmentMessages() []*Intent_Message {
	if x != nil {
		return x.FulfillmentMessages
	}
	return nil
}

func (x *QueryResult) GetWebhookSource() string {
	if x != nil {
		return x.WebhookSource
	}
	return ""
}

func (x *QueryResult) GetWebhookPayload() *structpb.Struct {
	if x != nil {
		return x.WebhookPayload
	}
	return nil
}

func (x *QueryResult) GetOutputContexts() []*Context {
	if x != nil {
		return x.OutputContexts
	}
	return nil
}

func (x *QueryResult) GetIntent() *Intent {
	if x != nil {
		return x.Intent
	}
	return nil
}

func (x *QueryResult) GetIntentDetectionConfidence() float32 {
	if x != nil {
		return x.IntentDetectionConfidence
	}
	return 0
}

func (x *QueryResult) GetDiagnosticInfo() *structpb.Struct {
	if x != nil {
		return x.DiagnosticInfo
	}
	return nil
}

func (x *QueryResult) GetSentimentAnalysisResult() *SentimentAnalysisResult {
	if x != nil {
		return x.SentimentAnalysisResult
	}
	return nil
}

// The top-level message sent by the client to the
// [Sessions.StreamingDetectIntent][google.cloud.dialogflow.v2.Sessions.StreamingDetectIntent] method.
//
// Multiple request messages should be sent in order:
//
// 1.  The first message must contain
// [session][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.session],
//     [query_input][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_input] plus optionally
//     [query_params][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_params]. If the client
//     wants to receive an audio response, it should also contain
//     [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config].
//     The message must not contain
//     [input_audio][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.input_audio].
// 2.  If [query_input][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_input] was set to
//     [query_input.audio_config][google.cloud.dialogflow.v2.InputAudioConfig], all subsequent
//     messages must contain
//     [input_audio][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.input_audio] to continue with
//     Speech recognition.
//     If you decide to rather detect an intent from text input after you
//     already started Speech recognition, please send a message with
//     [query_input.text][google.cloud.dialogflow.v2.QueryInput.text].
//
//     However, note that:
//
//     * Dialogflow will bill you for the audio duration so far.
//     * Dialogflow discards all Speech recognition results in favor of the
//       input text.
//     * Dialogflow will use the language code from the first message.
//
// After you sent all input, you must half-close or abort the request stream.
type StreamingDetectIntentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the session the query is sent to.
	// Format of the session name:
	// `projects/<Project ID>/agent/sessions/<Session ID>`, or
	// `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>`. If `Environment ID` is not specified, we assume
	// default 'draft' environment. If `User ID` is not specified, we are using
	// "-". It's up to the API caller to choose an appropriate `Session ID` and
	// `User Id`. They can be a random number or some type of user and session
	// identifiers (preferably hashed). The length of the `Session ID` and
	// `User ID` must not exceed 36 characters.
	//
	// For more information, see the [API interactions
	// guide](https://cloud.google.com/dialogflow/docs/api-overview).
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config which instructs the speech recognizer how to process
	//     the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Please use [InputAudioConfig.single_utterance][google.cloud.dialogflow.v2.InputAudioConfig.single_utterance] instead.
	// If `false` (default), recognition does not cease until
	// the client closes the stream. If `true`, the recognizer will detect a
	// single spoken utterance in input audio. Recognition ceases when it detects
	// the audio's voice has stopped or paused. In this case, once a detected
	// intent is received, the client should close the stream and start a new
	// request with a new stream as needed.
	// This setting is ignored when `query_input` is a piece of text or an event.
	//
	// Deprecated: Do not use.
	SingleUtterance bool `protobuf:"varint,4,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// Instructs the speech synthesizer how to generate the output
	// audio. If this field is not set and agent-level speech synthesizer is not
	// configured, no output audio is generated.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,5,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Mask for [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config] indicating which settings in this
	// request-level config should override speech synthesizer settings defined at
	// agent-level.
	//
	// If unspecified or empty, [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config] replaces the agent-level
	// config in its entirety.
	OutputAudioConfigMask *fieldmaskpb.FieldMask `protobuf:"bytes,7,opt,name=output_audio_config_mask,json=outputAudioConfigMask,proto3" json:"output_audio_config_mask,omitempty"`
	// The input audio content to be recognized. Must be sent if
	// `query_input` was set to a streaming input audio config. The complete audio
	// over all streaming messages must not exceed 1 minute.
	InputAudio []byte `protobuf:"bytes,6,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
}

func (x *StreamingDetectIntentRequest) Reset() {
	*x = StreamingDetectIntentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingDetectIntentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingDetectIntentRequest) ProtoMessage() {}

func (x *StreamingDetectIntentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingDetectIntentRequest.ProtoReflect.Descriptor instead.
func (*StreamingDetectIntentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{5}
}

func (x *StreamingDetectIntentRequest) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *StreamingDetectIntentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *StreamingDetectIntentRequest) GetQueryInput() *QueryInput {
	if x != nil {
		return x.QueryInput
	}
	return nil
}

// Deprecated: Do not use.
func (x *StreamingDetectIntentRequest) GetSingleUtterance() bool {
	if x != nil {
		return x.SingleUtterance
	}
	return false
}

func (x *StreamingDetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

func (x *StreamingDetectIntentRequest) GetOutputAudioConfigMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.OutputAudioConfigMask
	}
	return nil
}

func (x *StreamingDetectIntentRequest) GetInputAudio() []byte {
	if x != nil {
		return x.InputAudio
	}
	return nil
}

// The top-level message returned from the
// `StreamingDetectIntent` method.
//
// Multiple response messages can be returned in order:
//
// 1.  If the `StreamingDetectIntentRequest.input_audio` field was
//     set, the `recognition_result` field is populated for one
//     or more messages.
//     See the [StreamingRecognitionResult][google.cloud.dialogflow.v2.StreamingRecognitionResult] message for details
//     about the result message sequence.
//
// 2.  The next message contains `response_id`, `query_result`
//     and optionally `webhook_status` if a WebHook was called.
type StreamingDetectIntentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The result of speech recognition.
	RecognitionResult *StreamingRecognitionResult `protobuf:"bytes,2,opt,name=recognition_result,json=recognitionResult,proto3" json:"recognition_result,omitempty"`
	// The result of the conversational query or event processing.
	QueryResult *QueryResult `protobuf:"bytes,3,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// Specifies the status of the webhook request.
	WebhookStatus *status.Status `protobuf:"bytes,4,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the `query_result.fulfillment_messages` field. If
	// multiple default text responses exist, they will be concatenated when
	// generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	//
	// In some scenarios, multiple output audio fields may be present in the
	// response structure. In these cases, only the top-most-level audio output
	// has content.
	OutputAudio []byte `protobuf:"bytes,5,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,6,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
}

func (x *StreamingDetectIntentResponse) Reset() {
	*x = StreamingDetectIntentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingDetectIntentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingDetectIntentResponse) ProtoMessage() {}

func (x *StreamingDetectIntentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingDetectIntentResponse.ProtoReflect.Descriptor instead.
func (*StreamingDetectIntentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{6}
}

func (x *StreamingDetectIntentResponse) GetResponseId() string {
	if x != nil {
		return x.ResponseId
	}
	return ""
}

func (x *StreamingDetectIntentResponse) GetRecognitionResult() *StreamingRecognitionResult {
	if x != nil {
		return x.RecognitionResult
	}
	return nil
}

func (x *StreamingDetectIntentResponse) GetQueryResult() *QueryResult {
	if x != nil {
		return x.QueryResult
	}
	return nil
}

func (x *StreamingDetectIntentResponse) GetWebhookStatus() *status.Status {
	if x != nil {
		return x.WebhookStatus
	}
	return nil
}

func (x *StreamingDetectIntentResponse) GetOutputAudio() []byte {
	if x != nil {
		return x.OutputAudio
	}
	return nil
}

func (x *StreamingDetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.OutputAudioConfig
	}
	return nil
}

// Contains a speech recognition result corresponding to a portion of the audio
// that is currently being processed or an indication that this is the end
// of the single requested utterance.
//
// While end-user audio is being processed, Dialogflow sends a series of
// results. Each result may contain a `transcript` value. A transcript
// represents a portion of the utterance. While the recognizer is processing
// audio, transcript values may be interim values or finalized values.
// Once a transcript is finalized, the `is_final` value is set to true and
// processing continues for the next transcript.
//
// If `StreamingDetectIntentRequest.query_input.audio_config.single_utterance`
// was true, and the recognizer has completed processing audio,
// the `message_type` value is set to `END_OF_SINGLE_UTTERANCE and the
// following (last) result contains the last finalized transcript.
//
// The complete end-user utterance is determined by concatenating the
// finalized transcript values received for the series of results.
//
// In the following example, single utterance is enabled. In the case where
// single utterance is not enabled, result 7 would not occur.
//
// ```
// Num | transcript              | message_type            | is_final
// --- | ----------------------- | ----------------------- | --------
// 1   | "tube"                  | TRANSCRIPT              | false
// 2   | "to be a"               | TRANSCRIPT              | false
// 3   | "to be"                 | TRANSCRIPT              | false
// 4   | "to be or not to be"    | TRANSCRIPT              | true
// 5   | "that's"                | TRANSCRIPT              | false
// 6   | "that is                | TRANSCRIPT              | false
// 7   | unset                   | END_OF_SINGLE_UTTERANCE | unset
// 8   | " that is the question" | TRANSCRIPT              | true
// ```
//
// Concatenating the finalized transcripts with `is_final` set to true,
// the complete utterance becomes "to be or not to be that is the question".
type StreamingRecognitionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the result message.
	MessageType StreamingRecognitionResult_MessageType `protobuf:"varint,1,opt,name=message_type,json=messageType,proto3,enum=google.cloud.dialogflow.v2.StreamingRecognitionResult_MessageType" json:"message_type,omitempty"`
	// Transcript text representing the words that the user spoke.
	// Populated if and only if `message_type` = `TRANSCRIPT`.
	Transcript string `protobuf:"bytes,2,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// If `false`, the `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, the recognizer will not return
	// any further hypotheses about this piece of the audio. May only be populated
	// for `message_type` = `TRANSCRIPT`.
	IsFinal bool `protobuf:"varint,3,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// The Speech confidence between 0.0 and 1.0 for the current portion of audio.
	// A higher number indicates an estimated greater likelihood that the
	// recognized words are correct. The default of 0.0 is a sentinel value
	// indicating that confidence was not set.
	//
	// This field is typically only provided if `is_final` is true and you should
	// not rely on it being accurate or even set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Word-specific information for the words recognized by Speech in
	// [transcript][google.cloud.dialogflow.v2.StreamingRecognitionResult.transcript]. Populated if and only if `message_type` = `TRANSCRIPT` and
	// [InputAudioConfig.enable_word_info] is set.
	SpeechWordInfo []*SpeechWordInfo `protobuf:"bytes,7,rep,name=speech_word_info,json=speechWordInfo,proto3" json:"speech_word_info,omitempty"`
	// Time offset of the end of this Speech recognition result relative to the
	// beginning of the audio. Only populated for `message_type` = `TRANSCRIPT`.
	SpeechEndOffset *durationpb.Duration `protobuf:"bytes,8,opt,name=speech_end_offset,json=speechEndOffset,proto3" json:"speech_end_offset,omitempty"`
	// Detected language code for the transcript.
	LanguageCode string `protobuf:"bytes,10,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *StreamingRecognitionResult) Reset() {
	*x = StreamingRecognitionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingRecognitionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRecognitionResult) ProtoMessage() {}

func (x *StreamingRecognitionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRecognitionResult.ProtoReflect.Descriptor instead.
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{7}
}

func (x *StreamingRecognitionResult) GetMessageType() StreamingRecognitionResult_MessageType {
	if x != nil {
		return x.MessageType
	}
	return StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED
}

func (x *StreamingRecognitionResult) GetTranscript() string {
	if x != nil {
		return x.Transcript
	}
	return ""
}

func (x *StreamingRecognitionResult) GetIsFinal() bool {
	if x != nil {
		return x.IsFinal
	}
	return false
}

func (x *StreamingRecognitionResult) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *StreamingRecognitionResult) GetSpeechWordInfo() []*SpeechWordInfo {
	if x != nil {
		return x.SpeechWordInfo
	}
	return nil
}

func (x *StreamingRecognitionResult) GetSpeechEndOffset() *durationpb.Duration {
	if x != nil {
		return x.SpeechEndOffset
	}
	return nil
}

func (x *StreamingRecognitionResult) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Represents the natural language text to be processed.
type TextInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The UTF-8 encoded natural language text to be processed.
	// Text length must not exceed 256 characters.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Required. The language of this conversational query. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *TextInput) Reset() {
	*x = TextInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextInput) ProtoMessage() {}

func (x *TextInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextInput.ProtoReflect.Descriptor instead.
func (*TextInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{8}
}

func (x *TextInput) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *TextInput) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Events allow for matching intents by event name instead of the natural
// language input. For instance, input `<event: { name: "welcome_event",
// parameters: { name: "Sam" } }>` can trigger a personalized welcome response.
// The parameter `name` may be used by the agent in the response:
// `"Hello #welcome_event.name! What can I do for you today?"`.
type EventInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the event.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The collection of parameters associated with the event.
	//
	// Depending on your protocol or client library language, this is a
	// map, associative array, symbol table, dictionary, or JSON object
	// composed of a collection of (MapKey, MapValue) pairs:
	//
	// -   MapKey type: string
	// -   MapKey value: parameter name
	// -   MapValue type:
	//     -   If parameter's entity type is a composite entity: map
	//     -   Else: depending on parameter value type, could be one of string,
	//         number, boolean, null, list or map
	// -   MapValue value:
	//     -   If parameter's entity type is a composite entity:
	//         map from composite entity property names to property values
	//     -   Else: parameter value
	Parameters *structpb.Struct `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Required. The language of this query. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	//
	// This field is ignored when used in the context of a
	// [WebhookResponse.followup_event_input][google.cloud.dialogflow.v2.WebhookResponse.followup_event_input] field,
	// because the language was already defined in the originating detect
	// intent request.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *EventInput) Reset() {
	*x = EventInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventInput) ProtoMessage() {}

func (x *EventInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventInput.ProtoReflect.Descriptor instead.
func (*EventInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{9}
}

func (x *EventInput) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EventInput) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *EventInput) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Configures the types of sentiment analysis to perform.
type SentimentAnalysisRequestConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instructs the service to perform sentiment analysis on
	// `query_text`. If not provided, sentiment analysis is not performed on
	// `query_text`.
	AnalyzeQueryTextSentiment bool `protobuf:"varint,1,opt,name=analyze_query_text_sentiment,json=analyzeQueryTextSentiment,proto3" json:"analyze_query_text_sentiment,omitempty"`
}

func (x *SentimentAnalysisRequestConfig) Reset() {
	*x = SentimentAnalysisRequestConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SentimentAnalysisRequestConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SentimentAnalysisRequestConfig) ProtoMessage() {}

func (x *SentimentAnalysisRequestConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SentimentAnalysisRequestConfig.ProtoReflect.Descriptor instead.
func (*SentimentAnalysisRequestConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{10}
}

func (x *SentimentAnalysisRequestConfig) GetAnalyzeQueryTextSentiment() bool {
	if x != nil {
		return x.AnalyzeQueryTextSentiment
	}
	return false
}

// The result of sentiment analysis. Sentiment analysis inspects user input
// and identifies the prevailing subjective opinion, especially to determine a
// user's attitude as positive, negative, or neutral.
// For [Participants.DetectIntent][], it needs to be configured in
// [DetectIntentRequest.query_params][google.cloud.dialogflow.v2.DetectIntentRequest.query_params]. For
// [Participants.StreamingDetectIntent][], it needs to be configured in
// [StreamingDetectIntentRequest.query_params][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_params].
// And for [Participants.AnalyzeContent][google.cloud.dialogflow.v2.Participants.AnalyzeContent] and
// [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2.Participants.StreamingAnalyzeContent], it needs to be configured in
// [ConversationProfile.human_agent_assistant_config][google.cloud.dialogflow.v2.ConversationProfile.human_agent_assistant_config]
type SentimentAnalysisResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The sentiment analysis result for `query_text`.
	QueryTextSentiment *Sentiment `protobuf:"bytes,1,opt,name=query_text_sentiment,json=queryTextSentiment,proto3" json:"query_text_sentiment,omitempty"`
}

func (x *SentimentAnalysisResult) Reset() {
	*x = SentimentAnalysisResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SentimentAnalysisResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SentimentAnalysisResult) ProtoMessage() {}

func (x *SentimentAnalysisResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SentimentAnalysisResult.ProtoReflect.Descriptor instead.
func (*SentimentAnalysisResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{11}
}

func (x *SentimentAnalysisResult) GetQueryTextSentiment() *Sentiment {
	if x != nil {
		return x.QueryTextSentiment
	}
	return nil
}

// The sentiment, such as positive/negative feeling or association, for a unit
// of analysis, such as the query text.
type Sentiment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// A non-negative number in the [0, +inf) range, which represents the absolute
	// magnitude of sentiment, regardless of score (positive or negative).
	Magnitude float32 `protobuf:"fixed32,2,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
}

func (x *Sentiment) Reset() {
	*x = Sentiment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Sentiment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sentiment) ProtoMessage() {}

func (x *Sentiment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_session_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Sentiment.ProtoReflect.Descriptor instead.
func (*Sentiment) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP(), []int{12}
}

func (x *Sentiment) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *Sentiment) GetMagnitude() float32 {
	if x != nil {
		return x.Magnitude
	}
	return 0
}

var File_google_cloud_dialogflow_v2_session_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2_session_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcd, 0x03, 0x0a, 0x13, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x07,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x4e, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12,
	0x5d, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53,
	0x0a, 0x18, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x15, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64,
	0x69, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41,
	0x75, 0x64, 0x69, 0x6f, 0x22, 0xc0, 0x02, 0x0a, 0x14, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x64, 0x12, 0x4a,
	0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0b, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x39, 0x0a, 0x0e, 0x77, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x5d, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x97, 0x05, 0x0a, 0x0f, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x36, 0x0a, 0x0c, 0x67, 0x65, 0x6f, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74,
	0x4c, 0x6e, 0x67, 0x52, 0x0b, 0x67, 0x65, 0x6f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3f, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x5f, 0x0a, 0x14, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x07, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x85, 0x01, 0x0a,
	0x21, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x1e, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x68, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x1a, 0x41,
	0x0a, 0x13, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xe5, 0x01, 0x0a, 0x0a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x51, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x54,
	0x65, 0x78, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x3e, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x42, 0x07, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x22, 0xc7, 0x07, 0x0a, 0x0b, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x78, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x42, 0x0a,
	0x1d, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x1b, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x73, 0x5f, 0x73, 0x6c, 0x6f,
	0x74, 0x5f, 0x66, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x12, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x73, 0x53, 0x6c, 0x6f, 0x74, 0x46, 0x69, 0x6c, 0x6c,
	0x69, 0x6e, 0x67, 0x12, 0x29, 0x0a, 0x10, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x66,
	0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x65, 0x78, 0x74, 0x12, 0x5d,
	0x0a, 0x14, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x13, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x25, 0x0a,
	0x0e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x4c, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x52, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x73, 0x12, 0x3a, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x3e, 0x0a, 0x1b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x02, 0x52, 0x19, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x12, 0x40, 0x0a, 0x0f, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x0e, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x6f, 0x0a, 0x19, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x17, 0x73, 0x65, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x22, 0x85, 0x04, 0x0a, 0x1c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x0c, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0b, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x73, 0x69, 0x6e, 0x67, 0x6c,
	0x65, 0x5f, 0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x55, 0x74, 0x74,
	0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x18, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x15, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x22, 0xb0, 0x03, 0x0a, 0x1d,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x64, 0x12, 0x65,
	0x0a, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x11, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4a, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x39, 0x0a, 0x0e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x77,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12,
	0x5d, 0x0a, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xfa,
	0x03, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f,
	0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x65, 0x0a,
	0x0c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x12,
	0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x54, 0x0a, 0x10, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x57, 0x6f, 0x72,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x57, 0x6f, 0x72,
	0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f,
	0x65, 0x6e, 0x64, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x45, 0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x23, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x22, 0x58, 0x0a, 0x0b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1c, 0x0a, 0x18, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x10, 0x01, 0x12, 0x1b,
	0x0a, 0x17, 0x45, 0x4e, 0x44, 0x5f, 0x4f, 0x46, 0x5f, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f,
	0x55, 0x54, 0x54, 0x45, 0x52, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x02, 0x22, 0x4e, 0x0a, 0x09, 0x54,
	0x65, 0x78, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x88, 0x01, 0x0a, 0x0a,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x28, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x61, 0x0a, 0x1e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x0a, 0x1c, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73,
	0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65, 0x78, 0x74,
	0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x72, 0x0a, 0x17, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x57, 0x0a, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x3f, 0x0a,
	0x09, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x61, 0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x09, 0x6d, 0x61, 0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x32, 0xe5,
	0x05, 0x0a, 0x08, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc9, 0x03, 0x0a, 0x0c,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xd5, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb8, 0x02, 0x22, 0x36, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x52, 0x22, 0x4d, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x01, 0x2a, 0x5a, 0x47, 0x22, 0x42, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x01,
	0x2a, 0x5a, 0x5e, 0x22, 0x59, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x73,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3a, 0x01,
	0x2a, 0xda, 0x41, 0x13, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2c, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x92, 0x01, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x1a, 0x78, 0xca, 0x41,
	0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xf0, 0x03, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x42, 0x0c, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x32, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0xf8,
	0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x56, 0x32, 0xea, 0x41, 0xd1, 0x02, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x75, 0x73,
	0x65, 0x72, 0x73, 0x2f, 0x7b, 0x75, 0x73, 0x65, 0x72, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x40, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x12,
	0x68, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2f, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x75, 0x73, 0x65, 0x72, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_dialogflow_v2_session_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2_session_proto_rawDescData = file_google_cloud_dialogflow_v2_session_proto_rawDesc
)

func file_google_cloud_dialogflow_v2_session_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2_session_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2_session_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2_session_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2_session_proto_rawDescData
}

var file_google_cloud_dialogflow_v2_session_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_dialogflow_v2_session_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_dialogflow_v2_session_proto_goTypes = []interface{}{
	(StreamingRecognitionResult_MessageType)(0), // 0: google.cloud.dialogflow.v2.StreamingRecognitionResult.MessageType
	(*DetectIntentRequest)(nil),                 // 1: google.cloud.dialogflow.v2.DetectIntentRequest
	(*DetectIntentResponse)(nil),                // 2: google.cloud.dialogflow.v2.DetectIntentResponse
	(*QueryParameters)(nil),                     // 3: google.cloud.dialogflow.v2.QueryParameters
	(*QueryInput)(nil),                          // 4: google.cloud.dialogflow.v2.QueryInput
	(*QueryResult)(nil),                         // 5: google.cloud.dialogflow.v2.QueryResult
	(*StreamingDetectIntentRequest)(nil),        // 6: google.cloud.dialogflow.v2.StreamingDetectIntentRequest
	(*StreamingDetectIntentResponse)(nil),       // 7: google.cloud.dialogflow.v2.StreamingDetectIntentResponse
	(*StreamingRecognitionResult)(nil),          // 8: google.cloud.dialogflow.v2.StreamingRecognitionResult
	(*TextInput)(nil),                           // 9: google.cloud.dialogflow.v2.TextInput
	(*EventInput)(nil),                          // 10: google.cloud.dialogflow.v2.EventInput
	(*SentimentAnalysisRequestConfig)(nil),      // 11: google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig
	(*SentimentAnalysisResult)(nil),             // 12: google.cloud.dialogflow.v2.SentimentAnalysisResult
	(*Sentiment)(nil),                           // 13: google.cloud.dialogflow.v2.Sentiment
	nil,                                         // 14: google.cloud.dialogflow.v2.QueryParameters.WebhookHeadersEntry
	(*OutputAudioConfig)(nil),                   // 15: google.cloud.dialogflow.v2.OutputAudioConfig
	(*fieldmaskpb.FieldMask)(nil),               // 16: google.protobuf.FieldMask
	(*status.Status)(nil),                       // 17: google.rpc.Status
	(*latlng.LatLng)(nil),                       // 18: google.type.LatLng
	(*Context)(nil),                             // 19: google.cloud.dialogflow.v2.Context
	(*SessionEntityType)(nil),                   // 20: google.cloud.dialogflow.v2.SessionEntityType
	(*structpb.Struct)(nil),                     // 21: google.protobuf.Struct
	(*InputAudioConfig)(nil),                    // 22: google.cloud.dialogflow.v2.InputAudioConfig
	(*Intent_Message)(nil),                      // 23: google.cloud.dialogflow.v2.Intent.Message
	(*Intent)(nil),                              // 24: google.cloud.dialogflow.v2.Intent
	(*SpeechWordInfo)(nil),                      // 25: google.cloud.dialogflow.v2.SpeechWordInfo
	(*durationpb.Duration)(nil),                 // 26: google.protobuf.Duration
}
var file_google_cloud_dialogflow_v2_session_proto_depIdxs = []int32{
	3,  // 0: google.cloud.dialogflow.v2.DetectIntentRequest.query_params:type_name -> google.cloud.dialogflow.v2.QueryParameters
	4,  // 1: google.cloud.dialogflow.v2.DetectIntentRequest.query_input:type_name -> google.cloud.dialogflow.v2.QueryInput
	15, // 2: google.cloud.dialogflow.v2.DetectIntentRequest.output_audio_config:type_name -> google.cloud.dialogflow.v2.OutputAudioConfig
	16, // 3: google.cloud.dialogflow.v2.DetectIntentRequest.output_audio_config_mask:type_name -> google.protobuf.FieldMask
	5,  // 4: google.cloud.dialogflow.v2.DetectIntentResponse.query_result:type_name -> google.cloud.dialogflow.v2.QueryResult
	17, // 5: google.cloud.dialogflow.v2.DetectIntentResponse.webhook_status:type_name -> google.rpc.Status
	15, // 6: google.cloud.dialogflow.v2.DetectIntentResponse.output_audio_config:type_name -> google.cloud.dialogflow.v2.OutputAudioConfig
	18, // 7: google.cloud.dialogflow.v2.QueryParameters.geo_location:type_name -> google.type.LatLng
	19, // 8: google.cloud.dialogflow.v2.QueryParameters.contexts:type_name -> google.cloud.dialogflow.v2.Context
	20, // 9: google.cloud.dialogflow.v2.QueryParameters.session_entity_types:type_name -> google.cloud.dialogflow.v2.SessionEntityType
	21, // 10: google.cloud.dialogflow.v2.QueryParameters.payload:type_name -> google.protobuf.Struct
	11, // 11: google.cloud.dialogflow.v2.QueryParameters.sentiment_analysis_request_config:type_name -> google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig
	14, // 12: google.cloud.dialogflow.v2.QueryParameters.webhook_headers:type_name -> google.cloud.dialogflow.v2.QueryParameters.WebhookHeadersEntry
	22, // 13: google.cloud.dialogflow.v2.QueryInput.audio_config:type_name -> google.cloud.dialogflow.v2.InputAudioConfig
	9,  // 14: google.cloud.dialogflow.v2.QueryInput.text:type_name -> google.cloud.dialogflow.v2.TextInput
	10, // 15: google.cloud.dialogflow.v2.QueryInput.event:type_name -> google.cloud.dialogflow.v2.EventInput
	21, // 16: google.cloud.dialogflow.v2.QueryResult.parameters:type_name -> google.protobuf.Struct
	23, // 17: google.cloud.dialogflow.v2.QueryResult.fulfillment_messages:type_name -> google.cloud.dialogflow.v2.Intent.Message
	21, // 18: google.cloud.dialogflow.v2.QueryResult.webhook_payload:type_name -> google.protobuf.Struct
	19, // 19: google.cloud.dialogflow.v2.QueryResult.output_contexts:type_name -> google.cloud.dialogflow.v2.Context
	24, // 20: google.cloud.dialogflow.v2.QueryResult.intent:type_name -> google.cloud.dialogflow.v2.Intent
	21, // 21: google.cloud.dialogflow.v2.QueryResult.diagnostic_info:type_name -> google.protobuf.Struct
	12, // 22: google.cloud.dialogflow.v2.QueryResult.sentiment_analysis_result:type_name -> google.cloud.dialogflow.v2.SentimentAnalysisResult
	3,  // 23: google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_params:type_name -> google.cloud.dialogflow.v2.QueryParameters
	4,  // 24: google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_input:type_name -> google.cloud.dialogflow.v2.QueryInput
	15, // 25: google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config:type_name -> google.cloud.dialogflow.v2.OutputAudioConfig
	16, // 26: google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config_mask:type_name -> google.protobuf.FieldMask
	8,  // 27: google.cloud.dialogflow.v2.StreamingDetectIntentResponse.recognition_result:type_name -> google.cloud.dialogflow.v2.StreamingRecognitionResult
	5,  // 28: google.cloud.dialogflow.v2.StreamingDetectIntentResponse.query_result:type_name -> google.cloud.dialogflow.v2.QueryResult
	17, // 29: google.cloud.dialogflow.v2.StreamingDetectIntentResponse.webhook_status:type_name -> google.rpc.Status
	15, // 30: google.cloud.dialogflow.v2.StreamingDetectIntentResponse.output_audio_config:type_name -> google.cloud.dialogflow.v2.OutputAudioConfig
	0,  // 31: google.cloud.dialogflow.v2.StreamingRecognitionResult.message_type:type_name -> google.cloud.dialogflow.v2.StreamingRecognitionResult.MessageType
	25, // 32: google.cloud.dialogflow.v2.StreamingRecognitionResult.speech_word_info:type_name -> google.cloud.dialogflow.v2.SpeechWordInfo
	26, // 33: google.cloud.dialogflow.v2.StreamingRecognitionResult.speech_end_offset:type_name -> google.protobuf.Duration
	21, // 34: google.cloud.dialogflow.v2.EventInput.parameters:type_name -> google.protobuf.Struct
	13, // 35: google.cloud.dialogflow.v2.SentimentAnalysisResult.query_text_sentiment:type_name -> google.cloud.dialogflow.v2.Sentiment
	1,  // 36: google.cloud.dialogflow.v2.Sessions.DetectIntent:input_type -> google.cloud.dialogflow.v2.DetectIntentRequest
	6,  // 37: google.cloud.dialogflow.v2.Sessions.StreamingDetectIntent:input_type -> google.cloud.dialogflow.v2.StreamingDetectIntentRequest
	2,  // 38: google.cloud.dialogflow.v2.Sessions.DetectIntent:output_type -> google.cloud.dialogflow.v2.DetectIntentResponse
	7,  // 39: google.cloud.dialogflow.v2.Sessions.StreamingDetectIntent:output_type -> google.cloud.dialogflow.v2.StreamingDetectIntentResponse
	38, // [38:40] is the sub-list for method output_type
	36, // [36:38] is the sub-list for method input_type
	36, // [36:36] is the sub-list for extension type_name
	36, // [36:36] is the sub-list for extension extendee
	0,  // [0:36] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2_session_proto_init() }
func file_google_cloud_dialogflow_v2_session_proto_init() {
	if File_google_cloud_dialogflow_v2_session_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2_audio_config_proto_init()
	file_google_cloud_dialogflow_v2_context_proto_init()
	file_google_cloud_dialogflow_v2_intent_proto_init()
	file_google_cloud_dialogflow_v2_session_entity_type_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DetectIntentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingDetectIntentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingDetectIntentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingRecognitionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SentimentAnalysisRequestConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SentimentAnalysisResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_v2_session_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Sentiment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_v2_session_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*QueryInput_AudioConfig)(nil),
		(*QueryInput_Text)(nil),
		(*QueryInput_Event)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2_session_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2_session_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2_session_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2_session_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2_session_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2_session_proto = out.File
	file_google_cloud_dialogflow_v2_session_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2_session_proto_goTypes = nil
	file_google_cloud_dialogflow_v2_session_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SessionsClient is the client API for Sessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SessionsClient interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	//
	// If you might use
	// [Agent Assist](https://cloud.google.com/dialogflow/docs/#aa)
	// or other CCAI products now or in the future, consider using
	// [AnalyzeContent][google.cloud.dialogflow.v2.Participants.AnalyzeContent]
	// instead of `DetectIntent`. `AnalyzeContent` has additional
	// functionality for Agent Assist and other CCAI products.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	//
	// If you might use
	// [Agent Assist](https://cloud.google.com/dialogflow/docs/#aa)
	// or other CCAI products now or in the future, consider using
	// [StreamingAnalyzeContent][google.cloud.dialogflow.v2.Participants.StreamingAnalyzeContent]
	// instead of `StreamingDetectIntent`. `StreamingAnalyzeContent` has
	// additional functionality for Agent Assist and other CCAI products.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error)
}

type sessionsClient struct {
	cc grpc.ClientConnInterface
}

func NewSessionsClient(cc grpc.ClientConnInterface) SessionsClient {
	return &sessionsClient{cc}
}

func (c *sessionsClient) DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error) {
	out := new(DetectIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Sessions/DetectIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Sessions_serviceDesc.Streams[0], "/google.cloud.dialogflow.v2.Sessions/StreamingDetectIntent", opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsStreamingDetectIntentClient{stream}
	return x, nil
}

type Sessions_StreamingDetectIntentClient interface {
	Send(*StreamingDetectIntentRequest) error
	Recv() (*StreamingDetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsStreamingDetectIntentClient) Send(m *StreamingDetectIntentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentClient) Recv() (*StreamingDetectIntentResponse, error) {
	m := new(StreamingDetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SessionsServer is the server API for Sessions service.
type SessionsServer interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	//
	// If you might use
	// [Agent Assist](https://cloud.google.com/dialogflow/docs/#aa)
	// or other CCAI products now or in the future, consider using
	// [AnalyzeContent][google.cloud.dialogflow.v2.Participants.AnalyzeContent]
	// instead of `DetectIntent`. `AnalyzeContent` has additional
	// functionality for Agent Assist and other CCAI products.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	//
	// If you might use
	// [Agent Assist](https://cloud.google.com/dialogflow/docs/#aa)
	// or other CCAI products now or in the future, consider using
	// [StreamingAnalyzeContent][google.cloud.dialogflow.v2.Participants.StreamingAnalyzeContent]
	// instead of `StreamingDetectIntent`. `StreamingAnalyzeContent` has
	// additional functionality for Agent Assist and other CCAI products.
	//
	// Note: Always use agent versions for production traffic.
	// See [Versions and
	// environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
	StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error
}

// UnimplementedSessionsServer can be embedded to have forward compatible implementations.
type UnimplementedSessionsServer struct {
}

func (*UnimplementedSessionsServer) DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DetectIntent not implemented")
}
func (*UnimplementedSessionsServer) StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error {
	return status1.Errorf(codes.Unimplemented, "method StreamingDetectIntent not implemented")
}

func RegisterSessionsServer(s *grpc.Server, srv SessionsServer) {
	s.RegisterService(&_Sessions_serviceDesc, srv)
}

func _Sessions_DetectIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).DetectIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Sessions/DetectIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).DetectIntent(ctx, req.(*DetectIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_StreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SessionsServer).StreamingDetectIntent(&sessionsStreamingDetectIntentServer{stream})
}

type Sessions_StreamingDetectIntentServer interface {
	Send(*StreamingDetectIntentResponse) error
	Recv() (*StreamingDetectIntentRequest, error)
	grpc.ServerStream
}

type sessionsStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsStreamingDetectIntentServer) Send(m *StreamingDetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentServer) Recv() (*StreamingDetectIntentRequest, error) {
	m := new(StreamingDetectIntentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Sessions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Sessions",
	HandlerType: (*SessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectIntent",
			Handler:    _Sessions_DetectIntent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingDetectIntent",
			Handler:       _Sessions_StreamingDetectIntent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/v2/session.proto",
}
